<?php

namespace App\Console\Commands;

use App\Models\Edu\Device\DeviceLog;
use App\Models\Edu\Issue\IssueDetail;
use App\Traits\Device\OrganizeSavedDeviceLogTrait;
use App\Traits\TimeRelatedFunctionTrait;
use Carbon\Carbon;
use DateTime;
use DB;
use Illuminate\Console\Command;

class OrganizeSavedDeviceLogCommand extends Command
{

    use OrganizeSavedDeviceLogTrait, TimeRelatedFunctionTrait;
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'organize:log';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'All saved device log organized to specified table';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {

        set_time_limit(500);
        date_default_timezone_set('Asia/Dhaka');

       // $now = Carbon::now();
        $now1 = Carbon::now();


       // $previous_date = $now->subDays(1)->toDateString();
       // $previous_date = "2019-08-25";
        $today = $now1->toDateString();

       // $previous_date = "2019-7-10";
      //  $today = "2021-12-12";

        $get_device_log = (new DeviceLog())
        //    ->whereBetween('access_date', [$previous_date, $today])
            ->where('access_date', $today)
            ->where('executed_status', 0)
            ->orderBy('access_time', 'ASC')
            ->get();

        $issue = new IssueDetail();
        $issue->issue_type = 'organize:log';
        $issue->issuer_type = 'edu';
        $issue->issue_details = "Total DeviceLog Selected: " . count($get_device_log) . ' Start DateTime: ' . date('d F Y', strtotime($today)) . ' End Date: ' . date('d F Y', strtotime($today)) . ')';

        $issue->save();
       

        $saved_updated_att_ids = $this->organizeSavedDeviceLog($get_device_log);

        $data_saved = $saved_updated_att_ids[0];
        $data_updated = $saved_updated_att_ids[1];
        $emp_saved = $saved_updated_att_ids[2];
        $emp_updated = $saved_updated_att_ids[3];

        if (count($data_saved) || count($data_updated) || count($emp_saved) || count($emp_updated)) {
            $issue = new IssueDetail();
            $issue->issue_type = 'organize:log';
            $issue->issuer_type = 'edu';
            $issue->issue_details = 'student saved: ' . count($data_saved) . ' Student Updated: ' . count($data_updated) . ' Emp Saved: ' . count($emp_saved) . ' Emp Updated: ' . count($emp_updated);
            $issue->save();
        }

    }
}
