<?php

namespace App\Console\Commands;

use App\Models\Book\GlobalBookBorrowing;
use App\Models\Book\GlobalLibraryFineConfiguration;
use Carbon\Carbon;
use Illuminate\Console\Command;

class UpdateLibraryOverdueFines extends Command
{
    protected $signature = 'library:update-overdue-fines';

    protected $description = 'Update library fines for overdue unreturned books';

    public function handle()
    {
        $today = Carbon::today();

        $borrowings = GlobalBookBorrowing::whereNull('returned_date')
            ->whereDate('due_date', '<', $today)
            ->get();

        foreach ($borrowings as $b) {
            $fineConfiguration = $this->getLibraryFine($b->site_id);
            $fineMap = collect($fineConfiguration)->pluck('amount', 'day')->toArray();
            $lastFineAmount = collect($fineMap)->last();

            $dueDate = Carbon::parse($b->due_date);
            $overdueDays = $today->greaterThan($dueDate)
                ? $today->diffInDays($dueDate)
                : 0;

            $totalFine = 0;


            for ($i = 1; $i <= $overdueDays; $i++) {
                $amount = $fineMap[$i] ?? $lastFineAmount;
                $totalFine += $amount;
            }

            $b->fine = $totalFine;
            $b->save();
        }

        $this->info("Overdue fines updated successfully.");
    }

    protected function getLibraryFine($site_id)
    {
        $fine = GlobalLibraryFineConfiguration::where('site_id', $site_id)->first();

        if ($fine && is_array($fine->fine_details)) {
            return $fine->fine_details;
        }

        return [
            [
                'day' => 1,
                'amount' => 0.0,
            ]
        ];
    }

    private function smartTruncate($value, $precision = 2)
    {
        $multiplier = pow(10, $precision);
        $truncated = intval($value * $multiplier) / $multiplier;

        return fmod($truncated, 1.0) == 0.0 ? (int) $truncated : $truncated;
    }
}
