<?php

namespace App\Console;

use App\Console\Commands\DatabaseBackupToDrive;
use App\Console\Commands\DeployApp;
use App\Console\Commands\TraitMakeCommand;
use App\Console\Commands\UpdateLibraryOverdueFines;
use App\Http\Controllers\Edu\Fetch\FetchLogController;
use Carbon\Carbon;
use DateTime;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{

    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        TraitMakeCommand::class,
        DeployApp::class,
        UpdateLibraryOverdueFines::class,
        DatabaseBackupToDrive::class,

    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {

        $schedule->command('fetch:log')
            ->withoutOverlapping()
            ->everyMinute();


        $schedule->command('organize:log')
            ->withoutOverlapping()
            ->everyMinute();

        $schedule->command('send:absent-sms')
            ->withoutOverlapping()
            ->everyMinute();

        $schedule->command('fee:update')
            ->withoutOverlapping()
            ->everyMinute();
      
        $schedule->command('library:update-overdue-fines')->dailyAt('00:00');

            
        $schedule->exec('php artisan queue:work --stop-when-empty')
            ->withoutOverlapping()
            ->everyMinute();
            

        $schedule->command('db:backup')->dailyAt('02:00');

    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__ . '/Commands');

        require base_path('routes/console.php');
    }
}
