<?php
/**
 * Created by PhpStorm.
 * User: Abdul Aziz
 * Date: 4/27/2016
 * Time: 4:55 PM
 */

namespace App\Forms;


use App\Models\Academic\AcademicClass;
use Illuminate\Support\Facades\Input;

class AcademicClassForm extends AcademicClass implements FormInterface
{
    use FormControll, DataHelper;//must

    protected $nonEditableFields = [];

    public function formInputFields($id, $mode)
    {

        return [
            [
                'type'=>'text',
                'name'=>self::CLASS_NAME,
                'label' => 'Class Name',
                'value'=>null,
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12 ',
                'trans'=>false,
                'others'=>[
                    'class'=>'form-control',
                ],
               'validation' => 'required|unique:academic_classes,class_name,'.$id.',id,class_name,'.Input::get(self::CLASS_NAME)
            ],
            [
                'type'=>'textarea',
                'name'=>self::NOTE,
                'label' => 'Note',
                'value'=>null,
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12 ',
                'trans'=>false,
                'others'=>[
                    'class'=>'form-control',
                ]
            ],
            [
                'type'=>'radio',
                'name'=>self::Academic_Group_Present,
                'label' => 'Group Present?',
                'others'=>['class'=>'form-control'],
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12',
                'radval'=> [true=>'Yes',false=>'No'],
                'checked' => false,
                'validation'=>"required"
            ],
            [
                'type'=>'radio',
                'name'=>self::STATUS,
                'label' => 'Status',
                'others'=>['class'=>'form-control'],
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12',
                'radval'=> [true=>'Active',false=>'Inactive'],
                'checked' => true,
                'validation'=>"required"
            ],
            submitBtn($id),
        ];
    }
}