<?php


namespace App\Forms;


use App\Models\Timetable\ClassTimingDetail;

class ClassTimingDetailsForm extends ClassTimingDetail   implements FormInterface
{
    use FormControll, DataHelper;

    public function formInputFields($id=null, $mode=null)
    {
        return [

            [
                'type'=>'text',
                'name'=>self::NAME,
                'label' => 'Name',
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12',
                'others'=>[
                    'class'=>'form-control'
                ],
                'validation'=>'required'

            ],
               [
                'type'=>'text',
                'name'=>self::START_TIME,
                'label' => 'Class Start Time',
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12',
                'others'=>[
                    'class'=>'form-control'
                ],
                'validation'=>'required'

            ],
               [
                'type'=>'text',
                'name'=>self::END_TIME,
                'label' => 'Class End Time',
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12',
                'others'=>[
                    'class'=>'form-control'
                ],
                'validation'=>'required'


            ],
            [
                'type'=>'radio',
                'name'=>self::IS_BREAK,
                'label' => 'Is Break',
                'radval'=> [true=>'Yes',false=>'No'],
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12 ',
                'others'=>[
                    'class'=>'form-control',
                ],
                'value'=>false,
                'validation'=>'required',

            ],


            /*[
                'type'=>'submit',
                'label' => 'Submit',
                'others'=>[
                    'class'=>'btn btn-success',
                    'readonly'=>'readonly'
                ],
            ]*/
            submitBtn($id),
        ];
    }

}