<?php
/**
 * Created by PhpStorm.
 * User: HP
 * Date: 1/11/2016
 * Time: 8:23 PM
 */

namespace App\Forms;


use App\Models\Religion\Religion;

class ReligionForm extends Religion implements FormInterface
{
    use FormControll;

    public function formInputFields($id = null, $mode = null)
    {
        return [
            [
                'type' => 'text',
                'name' => self::NAME,
                'label' => 'Religion Name',
                'value' => null,
                'labclass' => 'col-sm-12',
                'wrapclass' => 'col-sm-12 ',
                'trans' => true,
                'others' => [
                    'class' => 'form-control',
                ],
                'validation'=>'required|unique:religion_translations,name,'.$id.',religion_id,site_id,'.session()->get(SITE_ID),

                //'validation' => 'required'
                //'validation' => 'required|unique:religion_translations,name,' . $id
            ],
            [
                'type' => 'radio',
                'name' => self::STATUS,
                'label' => 'Religion Status',
                'labclass' => 'col-sm-12',
                'wrapclass' => 'col-sm-12 ',
                'radval' => ['Active' => 'Active', 'Inactive' => 'Inactive'],
                'checked' => 'Active',
                'others' => [
                    'class' => 'form-control',
                ],
                'validation' => ''
            ],
            /*[
                'type'=>'submit',
                'label' => 'Submit',
                'others'=>[
                    'class'=>'btn btn-success',
                    'readonly'=>'readonly'
                ],
            ]*/
            submitBtn($id),
        ];
    }

} 