<?php

/**
 * Created by PhpStorm.
 * User: Abdul Aziz
 * Date: 4/27/2016
 * Time: 4:04 PM
 */

namespace App\Http\Controllers\AcademicAll;

use App\Forms\AcademicClassForm;
use App\Http\Controllers\Controller;
use App\Forms\DataHelper;
use App\Forms\FormControll;
use App\Http\Controllers\Language\Lang;
use App\Http\Controllers\ProjectController;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicSection;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use App\Models\SubjectGroup\SubjectGroup;
use App\Models\Student\Section;
use App\Models\Status\Status;
use App\Http\Requests\Validator;
use App\Models\User\User;
use DB;
use Illuminate\Http\Request;
use App\Http\Requests;
use Session;


class AcademicClassController extends Controller
{
    use Lang, FormControll, DataHelper;

    private $academicClass;
    private $classGroupSectionSetting;

    public function __construct(AcademicClass $academicClass, SiteShiftClassGroupSectionSetting $classGroupSectionSetting)
    {
        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');
        $this->academicClass = $academicClass;
        $this->classGroupSectionSetting = $classGroupSectionSetting;
    }

    public function getClassList()
    {

        $classList = $this->classGroupSectionSetting
            ->with('academicClass')
            ->where('academic_shift_id', 1)
            ->get();
        return $classList;

    }

    public function getClassWithPagination(Request $request)
    {
        $paginate = $request->paginate;
        $search_txt = $request->search_txt;
        $txt = '%' . $search_txt . '%';
        $class_list = $this->academicClass
            ->when($search_txt, function ($q) use ($txt) {
                $q->where('class_name', 'LIKE', $txt);
            })
            ->orderBy('serial_no', 'ASC')
            ->paginate($paginate);
        return response()->json($class_list, 200);
    }

    public function getClassListBySiteID()
    {
        $classList = $this->classGroupSectionSetting->get();

        return $classList;
    }


    public function index()
    {
        $viewType = 'Class List';
        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.academic.class.index', compact('viewType'));
    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function createClassForm()
    {

        $viewType = 'Create Class';
        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.academic.class.create-class', compact('viewType'));
    }

    /**
     * @param Validator $validatedRequest
     * @return mixed
     */
    public function createClass(Request $request)
    {

        $this->validate($request, [
            'class_name' => 'required',
        ]);

        $allClasses = $this->academicClass;
        $isOwnFieldsSaved = $this->ownFieldsToSave($allClasses, $request);


        if ($isOwnFieldsSaved) {
            return response()->json(['message' => 'Successfully Created', 'mode' => 'Success'], 200);
        }
    }

    /**
     * @param AcademicClass $academicClass
     * @param Validator $validatedRequest
     * @return bool
     */
    private function ownFieldsToSave(AcademicClass $academicClass, $request)
    {
        if (isset($academicClass->ownFields)) {
            foreach ($academicClass->ownFields as $ownField) {
                if ($request->{$ownField})
                    $academicClass->{$ownField} = $request->{$ownField};
            }
            $academicClass->academic_group_present = $request->academic_group_present;
        }
        if ($academicClass->save()) {
            return true;
        }
        return false;
    }

    /**
     * @param $id
     * @param AcademicClassForm $academicClassForm
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function editClassForm()
    {
        $viewType = 'Edit Class';

        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.academic.class.edit', compact('classData', 'viewType', 'editClass'));
    }

    /**
     * @param $id
     * @param Validator $validatedRequest
     * @return mixed
     */
    public function editClass(Request $request)
    {
        $classData = $this->academicClass->findOrFail($request->id);
        $this->validate($request, [
            'class_name' => 'required',
        ]);

        $isOwnFieldsSaved = $this->ownFieldsToSave($classData, $request);

        if ($isOwnFieldsSaved) {
            return response()->json(['message' => 'Successfully Updated', 'mode' => 'Success'], 200);

        }
    }

    /**
     * @param $id
     * @return $this
     */
    public function deleteClass($id)
    {
        $isExistInGroup = DB::select('SELECT * FROM site_group_settings WHERE FIND_IN_SET(?,academic_class_ids) > 0 LIMIT 1;', [$id]);
        $isExistInSite = DB::select('SELECT * FROM site_infos WHERE FIND_IN_SET(?,academic_class_ids) > 0 LIMIT 1;', [$id]);


        if (count($isExistInGroup) > 0) {
            return back()->withErrors('Dependency Found in Site Group Settings:  ID: ' . $isExistInGroup[0]->id);
        }
        if (count($isExistInSite) > 0) {
            return back()->withErrors('Dependency Found in Site Group Settings:  ID: ' . $isExistInSite[0]->id);
        }
        $menuToDelete = $this->menu->findOrFail($id);
        if ($menuToDelete->delete()) {
            return back()->withSuccess('The Route Successfully Deleted');
        }


        $classToDelete = $this->academicClass->findOrFail($id);
        if ($classToDelete->delete()) {
            return back()->withSuccess('Successfully deleted');
        }

        return back()->withErrors('Not successfully deleted');
    }

    public function sectionOfClass($classId, AcademicClass $academicClass, Request $request)
    {
        $selectedClass = $academicClass->findOrFail($classId);
        //dd($selectedClass);
        $sectionForClass = $selectedClass->sections;
        $subjectForClass = $selectedClass->subjects;
        $subjectGroupForClass = $selectedClass->subjectGroups;
//        dd($subjectGroupForClass);
        if ($request->ajax()) {
            return response()->json([$sectionForClass, $subjectForClass, $subjectGroupForClass]);
        }
    }


    public function siteBaseClassList()
    {

        $SiteInfoTableData = SiteInfo::where('id', (Session::get(SITE_ID)))->first();

        $academicclass = explode(',', $SiteInfoTableData->academic_class_ids);

        $academicClassList = AcademicClass::select('id', 'class_name')
            ->whereIn('id', $academicclass)
            ->get();


        return $academicClassList;
    }

}