<?php

namespace App\Http\Controllers\AcademicAll;

use App\Models\Academic\AcademicGroup;
use App\Models\Site\SiteGroup;
use Doctrine\DBAL\Exception\ConnectionException;
use Exception;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class AcademicGroupController extends Controller
{
    private $academicGroup;

    public function __construct(AcademicGroup $academicgroup)
    {

        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');

        $this->academicGroup = $academicgroup;
    }


    public function getList(Request $request)
    {
        $paginate = $request->paginate;
        $search_txt = $request->search_txt;
        $txt = '%' . $search_txt . '%';

        $subjects = $this->academicGroup
            ->with('classes')
            ->when($search_txt, function ($q) use ($txt) {
                $q->whereTranslationLike('subject_name', $txt);
            })
            ->orderByTranslation('subject_name', 'ASC')
            ->paginate($paginate);

        return $subjects;
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType = 'Create Academic Group';
        return view('default.admin.layouts.master', compact('viewType'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $viewType = 'Create Academic Group';
        $mode = true;
        $academicGroupList = $this->academicGroup->paginate(20);

        $paginate = $request->paginate;
        $search_txt = $request->search_txt;
        $txt = '%' . $search_txt . '%';

        $subjects = $this->academicSubject
            ->with('classes')
            ->when($search_txt, function ($q) use ($txt) {
                $q->whereTranslationLike('subject_name', $txt);
            })
            ->orderByTranslation('subject_name', 'ASC')
            ->paginate($paginate);


        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.academic.group.create', compact('viewType', 'academicGroupList', 'mode'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $this->validate($request, [
            "academic_group_name" => "required|unique:academic_groups,academic_group_name"
        ]);

        $academic_group_serial=$request->serial?$request->serial:1000;


        $this->academicGroup->academic_group_name = $request->academic_group_name;
        $this->academicGroup->serial = $academic_group_serial;
        $this->academicGroup->save();


        return response()->json(['message' => 'Successfully Saved', 'mode' => 'Save']);

    }


    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        $this->validate($request, [
            "academic_group_name" => "required|unique:academic_groups,academic_group_name," . $request->id
        ]);

        $academic_group_serial=$request->serial?$request->serial:1000;

        $academic_group = $this->academicGroup->findOrFail($request->id);
        $academic_group->academic_group_name = $request->academic_group_name;
        $academic_group->serial = $academic_group_serial;
        $academic_group->save();

        return response()->json(['message' => 'Successfully Update', 'mode' => 'Update']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }


    public function getGroupList(Request $request)
    {
        $paginate = $request->paginate;
        $search_txt = $request->search_txt;
        $txt = '%' . $search_txt . '%';

        $group_list = $this->academicGroup
            ->when($search_txt, function ($q) use ($txt) {
                $q->where('academic_group_name', $txt);
            })
            ->orderBy('serial', 'ASC')
            ->orderBy('id', 'ASC')
            ->paginate($paginate);
        return $group_list;
    }

    //Other methods
    public function getAcademicGroupsBySiteGroup($id)
    {
        try {

            $site_group = SiteGroup::findOrFail($id);
            $academic_ids = explode(',', $site_group->academic_group_ids);
            $academicGroup = AcademicGroup::whereIn('id', $academic_ids)->get();

            return $academicGroup;

        } catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => 'SiteGroup Not Found'], 410);
        } catch (ConnectionException $exception) {
            return JsonResponse::create(['message' => 'Database Connection Failed'], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 410]);
        }
    }
}
