<?php

namespace App\Http\Controllers\AcademicAll;

use App\Models\Academic\AcademicShift;
use App\Models\Site\SiteInfo;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Session;


class AcademicShiftController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');

    }


    /**
     * @return mixed
     */
    public function getSiteShiftListBySiteSessionId($site_id)
    {
        //dd('ok');
        //dd(Session::get(SITE_ID));

        $SiteInfoTableData=SiteInfo::where('id',$site_id)->first();
        $academicShift=explode(',',$SiteInfoTableData->shift_ids);


        $academicClassGroupPresentList = AcademicShift::whereIn('id',$academicShift)
            ->get();

        return $academicClassGroupPresentList;
    }
}
