<?php

namespace App\Http\Controllers\AcademicAll;

use App\Models\Academic\AcademicStudentOfferType;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Site\SiteInfo;
use Session;

class AcademicStudentOfferTypeController extends Controller
{

    private $academicStudentOfferType;

    public function __construct(AcademicStudentOfferType $academicStudentOfferType)
    {
        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');
        $this->academicStudentOfferType = $academicStudentOfferType;

    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType = 'Fee Head List';
        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.sites.site-student-offer-type.view', compact('viewType'));
    }

    public function getAcademicStudentOfferTypeList()
    {
        $academicStudentOfferTypes = new AcademicStudentOfferType();
        $academicStudentOfferTypesList = $academicStudentOfferTypes->get();

        return $academicStudentOfferTypesList;
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|unique:academic_student_offer_types',

        ]);

        $academicStudentOfferTypesList=AcademicStudentOfferType::create([
            'name' => $request->name,
            'status' => $request->status
        ]);
        return ['message' => 'Successfully Saved!'];
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'name' => 'required|unique:academic_student_offer_types',

        ]);

        $academicStudentOfferTypeUpdate = $this->academicStudentOfferType->findOrFail($id);

        $academicStudentOfferTypeUpdate->update([
            'name'=>$request->get('name'),
            'status'=>$request->get('status'),
        ]);

        return ['message' => 'Successfully Updated!'];
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $academicStudentOfferTypeDelete = $this->academicStudentOfferType->findOrFail($id);

        $academicStudentOfferTypeDelete->delete();
        return ['message' => 'Successfully Deleted!'];
    }
}
