<?php

namespace App\Http\Controllers\AcademicAll;

use App\Models\ClassGroup\ClassGroup;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class ClassGroupController extends Controller
{
    private $classGroup;

    public function __construct(ClassGroup $classgroup)
    {

        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');

        $this->classGroup = $classgroup;
    }

    public function getList(Request $request)
    {
        $paginate = $request->paginate;
        $search_txt = $request->search_txt;
        $txt = '%' . $search_txt . '%';

        $subjects = $this->classGroup
            ->when($search_txt, function ($q) use ($txt) {
                $q->where('group_name', $txt);
            })
            ->orderBy('group_name', 'ASC')
            ->paginate($paginate);
        return response()->json($subjects, 200);
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType = 'Class Group List';

        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.class-group.create', compact('viewType', 'classGroupList', 'mode'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $this->validate($request, [
            "group_name" => "required|unique:academic_class_groups,group_name"
        ]);
        $this->classGroup->group_name = $request->group_name;
        $this->classGroup->save();

        return response()->json(['message' => 'Successfully Saved!'], 200);
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {

        $viewType = "Edit Group";
        return view('default.admin.layouts.master', compact('viewType'));

    }

    public function getTheGroup($id)
    {

        $the_group = $this->classGroup->findOrFail($id);

        return response()->json($the_group, 200);


        return view('default.admin.class-group.create', compact('viewType', 'classGroupList', 'singleClassGroup', 'mode'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {

        $this->validate($request, [
            "group_name" => "required|unique:class_groups,group_name," . $request->id
        ]);


        $viewType = 'Update Class Group';
        $classgroup_Update = $this->classGroup->findOrFail($request->id);
        $classgroup_Update->group_name = $request->group_name;
        $classgroup_Update->save();

        return response()->json(['message' => 'Successfully Updated'], 200);

        return redirect()->route('class-group-create')->withSuccess('Successfully Update');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $classgroup_Delete = $this->classGroup->findOrFail($id);
        $classgroup_Delete->delete();

        return response()->json(['message'=>'Successfully Deleted'], 200);

    }
}
