<?php

namespace App\Http\Controllers\AcademicAll;

use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicGroup;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicSession;
use App\Models\Academic\AcademicStudentCategory;
use App\Models\Academic\AcademicSubject;
use App\Models\Academic\SubjectCondition;
use App\Models\Designation\Designation;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\GroupBaseDetail;
use League\Flysystem\Exception;
use Psy\Util\Json;
use Response;
use DB;
use Symfony\Component\Debug\Exception\UndefinedFunctionException;
use Symfony\Component\Routing\Exception\MethodNotAllowedException;

class GroupBaseDetailController extends Controller
{


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');

    }

    public function index()
    {
        //
    }


    public function getAcademicGroupList()
    {
        $groups =AcademicGroup::all();
        return $groups;
    }


    public function getAcademicGroupBasedClassSectionGroupSubjectCondition($id)
    {

        try{


        $classes =AcademicClass::whereStatus(1)->get(); //DB::select('SELECT id, class_name, academic_group_present FROM academic_classes WHERE STATUS=1');
        $sections = AcademicSection::all();// DB::select('SELECT id, section_name FROM academic_sections');
        $groups =AcademicClassGroup::all();// DB::select('SELECT id, group_name FROM academic_class_groups');
        $subjectCondition =SubjectCondition::all();// DB::select('SELECT id, name, status FROM academic_subject_conditions');
        $groupBasedDetail = GroupBaseDetail::whereAcademicGroupId($id)->first() ?? null;
        $academicSession=AcademicSession::all();
        $subjectList=AcademicSubject::all();
        $departmentList=AcademicDepartment::all();
        $designationList=Designation::all();



        $details_array=null;

       if ($groupBasedDetail){
           $details_array['academic_class_ids']=$groupBasedDetail->academic_class_ids?explode(',',$groupBasedDetail->academic_class_ids):null;
           $details_array['academic_class_group_ids']=$groupBasedDetail->academic_class_group_ids?explode(',',$groupBasedDetail->academic_class_group_ids):null;
           $details_array['academic_section_ids']=$groupBasedDetail->academic_section_ids?explode(',',$groupBasedDetail->academic_section_ids):null;
           $details_array['academic_subject_ids']=$groupBasedDetail->academic_subject_ids?explode(',',$groupBasedDetail->academic_subject_ids):null;
           $details_array['academic_subject_condition_ids']=$groupBasedDetail->academic_subject_condition_ids?explode(',',$groupBasedDetail->academic_subject_condition_ids):null;
           $details_array['academic_session_ids']=$groupBasedDetail->academic_session_ids? explode(',',$groupBasedDetail->academic_session_ids):null;
           $details_array['academic_department_ids']=$groupBasedDetail->academic_department_ids? explode(',',$groupBasedDetail->academic_department_ids):null;
           $details_array['designation_ids']=$groupBasedDetail->designation_ids? explode(',',$groupBasedDetail->designation_ids):null;


       }

       // return  $groupBasedDetail->academic_session_ids;

        return [$classes, $sections, $groups, $subjectCondition, $details_array,$subjectList,$academicSession, $departmentList, $designationList];
        }
        catch (Exception $exception){
            return JsonResponse::create(['message'=>$exception->getMessage()],401);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $viewType='Group base Academic Detail Page';
        return view('default.admin.layouts.master',compact('viewType'));
        return view('default.admin.academic-group-detail.create',compact('viewType'));

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return JsonResponse
     */
    public function store(Request $request)
    {

        $academic_department_ids=implode(',',array_unique($request->academic_department_ids??[]));
        $academic_class_ids=implode(',',array_unique($request->academic_class_ids??[]));
        $academic_class_group_ids=implode(',',array_unique($request->academic_class_group_ids??[]));
        $academic_section_ids=implode(',',array_unique($request->academic_section_ids??[]));
        $academic_subject_condition_ids=implode(',',array_unique($request->academic_subject_condition_ids??[]));
        $designation_ids=implode(',',array_unique($request->designation_ids??[]));
        $selectedSubjectIds=implode(',',array_unique($request->selectedSubjectIds??[]));
        $selectedSessionIds=implode(',',array_unique($request->selectedSessionIds??[]));
     
        $check=GroupBaseDetail::whereAcademicGroupId($request->academic_group_id)->first();
     
        if($check){
            $check->update([
                'academic_department_ids' => $academic_department_ids,
                'academic_class_ids' => $academic_class_ids,
                'academic_class_group_ids' => $academic_class_group_ids,
                'academic_section_ids' => $academic_section_ids,
                'academic_subject_condition_ids' => $academic_subject_condition_ids,
                'designation_ids' => $designation_ids,
                'academic_subject_ids' => $selectedSubjectIds,
                'academic_session_ids'=>$selectedSessionIds,
            ]);

            return JsonResponse::create([
                'message' => 'Academic Group Detail Successfully Updated!',
                'mode' => 'Updated!',
            ]);
        }
        else{
            GroupBaseDetail::create([
                'academic_group_id' => $request->academic_group_id,
                'academic_department_ids' => $academic_department_ids,
                'academic_class_ids' => $academic_class_ids,
                'academic_class_group_ids' => $academic_class_group_ids,
                'academic_section_ids' => $academic_section_ids,
                'academic_subject_condition_ids' => $academic_subject_condition_ids,
                'designation_ids' => $designation_ids,
                'academic_subject_ids' => $selectedSubjectIds,
                'academic_session_ids'=>$selectedSessionIds,
            ]);


            return JsonResponse::create(['message' => 'Academic Group Detail Successfully Created!',
                'mode' => 'Saved!',
            ]);
        }





    }


}
