<?php

namespace App\Http\Controllers\AcademicAll;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Forms\FormControll;
use App\Models\Department\Department;
use App\Models\House\House;
use App\Models\User\User;
use Response;

class HouseController extends Controller
{
    use FormControll;

    private $House;

    /**
     * HouseController constructor.
     * @param House $House
     */
    public function __construct(House $House)
    {

        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');
        $this->House = $House;
    }

    public function index()
    {

        $viewType = 'House List';

        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.House.index', compact('viewType', 'model'));

    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function createHouseForm()
    {
        $viewType = 'Create House';
        return view('default.admin.House.create', compact('viewType'));
    }

    /**
     * @param Request $validatedRequest
     * @return \Illuminate\Http\RedirectResponse|null
     */
    public function createHouse(Request $validatedRequest)
    {

        $this->validate($validatedRequest, [
            'name' => 'required|unique:houses',
            'status' => 'required|in:0,1'

        ]);

        $this->House->create([
            'name' => ucwords($validatedRequest->get('name')),
            'status' => ucwords($validatedRequest->get('status'))
        ]);

        return response()->json(['message' => 'Successfully Created', 'mode' => 'Success'], 200);

    }

    /**
     * @param $id
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function editHouseForm($id)
    {
        $viewType = 'Edit House';

        $HouseToEdit = $this->editFormModel($this->House->findOrFail($id));

        return view('default.admin.House.edit', compact('HouseToEdit', 'viewType'));
    }


    public function editHouse(Request $validatedRequest)
    {

        $this->validate($validatedRequest, [
            'name' => 'required|unique:houses,id,' . $validatedRequest->id,
            'status' => 'required|in:0,1'

        ]);
        $HouseToEdit = $this->House->findOrFail($validatedRequest->id);

        $isEdited = $HouseToEdit->update([
            'name' => ucwords($validatedRequest->get('name')),
            'status' => $validatedRequest->get('status')
        ]);

        return response()->json(['message' => 'Subject Condition Successfully Updated!'], 200);

    }

    /**
     * @param $id
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function getHouseList(Request $request)
    {

        $paginate = $request->paginate;
        $search_txt = $request->search_txt;
        $txt = '%' . $search_txt . '%';
        $class_list = $this->House
            ->when($search_txt, function ($q) use ($txt) {
                $q->where('name', 'LIKE', $txt);
            })->orderBy('id', 'DESC')
            ->paginate($paginate);

        return response()->json($class_list, 200);
    }

    /**
     * @param $id
     * @return $this|\Illuminate\Http\RedirectResponse
     */
    public function deleteHouse($id)
    {
        $HouseToDelete = $this->House->findOrFail($id);

        if ($HouseToDelete->delete()) {
            return redirect()->route('House-list')->with('success', 'Successfully Deleted!');
        }
        return redirect()->route('House-list')->withErrors('Not successfully deleted');

        /*if($HouseToDelete->delete()){

            return back();
        }
        return back()->withErrors('Not successfully deleted');*/


    }

    /**
     * @param $deptId
     * @param Department $department
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function HouseOfDept($deptId, Department $department, Request $request)
    {
        $selectedDepertment = $department->findOrFail($deptId);
        $HouseForDept = $selectedDepertment->Houses;
        $shiftForDetp = $selectedDepertment->shifts;
        $defalutLangShift = [];
        if (!$shiftForDetp->isEmpty()) {
            foreach ($shiftForDetp as $key => $item) {
                if (!is_null($item)) {
                    $defalutLangShift[$item->id] = $item->translate('en')->name;
                }
            }
        }

        if ($request->ajax()) {
            return response()->json([$HouseForDept, $defalutLangShift]);
        }
    }

    public function HouseToEdit($userId, User $user, Request $request)
    {
        $userToEdit = $user->findOrFail($userId);
        $HouseToEdit = $this->House->findOrFail($userToEdit->House_id);

        if ($request->ajax()) {
            return response()->json($HouseToEdit);
        }

    }
}
