<?php

namespace App\Http\Controllers\Api\Dashboard;

use App\Models\Attendance\GlobalStudentAttendance;
use App\Models\Attendance\StudentAttendance;
use App\Models\Site\Employee\Employee;
use App\Models\Site\Employee\EmployeeAttendance;
use App\Models\Site\Employee\GlobalEmployee;
use App\Models\SiteGroup\Site\Employee\SiteGroupEmployeeAttendance;
use App\Models\User\User;
use Auth;
use Carbon\Carbon;
use Exception;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Session;

class DashboardApiController extends Controller
{


    private $user;
    private $employeeAttendance;
    private $studentAttendance;
    private $siteGroupEmployeeAttendance;
    private $globalStudentAttendance;

    public function __construct(User $user, EmployeeAttendance $employeeAttendance, StudentAttendance $studentAttendance,
                                SiteGroupEmployeeAttendance $siteGroupEmployeeAttendance, GlobalStudentAttendance $globalStudentAttendance)
    {

        $this->middleware('auth:api');
        $this->middleware('api.access');

        $this->employeeAttendance = $employeeAttendance;
        $this->studentAttendance = $studentAttendance;
        $this->siteGroupEmployeeAttendance = $siteGroupEmployeeAttendance;
        $this->globalStudentAttendance = $globalStudentAttendance;

        $this->user = $user;
    }



}
