<?php

namespace App\Http\Controllers\Api\Edu\Menu;

use App\Forms\DataHelper;
use App\Models\Menu\Menu;
use Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Validation\ValidationException;
use Response;
use Illuminate\Support\Facades\Session;
use Auth;
use Illuminate\Foundation\Application;


class MenuApiController extends Controller
{
    private $app;
    private $menu;
    private $localeCode;

    public function __construct(Menu $menu, Application $app)
    {
        $this->middleware('auth:api');
        $this->middleware('api.access');
        $this->menu = $menu;
        $this->app = $app;

        // $this->localeCode = Auth::user()->locale;
        // dd($this->localeCode);
        // Session::put('locale', $this->localeCode);
       //  $this->app->setLocale($this->localeCode);
      ///   $this->setLocalize();
       
      $this->middleware(function ($request, $next) {
        $this->localeCode = Auth::user()->locale;
        Session::put('locale', $this->localeCode);
        $this->app->setLocale($this->localeCode);
        return $next($request);
    });
       
    }

    use DataHelper;

    public function getMenuForList()
    {
       
        return $this->menuForList();
       
    }

    // private function setLocalize(){
    //     $localeCode = Auth::user()->locale;
    //     Session::put('locale', $localeCode);
    //    return $this->app->setLocale($localeCode);
    // }



    public function getMenusList(Request $request)
    {
      //  $this->setLocalize();
        $search_txt = $request->search_txt;
        $is_displayable = $request->is_displayable;
        $is_common_access = $request->is_common_access;
        $paginate = $request->paginate ?? 20;
        $status = $request->status;
        $txt = '%' . $search_txt . '%';

        //   \Log::info($is_displayable);


        $menus = $this->menu
            ->when($is_displayable, function ($q) use ($is_displayable) {
                $q->where('is_displayable', $is_displayable);
            })->when($is_common_access, function ($q) use ($is_common_access) {
                $q->where('is_common_access', $is_common_access);
            })
            ->when($search_txt, function ($q) use ($txt) {
                return $q->where(function ($query) use ($txt) {
                    $query->where('id', 'LIKE', $txt)
                    ->orWhere('route_name', 'LIKE', $txt)
                    ->orWhereTranslationLike('menu_name', $txt);
                });
            })->orderBy('id', 'DESC')
           // ->where('type_id', 0)
            ->where('status', $status)
            ->paginate($paginate);
        //    dd($this->setLocalize());
        return Response::json($menus, 200);

    }

    public function displayableMenusList(Request $request)
    {
        $menus = $this->menu
            ->where('is_displayable', 1)
            ->get();

        return $menus;
    }

    public function getPositionForParentMenu(Request $request)
    {
        $parent_ids = $this->menu
            ->where('parent_id', $request->parent_id)
            ->orderBy('position')
            ->pluck('position');
        return $parent_ids;
    }

    public function getMenuBySearch(Request $request)
    {

        $search_txt = $request->search_txt;
        $is_displayable = $request->is_displayable;
        $is_common_access = $request->is_common_access;
        $status = $request->status;
        $txt = '%' . $search_txt . '%';

      //  \Log::info($request);


        $menus = $this->menu
            ->where('is_displayable', $is_displayable)
            ->when($is_common_access, function ($q) use ($is_common_access) {
                $q->where('is_common_access', $is_common_access);
            })
            ->when($search_txt, function ($q) use ($txt) {
                return $q->where(function ($query) use ($txt) {
                    $query->where('id', 'LIKE', $txt);
                });
            })->orderBy('id', 'DESC')
            ->where('status', $status)
            ->get()->map(function ($val) {
                return [
                    'id' => $val->id,
                    'menu_name' => $val->menu_name ?? '',
                    'route_name' => $val->route_name ?? ''
                ];
            });

        
        return response()->json($menus, 200);
    }

    public function createMenu(Request $request)
    {
        try {

            $this->validate($request, [
                'menu_name' => 'required|unique:menu_translations,menu_name',
                'route_name' => 'required|unique:menus,route_name',
                'menu_for' => 'required',
            ]);


            if ($request->parent_id && $this->parentLevelInCorrect($request->parent_id, $request->is_displayable)) {
                return response()->json(['message' => 'Parent Level InCorrect!'], 410);
            }
            if (!$request->parent_id && !$request->is_displayable) {
                return response()->json(['message' => 'Api Should have parent!'], 410);
            }
            if (isset($this->menu->ownFields)) {
                foreach ($this->menu->ownFields as $ownField) {
                    if ($request->{$ownField} || $request->status || $request->is_displayable || $request->is_common_access || $request->is_logged_common_access) {
                        $this->menu->{$ownField} = $request->{$ownField};
                    }
                }
            }

            foreach ($this->menu->translatedAttributes as $field) {
                foreach (config('app.locales') as $locale => $value) {
                    if ($request->get($field . '_' . $locale)) {
                        $this->menu->translateOrNew($locale)->{$field} = $request->get($field . '_' . $locale);
                    }
                }
            }

            $this->menu->save();
            return response()->json(['message' => 'Menu Successfully Created'], 200);

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 500);

        }
    }

    public function updateMenu($id, Request $validatedRequest)
    {

       
        if ($validatedRequest->parent_id && $this->parentLevelInCorrect($validatedRequest->parent_id, $validatedRequest->is_displayable)) {
            return response()->json(['message' => 'Parent Level InCorrect!'], 410);
        }
        if (!$validatedRequest->parent_id && !$validatedRequest->is_displayable) {
            return response()->json(['message' => 'Api Should have parent!'], 410);

        }

        //   \Log::info($validatedRequest);


        $this->validate($validatedRequest, [
            'menu_name' => 'required|unique:menu_translations,menu_name,' . $id . ',menu_id',
            'route_name' => 'required|unique:menus,route_name,' . $id,
        ]);
     
        $menuToEdit = Menu::findOrFail($id);

        if (isset($menuToEdit->ownFields)) {
            foreach ($menuToEdit->ownFields as $ownField) {
                if ($validatedRequest->{$ownField} || $validatedRequest->status || $validatedRequest->is_displayable || $validatedRequest->is_common_access || $validatedRequest->is_logged_common_access) {
                    $menuToEdit->{$ownField} = $validatedRequest->{$ownField};
                }
            }
       }
        
            // foreach ($menuToEdit->translatedAttributes as $field) {
            //      foreach (config('app.locales') as $locale => $value) {
                   
            //     //    $menuToEdit->translateOrNew($locale)->{$field} = $validatedRequest->{$field};
            //         if ($validatedRequest->get($field . '_' . $locale)) {
            //             $menuToEdit->translateOrNew($locale)->{$field} = $validatedRequest->get($field . '_' . $locale);
            //         }
            //      }
            //  } 

        $menuToEdit->save();
        return JsonResponse::create(['message' => "Successfully Updated"], 200);


    }

    public function deleteMenu($id)
    {

        $menuToDelete = $this->menu->findOrFail($id);
        if ($menuToDelete->delete()) {
            $menuToDelete->deleteTranslations();
            return response()->json(['message' => 'The Route Successfully Deleted'], 200);
        }
    }


    public function parentLevelInCorrect($parent_id, $is_displayable)
    {
        $parent = $this->menu->findOrFail($parent_id);

        if ($parent && $parent->parent_id) {
            $parent1 = $this->menu->findOrFail($parent->parent_id);
            if ($parent1 && $parent1->parent_id && $is_displayable) {
                return true;
            }
        }
        return false;
    }
}
