<?php

namespace App\Http\Controllers\Api\EmployeePanel;

use App\Http\Controllers\Api\ApiProjectController;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\User\UserMessage;
use App\Traits\PaginationTrait;
use Exception;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\ValidationException;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Session;
use DB;

class EmployeeMessageApiController extends ApiProjectController
{
    use PaginationTrait;
    public function __construct()
    {
        $this->middleware('auth:apps-api');
        $this->middleware('api.app.access');
        $this->middleware('employee.check');
    }
    
    public function getEmployeeMessageList(Request $request)
    {

        try{

        $paginate = $request->paginate??10;
        
        $this->siteInfoSessionPut($request);

        $message_list = UserMessage::with(['creator'=>function($q){
                    $q->select('id');
                }])
                ->where('user_id', Auth::id())
                ->where('message_type_key', 'message')
                ->orderBy('id','DESC')
                ->paginate($paginate);
                
            $data=[
                'message_list'=>$message_list,
                'mode'=>'success',
                'status'=>'200',
            ];
        
            return response()->json($data,200);


        } catch (ValidationException $exception) {
           // DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
           // DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
          //  DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }
      
    }

}



