<?php

namespace App\Http\Controllers\Api\EmployeePanel;

use App\Http\Controllers\Api\ApiProjectController;
use Illuminate\Http\Request;
use App\Models\Attendance\StudentAttendance;
use App\Models\Edu\Issue\IssueDetail;
use App\Models\Role\Role;
use App\Models\Setting\Setting;
use App\Models\Site\Academic\SitePeriodTypeDuration;
use App\Models\Site\Routine\RoutineAllocation;
use App\Models\Site\Routine\RoutineDetail;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Models\Site\Student\Attendance\StudentAbsentDetail;
use App\Traits\SmsFunctionsTrait;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use App\Models\Site\Student\Student;
use App\Models\Student\StudentHistory;
use App\Models\User\User;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicClass;
use App\Models\Site\Employee\EmployeeAttendance;
use App\Models\Site\Employee\EmployeeGeolocationSetting;
use Exception;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\ValidationException;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use App\Models\Site\SiteShiftDetails;
use App\Models\Site\Student\Attendance\PeriodicAttendance;
use App\Traits\LiveStreamingApiTrait;
use App\Traits\Site\Attendance\AttendanceRequestSave;
use App\Traits\Site\EventTrait;
use App\Traits\Site\Routine\RoutineFunction;
use App\Traits\TimeRelatedFunctionTrait;
use Carbon\Carbon;
use Session;
use PDF;
use Error;
use Response;



class StudentAttendanceApiForEmployeeController extends ApiProjectController
{
use  SmsFunctionsTrait, RoutineFunction, EventTrait, TimeRelatedFunctionTrait;


    private $carbon_now;
    private $studentAttendance;
    private $absentDetail;
    private $setting;
    private $user;
    private $siteShiftDetails;
    private $academicClass;
    private $academicSection;
    private $periodTypeDuration;
    private $routineDetail;
    private $siteShiftClassGroupSectionSetting;
    private $routineAllocation;
    private $studentHistory;
    private $student;
    private $infoSetting;
    private $periodicAttendance;

    public function __construct(RoutineDetail $routineDetail, StudentAttendance $studentAttendance, Setting $setting, User $user, RoutineAllocation $routineAllocation,
    SiteShiftDetails $siteShiftDetails, AcademicSection $academicSection, SiteShiftClassGroupSectionSetting $siteShiftClassGroupSectionSetting,
    AcademicClass $academicClass, SitePeriodTypeDuration $periodTypeDuration, StudentHistory $studentHistory, Student $student,
    StudentAbsentDetail $absentDetail, SiteInfoSetting $infoSetting, PeriodicAttendance $periodicAttendance)
    {
        $this->middleware('auth:apps-api');
        $this->middleware('api.app.access');
        $this->middleware('employee.check');

        $this->carbon_now = Carbon::now();

        $this->studentAttendance = $studentAttendance;
        $this->absentDetail = $absentDetail;
        $this->setting = $setting;
        $this->user = $user;
        $this->studentHistory = $studentHistory;
        $this->student = $student;
        $this->siteShiftDetails = $siteShiftDetails;
        $this->academicClass = $academicClass;
        $this->academicSection = $academicSection;
        $this->routineDetail = $routineDetail;
        $this->routineAllocation = $routineAllocation;
        $this->periodTypeDuration = $periodTypeDuration;
        $this->siteShiftClassGroupSectionSetting = $siteShiftClassGroupSectionSetting;
        $this->absentDetail = $absentDetail;
        $this->infoSetting = $infoSetting;
        $this->periodicAttendance = $periodicAttendance;

    }


    public function getSiteStudentAttendanceList(Request $request){

        try{

        $this->validate($request, [
            'academic_version_id' => 'required',
            'academic_year_id' => 'required',
            'academic_shift_id' => 'required',
            'academic_class_id' => 'required',
            'att_date' => 'required',
        ]);   

        $this->siteInfoSessionPut($request);
        $auth=Auth::user();
        $user_id=$auth->id;
      
            $data = [];
            $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
            $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
            $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;
            $data['academic_department_id'] = $request->academic_department_id == 'null' ? null : $request->academic_department_id;
            $data['academic_class_id'] = $request->academic_class_id == 'null' ? null : $request->academic_class_id;
            $data['academic_class_group_id'] = $request->academic_class_group_id == 'null' ? null : $request->academic_class_group_id;
            $data['academic_section_id'] = $request->academic_section_id == 'null' ? null : $request->academic_section_id;
            $data['academic_session_id'] = $request->academic_session_id == 'null' ? null : $request->academic_session_id;
            
            $att_date = $request->att_date;
            $present = $request->present;
            $leave = $request->leave;
            $absent = $request->absent;
            $search_txt = $request->search_txt;
            $status = $request->status;
            $paginate = $request->paginate ?? 20;
            $txt = '%' . $search_txt . '%';
            if ($present && $leave && $absent) {
                $present = 0;
                $leave = 0;
                $absent = 0;
            }
            $advance_date = ($this->carbon_now->toDateString() < $att_date);
            if ($advance_date) {
                return Response::json(['message' => 'The date can"t be future date!',  'mode'=>'error', 'status'=>'411'], 411);

            }
           
            $day = date('D', strtotime($att_date));
            $get_period_type_duration = $this->periodTypeDuration
                ->where('start_date', '<=', $att_date)
                ->where('end_date', '>=', $att_date)
                ->first();
            if (!$get_period_type_duration) {
                return Response::json(['message' => 'No Period Found On ' . $att_date,  'mode'=>'error', 'status'=>'404'], 404);

            }
    
            $st_list = null;
         //   dd($txt);
                $student_list = $this->studentHistory
                ->when($data['academic_version_id'], function ($query) use ($data) {
                    return $query->where('academic_version_id', $data['academic_version_id']);
                })->when($data['academic_year_id'], function ($query) use ($data) {
                    return $query->where('academic_year_id', $data['academic_year_id']);
                })->when($data['academic_shift_id'], function ($query) use ($data) {
                    return $query->where('academic_shift_id', $data['academic_shift_id']);
                })->when($data['academic_class_id'], function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })->when($data['academic_department_id'], function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })->when($data['academic_section_id'], function ($query) use ($data) {
                    return $query->where('academic_section_id', $data['academic_section_id']);
                })->when($data['academic_class_group_id'], function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })->when($data['academic_session_id'], function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->when($search_txt, function ($qu) use ($txt) {
                    $qu->whereHas('student', function ($q) use ($txt) {
                        return $q->where(function ($query) use ($txt) {
                            $query->where('username', 'LIKE', $txt)
                                ->orWhere('email', 'LIKE', $txt)
                                ->orWhere('contact_number', 'LIKE', $txt)
                                ->orWhere('student_roll_number', 'LIKE', $txt)
                                ->orWhereTranslationLike('first_name', $txt)
                                ->orWhereTranslationLike('last_name', $txt);
                        });
                    });
                })
                ->with(['student'])
                ->with(['attendance' => function ($q) use ($att_date) {
                    $q->where('present_date', $att_date);
                //    $q->orderBy('in_time', 'ASC');
                }, 'absent' => function ($q) use ($att_date) {
                    $q->where('absent_date', $att_date);
                }, 'leaveDetail' => function ($q) use ($att_date) {
                    $q->where('leave_date', $att_date);
                }
                ])
                ->where('status', $status)
                ->orderBy('student_roll_number')
                ->where('status', $status)
                ->paginate($paginate);
                // ->sortBy(function($query){
                //     $query->attendance;
                // });
    
                
            if($present && ($absent || $leave)){
                $st_att_list = $student_list;
            }elseif($absent || $leave){
            
                $student_list = $this->studentHistory
                ->when($data['academic_version_id'], function ($query) use ($data) {
                    return $query->where('academic_version_id', $data['academic_version_id']);
                })->when($data['academic_year_id'], function ($query) use ($data) {
                    return $query->where('academic_year_id', $data['academic_year_id']);
                })->when($data['academic_shift_id'], function ($query) use ($data) {
                    return $query->where('academic_shift_id', $data['academic_shift_id']);
                })->when($data['academic_class_id'], function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })->when($data['academic_department_id'], function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })->when($data['academic_section_id'], function ($query) use ($data) {
                    return $query->where('academic_section_id', $data['academic_section_id']);
                })->when($data['academic_class_group_id'], function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })->when($data['academic_session_id'], function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->when(($absent || $leave), function ($qu) use ($att_date) {
                    return $qu->whereHas('attendance', function ($q) use ($att_date) {
                        $q->where('present_date', $att_date);
                    })->orWhereHas('leaveDetail', function ($q) use ($att_date) {
                        $q->leaveToday($att_date);
                    });
                })
                ->when($search_txt, function ($qu) use ($txt) {
                    $qu->whereHas('student', function ($q) use ($txt) {
                        return $q->where(function ($query) use ($txt) {
                            $query->where('username', 'LIKE', $txt)
                                ->orWhere('email', 'LIKE', $txt)
                                ->orWhere('contact_number', 'LIKE', $txt)
                                ->orWhere('student_roll_number', 'LIKE', $txt)
                                ->orWhereTranslationLike('first_name', $txt)
                                ->orWhereTranslationLike('last_name', $txt);
                        });
                    });
                })
                ->with(['student'])
                ->with(['attendance' => function ($q) use ($att_date) {
                    $q->where('present_date', $att_date);
                }, 'absent' => function ($q) use ($att_date) {
                    $q->where('absent_date', $att_date);
                }, 'leaveDetail' => function ($q) use ($att_date) {
                    $q->where('leave_date', $att_date);
                }
                ])
                ->where('status', $status)
                ->get();
    
            
    
            $present_student_id = $student_list->pluck('id')
            ->unique()
            ->filter();;
        
        
            $absent_student = $this->studentHistory
            ->when($data['academic_version_id'], function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })->when($data['academic_year_id'], function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })->when($data['academic_session_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })->whereNotIn('id',$present_student_id)
            ->with(['student'])
            ->with(['attendance' => function ($q) use ($att_date) {
                $q->where('present_date', $att_date);
            }, 'absent' => function ($q) use ($att_date) {
                $q->where('absent_date', $att_date);
            }, 'leaveDetail' => function ($q) use ($att_date) {
                $q->where('leave_date', $att_date);
            }
            ])
            ->where('status', $status)
            ->paginate($paginate);
    
            $st_att_list = $absent_student;
        
        }elseif($present){
                $student_list = $this->studentHistory
                ->when($data['academic_version_id'], function ($query) use ($data) {
                    return $query->where('academic_version_id', $data['academic_version_id']);
                })->when($data['academic_year_id'], function ($query) use ($data) {
                    return $query->where('academic_year_id', $data['academic_year_id']);
                })->when($data['academic_shift_id'], function ($query) use ($data) {
                    return $query->where('academic_shift_id', $data['academic_shift_id']);
                })->when($data['academic_class_id'], function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })->when($data['academic_department_id'], function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })->when($data['academic_section_id'], function ($query) use ($data) {
                    return $query->where('academic_section_id', $data['academic_section_id']);
                })->when($data['academic_class_group_id'], function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })->when($data['academic_session_id'], function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
    
                ->when(($present), function ($qu) use ($att_date) {
                    return $qu->whereHas('attendance', function ($q) use ($att_date) {
                        $q->where('present_date', $att_date);
                    })->orWhereHas('leaveDetail', function ($q) use ($att_date) {
                        $q->leaveToday($att_date);
                    });
                })
                ->when($search_txt, function ($qu) use ($txt) {
                    $qu->whereHas('student', function ($q) use ($txt) {
                        return $q->where(function ($query) use ($txt) {
                            $query->where('username', 'LIKE', $txt)
                                ->orWhere('email', 'LIKE', $txt)
                                ->orWhere('contact_number', 'LIKE', $txt)
                                ->orWhere('student_roll_number', 'LIKE', $txt)
                                ->orWhereTranslationLike('first_name', $txt)
                                ->orWhereTranslationLike('last_name', $txt);
                        });
                    });
                })
                ->with(['student'])
                ->with(['attendance' => function ($q) use ($att_date) {
                    $q->where('present_date', $att_date);
                }, 'absent' => function ($q) use ($att_date) {
                    $q->where('absent_date', $att_date);
                }, 'leaveDetail' => function ($q) use ($att_date) {
                    $q->where('leave_date', $att_date);
                }
                ])
                ->where('status', $status)
                ->paginate($paginate);
    
                $st_att_list = $student_list;
    
            }
          else{
            $st_att_list = $student_list; 
          }
        
                $st_shift_details = $this->siteShiftDetails->where('academic_shift_id', $data['academic_shift_id'])
                ->where('belongs_to', 'student')
                ->where('academic_period_type_id', $get_period_type_duration->academic_period_type_id)
                ->where('academic_group_id', $get_period_type_duration->academic_group_id)
                ->where('week_day', $day)
                ->where('status', true)
                ->first();
            if (!$st_shift_details) {
                return Response::json(['message' => 'Shift Setting not found!',  'mode'=>'error', 'status'=>'404'], 404);

            }
            $class_present = $this->studentAttendance
                ->where('present_date', $att_date)
                ->whereIn('student_history_id', $st_att_list->pluck('id')->toArray())
                ->get();
    
            $present_count = $class_present->count();
            //  return $class_present->count();
            $st_att_list->getCollection()->transform(function ($value) use ($get_period_type_duration,  $day, $att_date, $st_shift_details, $st_att_list) {
                $late_status = $value->attendance->late_status ?? $this->checkStIsLate(($value->attendance->in_time ?? $st_shift_details->in_time ?? '00:00:00'), $st_shift_details);
                
               
               //========== select contact number for any condition ============
                if($value->student->sms_contact_field=="contact_number"){
                    if($value->student->contact_number==""){
                        if($value->student->father_contact_number==""){
                            $number = $value->student->mother_contact_number;
                        }else{
                            $number = $value->student->father_contact_number;
                        }
                    }else{
                        $number = $value->student->contact_number;
                    }
                }
                if($value->student->sms_contact_field=="father_contact_number"){
                    if($value->student->father_contact_number==""){
                        if($value->student->mother_contact_number==""){
                            $number = $value->student->contact_number;
                        }else{
                            $number = $value->student->mother_contact_number;
                        }
                    }else{
                        $number = $value->student->father_contact_number;
                    }
                }
                if($value->student->sms_contact_field=="mother_contact_number"){
                    if($value->student->mother_contact_number==""){
                        if($value->student->father_contact_number==""){
                            $number = $value->student->contact_number;
                        }else{
                            $number = $value->student->father_contact_number;
                        }
                    }else{
                        $number = $value->student->mother_contact_number;
                    }
                }
               //====    
    
                return [
                    'id' => $value->id ?? null,
                    'date' => $att_date ?? null,
                    'student_attendance_id' => $value->attendance->id ?? null,
                    // 'attendance_existed' => $attendance_existed ?? 0,
                    'present' => ($value->attendance ? 1 : 0),
                    // ($value->leaveDetail) ? 2 : (($value->attendance) ? 1 : ($attendance_existed ? 0 : 1))
                    'sms_sending' => false,
                    'st_status' => ($value->leaveDetail) ? "In Leave" : (($value->attendance) ? "Present" : "Absent"),
                    'st_status_int' => ($value->leaveDetail) ? 2 : (($value->attendance) ? 1 : 0),
                    //Absent
                    'absent' => $value->absent ?? null,
                    'absent_sms_status' => $value->absent->sms_status ?? null,
                    //Leave
                    'in_leave' => $value->leaveDetail ? 1 : 0,
                    'leave_id' => $value->leaveDetail->id ?? null,
                    //other data
                    'username' => $value->student->username ?? 'n/a',
                   // 'latest_photo' => $value->student->latestPhoto->path ?? 'n/a',
                    'latest_photo' => '/uploads/'.$value->student->latestPhoto->name ?? 'n/a',
                    'attendance_sms' => $value->student->attendance_sms ?? 'n/a',
                    'student_roll_number' => $value->student_full_roll_number ?? 'n/a',
                    'contact_number' => $number ?? 'n/a',
                    'sms_contact_field' => $value->student->sms_contact_field ?? '',
                    'name' => ($value->student->full_name ?? 'n/a'),
                    'details' => ($value->department->name ?? '') . '-' . ($value->stClass->class_name ?? '') . '-' . ($value->section->section_name ?? '') . '-' . ($value->classGroup->group_name ?? ''),
                    'year_name' => $value->year->year_name ?? 'n/a',
                    'version_name' => $value->version->version_name ?? 'n/a',
                    'shift_name' => $value->shift->shift_name ?? 'n/a',
                    'dept_name' => $value->department->name ?? 'n/a',
                    'class_name' => $value->stClass->class_name ?? 'n/a',
                    'class_group' => $value->classGroup->group_name ?? 'n/a',
                    'section_name' => $value->section->section_name ?? 'n/a',
                    'session' => $value->session->session_name ?? 'n/a',
                    'in_sms_id' => $value->attendance->in_sms_id ?? null,
                    'in_sms_sending' => false,
                    'out_sms_id' => $value->attendance->out_sms_id ?? null,
                    'out_sms_sending' => false,
                    'present_type' =>  $value->attendance->present_type ?? null,
                    'site_shift_details_id' =>  null,
                    'in_time' => $value->attendance->in_time ?? null,
                    'out_time' => $value->attendance->out_time ?? null,
                    'present_date' => $att_date,
                    'in_time_grace' =>  '',
                    'out_time_grace' =>  '',
                    'late_status' => $late_status,
                    'site_id' => $value->site_id ?? null,
                    'updated_at' => $value->attendance->updated_at ?? null,
                    'updated_by' => $value->attendance->updateBy->full_name ?? null,
                ];
            });
            if (count($st_att_list) < 1) {
                return Response::json(['message' => 'No Attendance Found For: ' . date('d M Y', strtotime($att_date)),  'mode'=>'error', 'status'=>'404'], 404);

            }
            $total_present = $this->getDateAttendanceCount($data, $att_date);
            $present_date = date('Y-m-d', strtotime($att_date));
          
        $data=[
            'student_att_list'=>$st_att_list,
            'total_present'=>$total_present,
            'present_date'=>$present_date,
            'present_count'=>$present_count,
            'mode'=>'success',
            'status'=>'200',
        ];

        return response()->json($data,200);

    } catch (ValidationException $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
    }catch (ModelNotFoundException $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
    } catch (Exception $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
    }

    }
    private function getDateAttendanceCount($data, $att_date)
    {
        $st_att_list = $this->studentHistory
            ->when($data['academic_version_id'], function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })->when($data['academic_year_id'], function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })->whereHas('attendance', function ($q) use ($att_date) {
                $q->where('present_date', $att_date);
            })->where('status', 1)
            ->count();

        return $st_att_list;
    }


    public function getSiteStudentPeriodicAttendanceList(Request $request)
    {
        try {

            $this->validate($request, [
                'att_date' => 'required',
            ]);   
    
            $this->siteInfoSessionPut($request);
           

            $data = [];
            $attDate = $request->att_date;
            $date = $attDate ? $attDate : date('Y-m-d', time());//'2019-05-09';
            $day = date('l', strtotime($date));
    
    
            $site_id = (int)session()->get('SITE_ID');
            $academic_group_id = (int)session()->get('ACADEMIC_GROUP_ID');
            $is_day_open = $this->isTheDateOpen($attDate, $academic_group_id, $site_id);
    
            if (!$is_day_open) {
                return response()->json(['message' => date('d M Y', strtotime($attDate)) . ' is holiday!'], 411);
            }
    
            $get_period_type_duration = $this->periodTypeDuration
                ->where('start_date', '<=', $date)
                ->where('end_date', '>=', $date)
                ->first();
            $emp_id = Auth::user()->id;
    
    
            $period_id = ($get_period_type_duration->academic_period_type_id ?? null);
            if (!$period_id) {
                return Response::json(['message' => 'Set Period Type Duration First' . $day,  'mode'=>'error', 'status'=>'411'], 411);

            }
    
    
            $routineDetails = $this->routineDetail
                ->where('weekday', $day)
                ->where('academic_period_type_id', $period_id)
                ->where('status', true)
                ->where(function ($q1) use ($emp_id, $date) {
                    $q1->whereHas('allocation', function ($q) use ($date, $emp_id) {
                        $q->where('employee_id', $emp_id)
                            ->where('status', true);
                    });
                    $q1->orWhereHas('allocation.swapCancel', function ($q) use ($date, $emp_id) {
                        $q->where('swap_cancel_date', $date)
                            ->where('employee_id', $emp_id);
                    });
                })
                ->with(['allocation' => function ($q) use ($emp_id) {
                    $q->where('employee_id', $emp_id);
                }, 'allocation.swapCancel' => function ($q) use ($emp_id) {
                    $q->where('employee_id', $emp_id);
                },
                    'allocation.liveMeeting' => function ($q) use ($date) {
                        $q->where('join_date', $date);
                    }, 'allocation.attendances' => function ($q) use ($date) {
                        $q->where('present_date', $date)
                            ->where('is_present', true);
                    }, 'allocation.subject', 'allocation.room', 'class', 'section'])
                ->orderBy('start_time', 'ASC')
                ->get();
    
            $allocation_lists = [];
    
    
            foreach ($routineDetails as $k => $detail) {
    
                // dd($emp_id, $detail->allocation->swapCancel);
    
                $allocation_lists[$k]['id'] = $detail->allocation->id ?? '';
                $allocation_lists[$k]['details'] = ($detail->allocation->swapCancel->subject_name_ex ??  $detail->allocation->subject_name_ex) . ' (' . ($detail->start_time ?? '') . '-' . ($detail->end_time ?? '') . ')';
                $allocation_lists[$k]['start_time'] = $detail->start_time ?? '';
                $allocation_lists[$k]['end_time'] = $detail->end_time ?? '';
                $allocation_lists[$k]['class_timing_detail_name'] = addOrdinalNumberSuffix($k + 1);
                $allocation_lists[$k]['class_name'] = ($detail->class->class_name ?? '') . ' (' . ($detail->year->year_name ?? '');
                $allocation_lists[$k]['section_name'] = $detail->section->section_name ?? '';
                $allocation_lists[$k]['subject_name'] = $detail->allocation->swapCancel->subject_name_ex ??  $detail->allocation->subject_name_ex;
                $allocation_lists[$k]['selected'] = false;
                $allocation_lists[$k]['loading'] = false;
                $allocation_lists[$k]['swapCancel'] = $detail->allocation->swapCancel ?? null;
                $allocation_lists[$k]['total_present'] = count($detail->allocation->attendances);
                $allocation_lists[$k]['status'] = $detail->allocation->status ?? false;
    
                $allocation_lists[$k]['invited'] = $detail->allocation->liveMeeting->status ?? false;
                $allocation_lists[$k]['meeting_id'] = $detail->allocation->liveMeeting->meeting->meeting_id ?? null;
                $allocation_lists[$k]['live_join_link'] = $detail->allocation->liveMeeting->meeting->join_url ?? null;
                $allocation_lists[$k]['start_url'] = $detail->allocation->liveMeeting->meeting->start_url ?? null;
                $allocation_lists[$k]['meeting_id'] = $detail->allocation->liveMeeting->meeting->meeting_id ?? null;
    
            }
    
            // dd($allocation_lists);
    
            if (count($routineDetails) < 1) {
                return Response::json(['message' => 'No Active Routine Found For ' . $day,  'mode'=>'error', 'status'=>'411'], 411);

            }

            $data=[
                'get_routine_list'=>$allocation_lists,
                'mode'=>'success',
                'status'=>'200',
            ];
    
            return response()->json($data,200);

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }

    }

    public function getStudentListByPeriodicAllocation(Request $request)
    {
        try{
        $this->siteInfoSessionPut($request);

        $data = [];
        $data = $request->all();
        $data['routine_allocation_id'] = $request->routine_allocation_id;
        $attDate = $request->att_date;
        $paginate = $request->paginate ?? 20;
        $att_date = $attDate != '0' ? $attDate : date('Y-m-d', time());

        $present = $request->present;
        $leave = $request->leave;
        $absent = $request->absent;
        $search_txt = $request->search_txt;
        $txt = '%' . $search_txt . '%';


        $history_ids = $this->getStudentHistoryIdsByAllocationId($data['routine_allocation_id']);
        $the_allocation = $this->routineAllocation->findOrFail($data['routine_allocation_id']);


        $student_history = $this->studentHistory
            ->whereIn('id', $history_ids)
            ->with(['attendance' => function ($q) use ($att_date) {
                $q->where('present_date', $att_date);
            }, 'absent' => function ($q) use ($att_date) {
                $q->where('absent_date', $att_date);
            }, 'leaveDetail' => function ($q) use ($att_date) {
                $q->where('leave_date', $att_date);
            }
            ])
            ->where('status', true)
            ->with(['student', 'student.translations', 'stClass', 'section', 'student.latestPhoto'])
            ->orderBy('student_roll_number', 'ASC');


        $total_student = $student_history->count();

        $student_history_paginate = $student_history
            /*  ->when($leave, function ($qu) use ($att_date) {
               $qu->whereHas('leaveDetail', function ($q) use ($att_date) {
                   $q->leaveToday($att_date);
               });
           })*/
            ->when($absent && !$present && !$leave, function ($qu) use ($att_date, $data) {
                $qu->whereDoesntHave('periodic', function ($q) use ($att_date) {
                    //   $q->PresentByDate($att_date);
                });
                $qu->whereDoesntHave('leaveDetail', function ($q) use ($att_date) {
                    $q->leaveToday($att_date);
                });
            })->when($present && !$absent && !$leave, function ($qu) use ($att_date, $data) {
                $qu->whereHas('periodic', function ($q) use ($att_date, $data) {
                    $q->where('present_date', $att_date);
                    $q->where('routine_allocation_id', $data['routine_allocation_id']);
                });
            })->when(!$present && !$absent && $leave, function ($qu) use ($att_date, $data) {
                $qu->whereHas('periodic', function ($q) use ($att_date, $data) {
                    $q->where('in_leave', true);
                    $q->where('routine_allocation_id', $data['routine_allocation_id']);
                });
            })
            ->when($search_txt, function ($qu) use ($txt) {
                $qu->whereHas('student', function ($q) use ($txt) {
                    return $q->where(function ($query) use ($txt) {
                        $query->where('username', 'LIKE', $txt)
                            ->orWhere('email', 'LIKE', $txt)
                            ->orWhere('contact_number', 'LIKE', $txt)
                            ->orWhereTranslationLike('first_name', $txt)
                            ->orWhereTranslationLike('last_name', $txt);
                    });
                });
            })
            ->paginate($paginate);

 //dd($student_history_paginate);
        $class_present = $this->studentAttendance
            ->where('present_date', $att_date)
            ->whereIn('student_history_id', $history_ids);

        $class_wise_total_present = $class_present->count();

        $period_wise = $this->periodicAttendance
            ->where('present_date', $att_date)
            ->where('routine_allocation_id', $data['routine_allocation_id'])
            ->get();
        $period_wise_found = count($period_wise);

       
        $period_wise_total = $period_wise
            ->count();

        $period_wise_total_present = $period_wise
            ->where('is_present', true)
            ->count();

        $period_wise_total_absent = $period_wise_found ? ($total_student - $period_wise_total_present) : 0;

    //    dd($total_student);

//        Log::info($period_wise_total_present);

        $period_wise_total_leave = $period_wise
            ->where('in_leave', true)
            ->count();


        $student_history_paginate->getCollection()->transform(function ($value) use ($att_date, $the_allocation, $period_wise_found, $class_present, $period_wise, $absent, $present) {
            //have to check in leave

            $previous_att = $period_wise
                ->where('student_history_id', $value->id)
                ->first();
            //check daily att exist
            $class_present = $class_present
                ->where('student_history_id', $value->id)
                ->first();


            // Log::info($class_present);


            $in_time = null;
            $out_time = null;
            $is_present = null;
            $in_leave = null;
            $late_status = false;
            $note = null;

            if ($period_wise_found) {//at least one student is preset for the period

                if ($previous_att) {//previous  att found as present

                    $in_time = $previous_att->in_time;
                    $out_time = $previous_att->out_time;

                    $is_present = $previous_att->is_present;
                    $late_status = $previous_att->late_status;

                } else {//previous  att found-as absent
                    $in_time = $the_allocation->routineDetail->start_time ?? '';
                    $out_time = $the_allocation->routineDetail->end_time ?? '';

                    $is_present = false;
                    $late_status = false;

                }

            } else {


                if ($previous_att) {//previous  att found as present

                    $in_time = $previous_att->in_time;
                    $out_time = $previous_att->out_time;

                    $is_present = $previous_att->is_present;
                    $late_status = $previous_att->late_status;


                } else {//previous  att found-as absent
                    $in_time = $the_allocation->routineDetail->start_time ?? '';
                    $out_time = $the_allocation->routineDetail->end_time ?? '';
                    $is_present = $class_present ? true : false;
                    $late_status = false;

                }

            }

            return [

                'id' => $value->id ?? null,
                'academic_group_id' => $value->academic_group_id ?? null,
                'username' => $value->student->username ?? 'n/a',
                'latest_photo' => $value->student->latestPhoto->path ?? 'n/a',
                'date' => $att_date ?? null,
                'periodic_id' => $previous_att->id ?? null,
                'present' => $is_present ? 1 : 0,
                'class_present' => $class_present ? 1 : 0,
                'st_status' => ($value->leaveDetail) ? "In Leave" : ($is_present ? "Present" : "Absent"),
                'st_status_int' => ($value->leaveDetail) ? 2 : (($value->attendance) ? 1 : 0),
                //Absent
                'absent' => $value->absent ?? null,
                //Leave
                'in_leave' => $value->leaveDetail ? 1 : 0,
                'leave_id' => $value->leaveDetail->id ?? null,
                //other data
                'student_roll_number' => $value->student_full_roll_number ?? 'n/a',
                'contact_number' => $value->student->contact_number ?? 'n/a',
                'full_name' => ($value->student->full_name ?? 'n/a'),
                'academic_shift_id' => ($value->academic_shift_id ?? null),
                'note' => $previous_att->note ?? '',
                'present_type' => $previous_att->present_type ?? 'web',
                'in_time' => $in_time ?? null,
                'out_time' => $out_time ?? null,
                'present_date' => $previous_att->present_date ?? $att_date,
                'late_status' => $late_status,
                'site_id' => $value->site_id ?? null,
                'updated_at' => $previous_att->updated_at ?? null,
                // 'updated_by' => $previous_att->updateBy->full_name ?? null,

            ];
        });


        if (count($student_history_paginate) <= 0) {
            return Response::json(['message' => 'No Student Found For The Subject!' . $day,  'mode'=>'error', 'status'=>'411'], 411);

        }

        $data=[
            'manualAttendanceList'=>$student_history_paginate,
            'att_date'=>$att_date,
            'class_wise_total_present'=>$class_wise_total_present,
            'period_wise_total_present'=>$period_wise_total_present,
            'period_wise_total_absent'=>$period_wise_total_absent,
            'period_wise_total_leave'=>$period_wise_total_leave,
            'period_wise_total'=>$period_wise_total,
            'mode'=>'success',
            'status'=>'200',
        ];

        return response()->json($data,200);

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }

    }

    public function savePeriodicStudentAttendance(Request $request)
    {
         try {

        $this->validate($request, [
            'att_date' => 'required',
            'routine_allocation_id' => 'required',
        ]);   

        $this->siteInfoSessionPut($request);
    
        $data = $request->manualAttendanceList;
        $att_date = $request->att_date;
        $routine_allocation_id = $request->routine_allocation_id;



        $day = date('D', strtotime($att_date));

        $get_period_type_duration = $this->periodTypeDuration
            ->where('start_date', '<=', $att_date)
            ->where('end_date', '>=', $att_date)
            ->first();

        if (!$get_period_type_duration) {
            return Response::json(['message' => 'No Period Found On' . $att_date,  'mode'=>'error', 'status'=>'404'], 404);

        }
        $routine_allocation = $this->routineAllocation->findOrFail($routine_allocation_id);
        $first_last_period = $routine_allocation->routineDetail->first_last ?? null;


        // return Response::json(['message' => 'No Routine Selected!'.$first_last_period], 410);


        $total_taken = 0;
        $total_updated = 0;
        $delete_ids = [];

        if (count($data) > 0) {
            foreach ($data as $item) {

                if ($item['present']) {

                    $existed = $this->periodicAttendance
                        ->where('student_history_id', $item['id'])
                        ->where('present_date', $att_date)
                        ->where('routine_allocation_id', $routine_allocation->id)
                        ->first();


                    if ($existed) {//previous found

                        $existed->in_time = $item['in_time'];
                        $existed->out_time = $item['out_time'];
                        $existed->in_leave = $item['in_leave'];
                        $existed->is_present = $item['present'];
                        $existed->late_status = $item['late_status'];
                        $existed->note = $item['note'];
                        $existed->updated_by = Auth::user()->id;
                        $existed->save();
                        $total_updated++;

                    } else {

                        $this->periodicAttendance = new PeriodicAttendance();

                        $this->periodicAttendance->routine_allocation_id = $routine_allocation_id;
                        $this->periodicAttendance->student_history_id = $item['id'];
                        $this->periodicAttendance->in_time = $item['in_time'];
                        $this->periodicAttendance->out_time = $item['out_time'];
                        $this->periodicAttendance->present_date = $att_date;
                        $this->periodicAttendance->present_year = date('Y', strtotime($att_date));
                        $this->periodicAttendance->present_month = date('m', strtotime($att_date));
                        $this->periodicAttendance->present_day = date('d', strtotime($att_date));
                        $this->periodicAttendance->in_leave = $item['in_leave'];
                        $this->periodicAttendance->is_present = $item['present'];
                        $this->periodicAttendance->late_status = $item['late_status'];
                        $this->periodicAttendance->note = $item['note'];
                        $this->periodicAttendance->taken_by = Auth::user()->id;
                        $this->periodicAttendance->save();
                        $total_taken++;
                    }


                    if ($first_last_period == 'first' || $first_last_period == 'last') {//save or update day attendance only if the routine is first period or last period


                        $day_present_exited = $this->studentAttendance
                            ->where('present_date', $att_date)
                            ->where('student_history_id', $item['id'])
                            ->where('academic_group_id', $item['academic_group_id'])
                            ->first();

                        $st_shift_details = $this->siteShiftDetails
                            ->where('academic_shift_id', $item['academic_shift_id'])
                            ->where('belongs_to', 'student')
                            ->where('academic_period_type_id', $get_period_type_duration->academic_period_type_id)
                            ->where('academic_group_id', $item['academic_group_id'])
                            ->where('week_day', $day)
                            ->where('status', true)
                            ->first();

                        if (!$st_shift_details) {
                            //   continue;
                            throw new Error('Shift Setting not found!');
                        }

                        $st_attendance = $day_present_exited ?? new StudentAttendance();
                        $st_attendance->student_history_id = $item['id'];
                        $st_attendance->present_type = 'web';
                        $st_attendance->site_shift_details_id = $st_shift_details->id ?? null;
                        $st_attendance->in_time = $first_last_period == 'first' ? $item['in_time'] : $st_attendance->in_time;
                        $st_attendance->out_time = $first_last_period == 'last' ? $item['out_time'] : $st_attendance->out_time;
                        $st_attendance->present_date = $att_date;
                        $st_attendance->present_year = date('Y', strtotime($att_date));
                        $st_attendance->present_month = date('m', strtotime($att_date));
                        $st_attendance->present_day = date('d', strtotime($att_date));
                        $st_attendance->late_status = $st_attendance->late_status ?? $item['late_status'];
                        $st_attendance->created_by = Auth::user()->id;
                        $st_attendance->updated_by = Auth::user()->id;
                        $st_attendance->save();
                    }


                } else {//delete previous present if exist
                    $delete_ids[] = $item['periodic_id'];
                }
            }

            $this->periodicAttendance
                ->whereIn('id', $delete_ids)
                ->delete();


            return Response::json(['message' => 'Periodic Attendance Successfully Saved:' . $total_taken . ' Updated:' . $total_updated, 'mode'=>'success', 'status'=>'200'], 200);

        }

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }


    }




   
}
