<?php

namespace App\Http\Controllers\Api\Site\Web\Setting;

use App\Http\Controllers\ProjectController;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicSubject;
use App\Models\Academic\AcademicSubjectClassExamCondition;
use App\Models\Employee\SiteEmployeeDepartmentClassSubject;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Models\Site\Web\ClassRoom\ClassRoom;
use App\Models\Site\Web\ClassRoom\SiteClassLessonFeedback;
use App\Models\Site\Web\ClassRoom\SiteClassLessonReplyFeedback;
use App\Models\Site\Web\ClassRoom\WebsiteClassRoomLink;
use App\Models\Site\Web\ClassRoom\WebSubjectGroupList;
use App\Models\Student\StudentHistory;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Input;
use App\Models\Image\Photo;
use Illuminate\Pagination\Paginator;
use Auth;
use Error;
use Exception;
use File;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Image;
use Response;
use Storage;
use Session;

class ClassRoomController extends Controller
{
    private $classRoom;
    private $academicSubject;

    public function __construct(ClassRoom $classRoom, AcademicSubject $academicSubject)
    {
        $this->middleware('auth:api');
        $this->middleware('api.access');
        $this->middleware('sitepagechecker2');

      //   $this->middleware('auth');
        // $this->middleware('sitepagechecker');
        $this->classRoom = $classRoom;
        $this->academicSubject = $academicSubject;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType = "Class Lesson";
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function studentClassLessonDetailsIndex()
    {
        $viewType = "Class Lesson";
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function studentClassLessonDetails(ClassRoom $classRoom, Request $request)
    {
        //==========check user student or not==========
        $user_type = Auth::user()->user_type;
        if ($user_type == 'student') {
            $user_id = Auth::user()->id;
        } else {
            throw new Error('Sorry! this page is for student!');
        }
//        return $user_id;

        //=========student history details================
        $user_history_details = StudentHistory::where('user_id', $user_id)->get();
        if (count($user_history_details)) {
            $department_ids = $user_history_details->pluck('academic_department_id');
            $class_ids = $user_history_details->pluck('academic_class_id');
            $subject_id_list = [];
            foreach ($user_history_details as $kk => $vv) {

                $academic_subject_ids = $vv->academic_subject_ids;
                $optional_subject_ids = $vv->optional_subject_ids;
                $compulsory_subject_ids = $vv->compulsory_subject_ids;
                $selective_markingless_subject_ids = $vv->selective_markingless_subject_ids;
                $religion_subject_id = $vv->religion_subject_id;

                if ($academic_subject_ids[1]) {
                    foreach ($academic_subject_ids[1] as $kkk => $vl) {
                        $subject_id_list[] = $vl;
                    }
                }
                if ($optional_subject_ids[1]) {
                    foreach ($optional_subject_ids[1] as $ky => $val) {
                        $subject_id_list[] = $val;
                    }
                }
                if ($compulsory_subject_ids[1]) {
                    foreach ($compulsory_subject_ids[1] as $kyy => $vll) {
                        $subject_id_list[] = $vll;
                    }
                }
                if ($selective_markingless_subject_ids[1]) {
                    foreach ($selective_markingless_subject_ids[1] as $kky => $vv) {
                        $subject_id_list[] = $vv;
                    }
                }
                if ($religion_subject_id) {
                    $subject_id_list[] = $religion_subject_id;
                }

            }

        } else {
            throw new Error('Sorry! There is no student history');
        }

        //==========department===============
        $academic_department_list = [];
        $academic_department_ids = $classRoom->where('entry_type', 'site')->whereIn('academic_department_id', $department_ids)->pluck('academic_department_id');
        if ($academic_department_ids) {
            $academic_department_list = AcademicDepartment::whereIn('id', $academic_department_ids)->get();
        }
        //==========class===============
        $academic_class_list = [];
        if ($request->academic_department_id) {
            $academic_class_ids = $classRoom->where('entry_type', 'site')->whereIn('academic_class_id', $class_ids)->where('academic_department_id', $request->academic_department_id)->pluck('academic_class_id');
        } else {
            $academic_class_ids = $classRoom->where('entry_type', 'site')->whereIn('academic_class_id', $class_ids)->pluck('academic_class_id');
        }
        if ($academic_class_ids) {
            $academic_class_list = AcademicClass::whereIn('id', $academic_class_ids)->get();
        }
        //=============subject===========
        $subject_list = [];
        if ($request->academic_class_id) {
            $academic_subject_ids = $classRoom->where('entry_type', 'site')->whereIn('academic_subject_id', $subject_id_list)->where('academic_class_id', $request->academic_class_id)->pluck('academic_subject_id');
            $subject_list = AcademicSubject::whereIn('id', $academic_subject_ids)->get();
        }
        //=============topic===========
        $topic_list = [];
        if ($request->academic_subject_id) {
            $topic_list = $classRoom->where('entry_type', 'site')->where('academic_subject_id', $request->academic_subject_id)->get();
        }
        //===========topic data list=========
        $academic_department_id = $request->academic_department_id;
        $academic_class_id = $request->academic_class_id;
        $academic_subject_id = $request->academic_subject_id;
        $topic_id = $request->topic_id;
        $live_type_status = $request->live_type_status;
        $paginate = $request->paginate;

        $class_room = new ClassRoom();
        $class_room_list = $class_room->where('publish_date', '<=', Carbon::now())
            ->where('pause_status', 0)
            ->where('approve_status', 1)
            ->where('entry_type', 'site')
            ->when($academic_department_id, function ($q) use ($academic_department_id) {
                return $q->where('academic_department_id', $academic_department_id);
            })
            ->when($academic_class_id, function ($q) use ($academic_class_id) {
                return $q->where('academic_class_id', $academic_class_id);
            })
            ->when($academic_subject_id, function ($q) use ($academic_subject_id) {
                return $q->where('academic_subject_id', $academic_subject_id);
            })
            ->when($topic_id, function ($q) use ($topic_id) {
                return $q->where('id', $topic_id);
            })
            ->when($live_type_status, function ($q) use ($live_type_status) {
                return $q->whereHas('websiteClassRoomLink', function ($qr) use ($live_type_status) {
                    if ($live_type_status == 1) {
                        $qr->where('live_status', $live_type_status);
                    } else if ($live_type_status == 2) {
                        $qr->where('live_status', 0);
                    }

                });
            })
            ->with('academicClass', 'academicSubject', 'academicDepartment', 'academicYear', 'files', 'websiteClassRoomLink')
            ->with(['user' => function ($q) {
                $q->with('latestPhoto', 'designation');
            }])
            ->orderBy('serial_no', 'ASC')
            ->get();

        $class_room_list_final = [];
        if (count($class_room_list)) {
            $srl = 1;
            $list_final_arr = Array();
            foreach ($class_room_list as $kk => $vv) {

                if ($vv->publish_to) {

                    $list_final_reply_arr[0] = [
                        'feedback_reply_detail' => null,
                        'id' => 0,
                        'replyEdit' => false,
                        'user' => [
                            'full_name' => null,
                        ],
                    ];

                    $list_final_arr['feedback_list'][0] = [
                        'id' => 0,
                        'feedback_detail' => null,
                        'feedback_reply_list' => $list_final_reply_arr,
                        'user' => [
                            'full_name' => null,
                        ],
                    ];

                    $list_final_arr['feedback_detail'] = null;
                    $list_final_arr['feedback_list_length'] = 0;


                    $publish_to_ids = explode(',', $vv->publish_to);
                    foreach ($publish_to_ids as $kkk => $vvv) {
                        if ($vvv == 2) {
                            $class_room_list_final[$kk]['data'] = array_merge($vv->toArray(), $list_final_arr);
                            $class_room_list_final[$kk]['srl'] = $srl;
                            $class_room_list_final[$kk]['live_video_link'] = false;
                            $srl++;
                        }
                    }

                }

            }

        }

        $classRoomListPage = new Paginator(collect($class_room_list_final)->values(), $paginate);
        return [$academic_department_list, $academic_class_list, $subject_list, $topic_list, $classRoomListPage];
    }


    public function getSubjectList($year_id, $department_id, $class_id)
    {
        $is_admin = request()->user()->roles()->where('key', 'admin')->first();

        if ($is_admin) {

            $department_id = $department_id == 'null' ? 0 : $department_id;
            $year_id = $year_id == 'null' ? 0 : $year_id;
            $class_id = $class_id == 'null' ? 0 : $class_id;

//        if (!$department_id || !$class_id || !$year_id) {
//            return Response::json(['message' => 'Select * Marked Field!'], 410);
//        }

            $academic_subject_class_exam_condition_ids = AcademicSubjectClassExamCondition::where('name_key', 'onlyforclass')
                ->orWhere('name_key', 'forclassandexam')
                ->pluck('id');


            $sGroupCondSettings = WebSubjectGroupList::with(['academicClass', 'academicSubject'])
                ->whereIn('academic_subject_class_exam_condition_id', $academic_subject_class_exam_condition_ids)
                ->where('academic_class_id', $class_id)
                ->where('academic_year_id', $year_id)
                ->when($department_id, function ($query) use ($department_id) {
                    return $query->where('academic_department_id', $department_id);
                })
                ->get();

            $subject_id_array = $sGroupCondSettings->pluck('academic_subject_id');
            $subjects = $this->academicSubject->whereIn('id', $subject_id_array)->get();
//        if(!count($subjects)){
//            throw new Error('Sorry, no subject found!');
//        }
            return $subjects;

        } else {
            $subjects = $this->getSubjectListByUser($year_id, $department_id, $class_id);
            return $subjects;

        }

    }

    public function getSubjectListByUser($year_id, $department_id, $class_id)
    {


        $department_id = $department_id == 'null' ? 0 : $department_id;
        $year_id = $year_id == 'null' ? 0 : $year_id;
        $class_id = $class_id == 'null' ? 0 : $class_id;


//        if (!$department_id || !$class_id || !$year_id) {
//            return Response::json(['message' => 'Select * Marked Field!'], 410);
//        }

        $user_id = Auth::user()->id;

        $academic_subject_ids = SiteEmployeeDepartmentClassSubject::where('academic_class_id', $class_id)
            ->where('user_id', $user_id)
            ->whereNull('release_date')
            ->when($department_id, function ($query) use ($department_id) {
                return $query->where('academic_department_id', $department_id);
            })
            ->pluck('academic_subject_id');

        $subjects = $this->academicSubject->whereIn('id', $academic_subject_ids)->get();
//        if(!count($subjects)){
//            throw new Error('Sorry, no subject found!');
//        }

        return $subjects;
    }

    public function getClassRoomList(Request $request)
    {
       // dd('sf');
        $pause_status = $request->pause_status;
        $live_type_status = $request->live_type_status;
        $search_txt = $request->search_txt;
        $academic_subject_id = $request->academic_subject_id;
        $academic_class_id = $request->academic_class_id;
        $date_range = $request->date_range ? json_decode($request->date_range) : null;
        $paginate = $request->paginate ?? 20;
        $txt = '%' . $search_txt . '%';

        $date_start = $date_range->start;
        $date_end = $date_range->end ?? $date_start;


        $class_room_list = ClassRoom::whereDate('publish_date', '>=', $date_start)
            ->whereDate('publish_date', '<=', $date_end)
            ->where('entry_type', 'site')
            ->when($search_txt, function ($q) use ($txt) {
                return $q->where(function ($query) use ($txt) {
                    $query->whereTranslationLike('topic_title', $txt)
                        ->orWhereTranslationLike('topic_description', $txt);

                });
            })
            ->when($pause_status, function ($qr) use ($pause_status) {
                return $qr->where('pause_status', (int)$pause_status);
            })
            ->when($academic_subject_id, function ($q) use ($academic_subject_id) {
                return $q->where('academic_subject_id', $academic_subject_id);
            })
            ->when($academic_class_id, function ($qq) use ($academic_class_id) {
                return $qq->where('academic_class_id', $academic_class_id);
            })
            ->when($live_type_status, function ($q) use ($live_type_status) {
                return $q->whereHas('websiteClassRoomLink', function ($qr) use ($live_type_status) {
                    if ($live_type_status == 1) {
                        $qr->where('live_status', $live_type_status);
                    } else if ($live_type_status == 2) {
                        $qr->where('live_status', 0);
                    }

                });
            })
            ->with('academicClass', 'academicSubject', 'academicDepartment', 'academicYear', 'files', 'user', 'websiteClassRoomLink')
            ->orderBy('id', 'DESC')
            ->get();

        //        return $class_room_list;
        $class_room_list_final = [];
        if (count($class_room_list)) {
            $list_final_arr = Array();
            foreach ($class_room_list as $k => $v) {

                $list_final_reply_arr[0] = [
                    'feedback_reply_detail' => null,
                    'id' => 0,
                    'replyEdit' => false,
                    'user' => [
                        'full_name' => null,
                    ],
                ];

                $list_final_arr['feedback_list'][0] = [
                    'id' => 0,
                    'feedback_detail' => null,
                    'feedback_reply_list' => $list_final_reply_arr,
                    'user' => [
                        'full_name' => null,
                    ],
                ];

                $list_final_arr['feedback_detail'] = null;
                $list_final_arr['feedback_list_length'] = 0;
                $class_room_list_final[$k]['data'] = array_merge($list_final_arr, $v->toArray());
                $class_room_list_final[$k]['live_video_link'] = false;
                $publish_to_ids = "";
                if ($v->publish_to) {
                    $publish_to_ids = explode(',', $v->publish_to);
                }
                $class_room_list_final[$k]['publish_to'] = $publish_to_ids ?? null;
            }
        }

//        $class_room_list_final->paginate($paginate);
        $classRoomListPage = new Paginator(collect($class_room_list_final)->values(), $paginate);

        //==============department==========================
        $department_list = [];
        $department_ids = ClassRoom::where('entry_type', 'site')->pluck('academic_department_id');
        $department_list = AcademicDepartment::whereIn('id', $department_ids)->get();

        //==============class==========================
        $class_list = [];
        $class_ids = ClassRoom::where('entry_type', 'site')->pluck('academic_class_id');
        $class_list = AcademicClass::whereIn('id', $class_ids)->get();

        //==============department==========================
        $subject_list = [];
        $subject_ids = ClassRoom::where('entry_type', 'site')->pluck('academic_subject_id');
        $subject_list = AcademicSubject::whereIn('id', $subject_ids)->get();

        return [$department_list, $class_list, $subject_list, $classRoomListPage];

    }

    public function getClassLessonList(Request $request)
    {
        $search_txt = $request->search_txt;
        $live_type_status = $request->live_type_status;
        $academic_department_id = $request->academic_department_id;
        $academic_class_id = $request->academic_class_id;
        $academic_subject_id = $request->academic_subject_id;
        $date_range = $request->date_range ? json_decode($request->date_range) : null;
        $paginate = $request->paginate ?? 20;
        $txt = '%' . $search_txt . '%';

        $date_start = $date_range->start;
        $date_end = $date_range->end ?? $date_start;

        $user_id = Auth::user()->id;


        $class_room_list = ClassRoom::whereDate('publish_date', '>=', $date_start)
            ->whereDate('publish_date', '<=', $date_end)
            ->where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
            ->where('entry_type', 'site')
            ->where('faculty_id', $user_id)
            ->when($search_txt, function ($q) use ($txt) {
                return $q->where(function ($query) use ($txt) {
                    $query->whereTranslationLike('topic_title', $txt)
                        ->orWhereTranslationLike('topic_description', $txt);

                });
            })
            ->when($academic_department_id, function ($qr) use ($academic_department_id) {
                return $qr->where('academic_department_id', $academic_department_id);
            })
            ->when($academic_subject_id, function ($q) use ($academic_subject_id) {
                return $q->where('academic_subject_id', $academic_subject_id);
            })
            ->when($academic_class_id, function ($qq) use ($academic_class_id) {
                return $qq->where('academic_class_id', $academic_class_id);
            })
            ->when($live_type_status, function ($q) use ($live_type_status) {
                return $q->whereHas('websiteClassRoomLink', function ($qr) use ($live_type_status) {
                    if ($live_type_status == 1) {
                        $qr->where('live_status', $live_type_status);
                    } else if ($live_type_status == 2) {
                        $qr->where('live_status', 0);
                    }

                });
            })
            ->with('academicClass', 'academicSubject', 'academicDepartment', 'academicYear', 'files', 'user', 'websiteClassRoomLink')
            ->orderBy('id', 'DESC')
            ->get();

//        return $class_room_list;
        $class_room_list_final = [];
        if (count($class_room_list)) {
            $list_final_arr = Array();
            foreach ($class_room_list as $k => $v) {

                $list_final_reply_arr[0] = [
                    'feedback_reply_detail' => null,
                    'id' => 0,
                    'replyEdit' => false,
                    'user' => [
                        'full_name' => null,
                    ],
                ];

                $list_final_arr['feedback_list'][0] = [
                    'id' => 0,
                    'feedback_detail' => null,
                    'feedback_reply_list' => $list_final_reply_arr,
                    'user' => [
                        'full_name' => null,
                    ],
                ];

                $list_final_arr['feedback_detail'] = null;
                $list_final_arr['feedback_list_length'] = 0;
                $class_room_list_final[$k]['data'] = array_merge($list_final_arr, $v->toArray());
                $class_room_list_final[$k]['live_video_link'] = false;
                $publish_to_ids = "";
                if ($v->publish_to) {
                    $publish_to_ids = explode(',', $v->publish_to);
                }
                $class_room_list_final[$k]['publish_to'] = $publish_to_ids ?? null;
            }
        }

//        $class_room_list_final->paginate($paginate);
        $classRoomListPage = new Paginator(collect($class_room_list_final)->values(), $paginate);

        //==============department==========================
        $department_list = [];
        $department_ids = ClassRoom::where('entry_type', 'site')->where('faculty_id', $user_id)->pluck('academic_department_id');
        $department_list = AcademicDepartment::whereIn('id', $department_ids)->get();

        //==============class==========================
        $class_list = [];
        $class_ids = ClassRoom::where('entry_type', 'site')->where('faculty_id', $user_id)->pluck('academic_class_id');
        $class_list = AcademicClass::whereIn('id', $class_ids)->get();

        //================subject======================
        $subject_list = [];
        $subject_ids = ClassRoom::where('entry_type', 'site')->where('faculty_id', $user_id)->pluck('academic_subject_id');
        $subject_list = AcademicSubject::whereIn('id', $subject_ids)->get();

        return [$department_list, $class_list, $subject_list, $classRoomListPage];

    }

    public function createClassRoom(ClassRoom $classRoom, Request $request)
    {

//        return $request->live_status;

//        $this->validate($request, [
//            'academic_class_id' => 'required',
//            'academic_subject_id' => 'required',
//            'topic_title' => 'required',
//            'topic_description' => 'required',
//            'publish_date' => 'required',
//        ]);
//        $site_id = Session::get('ACADEMIC_GROUP_ID');
//        return $request;
        if (!$request->academic_class_id || !$request->academic_subject_id || !$request->topic_title || !$request->topic_description || !$request->publish_date) {
            throw new Error('Please, fill the required fields');
        }


        if (count($classRoom->ownFields) > 0) {
            foreach ($classRoom->ownFields as $field) {
                if ($request->{$field}) {
                    $classRoom->{$field} = $request->{$field};
                }
            }
            $classRoom->entry_type = 'site';
            $classRoom->entry_date = Carbon::today();
            $classRoom->status = 1;
            $classRoom->approve_status = 1;
            $classRoom->created_by = Auth::user()->id;

            $publish_to_ids_string = implode(',', $request->publish_to);

            $classRoom->publish_to = $publish_to_ids_string;

            $latest_data = ClassRoom::where('entry_type', 'site')->orderBy('id', 'DESC')->first();
            if ($latest_data) {
                $classRoom->serial_no = $latest_data->serial_no + 1;
            } else {
                $classRoom->serial_no = 1;
            }

            if ($classRoom->save()) {
                $files = range(1, $request->length);
                $file_path = null;

                if ($request->length) {
                    foreach ($files as $k => $val) {
                        $file = Input::file('files' . $k);
                        $file_name = $classRoom->site_id . '/' . uniqid() . '.' . $file->getClientOriginalExtension();
                        Storage::disk('uploads')->put($file_name, File::get($file));
                        $file_path = '/uploads/files/' . $file_name;
                        $file = Input::file('files' . $k);
                        $file_type = $file->getClientMimeType();

                        if (in_array($file_type, ['image/png', 'image/gif', 'image/jpeg', 'image/png'])) {
                            Image::make($file->getRealPath())->resize(700, null, function ($constraint) {
                                $constraint->aspectRatio();
                            })->save('uploads/files/' . $file_name);

                        } else {
                            Storage::disk('uploads')->put($file_name, File::get($file));
                        }

                        $classRoom->files()->create([
                            'user_id' => Auth::user()->id,
                            'path' => $file_path,
                            'name' => $file->getClientOriginalName(),
                        ]);
                    }
                }
                $latest_data = ClassRoom::where('entry_type', 'site')->orderBy('id', 'DESC')->first();
                if (count($request->siteLinkList)) {
                    foreach ($request->siteLinkList as $kk => $vv) {
                        if ($vv) {
                            $classRoomLink = new WebsiteClassRoomLink();

                            $classRoomLink->website_class_room_id = $latest_data->id;
                            $classRoomLink->link_type = 'site';
                            $classRoomLink->link = $vv;
                            $classRoomLink->status = 1;
                            $classRoomLink->save();

                        }
                    }

                }
                if (count($request->videoLinkList)) {
                    foreach ($request->videoLinkList as $kkk => $vvv) {
                        if ($vvv) {
                            if ($request->live_status) {
                                $abc = explode('/', $vvv);
                                $count = count($abc) - 2;
                                if (count($abc)) {
                                    foreach ($abc as $k => $v) {
                                        if ($k == $count) {
                                            $final_link_last = $v;
                                        }
                                    }
                                }

                            } else {
                                $abc = explode('/', $vvv);
                                $last = end($abc);
                                $again = explode('?', $last);
                                if ($again) {
                                    $mid_last = end($again);
                                    $last_last = explode('v=', $mid_last);
                                    $final_link_last = end($last_last);

                                } else {
                                    $final_link_last = $last;
                                }
                            }

                            $final_link = 'https://www.youtube.com/embed/' . $final_link_last;


                            $classRoomLink = new WebsiteClassRoomLink();

                            $classRoomLink->website_class_room_id = $latest_data->id;
                            $classRoomLink->link_type = 'video';
                            $classRoomLink->link = $final_link;
                            $classRoomLink->live_status = $request->live_status;
                            $classRoomLink->status = 1;
                            $classRoomLink->save();

                        }
                    }

                }

                return Response::json(['message' => 'Successfully Saved!', 'mode' => 'Save'], 200);

            }

        }

    }

    public function createClassLesson(ClassRoom $classRoom, Request $request)
    {
        if (!$request->academic_class_id || !$request->academic_subject_id || !$request->topic_title || !$request->topic_description || !$request->publish_date) {
            throw new Error('Please, fill the required fields');
        }

        if (count($classRoom->ownFields) > 0) {
            foreach ($classRoom->ownFields as $field) {
                if ($request->{$field}) {
                    $classRoom->{$field} = $request->{$field};
                }
            }
            $classRoom->entry_type = 'site';
            $classRoom->entry_date = Carbon::today();
            $classRoom->status = 1;
            $classRoom->created_by = Auth::user()->id;
            $classRoom->faculty_id = Auth::user()->id;

            $publish_to_ids_string = implode(',', $request->publish_to);

            $classRoom->publish_to = $publish_to_ids_string;

            $latest_data = ClassRoom::where('entry_type', 'site')->orderBy('id', 'DESC')->first();
            if ($latest_data) {
                $classRoom->serial_no = $latest_data->serial_no + 1;
            } else {
                $classRoom->serial_no = 1;
            }
            if ($classRoom->save()) {
                $files = range(1, $request->length);
                $file_path = null;
                if ($request->length) {
                    foreach ($files as $k => $val) {
                        $file = Input::file('files' . $k);
                        $file_name = $classRoom->site_id . '/' . uniqid() . '.' . $file->getClientOriginalExtension();
                        Storage::disk('uploads')->put($file_name, File::get($file));
                        $file_path = '/uploads/files/' . $file_name;
                        $file = Input::file('files' . $k);
                        $file_type = $file->getClientMimeType();

                        if (in_array($file_type, ['image/png', 'image/gif', 'image/jpeg', 'image/png'])) {
                            Image::make($file->getRealPath())->resize(700, null, function ($constraint) {
                                $constraint->aspectRatio();
                            })->save('uploads/files/' . $file_name);

                        } else {
                            Storage::disk('uploads')->put($file_name, File::get($file));
                        }
                        $classRoom->files()->create([
                            'user_id' => Auth::user()->id,
                            'path' => $file_path,
                            'name' => $file->getClientOriginalName(),
                        ]);
                    }
                }
                $latest_data = ClassRoom::where('entry_type', 'site')->orderBy('id', 'DESC')->first();
                if (count($request->siteLinkList)) {
                    foreach ($request->siteLinkList as $kk => $vv) {
                        if ($vv) {
                            $classRoomLink = new WebsiteClassRoomLink();
                            $classRoomLink->website_class_room_id = $latest_data->id;
                            $classRoomLink->link_type = 'site';
                            $classRoomLink->link = $vv;
                            $classRoomLink->status = 1;
                            $classRoomLink->save();
                        }
                    }
                }
                if (count($request->videoLinkList)) {
                    foreach ($request->videoLinkList as $kkk => $vvv) {
                        if ($vvv) {
                            if ($request->live_status == 1) {
                                $abc = explode('/', $vvv);
                                $count = count($abc) - 2;
                                if (count($abc)) {
                                    foreach ($abc as $k => $v) {
                                        if ($k == $count) {
                                            $final_link_last = $v;
                                        }
                                    }
                                }

                            } else {
                                $abc = explode('/', $vvv);
                                $last = end($abc);
                                $again = explode('?', $last);
                                if ($again) {
                                    $mid_last = end($again);
                                    $last_last = explode('v=', $mid_last);
                                    $final_link_last = end($last_last);

                                } else {
                                    $final_link_last = $last;
                                }
                            }

                            $final_link = 'https://www.youtube.com/embed/' . $final_link_last;


                            $classRoomLink = new WebsiteClassRoomLink();

                            $classRoomLink->website_class_room_id = $latest_data->id;
                            $classRoomLink->link_type = 'video';
                            $classRoomLink->link = $final_link;
                            $classRoomLink->live_status = $request->live_status;
                            $classRoomLink->status = 1;
                            $classRoomLink->save();

                        }
                    }

                }

                return Response::json(['message' => 'Successfully Saved!', 'mode' => 'Save'], 200);

            }

        }

    }

    public function getClassRoomDetails($id)
    {
//        return $id;
        $class_room_list = ClassRoom::with('academicClass', 'academicSubject', 'academicDepartment', 'academicYear', 'files', 'user', 'websiteClassRoomLink')
            ->findOrFail($id);
        $publish_to_ids = [];
        if ($class_room_list->publish_to) {
            $publish_to_ids = explode(',', $class_room_list->publish_to);
        }


        return [$class_room_list, $publish_to_ids];

    }

    public function updateClassRoom(Request $request)
    {
//        throw new Error('hello, testing');

//        return $request;
        if (!$request->academic_class_id || !$request->academic_subject_id || !$request->topic_title || !$request->topic_description || !$request->publish_date) {
            throw new Error('Please, fill the required fields');
        }

        $deletes = $request->deletes ? explode(',', $request->deletes) : [];
        $user_id = Auth::user()->id;

        $classRoom = $this->classRoom->findOrFail($request->id);

        if ($request->serial_no != $classRoom->serial_no) {

            $updateClassRoomSerial = ClassRoom::where('entry_type', 'site')->where('serial_no', $request->serial_no)->first();
            if ($updateClassRoomSerial) {
                $updateClassRoomSerial->update([
                    'serial_no' => $classRoom->serial_no,
                ]);
            }

        }

        foreach ($classRoom->ownFields as $k => $ownField) {
            if ($request->{$ownField}) {
                $classRoom->{$ownField} = $request->{$ownField};
            }
        }
        $publish_to_ids_string = implode(',', $request->publish_to);

        $classRoom->publish_to = $publish_to_ids_string;

        if ($request->pause_status == 'true') {
            $classRoom->pause_status = $request->pause_status = 1;
        } else {
            $classRoom->pause_status = $request->pause_status = 0;
        }


        if ($classRoom->save()) {
            $existLink = WebsiteClassRoomLink::where('website_class_room_id', $classRoom->id)->get();
            if (count($existLink)) {
                foreach ($existLink as $kk => $vv) {
                    $vv->delete();
                }

            }

            if (count($request->siteLinkList)) {
                foreach ($request->siteLinkList as $kkk => $vvv) {
                    if ($vvv) {
                        $classRoomLink = new WebsiteClassRoomLink();

                        $classRoomLink->website_class_room_id = $classRoom->id;
                        $classRoomLink->link_type = 'site';
                        $classRoomLink->link = $vvv;
                        $classRoomLink->status = 1;
                        $classRoomLink->save();

                    }
                }

            }
            if (count($request->videoLinkList)) {
                foreach ($request->videoLinkList as $kkkk => $vvvv) {
                    if ($vvvv) {
                        if ($request->live_status == 1) {
                            $abc = explode('/', $vvvv);
                            $count = count($abc) - 2;
//                            return $count;
                            if (count($abc)) {
                                foreach ($abc as $k => $v) {
                                    if ($k == $count) {
                                        $final_link_last = $v;
                                    }
                                }
                            }

                        } else {
                            $abc = explode('/', $vvvv);
                            $last = end($abc);
                            $again = explode('?', $last);
                            if ($again) {
                                $mid_last = end($again);
                                $last_last = explode('v=', $mid_last);
                                $final_link_last = end($last_last);

                            } else {
                                $final_link_last = $last;
                            }
                        }
                        $final_link = 'https://www.youtube.com/embed/' . $final_link_last;

                        $classRoomLink = new WebsiteClassRoomLink();

                        $classRoomLink->website_class_room_id = $classRoom->id;
                        $classRoomLink->link_type = 'video';
                        $classRoomLink->link = $final_link;
                        $classRoomLink->live_status = $request->live_status;
                        $classRoomLink->status = 1;
                        $classRoomLink->save();

                    }
                }

            }
            if ($request->length) {
                $files = range(1, $request->length);
                $file_path = null;
                foreach ($files as $k => $val) {

                    $file = Input::file('files' . $k);
                    $file_type = $file->getClientMimeType();

                    $file_name = $classRoom->site_id . '/' . uniqid() . '.' . $file->getClientOriginalExtension();
                    $file_path = '/uploads/files/' . $file_name;

                    if (in_array($file_type, ['image/png', 'image/gif', 'image/jpeg', 'image/png'])) {
                        Image::make($file->getRealPath())->resize(700, null, function ($constraint) {
                            $constraint->aspectRatio();
                        })->save('uploads/files/' . $file_name);

                    } else {
                        Storage::disk('uploads')->put($file_name, File::get($file));
                    }

                    $this->deleteFiles($classRoom);


                    $classRoom->files()->create([
                        'user_id' => Auth::user()->id,
                        'path' => $file_path,
                        'name' => $file->getClientOriginalName(),
                    ]);
                }
            }

            if (count($deletes)) {
                foreach ($deletes as $k => $id) {
                    $the_photo = Photo::where('id', $id)->first();
                    $fssf[$k] = $the_photo;
                    if ($the_photo) {
                        $image_path = public_path($the_photo->path);
                        if (File::exists($image_path)) {
                            unlink($image_path);
                        }
                    }

                }
            }
            return Response::json(['message' => 'Successfully Updated!', 'mode' => 'Update'], 200);
        }

    }

    public function updateClassLesson(Request $request)
    {
//        return $request;
//        $this->validate($request, [
//            'academic_class_id' => 'required',
//            'academic_subject_id' => 'required',
//            'topic_title' => 'required',
//            'topic_description' => 'required',
//            'publish_date' => 'required',
//        ]);
        if (!$request->academic_class_id || !$request->academic_subject_id || !$request->topic_title || !$request->topic_description || !$request->publish_date) {
            throw new Error('Please, fill the required fields');
        }


        $deletes = $request->deletes ? explode(',', $request->deletes) : [];
        $user_id = Auth::user()->id;

        $classRoom = $this->classRoom->findOrFail($request->id);

        foreach ($classRoom->ownFields as $k => $ownField) {
            if ($request->{$ownField}) {
                $classRoom->{$ownField} = $request->{$ownField};
            }
        }

        $publish_to_ids_string = implode(',', $request->publish_to);

        $classRoom->publish_to = $publish_to_ids_string;

        if ($classRoom->save()) {
            $existLink = WebsiteClassRoomLink::where('website_class_room_id', $classRoom->id)->get();
            if (count($existLink)) {
                foreach ($existLink as $kk => $vv) {
                    $vv->delete();
                }

            }

            if (count($request->siteLinkList)) {
                foreach ($request->siteLinkList as $kkk => $vvv) {
                    if ($vvv) {
                        $classRoomLink = new WebsiteClassRoomLink();

                        $classRoomLink->website_class_room_id = $classRoom->id;
                        $classRoomLink->link_type = 'site';
                        $classRoomLink->link = $vvv;
                        $classRoomLink->status = 1;
                        $classRoomLink->save();

                    }
                }

            }
            if (count($request->videoLinkList)) {
                foreach ($request->videoLinkList as $kkkk => $vvvv) {
                    if ($vvvv) {
                        if ($request->live_status == 1) {
                            $abc = explode('/', $vvvv);
                            $count = count($abc) - 2;
//                            return $count;
                            if (count($abc)) {
                                foreach ($abc as $k => $v) {
                                    if ($k == $count) {
                                        $final_link_last = $v;
                                    }
                                }
                            }
                        } else {
                            $abc = explode('/', $vvvv);
                            $last = end($abc);
                            $again = explode('?', $last);
                            if ($again) {
                                $mid_last = end($again);
                                $last_last = explode('v=', $mid_last);
                                $final_link_last = end($last_last);

                            } else {
                                $final_link_last = $last;
                            }
                        }
                        $final_link = 'https://www.youtube.com/embed/' . $final_link_last;


                        $classRoomLink = new WebsiteClassRoomLink();

                        $classRoomLink->website_class_room_id = $classRoom->id;
                        $classRoomLink->link_type = 'video';
                        $classRoomLink->link = $final_link;
                        $classRoomLink->live_status = $request->live_status;
                        $classRoomLink->status = 1;
                        $classRoomLink->save();

                    }
                }

            }
            if ($request->length) {
                $files = range(1, $request->length);
                $file_path = null;
                foreach ($files as $k => $val) {

                    $file = Input::file('files' . $k);
                    $file_type = $file->getClientMimeType();

                    $file_name = $classRoom->site_id . '/' . uniqid() . '.' . $file->getClientOriginalExtension();
                    $file_path = '/uploads/files/' . $file_name;

                    if (in_array($file_type, ['image/png', 'image/gif', 'image/jpeg', 'image/png'])) {
                        Image::make($file->getRealPath())->resize(700, null, function ($constraint) {
                            $constraint->aspectRatio();
                        })->save('uploads/files/' . $file_name);

                    } else {
                        Storage::disk('uploads')->put($file_name, File::get($file));
                    }

                    $this->deleteFiles($classRoom);


                    $classRoom->files()->create([
                        'user_id' => Auth::user()->id,
                        'path' => $file_path,
                        'name' => $file->getClientOriginalName(),
                    ]);
                }
            }

            if (count($deletes)) {
                foreach ($deletes as $k => $id) {
                    $the_photo = Photo::where('id', $id)->first();
                    $fssf[$k] = $the_photo;
                    if ($the_photo) {
                        $image_path = public_path($the_photo->path);
                        if (File::exists($image_path)) {
                            unlink($image_path);
                        }
                    }

                }
            }

        }


        $replicated_lecture = $classRoom->where('replicate_id', $request->id)->get();
        if (count($replicated_lecture) > 0) {
            $present_lecture_list = $classRoom->with(['files'])->where('id', $request->id)->first();
            $present_site_links = WebsiteClassRoomLink::where('website_class_room_id', $present_lecture_list->id)
                ->get();
            $present_file_links = $present_lecture_list->files;


            foreach ($replicated_lecture as $key => $value) {

                $class_room = $replicated_lecture->where('id', $value->id)->first();

                $class_room->topic_title = $present_lecture_list->topic_title;
                $class_room->topic_description = $present_lecture_list->topic_description;
                $class_room->serial_no = $present_lecture_list->serial_no;
                $class_room->publish_date = $present_lecture_list->publish_date;
                $class_room->publish_to = $present_lecture_list->publish_to;
                $class_room->save();

                $latest_class_room_id = $class_room->id;


                if (count($present_file_links) > 0) {
                    $rep_file = Photo::where('imageable_id', $latest_class_room_id)->delete();
                    foreach ($present_file_links as $kk => $vv) {

                        $photo = new Photo();

                        $photo->user_id = Auth::user()->id;
                        $photo->path = $vv->path;
                        $photo->name = $vv->name;
                        $photo->imageable_id = $latest_class_room_id;
                        $photo->imageable_type = $vv->imageable_type;
                        $photo->save();

                    }
                }


                if (count($present_site_links) > 0) {
                    $rep_links = WebsiteClassRoomLink::where('website_class_room_id', $latest_class_room_id)->delete();
                    foreach ($present_site_links as $kk => $vv) {

                        $classRoomLink = new WebsiteClassRoomLink();

                        $classRoomLink->website_class_room_id = $latest_class_room_id;
                        $classRoomLink->link_type = $vv->link_type;
                        $classRoomLink->link = $vv->link;
                        $classRoomLink->status = $vv->status;
                        $classRoomLink->save();

                    }
                }


            }

        }


        return Response::json(['message' => 'Successfully Updated!', 'mode' => 'Update'], 200);

    }

    private function deleteFiles($about)
    {
        foreach ($about->files as $k => $file) {
            $the_photo = Photo::where('id', $file->id)->first();
            $image_path = public_path($the_photo->path);
            if (File::exists($image_path)) {
                unlink($image_path);
            }
            $the_photo->delete();
        }
    }

    public function updateClassLessonPublishStatus(Request $request)
    {
        $class_room = ClassRoom::findOrFail($request->id);
        $class_room->update([
            'approve_status' => $request->approve_status
        ]);
        return Response::json(['message' => 'Successfully Updated!'], 200);
    }

    public function deleteClassRoom($id)
    {
        try {

            $classRoom = $this->classRoom->findOrFail($id);

            $replicated_lecture = ClassRoom::where('replicate_id', $id)->get();


            if (count($replicated_lecture) > 0) {
                $rep_ids = $replicated_lecture->pluck('id');
                WebsiteClassRoomLink::whereIn('website_class_room_id', $rep_ids)->delete();
                Photo::whereIn('imageable_id', $rep_ids)->delete();
                ClassRoom::where('replicate_id', $id)->delete();
            }


            $classRoom->delete();
            $classRoom->deleteTranslations();
            $this->deleteFiles($classRoom);
            $existLink = WebsiteClassRoomLink::where('website_class_room_id', $classRoom->id)->get();
            if (count($existLink)) {
                foreach ($existLink as $kk => $vv) {
                    $vv->delete();
                }

            }

            return Response::json(['message' => 'Successfully Deleted!'], 200);

        } catch (ModelNotFoundException $ex) {
            return Response::json(['message' => 'The Notice Not Found!'], 405);

        } catch (Exception $ex) {
            return Response::json(['message' => 'Something went Wrong!'], 405);
        }
    }


    public function apiSiteEmployeeGetDeptClassSubjectListForLessonReplicate($id)
    {


        $present_lecture = ClassRoom::where('id', $id)->first();
        $replicated_lecture_ids = ClassRoom::where('replicate_id', $present_lecture->id)->pluck('id');

        if (count($replicated_lecture_ids) > 0) {
            $present_ids = array_merge($replicated_lecture_ids->toArray(), [$present_lecture->id]);
        } else {
            $present_ids = [$present_lecture->id];
        }


        $check_present_lecture_list = ClassRoom::whereIn('id', $present_ids)->get();

        $employeeSelectedSubject = SiteEmployeeDepartmentClassSubject::with(['department'])
            ->with(['emClass'])
            ->with(['emSubject'])
            ->where('user_id', $present_lecture->faculty_id)
            ->whereNull('release_date')->get();


        $check_dept_present_ids = $employeeSelectedSubject->pluck('academic_department_id')->unique()->filter();

        $siteDepartmentList = [];
        if (count($check_dept_present_ids) > 0) {

            $siteDepartmentList = AcademicDepartment::whereIn('id', $check_dept_present_ids)->get();

        }


        $check_class_present_ids = $employeeSelectedSubject->pluck('academic_class_id')->unique()->filter();
        $siteClassList = AcademicClass::whereIn('id', $check_class_present_ids)->get();


        $deptArray = [];
        if (count($check_dept_present_ids) > 0) {

            $testDeptArr = Array();

            foreach ($siteDepartmentList as $keyt => $valuet) {


                $check_dept = $check_present_lecture_list->where('academic_department_id', $valuet->id);
                if (count($check_dept) > 0) {
                    $testDeptArr['select_academic_department_id'] = true;
                } else {
                    $testDeptArr['select_academic_department_id'] = false;
                }
                $testDeptArr['academic_department_id'] = $valuet->id;
                $testDeptArr['dempartment_name'] = $valuet->name;


                $emp_class_list_ids = $employeeSelectedSubject->where('academic_department_id', $valuet->id)
                    ->pluck('academic_class_id')->unique()->filter();

                $siteDeptClassList = $siteClassList->whereIn('id', $emp_class_list_ids);

                $testClassArr = Array();
                $ClassArray = [];
                foreach ($siteDeptClassList as $key => $value) {

                    $check_class = $check_dept->where('academic_class_id', $value->id);
                    if (count($check_class) > 0) {
                        $testClassArr['select_academic_class_id'] = true;
                    } else {
                        $testClassArr['select_academic_class_id'] = false;
                    }
                    $testClassArr['academic_class_id'] = $value->id;
                    $testClassArr['class_name'] = $value->class_name;


                    $emp_subject_list = $employeeSelectedSubject
                        ->where('academic_department_id', $valuet->id)
                        ->where('academic_class_id', $value->id);


                    $subject_arr = Array();
                    $subject_array = [];
                    foreach ($emp_subject_list as $keys => $values) {
                        $check_subject = $check_class->where('academic_subject_id', $values->academic_subject_id)->first();

                        if ($check_subject) {
                            $subject_arr['select_academic_subject_id'] = true;

                            if ($check_subject->replicate_id == 0) {
                                $subject_arr['replicate_id'] = true;
                            } else {
                                $subject_arr['replicate_id'] = false;
                            }

                        } else {
                            $subject_arr['select_academic_subject_id'] = false;
                            $subject_arr['replicate_id'] = false;
                        }


                        $subject_arr['academic_subject_id'] = $values->academic_subject_id;
                        $subject_arr['subject_name'] = $values->emSubject->subject_name;

                        $subject_array[$keys] = $subject_arr;

                    }


                    $testClassArr['subject_list'] = collect($subject_array)->values();

                    $ClassArray[$key] = $testClassArr;

                }

                $testDeptArr['class_list'] = collect($ClassArray)->values();

                $deptArray[$keyt] = $testDeptArr;
            }

        }


        $ClassArray = [];
        if (count($check_dept_present_ids) == 0) {

            $testClassArr = Array();

            foreach ($siteClassList as $key => $value) {

                $check_class = $check_present_lecture_list->where('academic_class_id', $value->id);
                if (count($check_class) > 0) {
                    $testClassArr['select_academic_class_id'] = true;
                } else {
                    $testClassArr['select_academic_class_id'] = false;
                }
                $testClassArr['academic_class_id'] = $value->id;
                $testClassArr['class_name'] = $value->class_name;


                $emp_subject_list = $employeeSelectedSubject->where('academic_class_id', $value->id);


                $subject_arr = Array();
                $subject_array = [];
                foreach ($emp_subject_list as $keys => $values) {
                    $check_subject = $check_class->where('academic_subject_id', $values->academic_subject_id)->first();

                    if ($check_subject) {
                        $subject_arr['select_academic_subject_id'] = true;

                        if ($check_subject->replicate_id == 0) {
                            $subject_arr['replicate_id'] = true;
                        } else {
                            $subject_arr['replicate_id'] = false;
                        }
                    } else {
                        $subject_arr['select_academic_subject_id'] = false;
                        $subject_arr['replicate_id'] = false;
                    }


                    $subject_arr['academic_subject_id'] = $values->academic_subject_id;
                    $subject_arr['subject_name'] = $values->emSubject->subject_name;

                    $subject_array[$keys] = $subject_arr;

                }


                $testClassArr['subject_list'] = collect($subject_array)->values();

                $ClassArray[$key] = $testClassArr;

            }

        }


        return response()->json(
            [
                'department_list' => $deptArray,
                'class_list' => $ClassArray,

            ]);


    }


    public function apiSiteEmployeeLectureReplicateCreate(ClassRoom $classRoom, Request $request)
    {

        $present_lecture_list = $classRoom->with(['files'])->where('id', $request->website_class_room_id)->first();
        $replicated_lecture = $classRoom->where('replicate_id', $present_lecture_list->id)->get();
        $present_site_links = WebsiteClassRoomLink::where('website_class_room_id', $present_lecture_list->id)
            ->get();
        $present_file_links = $present_lecture_list->files;


        $DepartmentClassSubjectList = collect($request->DepartmentClassSubjectList);
        $ClassSubjectList = collect($request->ClassSubjectList);


        $rep_ids = [];
        if (count($DepartmentClassSubjectList) > 0) {

            $checked_dept = $DepartmentClassSubjectList->where('select_academic_department_id', true);

            if (count($checked_dept) > 0) {
                foreach ($checked_dept as $key => $value) {

                    $class_all_list = collect($value['class_list']);
                    $checked_class = $class_all_list->where('select_academic_class_id', true);

                    if (count($checked_class) > 0) {

                        foreach ($checked_class as $keys => $values) {

                            $subject_all_list = collect($values['subject_list']);
                            $checked_subject = $subject_all_list
                                ->where('select_academic_subject_id', true)
                                ->where('replicate_id', false);

                            if (count($checked_subject) > 0) {
                                foreach ($checked_subject as $keyst => $valuest) {

                                    $check_replicated_value = $replicated_lecture
                                        ->where('academic_department_id', $value['academic_department_id'])
                                        ->where('academic_class_id', $values['academic_class_id'])
                                        ->where('academic_subject_id', $valuest['academic_subject_id'])
                                        ->first();

                                    if ($check_replicated_value) {
                                        $rep_ids[] = $check_replicated_value->id;
                                    } else {

                                        $class_room = new ClassRoom();

                                        if (count($class_room->ownFields) > 0) {
                                            foreach ($class_room->ownFields as $field) {
                                                if ($present_lecture_list->{$field}) {
                                                    $class_room->{$field} = $present_lecture_list->{$field};
                                                }
                                            }
                                            $class_room->academic_department_id = $value['academic_department_id'];
                                            $class_room->academic_class_id = $values['academic_class_id'];
                                            $class_room->academic_subject_id = $valuest['academic_subject_id'];
                                            $class_room->replicate_id = $request->website_class_room_id;


                                            if ($class_room->save()) {
                                                $latest_class_room_id = $class_room->id;

                                                \Log::info($latest_class_room_id);

                                                if (count($present_file_links) > 0) {
                                                    foreach ($present_file_links as $kk => $vv) {

                                                        $photo = new Photo();

                                                        $photo->user_id = Auth::user()->id;
                                                        $photo->path = $vv->path;
                                                        $photo->name = $vv->name;
                                                        $photo->imageable_id = $latest_class_room_id;
                                                        $photo->imageable_type = $vv->imageable_type;
                                                        $photo->save();

                                                    }
                                                }

                                                if (count($present_site_links) > 0) {
                                                    foreach ($present_site_links as $kk => $vv) {

                                                        $classRoomLink = new WebsiteClassRoomLink();

                                                        $classRoomLink->website_class_room_id = $latest_class_room_id;
                                                        $classRoomLink->link_type = $vv->link_type;
                                                        $classRoomLink->link = $vv->link;
                                                        $classRoomLink->status = $vv->status;
                                                        $classRoomLink->save();

                                                    }
                                                }

                                            }

                                        }


                                    }


                                }
                            }


                        }
                    }


                }
            }


        } else if (count($ClassSubjectList) > 0) {

            foreach ($ClassSubjectList as $keys => $values) {

                $subject_all_list = collect($values['subject_list']);
                $checked_subject = $subject_all_list
                    ->where('select_academic_subject_id', true)
                    ->where('replicate_id', false);

                if (count($checked_subject) > 0) {
                    foreach ($checked_subject as $keyst => $valuest) {

                        $check_replicated_value = $replicated_lecture
                            ->where('academic_class_id', $values['academic_class_id'])
                            ->where('academic_subject_id', $valuest['academic_subject_id'])
                            ->first();

                        if ($check_replicated_value) {
                            $rep_ids[] = $check_replicated_value->id;
                        } else {

                            $class_room = new ClassRoom();

                            if (count($class_room->ownFields) > 0) {
                                foreach ($class_room->ownFields as $field) {
                                    if ($present_lecture_list->{$field}) {
                                        $class_room->{$field} = $present_lecture_list->{$field};
                                    }
                                }
                                $class_room->academic_class_id = $values['academic_class_id'];
                                $class_room->academic_subject_id = $valuest['academic_subject_id'];
                                $class_room->replicate_id = $request->website_class_room_id;


                                if ($class_room->save()) {
                                    $latest_class_room_id = $class_room->id;


                                    if (count($present_file_links) > 0) {
                                        foreach ($present_file_links as $kk => $vv) {

                                            $photo = new Photo();

                                            $photo->user_id = Auth::user()->id;
                                            $photo->path = $vv->path;
                                            $photo->name = $vv->name;
                                            $photo->imageable_id = $latest_class_room_id;
                                            $photo->imageable_type = $vv->imageable_type;
                                            $photo->save();

                                        }
                                    }

                                    if (count($present_site_links) > 0) {
                                        foreach ($present_site_links as $kk => $vv) {

                                            $classRoomLink = new WebsiteClassRoomLink();

                                            $classRoomLink->website_class_room_id = $latest_class_room_id;
                                            $classRoomLink->link_type = $vv->link_type;
                                            $classRoomLink->link = $vv->link;
                                            $classRoomLink->status = $vv->status;
                                            $classRoomLink->save();

                                        }
                                    }

                                }

                            }


                        }


                    }
                }


            }

        }


        if (count($replicated_lecture) > 0) {
            $replicated_ids = $replicated_lecture->pluck('id');
            $uncheck_lecture = array_diff($replicated_ids->toArray(), $rep_ids);

            WebsiteClassRoomLink::whereIn('website_class_room_id', $uncheck_lecture)->delete();
            Photo::whereIn('imageable_id', $uncheck_lecture)->delete();

            ClassRoom::whereIn('id', $uncheck_lecture)
                ->delete();
        }


        return Response::json(['message' => 'Successfully Saved!', 'mode' => 'Save'], 200);

    }


    //====================Feedback==============
    public function apiLectureFeedbackSave(SiteClassLessonFeedback $siteClassLessonFeedback, Request $request)
    {


        if ($request->site_class_lesson_feedback_id) {
            $check_data = $siteClassLessonFeedback->where('id', $request->site_class_lesson_feedback_id)->first();

            if ($check_data) {
                $check_data->feedback_by = Auth::user()->id;
                $check_data->feedback_detail = $request->feedback_detail;
                $check_data->save();
            }
        } else {
            $siteClassLessonFeedback->website_class_room_id = $request->website_class_room_id;
            $siteClassLessonFeedback->feedback_by = Auth::user()->id;
            $siteClassLessonFeedback->feedback_detail = $request->feedback_detail;
            $siteClassLessonFeedback->site_id = Session::get('SITE_ID');
            $siteClassLessonFeedback->status = true;
            $siteClassLessonFeedback->save();
        }


        return Response::json(['message' => 'Successfully Saved!', 'mode' => 'Save'], 200);
    }


    public function getLectureFeedback(SiteClassLessonFeedback $siteClassLessonFeedback, Request $request)
    {

        $feedback_list = $siteClassLessonFeedback->where('website_class_room_id', $request->website_class_room_id)
            ->with(['user' => function ($query) {
                $query->select('id');
            },
                'siteClassLessonReplyFeedback' => function ($query) {
                    $query->with(['user' => function ($querys) {
                        $querys->select('id');
                    }]);
                }])
            ->get();


        $feedback_list_arr = Array();
        $feedback_list_array = [];
        foreach ($feedback_list as $key => $value) {

            $reply_arr = Array();
            $reply_array = [];
            foreach ($value->siteClassLessonReplyFeedback as $keys => $values) {
                $reply_arr['reply_edit_btn'] = Auth::user()->id == $values->reply_by ? true : false;
                $reply_arr['reply_delete_btn'] = Auth::user()->id == $values->reply_by ? true : false;

                $reply_array[$keys] = array_merge($values->toArray(), $reply_arr);
            }

            $feedback_list_arr['siteClassLessonReplyFeedback'] = collect($reply_array)->values();
            $feedback_list_arr['reply_present'] = count(collect($reply_array)) > 0 ? true : false;


            $feedback_list_arr['feedback_edit_btn'] = Auth::user()->id == $value->feedback_by ? true : false;
            $feedback_list_arr['feedback_delete_btn'] = Auth::user()->id == $value->feedback_by ? true : false;

            $feedback_list_array[$key] = array_merge($feedback_list_arr, $value->toArray());

        }


        return $feedback_list_array;

    }

    public function deleteLectureFeedback(Request $request)
    {

//        $reply_ids=SiteClassLessonReplyFeedback::where('site_class_lesson_feedback_id', $request->site_class_lesson_feedback_id)
//            ->pluck('id');

        SiteClassLessonReplyFeedback::where('site_class_lesson_feedback_id', $request->site_class_lesson_feedback_id)
            ->delete();

        SiteClassLessonFeedback::where('id', $request->site_class_lesson_feedback_id)
            ->delete();

        return Response::json(['message' => 'Successfully Deleted!', 'mode' => 'success'], 200);
    }


    //=======================Feedback Reply====================

    public function lectureFeedbackReplySave(SiteClassLessonReplyFeedback $siteClassLessonReplyFeedback, Request $request)
    {


        if ($request->site_class_lesson_reply_feedback_id) {
            $check_data = $siteClassLessonReplyFeedback->where('id', $request->site_class_lesson_reply_feedback_id)->first();

            if ($check_data) {
                $check_data->reply_by = Auth::user()->id;
                $check_data->reply_detail = $request->feedback_reply_detail;
                $check_data->save();

                $last_data = $siteClassLessonReplyFeedback->where('id', $request->site_class_lesson_reply_feedback_id)->first();
                return $last_data;
            }
        } else {
            $siteClassLessonReplyFeedback->site_class_lesson_feedback_id = $request->site_class_lesson_feedback_id;
            $siteClassLessonReplyFeedback->reply_by = Auth::user()->id;
            $siteClassLessonReplyFeedback->reply_detail = $request->feedback_reply_detail;
            $siteClassLessonReplyFeedback->site_id = Session::get('SITE_ID');
            $siteClassLessonReplyFeedback->status = true;
            $siteClassLessonReplyFeedback->save();

            $last_data = $siteClassLessonReplyFeedback->where('id', $siteClassLessonReplyFeedback->id)->first();
            return $last_data;

        }
//        return $last_data;

    }


    public function deleteLectureFeedbackReply(Request $request)
    {

        SiteClassLessonReplyFeedback::where('id', $request->site_class_lesson_reply_feedback_id)
            ->delete();

        return Response::json(['message' => 'Successfully Deleted!', 'mode' => 'success'], 200);
    }


}
