<?php

namespace App\Http\Controllers\Api;

use App\Forms\DataHelper;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\User\GlobalUser;
use App\Models\User\User;
use App\Traits\SiteUserAddress;
use Carbon\Carbon;
use Illuminate\Validation\ValidationException;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Exception;
use Response;
use Session;
use PDF;
use Illuminate\Support\Facades\Auth;


class UserApiController extends Controller
{
    use DataHelper,SiteUserAddress;
 

    public function __construct()
    {
        $this->middleware('auth:apps-api');
        $this->middleware('api.app.access');
    }

    
    private function getSiteId($request){
         
        if(empty($request->site_id)){
            $domain = "";
            if (isset($_SERVER['HTTP_HOST']) && !empty($_SERVER['HTTP_HOST'])) {
                $getHost = explode(".", $_SERVER['HTTP_HOST']);
                $domain = array_shift($getHost);
            }
            $site_info = GlobalSiteInfo::where('site_alias', $domain)->first();
            $site_id = $site_info->id;
            Session::put('SITE_ID', $site_id);
        }else{
            Session::put('SITE_ID', $request->site_id);
            $site_id = $request->site_id;
        }
        return $site_id;
    }

    public function getUserReadUnreadNotificaion(){

        try{
            $user=Auth::user();
            // read notification
            $read_array=[];
            foreach($user->readNotifications as $key=>$unread){

                $noti_data=[
                    'title'=>isset($unread->data['title'])?$unread->data['title']:'',
                    'details'=>isset($unread->data['data'])?$unread->data['data']:'',
                    'file_path'=>isset($unread->data['image_link'])?$unread->data['image_link']:'',
                    ];

                $read_array[$key]['id']=$unread->id;
                $read_array[$key]['data']=$noti_data;
                $read_array[$key]['created_at']=$unread->created_at;


            }

            // unread notification
            $unread_array=[];
            foreach($user->unreadNotifications as $key=>$unread){

                $noti_data=[
                    'title'=>isset($unread->data['title'])?$unread->data['title']:'',
                    'details'=>isset($unread->data['data'])?$unread->data['data']:'',
                    'file_path'=>isset($unread->data['image_link'])?$unread->data['image_link']:'',
                    ];

                $unread_array[$key]['id']=$unread->id;
                $unread_array[$key]['data']=$noti_data;
                $unread_array[$key]['created_at']=$unread->created_at;

            }

            $data=[
                'notifications'=>['read'=>$read_array,'unread'=>$unread_array],
                'mode'=>'success',
                'status'=>'200',
            ];

            return response()->json($data, 200);
        
        } catch (ValidationException $exception) {
         return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }
    }

    public function getUserAllNotificaion(){

        try{

            $user=Auth::user();

            $notifications=$user->notifications()->paginate(20);

            $notifications->transform(function ($value) {

                $noti_data=[
                    'title'=>isset($value->data['title'])?$value->data['title']:'',
                    'details'=>isset($value->data['data'])?$value->data['data']:'',
                    'file_path'=>isset($value->data['image_link'])?$value->data['image_link']:'',
                    ];

                return [
                    'id' => $value->id ?? null,
                    'data' => $noti_data ?? null,
                    'created_at'=>$value->created_at,

                ];
            });

            
            $data=[
                'notifications'=>$notifications,
                'mode'=>'success',
                'status'=>'200',
            ];

            return response()->json($data, 200);

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }

    }

    public function readNotification(Request $request){
        try{

            $this->validate($request, [
                'id' => 'required',
            ]);

            $user=Auth::user();
            $notifications=$user->notifications()->findOrFail($request->id);
    
            $notifications->markAsRead();

            $noti_data=[
                'title'=>isset($notifications->data['title'])?$notifications->data['title']:'',
                'details'=>isset($notifications->data['data'])?$notifications->data['data']:'',
                'file_path'=>isset($notifications->data['image_link'])?$notifications->data['image_link']:'',
                ];

            $res_data['id']=$notifications->id;
            $res_data['data']=$noti_data;
            $res_data['created_at']=$notifications->created_at;

            $data=[
                'notification'=>$res_data,
                'mode'=>'success',
                'status'=>'200',
            ];

            return response()->json($data, 200);

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }
    }

    public function getUserLocation(Request $request){
        try{

            $this->validate($request, [
                'latitude' => 'required',
                'longitude' => 'required',
            ]); 

            $latitude=$request->latitude;
            $longitude=$request->longitude;

            $data=$this->getAddress($latitude,$longitude);

            $data=[
                'address'=>$data['address'],
                'components'=>$data['components'],
                'mode'=>'success',
                'status'=>'200',
            ];

            return response()->json($data,200);

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }
    }


}
