<?php

namespace App\Http\Controllers\Api\Web;

use App\Forms\DataHelper;
use App\Http\Controllers\ProjectController;
use App\Models\Edu\NewSite\Application;
use App\Models\Image\Photo;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Image;
use Response;

class EduApiController extends ProjectController
{

    use DataHelper;

    private $application;

    public function __construct(Application $application)
    {
        $this->application = $application;


    }

    public function saveApplication(Request $request)
    {

     //   dd($request->all());

        $this->validate($request, [
            "academic_group_ids" => "required",
            "site_name" => "required",
            "board_id" => "required",
            "first_name" => "required",
            "country_id" => "required",
            "division_id" => "required",
            "district_id" => "required",
            "thana_id" => "required",
            "address" => "required",
            "eiin" => "required",
            "site_email" => "required|unique:edu_newsite_applications,site_email",
            "site_phone" => "required|unique:edu_newsite_applications,site_email",
        ]);


        if($request->site_logo=='/uploads/no_image.png'){

            return Response::json(['message' => 'Plese Upload Your Institute Logo!', 'mode' => 'Error'], 412);
        }



        if (isset($this->application->ownfields)) {
            foreach ($this->application->ownfields as $ownField) {
                if ($request->{$ownField}) {
                    if (is_array($request->{$ownField})) {
                        $this->application->{$ownField} = implode(',', $request->{$ownField});
                    } else {
                        $this->application->{$ownField} = $request->{$ownField};
                    }
                }
            }
            $this->application->status = 1;
        }

        $this->application->save();


        if ($this->is_base64_string($request->site_logo)) {

            $name = time() . '.' . explode('/', explode(':', substr($request->site_logo, 0, strpos($request->site_logo, ';')))[1])[1];
            $path = '/uploads/' . $name;
            Image::make($request->site_logo)->resize(150, 150)->save(public_path('uploads/') . $name);

            $photo = new Photo();
            $photo->path = $path;
            $photo->name = $name;
         //   $this->application->headImage()->save($photo);
            $this->application->siteLogoImage()->save($photo);


        } else {
            $photo = new Photo();
            $photo->path = $request->site_logo;
            $photo->name = "Default Picture";
         //   $this->application->headImage()->save($photo);
            $this->application->siteLogoImage()->save($photo);
        }

            return Response::json(['message' => 'Thanks for your application. Edu world will contact you if information is genuine!', 'mode' => 'Submit!'], 200);




    }
}
