<?php

namespace App\Http\Controllers\Assessment\Setting;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassWiseSubject;
use App\Models\Academic\AcademicSubject;
use App\Models\Assessment\AssessmentType;
use App\Models\Assessment\AssessmentTypeNo;

class AcademicAssessmentTypeNoController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
     //   $this->middleware('eduworlduserchecker');
    }

    public function index()
    {
        $viewType = 'Assessment Type List';
       
        return view('default.admin.layouts.master', compact('viewType'));
    }


    public function getAssessmentTypeAndClassList(Request $request){
        $class_id_array=[
            '0'=>16,
            '1'=>17,
            '2'=>18,
            '3'=>19,
            '4'=>20,
            '5'=>21,
            '6'=>22,
            '7'=>23,
            '8'=>24,
            '9'=>25,
        ];

        $subject_id_array=[
            '0'=>1,
            '1'=>2,
            '2'=>3,
            '3'=>8,
            '4'=>9,
            '5'=>10,
            '6'=>11,
            '7'=>48,
            '8'=>282,
            '9'=>278,
            '10'=>279,
            '11'=>280,
            '12'=>281,
        ];

        $classList = AcademicClass::whereIn('id',$class_id_array)->where('status',true)->orderBy('serial_no','ASC')->get();
   //     
        $typeList = AssessmentType::get();

       $academic_subject_ids = AcademicClassWiseSubject::when(!empty($request->academic_class_id), function($q) use ($request){
                return $q->where('academic_class_id',$request->academic_class_id);
            })
            ->pluck('academic_subject_id')
            ->filter()
            ->unique();


        $subjectList = AcademicSubject::with('classes')
            ->whereIn('id',$subject_id_array)
            ->whereIn('id',$academic_subject_ids)
            ->get();;

       // dd($request->all());
     //   whereIn('id',$subject_id_array)->

        return [$classList,$typeList,$subjectList];

    }

    public function assessmentTypeNoAdd(Request $request)
    {
        $request->validate([
            'assessment_type_id'=> 'required',
            //'academic_class_id'=> 'required',
            'type_no'=> 'required',
            'type_no_key'=> 'required',
            'serial'=> 'required',
            'status'=> 'required',
        ]);
        $academicAssessment = new AssessmentTypeNo();

        $academicAssessment->assessment_type_id     = $request->assessment_type_id;
        $academicAssessment->academic_class_id     = $request->academic_class_id;
        $academicAssessment->type_no     = $request->type_no;
        $academicAssessment->type_no_key = $request->type_no_key;
        $academicAssessment->serial      = $request->serial;
        $academicAssessment->status      = $request->status;
        $academicAssessment->save();
        return response()->json(['message'=>'Created Successfully!']);
    }

    public function assessmentTypeNoList(Request $request){
        $assessmentTypeList=AssessmentTypeNo::with('assessmentType','academicClass')
            ->when($request->academic_class_id!='null',function($q) use ($request){
                $q->where('academic_class_id',$request->academic_class_id);
                $q->orWhere('assessment_type_id',2);
            })
            // ->when(!empty($request->assessment_type_id),function($q) use ($request){
            //     $q->where('type_id',$request->assessment_type_id);
            // })
            ->orderBy('academic_class_id')
            ->orderBy('serial')
            ->paginate(20);

        return response()->json($assessmentTypeList);
    }

    public function assessmentTypeNoUpdate(Request $request , $id){
        $request->validate([
            'assessment_type_id'=> 'required',
            'type_no'=> 'required',
            'type_no_key' => 'required',
            'serial'=> 'required',
            'status'=> 'required',
        ]);

        $academicAssessment = AssessmentTypeNo::findOrFail($id);
        $academicAssessment->assessment_type_id     = $request->assessment_type_id;
        $academicAssessment->academic_class_id     = $request->academic_class_id;
        $academicAssessment->type_no     = $request->type_no;
        $academicAssessment->type_no_key = $request->type_no_key;
        $academicAssessment->serial      = $request->serial;
        $academicAssessment->status      = $request->status;
        $academicAssessment->save();
        return response()->json(['message'=>'Updated Successfully!']);
    }

}
