<?php

namespace App\Http\Controllers\Common;

use App\Forms\AssignPermission;
use App\Forms\AssignRole;
use App\Forms\FormControll;
use App\Http\Controllers\Language\Lang;
use App\Http\Controllers\ProjectController;
use App\Models\Permission\Permission;
use App\Models\Role\Role;
use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Models\Gender\Gender;
use App\Models\Religion\Religion;
use App\Models\Company\CompanyGroup;
use App\Models\Company\Company;
use App\Models\Department\Department;
use App\Http\Requests\Validator;
use Illuminate\Support\Facades\Config;
use App\Models\User\User;
use Illuminate\Support\Facades\Route;

class CommonController extends ProjectController
{
    use Lang, FormControll;

    private $request;
    private $gender;
    private $religion;
    private $cgroup;
    private $company;
    private $department;


    public function __construct(Request $request)
    {
        $this->request = $request;

    }

    /**
     * @return $this
     */
    public function createForm()
    {
        $viewType = $this->request->segment(1);

        return view('default.admin.'.$viewType.'.create')
                    ->with('viewType',$viewType);
    }
}
