<?php

namespace App\Http\Controllers\Company;

use App\Models\Company\Company;
use App\Models\Company\GlobalCompany;
use App\Models\Modules\Module;
use App\Models\Package\EduPackage;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\SiteGroup\GlobalSiteGroup;
use App\Models\SiteGroup\SiteGroupModel;
use Exception;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use phpDocumentor\Reflection\DocBlock\Tags\See;
use Response;
use Session;

class CompanyController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');

    }


    public function getCompanyList()
    {
        $list = GlobalCompany::all();

        return response()->json($list, 200, [], JSON_NUMERIC_CHECK);

    }


    public function getSiteGroupList()
    {
        try {
            $company = Company::findOrFail(Session::get('COMPANY_ID'));
            $s_g_ids = explode(',', $company->site_groups_ids);
            $site_groups = GlobalSiteGroup::whereIn('id', $s_g_ids)->get();


             $s_ids = explode(',', $company->site_ids);
            $site_g = GlobalSiteGroup::whereHas('sites',function($q)use($s_ids){
                $q->whereIn('id',$s_ids);
            })->get();



            return response()->json([$site_groups,$site_g], 200, [], JSON_NUMERIC_CHECK);
        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 412);

        }

    }

    public function getSiteListBySiteGroup($sg_id)
    {
        try {
            $company = Company::findOrFail(Session::get('COMPANY_ID'));
            $s_ids = explode(',', $company->site_ids);
            $sites = GlobalSiteInfo::where('site_group_id', $sg_id)->whereIn('id', $s_ids)->get();


            return response()->json($sites, 200, [], JSON_NUMERIC_CHECK);
        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 412);

        }

    }

    public function getAssignedListForCompany()
    {
        try {
            $com_id = Session::get('COMPANY_ID');
            $company = Company::findOrFail($com_id) ?? [];

            $package = EduPackage::whereId($company->edu_package_id ?? null)->first();
            $package_module_ids = $package ? ($package->modules->pluck('id')->toArray()) : [];

            $module_list = Module::with(['subModule'])
                ->whereIn('id', $package_module_ids)
                ->orderBy('id', 'DESC')
                ->get();


            if (count($module_list) <= 0) {
                return JsonResponse::create(['message' => "Don't Have Assigned Module <br/> Contact With EduTeam"], 410);
            }
            return response()->json($module_list, 200, [], JSON_NUMERIC_CHECK);

        } catch (ModelNotFoundException $y) {
            return JsonResponse::create(['message' => 'Site Info Not Found'], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }

}
