<?php

namespace App\Http\Controllers\Company\User;

use App\Mail\SendMailToUserWithQueue;
use App\Models\Company\Company;
use App\Models\Company\CompanyUser;
use App\Models\Company\Role\CompanyRole;
use App\Models\Image\Photo;
use App\Traits\RequestHandleWithThirdPartyApi;
use App\Traits\RequestHandlingWithMachine;
use Auth;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Mail;
use Response;
use Session;

class UserController extends Controller
{
    use RequestHandlingWithMachine,RequestHandleWithThirdPartyApi;

    private $user;

    public function __construct(CompanyUser $user)
    {
        $this->middleware('auth');
        $this->user = $user;
    }


    public function index()
    {
        $viewType = 'User List';
        return view('default.admin.company.user.user-list', compact('viewType'));
    }

    public function create(Request $validatedRequest)
    {

        $this->validate($validatedRequest, [
            'first_name' => 'required',
            'last_name' => 'required',
            'username' => 'required|unique:users,username',
            'password' => 'required',
            'email' => 'nullable|email|unique:users',
            'phone' => 'required|unique:users,phone',
        ]);
        $role_ids = $validatedRequest->checkedRoles;
        $site_g_id = $validatedRequest->checkedSiteGroups;
        $site_id = $validatedRequest->checkedSites;
        $send_sms = $validatedRequest->sendSms;


        //check manager role


        $this->user = new CompanyUser();

        if (count($this->user->ownFields) > 0) {
            foreach ($this->user->ownFields as $ownField) {
                if ($validatedRequest->{$ownField}) {
                    $this->user->{$ownField} = $validatedRequest->{$ownField};
                }
            }
        }

        if ($this->user->save()) {


            Photo::insert([

                'user_id' => $this->user->id,
                'imageable_id' => $this->user->id,
                'imageable_type' => 'App\User',
                'name' => 'image-not.png'

            ]);

            $this->user->companyRoles()->sync($role_ids);
            $this->user->siteInfoes()->sync($site_id);
            $this->user->siteGroups()->sync($site_g_id);

            //-----send mail to newly created user

            $url = config('app.url');
            $parsedUrl = parse_url($url);
            $company = Company::findOrFail(Session::get('COMPANY_ID'));
            $sub_domain = $parsedUrl['scheme'] . '://' . $company->alias . '.' . $parsedUrl['host'];

            $user_name = $validatedRequest->username;
            $password = $validatedRequest->password;
            $phone = $validatedRequest->phone;
            $data = [
                'username' => $user_name,
                'sub_domain' => $sub_domain,
                'password' => $password,
                'message' => "User Created For " . $company->name,
                'created_by' => Auth::user()->username

            ];
            $subject = "User Created For " . $company->name;
            Mail::to([$this->user->email, 'eduworlderp@gmail.com'])->send(new SendMailToUserWithQueue($subject, $data));


            if ($send_sms && $phone) {
                $this->sendSms([$phone], arrayToString($data));
                return Response::json(['message' => 'Updated Successfully With SMS', 'mode' => 'Saved!'], 200);
            }
            return Response::json(['message' => 'Saved Successfully!', 'mode' => 'Saved!'], 200);

        }
    }

    public function update(Request $validatedRequest, $id)
    {
        $this->validate($validatedRequest, [
            'first_name' => 'required',
            'last_name' => 'required',
            'username' => 'required|unique:users,username,' . $id . ',id',
            'email' => 'nullable|email|unique:users,email,' . $id . ',id',
            'phone' => 'required|unique:users,phone,' . $id . ',id',
        ]);

        $role_ids = $validatedRequest->checkedRoles;
        $site_g_id = $validatedRequest->checkedSiteGroups;
        $site_id = $validatedRequest->checkedSites;
        $send_sms = $validatedRequest->sendSms;


        $toEdit = $this->user->findOrFail($id);

        $toEdit->first_name = $validatedRequest->get('first_name');
        $toEdit->last_name = $validatedRequest->get('last_name');
        $toEdit->company_branch_id = $validatedRequest->get('company_branch_id');
        $toEdit->email = $validatedRequest->get('email');
        $toEdit->phone = $validatedRequest->get('phone');
        $toEdit->status = $validatedRequest->get('status');


        if ($toEdit->save()) {
            $toEdit->companyRoles()->sync($role_ids);
            $toEdit->siteInfoes()->sync($site_id);
            $toEdit->siteGroups()->sync($site_g_id);


            $com_role_id = CompanyRole::where('key', 'b_manager')->first()->id ?? 0;

            $company_users = $this->user
                ->where('company_branch_id', $validatedRequest->company_branch_id)
                ->whereHas('companyRoles', function ($q) use ($com_role_id) {
                    $q->where('company_role_id', $com_role_id);
                })
                ->count();
            $mg_text = '';


            if ($validatedRequest->company_branch_id && $company_users && in_array($com_role_id, $role_ids)) {
                $mg_text = 'The Branch belongs to ' . $company_users . ' Manager';
            }

          /*  if ($send_sms) {
                return Response::json(['message' => 'Updated Successfully With SMS ' . $mg_text, 'mode' => 'Updated!'], 200);
            }*/
            return Response::json(['message' => 'Updated Successfully ' . $mg_text, 'mode' => 'Updated!'], 200);
        }
    }


    public function delete($id)
    {
        $the_role = $this->role->findOrFail($id);
        $the_role->delete();

        return Response::json(['message' => 'Deleted Successfully', 'mode' => 'Updated!'], 200);


    }

    //Api================================Api======

    public function getUserList()
    {
        $list = $this->role->all();
        return response()->json($list, 200, [], JSON_NUMERIC_CHECK);

    }


    public function getUserListWithPagination()
    {
        $list = $this->user->with(['companyRoles', 'siteGroups', 'siteInfoes'])
            ->select(['id', 'username', 'phone', 'email', 'status', 'company_branch_id'])
            ->orderBy('id', 'DESC')
            ->paginate(10);

        return response()->json($list, 200, [], JSON_NUMERIC_CHECK);

    }


}
