<?php

/**
 * Created by PhpStorm.
 * User: Abdul Aziz
 * Date: 5/7/2016
 * Time: 3:26 PM
 */
namespace App\Http\Controllers\Division;


use App\Http\Controllers\Controller;
use App\Forms\DivisionForm;
use App\Forms\FormControll;
use App\Http\Controllers\Language\Lang;
use App\Http\Controllers\ProjectController;
use App\Models\Country\Country;
use App\Models\Division\Division;
use Illuminate\Http\Request;
use App\Http\Requests;
use Response;

class DivisionController extends ProjectController
{
    use Lang,FormControll;

    private $division;

    /**
     * @param Division $division
     */
    public function __construct(Division $division)
    {

        $this->middleware('auth')->except(['getDivisionListByCountryID']);
        $this->division = $division;
    }

    /**
     * @param Division $division
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index(Division $division)
    {
        $locale = $this->chosenLanguage();
        $defaultLocale = $this->defaultLocale();

        $divisionList = $division->with('country')->paginate(20);
        //dd($divisionList);

        $viewType = 'Division List';
        return view('default.admin.layouts.master', compact('viewType'));

        return view('default.admin.division.index',compact('viewType', 'divisionList', 'locale', 'defaultLocale'));
    }

    public function getDivisionList()
    {
        $divisionList = $this->division->with('country')->get();
//        $divisionList = $this->division->with('country')->get();
        return $divisionList;

    }

    public function getDivisionListPagination(Request $request)
    {
        $paginate = $request->paginate;
        $division_id = $request->division_id;
        $country_id = $request->search_country_id;
        $division_list =  $this->division->when($division_id, function ($q) use($division_id){
            $q->where('id', $division_id);
        })->when($country_id, function ($qr) use($country_id){
            $qr->where('country_id', $country_id);
        })->with('country')->paginate($paginate);
        return $division_list;

    }

    public function getDivisionListByCountryID($country_id)
    {
        $division_list =  $this->division->where('country_id', $country_id)->get();
        return $division_list;

    }

    public function getDivisionByCountryId($countryId)
    {

        $divisionOfCountry = $this->division->whereCountryId($countryId)->get();

        //return $divisionOfCountry;
        //$subjectOfClass = $subject->whereStudentClassId($divisionId)->get();
        //return $districtOfDivision;


        return $divisionOfCountry;
    }


    public function createDivision(Request $request)
    {
        $this->division->country_id = $request->get('country_id');
        $this->division->division_name = $request->get('division_name');
        $this->division->govt_code = $request->get('govt_code');
        $this->division->status = $request->get('status');

        if($this->division->save()){
            $country_check = Country::where('id', $request->get('country_id'))->first();
            $country_check->update([
                'division_check' => 1
            ]);
            return Response::json(['message' => 'Successfully Saved!', 'mode' => 'Save'], 200);
        }

    }


    /**
     * @param $id
     * @param Requests\Validator $validatedRequest
     * @return null
     */
    public function editDivision($id, Request $request)
    {
        $divisionToEdit = $this->division->findOrFail($id);

        $divisionToEdit->country_id = $request->get('country_id');
        $divisionToEdit->division_name = $request->get('division_name');
        $divisionToEdit->govt_code = $request->get('govt_code');
        $divisionToEdit->status = $request->get('status');

        if($divisionToEdit->save()){
            $country_check = Country::where('id', $request->get('country_id'))->first();
            $country_check->update([
                'division_check' => 1
            ]);
            return Response::json(['message' => 'Successfully Updated!', 'mode' => 'Update'], 200);
        }
    }


    /**
     * @param $id
     * @return $this
     */
    public function deleteDivision($id)
    {
        $divisionToDelete = $this->division->findOrFail($id);

        if ($divisionToDelete->district_check == 0){
            $country_id = $divisionToDelete->country_id;
            if($divisionToDelete->delete()){
                $country_wise_division_check = Division::where('country_id', $country_id)->get();
                if(!count($country_wise_division_check)){
                    $country_check = Country::where('id', $country_id)->first();
                    $country_check->update([
                        'division_check' => 0
                    ]);
                }
                return Response::json(['message' => 'Successfully Deleted!', 'mode' => 'Delete'], 200);


            }
        }else{
            throw new Error('There is a dependecy');

        }

    }
}