<?php

namespace App\Http\Controllers\Edu\Accounts\AccountsVoucherType;

use App\Models\Edu\Accounts\AccountsVoucherType;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Pagination\Paginator;
use Carbon\Carbon;
use Error;
use Auth;
use Exception;
use File;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Image;
use Response;
use Storage;
use Session;

class AccountsVoucherTypeController extends Controller
{
    private $accountsVoucherType;

    public function __construct(AccountsVoucherType $accountsVoucherType)
    {
//        $this->middleware('auth:api');
//        $this->middleware('api.access');
        $this->middleware('eduworlduserchecker');
        $this->middleware('auth');
        $this->accountsVoucherType = $accountsVoucherType;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType ="Accounts Voucher Type";
        return view('default.admin.layouts.master',compact('viewType'));
    }

    public function getEduAccountsVoucherTypeListWithPagination(Request $request)
    {
//        return $request;

        $search_accounts_voucher_type_id = $request->search_accounts_voucher_type_id;
        $paginate = $request->paginate;

        $acc_voucher_type_list = AccountsVoucherType::when($search_accounts_voucher_type_id, function ($q) use($search_accounts_voucher_type_id){
            $q->where('id', $search_accounts_voucher_type_id);
        })->orderBy('id', 'DESC')->paginate($paginate);

        $acc_voucher_type_list_for_search = AccountsVoucherType::where('status', 1)->get();

        return [$acc_voucher_type_list,$acc_voucher_type_list_for_search];

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request, AccountsVoucherType $accountsVoucherType)
    {
        //==============validation=============
        if(!$request->name){
            throw new Error('Please, fill the required fields');
        }
        if (count($accountsVoucherType->ownFields) > 0) {
            foreach ($accountsVoucherType->ownFields as $field) {
                if ($request->{$field}) {
                    $accountsVoucherType->{$field} = $request->{$field};
                }
            }
            $accountsVoucherType->created_by = Auth::user()->id;
            $accountsVoucherType->created_date = Carbon::today();
            if($accountsVoucherType->save()){
                return Response::json(['message' => 'Successfully Saved!', 'mode' => 'Save'], 200);
            }
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        //==============validation=============
        if (!$request->name) {
            throw new Error('Please, fill the required fields');
        }

        $acc_account_voucher_type = AccountsVoucherType::findOrFail($request->id);
        if (count($acc_account_voucher_type->ownFields) > 0) {
            foreach ($acc_account_voucher_type->ownFields as $field) {
                if ($request->{$field}) {
                    $acc_account_voucher_type->{$field} = $request->{$field};
                }
            }
            $acc_account_voucher_type->created_by = Auth::user()->id;
            $acc_account_voucher_type->created_date = Carbon::today();
            $acc_account_voucher_type->status = (int)$request->status;
            if ($acc_account_voucher_type->save()) {
                return Response::json(['message' => 'Successfully Updated!', 'mode' => 'Update'], 200);
            }
        }
    }

            /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete($id)
    {
        $acc_head = AccountsVoucherType::findOrFail($id);
        if($acc_head->delete()){
            return Response::json(['message' => 'Successfully Deleted!', 'mode' => 'Deleted'], 200);
        }
    }
}
