<?php

namespace App\Http\Controllers\Edu\Company;

use App\Mail\SendMailToUserWithQueue;
use App\Models\Company\GlobalCompany;
use App\Models\Company\Role\GlobalCompanyRole;
use App\Models\Modules\SubModule;
use App\Models\Package\EduPackage;
use Auth;
use DB;
use Error;
use Exception;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Image;
use Mail;
use Response;

class CompanyController extends Controller
{
    private $company;
    private $eduPackage;

    public function __construct(EduPackage $eduPackage, GlobalCompany $company)
    {
        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');
        $this->eduPackage = $eduPackage;
        $this->company = $company;

    }

    public function index()
    {
        $viewType = 'Company List';
        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.edu.company.index', compact('viewType'));
    }


    public function create(Request $validatedRequest)
    {

        $this->validate($validatedRequest, [
            'name' => 'required|unique:site_groups,id',
            'alias' => 'required|unique:company_details,alias|unique:site_infos,site_alias|unique:site_groups,group_alias',
            'email' => 'required|email|unique:company_details',
            'address' => 'required',
            'edu_package_id' => 'required|numeric|not_in:0',
            'phone' => 'required|numeric|unique:company_details,phone',
            'status' => 'required',
        ]);

        $checkedSiteGroups=$validatedRequest->checkedSiteGroups ? implode(',', $validatedRequest->checkedSiteGroups): null;
        $checkedSites=$validatedRequest->checkedSites ? implode(',', $validatedRequest->checkedSites): null;


        if (count($this->company->ownFields) > 0) {
            foreach ($this->company->ownFields as $ownField) {
                if ($validatedRequest->{$ownField}) {
                    $this->company->{$ownField} = $validatedRequest->{$ownField};
                }
            }
            $this->company->status = $validatedRequest->status;
            $this->company->site_groups_ids =$checkedSiteGroups;
            $this->company->site_ids = $checkedSites;
        }


        if ($validatedRequest->logo == "demo_logo.jpg") {
            $this->company->logo = $validatedRequest->logo;
        } else {

            $name = time() . '.' . explode('/', explode(':', substr($validatedRequest->logo, 0, strpos($validatedRequest->logo, ';')))[1])[1];
            Image::make($validatedRequest->logo)->save(public_path('img/company/') . $name);

            $validatedRequest->merge(['logo' => $name]);
            $userPhoto = public_path('img/company/' . $name);

            $this->company->logo = $name;
        }

        if ($this->company->save()) {

        GlobalCompanyRole::create(['name'=>'SuperAdmin','key'=>'superadmin','company_id' => $this->company->id]);
            GlobalCompanyRole::create(['name' => 'Manager','key'=>'b_manager', 'company_id' => $this->company->id]);

            $this->createAdminUser($this->company);

            $this->assignPackagesToCompany($this->company, $validatedRequest->edu_package_id);
            return Response::json(['message' => 'Updated Successfully with all!', 'mode' => 'Saved!'], 200);

        }
    }

    public function update(Request $validatedRequest, $id)
    {

        $this->validate($validatedRequest, [
            'name' => 'required|unique:site_groups,id,' . $id,
            'alias' => 'required|unique:company_details,alias,' . $id . ',id|unique:site_infos,site_alias|unique:site_groups,group_alias',
            'email' => 'required|email|unique:company_details,id,' . $id,
            'address' => 'required',
            'edu_package_id' => 'required|numeric|not_in:0',
            'phone' => 'required|numeric|unique:company_details,phone,' . $id,
            'status' => 'required',
        ]);

        $checkedSiteGroups=$validatedRequest->checkedSiteGroups ? implode(',', $validatedRequest->checkedSiteGroups): null;
        $checkedSites=$validatedRequest->checkedSites ? implode(',', $validatedRequest->checkedSites): null;



        $toEdit = $this->company->findOrFail($id);
        $currentPhoto = $toEdit->logo;

        if (count($toEdit->ownFields) > 0) {
            foreach ($toEdit->ownFields as $ownField) {
                if ($validatedRequest->{$ownField}) {
                    $toEdit->{$ownField} = $validatedRequest->{$ownField};
                }
            }
            $toEdit->status = $validatedRequest->status;
            $toEdit->site_groups_ids =$checkedSiteGroups;
            $toEdit->site_ids = $checkedSites;
        }

        if ($validatedRequest->logo == "demo_logo.jpg") {
            $toEdit->logo = $validatedRequest->logo;
        } elseif ($validatedRequest->logo != $currentPhoto) {

            $name = time() . '.' . explode('/', explode(':', substr($validatedRequest->logo, 0, strpos($validatedRequest->logo, ';')))[1])[1];
            Image::make($validatedRequest->logo)->save(public_path('img/company/') . $name);

            $validatedRequest->merge(['logo' => $name]);
            $userPhoto = public_path('img/company/' . $currentPhoto);
            if (file_exists($userPhoto) && $currentPhoto != "demo_logo.jpg") {
                @unlink($userPhoto);
            }
            $toEdit->logo = $name;
        }
        if ($toEdit->save()) {
            $this->assignPackagesToCompany($toEdit, $validatedRequest->edu_package_id);
            return Response::json(['message' => 'Updated Successfully with all!', 'mode' => 'Updated!'], 200);
        }
    }




    public function createAdminUser(GlobalCompany $company)
    {
        try {

            $tableUser = DB::table('users');
            $user_name = 'superadmin' . $company->id;
            $adminPassword = rand(100000, 200000);
            $name = $company->name;
            $email = $company->email;
            $alias = $company->alias;


            $userId = $tableUser->insertGetId(
                [
                    'username' => $user_name,
                    'email' => $email,
                    'password' => bcrypt($adminPassword),
                    'alias' => $alias,
                    'site_id' => null,
                    'user_type' => 'employee',
                    'status' => true,
                ]
            );

            DB::table('user_translations')->insert(
                [
                    'user_id' => $userId,
                    'first_name' => $name,
                    'locale' => 'en'
                ]
            );

            DB::table('photos')->insert(
                [
                    'name' => 'image-not.png',
                    'user_id' => $userId,
                    'imageable_id' => $userId,
                    'imageable_type' => 'App\User'
                ]
            );

            $this->setAdminRole($userId, $company);

            $url = config('app.url');
            $parsedUrl = parse_url($url);
            $sub_domain = $parsedUrl['scheme'] . '://' . $company->alias . '.' . $parsedUrl['host'];
            $data = [
                'username' => $user_name,
                'sub_domain' => $sub_domain,
                'password' => $adminPassword,
                'message' => 'Company Successfully Created!',
                'user_id' => Auth::user()->username
            ];
            $subject = "New Company Added";
            Mail::to([$company->email, 'eduworlderp@gmail.com'])->send(new SendMailToUserWithQueue($subject, $data));

            return true;
        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }

    private function setAdminRole($userId,GlobalCompany $company)
    {
        try {

            $role = GlobalCompanyRole::where([
                'key' => 'superadmin',
                'company_id' => $company->id
            ])->first();

            if ($role) {
                $roleId = $role->id;
                DB::table('company_role_users')->insert(
                    [
                        'user_id' => $userId,
                        'company_role_id' => $roleId
                    ]
                );
            }
            return true;
        } catch (Exception $exception) {
            return false;
        }
    }


    public function assignPackagesToCompany(GlobalCompany $company, $package_id)
    {
        try {
            $sub_module_ids = [];
            $package = $this->eduPackage->findOrFail($package_id);
            if ($package) {

                $module_ids = $package->modules->pluck('id')->toArray();
                $unique_module_ids = array_unique($module_ids);
                foreach ($unique_module_ids as $k => $v) {
                    $sub_module_ids = array_merge($sub_module_ids, SubModule::whereModuleId($v)->pluck('id')->toArray());
                }
                $company->save();

                //assigned newly subModule to superAdmin too

                if (file_exists(base_path("resources/views/default/admin/layouts/sidebars/" . $company->alias))) {
                    deleteDir((base_path("resources/views/default/admin/layouts/sidebars/" . $company->alias)));
                }

                $the_role = GlobalCompanyRole::firstOrCreate(['key'=>'superadmin','company_id' => $company->id]);
                $imploded_sub_module_ids = implode(',', $sub_module_ids) ?? null;

                // throw new Error( $site_group_id_obj->id);

                if ($the_role->roleAccess == null) {
                    $the_role->roleAccess()->create([
                        'company_role_id' => $the_role->id,
                        'company_id' => $company->id,
                        'sub_module_ids' => $imploded_sub_module_ids,

                    ]);
                } else {
                    $the_role->roleAccess->update([
                        'company_id' => $company->id,
                        'sub_module_ids' => $imploded_sub_module_ids
                    ]);

                }

            }
        } catch (Exception $exception) {
            throw new Error($exception);
        }
    }


}
