<?php

namespace App\Http\Controllers\Edu\PaymentGateway;

use App\Models\Academic\AcademicOnlinePaymentMarchentType;
use App\Models\Academic\AcademicOnlinePaymentMethod;
use App\Models\Academic\AcademicPaymentType;
use App\Models\Edu\PaymentGateway\EduPaymentGateway;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Carbon\Carbon;
use Auth;
use Illuminate\Support\Facades\Storage;
use Session;
use Response;
use File;
use Error;

class PaymentGatewayController extends Controller
{
    private $paymentGateway;
    private $academicPaymentType;
    private $academicOnlinePaymentMethod;
    private $academicOnlinePaymentMarchentType;


    public function __construct(EduPaymentGateway $paymentGateway,
                                AcademicPaymentType $academicPaymentType,
                                AcademicOnlinePaymentMethod $academicOnlinePaymentMethod,
                                AcademicOnlinePaymentMarchentType $academicOnlinePaymentMarchentType)
    {
        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');
        // $this->middleware('sitepagechecker');
        $this->paymentGateway = $paymentGateway;
        $this->academicPaymentType = $academicPaymentType;
        $this->academicOnlinePaymentMethod = $academicOnlinePaymentMethod;
        $this->academicOnlinePaymentMarchentType = $academicOnlinePaymentMarchentType;

    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType ="Edu payment gateway";
        return view('default.admin.layouts.master',compact('viewType'));
    }

    public function getPaymentGatewayList()
    {
        $payment_gateway_list =  $this->paymentGateway->where('status', 1)->get();
        return $payment_gateway_list;
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function getPaymentGatewayListWithPagination(Request $request)
    {
        $paginate = $request->paginate ?? 15;
        $search_txt = $request->search_txt;
        $search_with_payment_type = $request->search_with_payment_type;
        $search_with_payment_method = $request->search_with_payment_method;
        $search_with_payment_marchent_type_id = $request->search_with_payment_marchent_type_id;
//        return $search_with_payment_type;

        $txt = '%' . $search_txt . '%';


        $payment_gateway_list =  EduPaymentGateway::when($search_with_payment_type, function ($q) use($search_with_payment_type){
            $q->where('academic_payment_type_key', $search_with_payment_type);
        })
            ->when($search_with_payment_method, function ($q) use($search_with_payment_method){
                $q->where('academic_payment_method_key', $search_with_payment_method);

            })
            ->when($search_with_payment_marchent_type_id, function ($qr) use($search_with_payment_marchent_type_id){
                $qr->where('academic_online_payment_marchent_type_id', $search_with_payment_marchent_type_id);

            })
            ->when($search_txt, function ($q) use($txt){
                $q->where('user_name', 'LIKE', $txt)
                    ->orWhere('password', 'LIKE', $txt)
                    ->orWhere('transaction_code', 'LIKE', $txt);

            })
            ->with(['academicOnlinePaymentMethod','academicOnlinePaymentMarchentType'])
            ->paginate($paginate);

        $data_for_dropdown = EduPaymentGateway::get();
        $payment_method_keys = $data_for_dropdown->pluck('academic_payment_method_key');
        $payment_type_head_keys = $data_for_dropdown->pluck('academic_payment_type_key');
        $payment_marcent_type_ids = $data_for_dropdown->pluck('academic_online_payment_marchent_type_id');

        $payment_method_list = AcademicOnlinePaymentMethod::whereIn('name_key', $payment_method_keys)->get();

        $payment_type_list = AcademicPaymentType::whereIn('name_key', $payment_type_head_keys)->get();

        $payment_marchent_type_list = AcademicOnlinePaymentMarchentType::whereIn('id', $payment_marcent_type_ids)->get();

        return [$payment_gateway_list, $payment_type_list, $payment_method_list, $payment_marchent_type_list] ;
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request, EduPaymentGateway $paymentGateway)
    {
//        return $request;
        //==============validation=============
        if($request->academic_payment_method_key == 'nagad'){
            $this->validate($request, [

                "academic_payment_type_key" => "required",
                "academic_payment_method_key" => "required",
                "academic_online_payment_marchent_type_id" => "required",
                "user_name" => "required",
                "password" => "required",
                "partner_code" => "required",
                "partner_number" => "required",


            ]);
        } else if($request->academic_payment_method_key == 'nagad'
            && $request->academic_online_payment_marchent_type_id
            && $request->academic_online_payment_marchent_type_id['name_key'] == 'non-marchent'){
            $this->validate($request, [

                "academic_payment_type_key" => "required",
                "academic_payment_method_key" => "required",
                "academic_online_payment_marchent_type_id" => "required",
                "user_name" => "required",
                "password" => "required",
                "partner_code" => "required",
                "partner_number" => "required",
                "authorization" => "required",
                "api_link" => "required",


            ]);
        } else if($request->academic_payment_method_key == 'bkash'
            && $request->academic_online_payment_marchent_type_id
            && $request->academic_online_payment_marchent_type_id['name_key'] == 'marchent'){
            $this->validate($request, [

                "academic_payment_type_key" => "required",
                "academic_payment_method_key" => "required",
                "academic_online_payment_marchent_type_id" => "required",
                "user_name" => "required",
                "password" => "required",
                "partner_code" => "required",
                "partner_number" => "required",
                "create_url" => "required",
                "execute_url" => "required",
                "token_url" => "required",
                "script" => "required",
                "app_key" => "required",
                "app_secret" => "required",

            ]);
        }


        if (count($paymentGateway->ownFields) > 0) {
            foreach ($paymentGateway->ownFields as $field) {
                if ($request->{$field}) {
                    $paymentGateway->{$field} = $request->{$field};
                }
            }
            $paymentGateway->created_by = Auth::user()->id;
            $paymentGateway->created_date = Carbon::today();
            $paymentGateway->academic_online_payment_marchent_type_id = $request->academic_online_payment_marchent_type_id['id'];
            $paymentGateway->save();
        }

        return Response::json(['message' => 'Payment Gateway Successfully Saved!', 'mode' => 'Saved!'], 200);

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
//        return $request->academic_online_payment_marchent_type_id['id'];
        //==============validation=============
        if($request->academic_payment_method_key == 'nagad'){
            $this->validate($request, [

                "academic_payment_type_key" => "required",
                "academic_payment_method_key" => "required",
                "academic_online_payment_marchent_type_id" => "required",
                "user_name" => "required",
                "password" => "required",
                "partner_code" => "required",
                "partner_number" => "required",


            ]);
        } else if($request->academic_payment_method_key == 'nagad'
            && $request->academic_online_payment_marchent_type_id
            && $request->academic_online_payment_marchent_type_id['name_key'] == 'non-marchent'){
            $this->validate($request, [

                "academic_payment_type_key" => "required",
                "academic_payment_method_key" => "required",
                "academic_online_payment_marchent_type_id" => "required",
                "user_name" => "required",
                "password" => "required",
                "partner_code" => "required",
                "partner_number" => "required",
                "authorization" => "required",
                "api_link" => "required",


            ]);
        } else if($request->academic_payment_method_key == 'bkash'
            && $request->academic_online_payment_marchent_type_id
            && $request->academic_online_payment_marchent_type_id['name_key'] == 'marchent'){
            $this->validate($request, [

                "academic_payment_type_key" => "required",
                "academic_payment_method_key" => "required",
                "academic_online_payment_marchent_type_id" => "required",
                "user_name" => "required",
                "password" => "required",
                "partner_code" => "required",
                "partner_number" => "required",
                "create_url" => "required",
                "execute_url" => "required",
                "token_url" => "required",
                "script" => "required",
                "app_key" => "required",
                "app_secret" => "required",

            ]);
        }

        $paymentGateway = EduPaymentGateway::findOrFail($request->id);
        if (count($paymentGateway->ownFields) > 0) {
            foreach ($paymentGateway->ownFields as $field) {
                if ($request->{$field}) {
                    $paymentGateway->{$field} = $request->{$field};
                }
            }
            $paymentGateway->created_by = Auth::user()->id;
            $paymentGateway->created_date = Carbon::today();
            $paymentGateway->academic_online_payment_marchent_type_id = $request->academic_online_payment_marchent_type_id['id'];
            $paymentGateway->status = $request->status;
            $paymentGateway->save();
        }
        return Response::json(['message' => 'Payment Gateway Successfully Updated!', 'mode' => 'Updated!'], 200);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete($id)
    {
        $paymentGateway = EduPaymentGateway::where('id',$id)->delete();
        return Response::json(['message' => 'Payment Gateway Successfully Deleted!', 'mode' => 'Deleted!'], 200);
    }
}
