<?php

namespace App\Http\Controllers\Edu\Replication;

use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicGroup;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Site\GlobalSiteShiftClassGroupSectionSetting;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use App\Models\SubjectGroupConditionSetting\GlobalSubjectGroupConditionSetting;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Response;

class SiteReplicationController extends Controller
{


    private $siteInfoSetting;
    public function __construct( GlobalSiteInfoSetting $siteInfoSetting)
    {
        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');
        $this->siteInfoSetting = $siteInfoSetting;

    }


    public function index()
    {
        $viewType = 'Replication';
        return view('default.admin.layouts.master', compact('viewType'));

    }



    public function getYearSiteListForReplication(){

        $site_list=SiteInfo::select('id')->get();

        $academic_year=AcademicYear::get();
        $academic_group=AcademicGroup::get();


        return response()->json(
            [
                'site_list'=>$site_list,
                'academic_year' => $academic_year,
                'academic_group' => $academic_group,

            ]);

    }


    public function getFromSiteYearGroupBaseDeptClassListForReplication(Request $request){



        $class_ids=GlobalSiteShiftClassGroupSectionSetting::where('site_id', $request->from_site_id)
            ->where('academic_year_id', $request->from_academic_year_id)
            ->where('academic_group_id', $request->from_academic_group_id)
            ->pluck('academic_class_id')
            ->unique();



        $class_list=AcademicClass::select('id', 'class_name')
            ->whereIn('id', $class_ids)
            ->get();


        $class_arr=Array();
        $class_array=[];
        foreach ($class_list as $key => $value) {

            $check_subject=GlobalSubjectGroupConditionSetting::where('site_id', $request->from_site_id)
                ->where('academic_year_id', $request->from_academic_year_id)
                ->where('academic_group_id', $request->from_academic_group_id)
                ->where('academic_class_id', $value->id)
                ->first();

            if($check_subject){
                $class_arr['setup_check']=true;
            }else{
                $class_arr['setup_check']=false;
            }
            $class_arr['select_class_id']=false;

            $class_array[$key]=array_merge($class_arr, $value->toArray());


        }


        return $class_array;

    }



    public function getToSiteYearGroupBaseDeptClassListForReplication(Request $request){
        $class_ids=GlobalSiteShiftClassGroupSectionSetting::where('site_id', $request->to_site_id)
            ->where('academic_year_id', $request->to_academic_year_id)
            ->where('academic_group_id', $request->to_academic_group_id)
            ->pluck('academic_class_id')
            ->unique();



        $class_list=AcademicClass::select('id', 'class_name')
            ->whereIn('id', $class_ids)
            ->get();


        $class_arr=Array();
        $class_array=[];
        foreach ($class_list as $key => $value) {

            $check_subject=GlobalSubjectGroupConditionSetting::where('site_id', $request->to_site_id)
                ->where('academic_year_id', $request->to_academic_year_id)
                ->where('academic_group_id', $request->to_academic_group_id)
                ->where('academic_class_id', $value->id)
                ->where('status', true)
                ->first();

            if($check_subject){
                $class_arr['setup_check']=true;

            }else{
                $class_arr['setup_check']=false;
            }
            $class_arr['select_class_id']=false;

            $class_array[$key]=array_merge($class_arr, $value->toArray());


        }


        return $class_array;
    }




    public function createSiteSubjectConditionReplication(Request $request){

        $FromClassList=collect($request->FromClassList);
        $ToClassList=collect($request->ToClassList);

        $from_class_ids=$FromClassList->where('select_class_id', true)->pluck('id')->unique();
        $to_class_ids=$ToClassList
            ->whereIn('id', $from_class_ids)
            ->where('select_class_id', true)
            ->where('setup_check', false)
            ->pluck('id')
            ->unique();

        $to_subject_list=GlobalSiteInfoSetting::where('site_id', $request->to_site_id)
            ->where('academic_group_id', $request->to_academic_group_id)
            ->select('academic_subject_ids')
            ->first();

        $to_subject_ids=explode(',', $to_subject_list->academic_subject_ids);



        $check_from_site_subject=GlobalSubjectGroupConditionSetting::where('site_id', $request->from_site_id)
            ->where('academic_year_id', $request->from_academic_year_id)
            ->where('academic_group_id', $request->from_academic_group_id)
            ->whereIn('academic_class_id', $to_class_ids)
            ->whereIn('academic_subject_id', $to_subject_ids)
            ->where('status', true)
            ->get();


        if(count($check_from_site_subject)>0){
            $charges=[];
            foreach ($check_from_site_subject as $key => $value){

                $charges[] = [
                    'academic_subject_id'=>$value->academic_subject_id,
                    'academic_class_id'=>$value->academic_class_id,
                    'academic_department_id'=>$value->academic_department_id,
                    'academic_class_group_ids'=>$value->academic_class_group_ids,
                    'academic_subject_condition_ids'=>$value->academic_subject_condition_ids,
                    'academic_subject_class_exam_condition_id'=>$value->academic_subject_class_exam_condition_id,
                    'exam_dependent_academic_subject_id'=>$value->exam_dependent_academic_subject_id,
                    'subject_position'=>$value->subject_position,
                    'result_show_in_table_bellow'=>$value->result_show_in_table_bellow,
                    'subject_code'=>$value->subject_code,
                    'status'=>$value->status,
                    'created_at'=>\Auth::user()->id,

                    'site_id'=>$request->to_site_id,
                    'academic_group_id'=>$request->to_academic_group_id,
                    'academic_year_id'=>$request->to_academic_year_id,


                ];

            }

            if(count($charges)>0){
                GlobalSubjectGroupConditionSetting::insert($charges);
            }
        }
        else{
            return Response::json(['message' => 'Somethis wanna wrong!', 'mode' => 'Error'], 200);
        }



        return Response::json(['message' => 'Replicate Successfully!', 'mode' => 'Saved!'], 200);


    }















}
