<?php

namespace App\Http\Controllers\Edu\SitePayment;

use App\Models\Academic\AcademicMonthName;
use App\Models\Edu\SitePayment\EduInvoicePayment;
use App\Models\Edu\SitePayment\SiteInvoice;
use App\Models\Edu\SitePayment\SiteInvoiceDetail;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteMembership;
use App\Traits\Invoice\InvoiceHistoryTrait;
use App\Traits\SmsApiTrait;
use Auth;
use Carbon\Carbon;
use DB;
use Error;
use Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Edu\Device\DeviceDetail;
use App\Models\Edu\Item\ItemDetail;
use Illuminate\Validation\ValidationException;
use PDF;
use Session;

class SiteInvoiceController extends Controller
{
    use InvoiceHistoryTrait, SmsApiTrait;
    private $sitePayment;
    private $siteMembership;
    private $siteInfo;
    private $invoice;
    private $invoiceDetail;

    public function __construct(SiteInvoice $invoice, SiteInvoiceDetail $invoiceDetail, EduInvoicePayment $sitePayment, SiteInfo $siteInfo, SiteMembership $siteMembership)
    {
        $this->middleware('auth');
      //  $this->middleware('sitepagechecker');
        $this->middleware('eduworlduserchecker');
        $this->siteInfo = $siteInfo;
        $this->siteMembership = $siteMembership;
        $this->sitePayment = $sitePayment;
        $this->invoice = $invoice;
        $this->invoiceDetail = $invoiceDetail;

    }


    /* Invoice status
 draft==when first created
 viewed=client viewed it
 approved=admin approve it
 Partial=payment partial
 Paid=full paid*/


    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {

        /*
                $rr=     [
                    'sms_txt' => 'Login Info[nl]Hasan Uddin[nl]http://ctgcs.eduworld.test[nl]Username: 2000900001[nl]Password: 8JsP7n[nl]Regards: Chattogram Collegiate School',
                    'sms_bearer' => 'site',
                    'sms_bearer_id' => 9,
                    'sms_company' => 'zamanit',
                    'per_sms_cost' => '0.35',
                    'sms_count' => 1.0,
                    'total_sms_charges' => 0.35,
                    'sms_type' => 'text',
                    'sms_masking' => NULL,
                ];

                $tt=    $this->sendSmsDynamicApi(['01675020403'],$rr);


              //  dd($tt);*/

        $viewType = 'Site Invoice';
        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.edu.site-payment.index', compact('viewType'));
    }


    public function create(Request $request)
    {
        DB::beginTransaction();

        try {


            $this->validate($request, [
                'invoice_date' => 'required',
                'due_date' => 'required',
                'sub_total' => 'required',
                'site_id' => 'required|numeric|min:1',
                'grand_total' => 'required|numeric|min:1'
            ]);


            $user = request()->user()->id;
            $site_id = $request->site_id;
            $items = $request->details;

            $previous_due_id = $request->previous_due_id;


            if (!$site_id) {
                throw new Error('Please Choose Site!');
            }
            if (count($items) < 1) {
                throw new Error('Please Choose Item!');
            }


            $invoice_number = $this->invoiceNumberGeneration();

            $check_invoice = $this->invoice
                ->where("invoice_no", $invoice_number)
                ->first();

            if ($check_invoice) {
                $invoice_number = $this->invoiceNumberGeneration();
            }


            if (isset($this->invoice->ownFields)) {
                foreach ($this->invoice->ownFields as $ownField) {
                    if ($request->{$ownField}) {
                        $this->invoice->{$ownField} = $request->{$ownField};
                    }
                }
                $this->invoice->invoice_no = $invoice_number;
                $this->invoice->status_code = 'approved';
                $this->invoice->created_by = $user;
                $this->invoice->save();


                foreach ($items as $k => $item) {

                    $this->invoiceDetail = new SiteInvoiceDetail();

                    if (count($this->invoiceDetail->ownFields) > 0) {
                        foreach ($this->invoiceDetail->ownFields as $ownField) {
                            if ($item[$ownField]) {
                                $this->invoiceDetail->{$ownField} = $item[$ownField];
                            }
                        }
                    }
                    $this->invoiceDetail->invoice_id = $this->invoice->id;
                    $this->invoiceDetail->item_details_id = $item['item_details_id'];
                    $this->invoiceDetail->save();
                }
            }

            $this->createHistory($this->invoice->id, 'draft', 'New Invoice:' . $this->invoice->invoice_no . ' created Successfully');

            //check previous due_id
            if ($previous_due_id) {
                $pre_invoice = $this->invoice
                    ->where("id", $previous_due_id)
                    ->first();

                $pre_invoice->carried_invoice_id = $this->invoice->id;
                $pre_invoice->status_code = 'carried';
                $pre_invoice->save();

                $this->createHistory($pre_invoice->id, 'carried', 'The Invoice:' . $pre_invoice->invoice_no . ' Carried to ' . $this->invoice->invoice_no . ' Successfully');
            }

            DB::commit();
            return response()->json(['message' => $this->invoice->invoice_no . ' Successfully Created!'], 200, []);

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            DB::rollback();
            throw new Error($exception->getMessage());
        }
    }

    public function update(Request $request)
    {
        DB::beginTransaction();
        try {


            $this->validate($request, [
                'invoice_date' => 'required',
                'due_date' => 'required',
                'sub_total' => 'required',
                'site_id' => 'required|numeric|min:1',
                'grand_total' => 'required|numeric|min:1'
            ]);


            $user = request()->user()->id;
            $site_id = $request->site_id;
            $items = $request->details;


            if (!$site_id) {
                throw new Error('Please Choose Site!');
            }
            if (count($items) < 1) {
                throw new Error('Please Choose Item!');
            }

            $this->invoice = $this->invoice
                ->where("id", $request->id)
                ->first();

            if (count($this->invoice->payments)) {
                throw new Error('The invoice has payment ' . $this->invoice->payments->sum('paid_amount') . ' Tk.');
            }
            if ($this->invoice->status_code == 'Paid') {
                throw new Error('The invoice is paid already!!');
            }


            if (isset($this->invoice->ownFields)) {
                foreach ($this->invoice->ownFields as $ownField) {
                    if ($request->{$ownField}) {
                        $this->invoice->{$ownField} = $request->{$ownField};
                    }
                };
                //$this->invoice->created_by = $user;
                $this->invoice->save();
                $this->invoice->details()->delete();


                foreach ($items as $k => $item) {

                    $this->invoiceDetail = new SiteInvoiceDetail();

                    if (count($this->invoiceDetail->ownFields) > 0) {
                        foreach ($this->invoiceDetail->ownFields as $ownField) {
                            if ($item[$ownField]) {
                                $this->invoiceDetail->{$ownField} = $item[$ownField];
                            }
                        }
                    }
                    $this->invoiceDetail->invoice_id = $this->invoice->id;
                    $this->invoiceDetail->item_details_id = $item['item_details_id'];
                    $this->invoiceDetail->save();
                }
            }

            $this->createHistory($this->invoice->id, 'draft', ' Invoice:' . $this->invoice->invoice_no . ' Updated Successfully. grand total: '.$this->invoice->grand_total);


            DB::commit();
            return response()->json(['message' => $this->invoice->invoice_no . ' Successfully Updated!'], 200);

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            DB::rollback();
            throw new Error($exception->getMessage());
        }
    }


    public function deleteSiteInvoice($id)
    {
        try {

            $the_invoice = $this->invoice
                ->findOrFail($id);

            if (count($the_invoice->payments) > 0) {
                return response()->json(['message' => 'The invoice can"t Be Deleted'], 410, []);
            }

            $the_invoice->delete();

            $this->createHistory($the_invoice->id, 'carried', 'The Invoice:' . $the_invoice->invoice_no . ' Successfully Deleted By: ' . Auth::user()->id);


            return response()->json(['message' => 'The invoice Deleted Successfully'], 200, []);


        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }

    }


    public function getTheInvoice($id)
    {
        try {

            $the_invoice = $this->invoice
                ->with('details')
                ->findOrFail($id);
            return response()->json($the_invoice, 200);


        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }

    }


    public function getInvoiceBySearch(Request $request)
    {
        //  \Log::info();


        $site_id = $request->site_id;
        $paginate = $request->paginate ?? 20;
        $invoice_no = $request->invoice_no;

        if(isset($request->date_range) && is_array($request->date_range)) {
            $start_date = isset($request->date_range['start']) ? $request->date_range['start'] : null;
            $end_date = isset($request->date_range['end']) ? $request->date_range['end'] : null;
        } else {
            // Handle the case where $request->date_range is null or not an array
            $start_date = null;
            $end_date = null;
        }

        if (Session::get('SITE_ID')) {
            $site_id = Session::get('SITE_ID');
        }


        if ($request->date_range) {
            if (!$start_date || !$end_date) {
                throw new Error('Please Select Both Date');
            }
        }

        $list = $this->invoice
            ->when($site_id, function ($query) use ($site_id) {
                return $query->where('site_id', $site_id);
            })->when(isset($start_date) && isset($end_date), function ($query) use ($start_date, $end_date) {
                return $query->whereBetween('invoice_date', [$start_date, $end_date]);
            })->when($invoice_no, function ($query) use ($invoice_no) {
                return $query->where('invoice_no', 'like', '%' . $invoice_no . '%');
            })
            ->orderBy('id', 'DESC')
            ->paginate($paginate);

        return response()->json([$list], 200);

    }

    public function getInvoiceList(Request $request)
    {

        $site_id    = $request->site_id;
        $paginate   = $request->paginate ?? 20;
        $invoice_no = $request->invoice_no;


        // Decode the JSON string into an associative array
        $date_range_array = json_decode($request->input('date_range'), true);
        if ($date_range_array !== null) {
            $start_date = isset($date_range_array['start']) ? $date_range_array['start'] : null;
            $end_date = isset($date_range_array['end']) ? $date_range_array['end'] : null;
        } else {
            $start_date = null;
            $end_date = null;
        }

        if ($date_range_array) {
            if (!$start_date || !$end_date) {
                throw new Error('Please Select Both Date');
            }
        }

        $list = $this->invoice
            ->when(isset($site_id), function ($query) use ($site_id) {
                return $query->where('site_id', $site_id);
            })
            ->when(isset($start_date) && isset($end_date), function ($query) use ($start_date, $end_date) {
                return $query->whereBetween('invoice_date', [$start_date, $end_date]);
            })
            ->when(isset($invoice_no), function ($query) use ($invoice_no) {
                return $query->where('invoice_no', 'like', '%' . $invoice_no . '%');
            })
            ->orderBy('id', 'DESC')
            ->paginate($paginate);


        return response()->json([$list], 200);

    }
    public function getRegulerSiteInvoiceList(Request $request)
    {

        $site_id    = $request->site_id;
        $paginate   = $request->paginate ?? 20;
        $invoice_no = $request->invoice_no;


        // Decode the JSON string into an associative array
        $date_range_array = json_decode($request->input('date_range'), true);
        if ($date_range_array !== null) {
            $start_date = isset($date_range_array['start']) ? $date_range_array['start'] : null;
            $end_date = isset($date_range_array['end']) ? $date_range_array['end'] : null;
        } else {
            $start_date = null;
            $end_date = null;
        }

        if ($date_range_array) {
            if (!$start_date || !$end_date) {
                throw new Error('Please Select Both Date');
            }
        }

        $site_ids=SiteMembership::where('service_type','regular')->pluck('site_id')->unique()->values();

        $list = $this->invoice
            ->with(['details'=>function($q) use ($request){
                $q->where('item_details_id',$request->item_id);
            }])
            ->whereHas('details')
            ->whereIn('site_id',$site_ids)
            ->when(isset($site_id), function ($query) use ($site_id) {
                return $query->where('site_id', $site_id);
            })
            ->when(isset($start_date) && isset($end_date), function ($query) use ($start_date, $end_date) {
                return $query->whereBetween('invoice_date', [$start_date, $end_date]);
            })
            ->when(isset($invoice_no), function ($query) use ($invoice_no) {
                return $query->where('invoice_no', 'like', '%' . $invoice_no . '%');
            })
            ->orderBy('id', 'DESC')
        //    ->get();
            ->paginate($paginate);


        return response()->json([$list], 200);

    }
    // public function getRegulerSiteHeadWiseReportList(Request $request)
    // {

    //     $site_id    = $request->site_id;
    //     $paginate   = $request->paginate ?? 20;
    //     $invoice_no = $request->invoice_no;


    //     // Decode the JSON string into an associative array
    //     $date_range_array = json_decode($request->input('date_range'), true);
    //     if ($date_range_array !== null) {
    //         $start_date = isset($date_range_array['start']) ? $date_range_array['start'] : null;
    //         $end_date = isset($date_range_array['end']) ? $date_range_array['end'] : null;
    //     } else {
    //         $start_date = null;
    //         $end_date = null;
    //     }

    //     if ($date_range_array) {
    //         if (!$start_date || !$end_date) {
    //             throw new Error('Please Select Both Date');
    //         }
    //     }
    //     if($site_id){
    //         $site_ids=[$site_id];
    //     }else{
    //         $site_ids=SiteMembership::where('service_type','regular')->pluck('site_id')->unique()->values();
    //     }



    //     $invoiceList = $this->invoice->with(['siteInfo'=>function($q){
    //         $q->select('id');
    //         }])
    //         ->when(!empty($request->item_id), function ($query) use ($request) {
    //             $query->with(['details' => function ($q) use ($request) {
    //                 $q->where('item_details_id', $request->item_id)
    //                 ->when(!empty($request->month_id), function ($qq) use ($request) {
    //                     $qq->where('month_for', $request->month_id);
    //                 });
    //             }]);

    //             $query->whereHas('details', function ($q) use ($request) {
    //                 $q->where('item_details_id', $request->item_id)
    //                 ->when(!empty($request->month_id), function ($qq) use ($request) {
    //                     $qq->where('month_for', $request->month_id);
    //                 });
    //             });
    //         }, function ($query) {
    //             $query->with('details');
    //         })
    //         ->when($request->payment_status != 'All', function ($query) use ($request) {
    //             $query->where('status_code', $request->payment_status);
    //         })
    //         ->whereIn('site_id', $site_ids)
    //         ->when(!empty($start_date) && !empty($end_date), function ($query) use ($start_date, $end_date) {
    //             $query->whereBetween('invoice_date', [$start_date, $end_date]);
    //         })
    //         ->when(!empty($invoice_no), function ($query) use ($invoice_no) {
    //             $query->where('invoice_no', 'like', '%' . $invoice_no . '%');
    //         })
    //         ->when(!empty($request->year_name), function ($query) use ($request) {
    //             $query->whereYear('created_at', $request->year_name);
    //         })
    //         ->orderBy('id', 'DESC')
    //         ->get();


    //     $invoice_ids = $invoiceList
    //             ->pluck('id')
    //             ->unique()
    //             ->values();


    //     $site_invoice_details_ids=SiteInvoiceDetail::whereIn('invoice_id',$invoice_ids)
    //         ->pluck('item_details_id')
    //         ->unique()
    //         ->values();

    //     $itemsList=ItemDetail::whereIn('id',$site_invoice_details_ids)->orderBy('id')->get();


    //     $site_info=SiteInfo::whereIn('id',$site_ids)->get();

    //     $site_array = [];
    //     $site_key=0;
    //     $item_totals = [];
    //     foreach($site_info as $site){

    //      $siteInvoiceList=$invoiceList->where('site_id',$site->id)->values();

    //     $invoice_array = [];
    //     $site_item_totals=[];
    //     foreach ($siteInvoiceList as $key => $invoice) {
    //         $item_array = [];

    //         foreach ($itemsList as $item) {
    //             // default value (যদি match না হয়)
    //             $item_details = [
    //                 'id' => $item->id,
    //                 'name' => $item->item_name,
    //                 'item_final_amount' => 0
    //             ];

    //             // check invoice details
    //             foreach ($invoice->details as $inv_details) {
    //                 if ($item->id == $inv_details->item_details_id) {
    //                     $item_details['item_final_amount'] = $inv_details->item_final_amount;
    //                     break;
    //                 }
    //             }

    //             $item_array[] = $item_details;

    //               // grand total হিসাব
    //         if (!isset($item_totals[$item->id])) {
    //             $item_totals[$item->id] = [
    //                 'id' => $item->id,
    //                 'name' => $item->item_name,
    //                 'grand_total' => 0
    //             ];
    //             $site_item_totals[$item->id] = [
    //                 'id' => $item->id,
    //                 'name' => $item->item_name,
    //                 'grand_total2' => 0
    //             ];
    //         }

    //         $item_totals[$item->id]['grand_total'] += $item_details['item_final_amount'];
    //       //  $site_item_totals[$item->id]['grand_total2'] += $item_details['item_final_amount'];

    //         }

    //         $invoice_array[$key] = array_merge(
    //             $invoice->toArray(),
    //             ['details' => $item_array]
    //         );
    //     }

    //     if(count($invoice_array)==0){
    //         continue;
    //     }

    // //    $item_totals_array=array_values($item_totals);
    //     $item_totals_array=array_values($site_item_totals);

    //     $sub_total_sum=$siteInvoiceList->sum('sub_total');
    //     $total_tax_sum=$siteInvoiceList->sum('total_tax');
    //     $previous_due_sum=$siteInvoiceList->sum('previous_due');
    //     $discount_amount_sum=$siteInvoiceList->sum('discount_amount');
    //     $grand_total_sum=$siteInvoiceList->sum('grand_total');
    //     $amount_paid_sum=$siteInvoiceList->sum('amount_paid');
    //     $amount_due_sum=$siteInvoiceList->sum('amount_due');

    //     $site_array[$site_key]['site_id']=$site->id;
    //     $site_array[$site_key]['site_name']=$site->site_name;
    //     $site_array[$site_key]['short_name']=$site->short_name;
    //     $site_array[$site_key]['site_alias']=$site->site_alias;
    //     $site_array[$site_key]['invoice_array']=$invoice_array;

    //     $site_array[$site_key]['sub_total_sum']=$sub_total_sum;
    //     $site_array[$site_key]['total_tax_sum']=$total_tax_sum;
    //     $site_array[$site_key]['previous_due_sum']=$previous_due_sum;
    //     $site_array[$site_key]['discount_amount_sum']=$discount_amount_sum;
    //     $site_array[$site_key]['grand_total_sum']=$grand_total_sum;
    //     $site_array[$site_key]['amount_paid_sum']=$amount_paid_sum;
    //     $site_array[$site_key]['amount_due_sum']=$amount_due_sum;
    //     $site_array[$site_key]['item_totals_array']=$item_totals_array;

    //     $site_key++;
    // }


    //     $sub_total_sum=$invoiceList->sum('sub_total');
    //     $total_tax_sum=$invoiceList->sum('total_tax');
    //     $previous_due_sum=$invoiceList->sum('previous_due');
    //     $discount_amount_sum=$invoiceList->sum('discount_amount');
    //     $grand_total_sum=$invoiceList->sum('grand_total');
    //     $amount_paid_sum=$invoiceList->sum('amount_paid');
    //     $amount_due_sum=$invoiceList->sum('amount_due');

     
    //     $grand_totals =[
    //         'item_total_array'=>array_values($item_totals),
    //         'sub_total_sum'=>$sub_total_sum,
    //         'total_tax_sum'=>$total_tax_sum,
    //         'previous_due_sum'=>$previous_due_sum,
    //         'discount_amount_sum'=>$discount_amount_sum,
    //         'grand_total_sum'=>$grand_total_sum,
    //         'amount_paid_sum'=>$amount_paid_sum,
    //         'amount_due_sum'=>$amount_due_sum,
    //     ];

    //     $months = AcademicMonthName::all();

    //     $years = range(2020, now()->year);


    //     return ['site_invoice_array'=>$site_array, 'itemsList'=>$itemsList,'grand_totals'=>$grand_totals,'months'=>$months,'years'=>$years];

    // }


    public function getRegulerSiteHeadWiseReportList(Request $request)
    {
        $site_id    = $request->site_id;
        $paginate   = $request->paginate ?? 20;
        $invoice_no = $request->invoice_no;

        // Decode the JSON string into an associative array
        $date_range_array = json_decode($request->input('date_range'), true);
        if ($date_range_array !== null) {
            $start_date = $date_range_array['start'] ?? null;
            $end_date   = $date_range_array['end'] ?? null;
        } else {
            $start_date = null;
            $end_date   = null;
        }

        if ($date_range_array) {
            if (!$start_date || !$end_date) {
                throw new Error('Please Select Both Date');
            }
        }

        if ($site_id) {
            $site_ids = [$site_id];
        } else {
            $site_ids = SiteMembership::where('service_type', 'regular')
                ->pluck('site_id')->unique()->values();
        }

        $invoiceList = $this->invoice->with(['siteInfo' => function ($q) {
            $q->select('id');
        }])
            // ->when(!empty($request->item_id), function ($query) use ($request) {
            //     $query->with(['details' => function ($q) use ($request) {
            //         $q->where('item_details_id', $request->item_id)
            //             ->when(!empty($request->month_id), function ($qq) use ($request) {
            //                 $qq->where('month_for', $request->month_id);
            //             });
            //     }]);

            //     $query->whereHas('details', function ($q) use ($request) {
            //         $q->where('item_details_id', $request->item_id)
            //             ->when(!empty($request->month_id), function ($qq) use ($request) {
            //                 $qq->where('month_for', $request->month_id);
            //             });
            //     });
            // }, function ($query) {
            //     $query->with('details');
            // })
            ->when(!empty($request->month_id), function ($query) use ($request) {
                $query->with(['details' => function ($q) use ($request) {
                    $q->where('month_for', $request->month_id);
                        // ->when(!empty($request->month_id), function ($qq) use ($request) {
                        //     $qq->where('month_for', $request->month_id);
                        // });
                }]);

                $query->whereHas('details', function ($q) use ($request) {
                    $q->where('month_for', $request->month_id);
                        // ->when(!empty($request->month_id), function ($qq) use ($request) {
                        //     $qq->where('month_for', $request->month_id);
                        // });
                });
            }, function ($query) {
                $query->with('details');
            })
            ->when($request->payment_status != 'All', function ($query) use ($request) {
                $query->where('status_code', $request->payment_status);
            })
            ->whereIn('site_id', $site_ids)
            ->when(!empty($start_date) && !empty($end_date), function ($query) use ($start_date, $end_date) {
                $query->whereBetween('invoice_date', [$start_date, $end_date]);
            })
            ->when(!empty($invoice_no), function ($query) use ($invoice_no) {
                $query->where('invoice_no', 'like', '%' . $invoice_no . '%');
            })
            ->when(!empty($request->year_name), function ($query) use ($request) {
                $query->whereYear('created_at', $request->year_name);
            })
            ->orderBy('id', 'DESC')
            ->get();

        $invoice_ids = $invoiceList->pluck('id')->unique()->values();

        $site_invoice_details_ids = SiteInvoiceDetail::whereIn('invoice_id', $invoice_ids)
            ->pluck('item_details_id')
            ->unique()
            ->values();

        $itemsList = ItemDetail::whereIn('id', $site_invoice_details_ids)->orderBy('id')->get();
        $site_info = SiteInfo::whereIn('id', $site_ids)->get();

        $site_array = [];
        $site_key   = 0;
        $item_totals = []; // overall grand totals

        foreach ($site_info as $site) {
            $siteInvoiceList = $invoiceList->where('site_id', $site->id)->values();

            $invoice_array = [];
            $site_item_totals = []; // site-wise totals

            foreach ($siteInvoiceList as $key => $invoice) {
                $item_array = [];

                foreach ($itemsList as $item) {
                    // default value
                    $item_details = [
                        'id' => $item->id,
                        'name' => $item->item_name,
                        'item_final_amount' => 0
                    ];

                    // match invoice details
                    foreach ($invoice->details as $inv_details) {
                        if ($item->id == $inv_details->item_details_id) {
                            $item_details['item_final_amount'] = $inv_details->item_final_amount;
                            break;
                        }
                    }

                    $item_array[] = $item_details;

                    // ======================
                    // overall totals
                    // ======================
                    if (!isset($item_totals[$item->id])) {
                        $item_totals[$item->id] = [
                            'id' => $item->id,
                            'name' => $item->item_name,
                            'grand_total' => 0
                        ];
                    }
                    $item_totals[$item->id]['grand_total'] += $item_details['item_final_amount'];

                    // ======================
                    // site-wise totals
                    // ======================
                    if (!isset($site_item_totals[$item->id])) {
                        $site_item_totals[$item->id] = [
                            'id' => $item->id,
                            'name' => $item->item_name,
                            'grand_total' => 0
                        ];
                    }
                    $site_item_totals[$item->id]['grand_total'] += $item_details['item_final_amount'];
                }

                $invoice_array[$key] = array_merge(
                    $invoice->toArray(),
                    ['details' => $item_array]
                );
            }

            if (count($invoice_array) == 0) {
                continue;
            }

            $item_totals_array = array_values($site_item_totals);

            // site wise sums
            $sub_total_sum     = $siteInvoiceList->sum('sub_total');
            $total_tax_sum     = $siteInvoiceList->sum('total_tax');
            $previous_due_sum  = $siteInvoiceList->sum('previous_due');
            $discount_amount_sum = $siteInvoiceList->sum('discount_amount');
            $grand_total_sum   = $siteInvoiceList->sum('grand_total');
            $amount_paid_sum   = $siteInvoiceList->sum('amount_paid');
            $amount_due_sum    = $siteInvoiceList->sum('amount_due');

            $site_array[$site_key] = [
                'site_id' => $site->id,
                'site_name' => $site->site_name,
                'short_name' => $site->short_name,
                'site_alias' => $site->site_alias,
                'invoice_array' => $invoice_array,

                'sub_total_sum' => $sub_total_sum,
                'total_tax_sum' => $total_tax_sum,
                'previous_due_sum' => $previous_due_sum,
                'discount_amount_sum' => $discount_amount_sum,
                'grand_total_sum' => $grand_total_sum,
                'amount_paid_sum' => $amount_paid_sum,
                'amount_due_sum' => $amount_due_sum,
                'item_totals_array' => $item_totals_array,
            ];

            $site_key++;
        }

        // overall sums
        $sub_total_sum     = $invoiceList->sum('sub_total');
        $total_tax_sum     = $invoiceList->sum('total_tax');
        $previous_due_sum  = $invoiceList->sum('previous_due');
        $discount_amount_sum = $invoiceList->sum('discount_amount');
        $grand_total_sum   = $invoiceList->sum('grand_total');
        $amount_paid_sum   = $invoiceList->sum('amount_paid');
        $amount_due_sum    = $invoiceList->sum('amount_due');

        $grand_totals = [
            'item_total_array' => array_values($item_totals),
            'sub_total_sum' => $sub_total_sum,
            'total_tax_sum' => $total_tax_sum,
            'previous_due_sum' => $previous_due_sum,
            'discount_amount_sum' => $discount_amount_sum,
            'grand_total_sum' => $grand_total_sum,
            'amount_paid_sum' => $amount_paid_sum,
            'amount_due_sum' => $amount_due_sum,
        ];

        $months = AcademicMonthName::all();
        $years = range(2020, now()->year);

        return [
            'site_invoice_array' => $site_array,
            'itemsList' => $itemsList,
            'grand_totals' => $grand_totals,
            'months' => $months,
            'years' => $years
        ];
    }



    public function getRegulerSiteHeadWiseReportListPdf(Request $request){
        try {

            $result=$this->getRegulerSiteHeadWiseReportList($request);

            $invoiceList=$result['invoiceList'];
            $itemsList=$result['itemsList'];
            $grand_totals=$result['grand_totals'];

            $report_tittle='astete';
            $title_view ='title_view ';
            // return view('default.admin.edu.site-payment.payment-report', compact('report_tittle', 'the_invoice'));
            $pdf = PDF::loadView('default.admin.edu.site.reguler-site-invoice-list-pdf', compact('report_tittle','title_view','invoiceList', 'itemsList','grand_totals'));//->setPaper('a4', 'landscape');
            $path = storage_path() . '/pdf';
            $time = Auth::user()->id . '-' . Carbon::now()->unix();
            $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');

            $name = $time . '.pdf';

            return response()->json([
                'link' => route('open-report-pdf', [$name]),
                'message' => 'Successfully Created Card Report'
            ], 200);

        } catch (Exception $exception) {
            return $exception->getMessage();
        }
    //}
    }

       public function openReportPdf($name)
        {
            try {
                if (!file_exists(storage_path('pdf/' . $name))) {
                    return "The file existed only for 1 day and deleted today!";
                }
                return response()->file(storage_path('pdf/' . $name));

            } catch (Exception $exception) {
                return Response::json(['message' => $exception->getMessage()], 410);
            }
        }

    public function regulerSiteList(Request $request){
        $siteMembership=SiteMembership::where('service_type','regular')->get();
        $site_ids=$siteMembership->pluck('site_id')->unique()->values();
        $siteInfo=SiteInfo::whereIn('id',$site_ids)->select('id')->get();
      
        $site_array = [];
            foreach ($siteInfo as $key => $site) {
                $invoice=SiteInvoice::
                //when(!empty($request->item_id), function ($query) use ($request) {
                    // with(['details' => function ($q) use ($request) {
                    //   //  $q->where('item_details_id', $request->item_id)
                    //     $q->when(!empty($request->month_id), function ($qq) use ($request) {
                    //         $qq->where('month_for', $request->month_id);
                    //     });
                    // }])

                    // ->whereHas('details', function ($q) use ($request) {
                    //     $q->where('item_details_id', $request->item_id)
                    //     ->when(!empty($request->month_id), function ($qq) use ($request) {
                    //         $qq->where('month_for', $request->month_id);
                    //     });
                    // })
              //  })
                when(!empty($request->year_name), function ($query) use ($request) {
                    $query->whereYear('created_at', $request->year_name);
                })
               
                ->orderBy('id', 'DESC')
                ->where('site_id', $site->id)
                ->pluck('id');

                $singleSiteMembership=SiteMembership::where('site_id',$site->id)->first();


                $item_details=SiteInvoiceDetail::whereIn('invoice_id',$invoice)->where('month_for',$request->month_id)->get();

                // যেসব item_details_id অবশ্যই দরকার
                $default_item_2 = [
                        'id' => null,
                        'invoice_id' => null,
                        'item_details_id' => 2,
                        'item_final_amount' => $singleSiteMembership->payment_amount,
                        'item_price' => $singleSiteMembership->payment_amount,
                        'item_quantity' => "1",
                        'month_for' => $request->month_id,
                        'tax_percentage' => "0",
                        'total_tax' => "0.00",
                        'created_at' => now(),
                        'updated_at' => now(),
                    ];

                $active_device_count = DeviceDetail::where('site_id', $site->id)->where('status', 1)->count();
                $default_item_18 = [
                        'id' => null,
                        'invoice_id' => null,
                        'item_details_id' => 18,
                        'item_final_amount' => $singleSiteMembership->per_device_bill*$active_device_count,
                        'item_price' => $singleSiteMembership->per_device_bill,
                        'item_quantity' => $active_device_count,
                        'month_for' => $request->month_id,
                        'tax_percentage' => "0",
                        'total_tax' => "0.00",
                        'created_at' => now(),
                        'updated_at' => now(),
                    ];

                // চেক করি item 2 আছে কিনা
                if (!$item_details->contains('item_details_id', 2)) {
                    $item_details->push($default_item_2);
                }

                // চেক করি item 18 আছে কিনা
                if (!$item_details->contains('item_details_id', 18)) {
                    $item_details->push($default_item_18);
                }
                
                $sub_total_sum=$item_details->where('invoice_id',null)->sum('item_final_amount');
                $today = Carbon::now()->format('d-m-Y');
                
                $site_array[$key] = [
                    'site_id'         => $site->id,
                    'site_name'  => $site->site_name,
                    'items'  => $item_details,//// test
                   // 'invoice'  => $invoice,//// test
                    'short_name' => $site->short_name,
                    'address'    => $site->address,
                    'sub_total'    => $sub_total_sum,
                    'tax_percentage'    => '0',
                    'total_tax'    => '0',
                    'previous_due'    => '0',
                    'tex_amount'    => '0',
                    'discount_amount'    => '0',
                    'grand_total'    => $sub_total_sum,
                    'due_date'    => $today,
                    // 'items'      => [
                    //     // [
                    //     //     'id'     => '',
                    //     //     'item_quantity' => '',
                    //     //     'amount' => '',
                    //     // ]
                    // ]
                ];
            }

        $months = AcademicMonthName::all();

        $years = range(2020, now()->year);

        return ['site_array'=>$site_array, 'months'=>$months,'years'=>$years];

     //   return $site_array;

    }

    public function createRegulerSiteInvoiceCreate(Request $request){

        $today = Carbon::now()->format('Y-m-d');
        $siteInvoice=null;
        foreach($request->siteList as $site_item){

            if($site_item['sub_total']==0){
                continue;
            }

            $check_items=collect($site_item['items'])->where('invoice_id',null);

            if(count($check_items)){
               

            $invoice_number = $this->invoiceNumberGeneration();

            $check_invoice = $this->invoice
                ->where("invoice_no", $invoice_number)
                ->where('site_id',$site_item['site_id'])
                ->first();

            if ($check_invoice) {
                $invoice_number = $this->invoiceNumberGeneration();
            }

            $invoice=new SiteInvoice();

         //   $invoice->due_date


        //   if (isset($this->invoice->ownFields)) {
                // foreach ($invoice->ownFields as $ownField) {
                //     if ($request->{$ownField}) {
                //         $invoice->{$ownField} = $request->{$ownField};
                //     }
                // }
                
                $invoice->site_id = $site_item['site_id'];
                $invoice->sub_total = $site_item['sub_total'];
                $invoice->total_after_tax = $site_item['sub_total'];
                $invoice->grand_total = $site_item['grand_total'];
                $invoice->invoice_date = $today;
                $invoice->due_date = $site_item['due_date'];
                $invoice->invoice_no = $invoice_number;
                $invoice->status_code = 'approved';
                $invoice->created_by = Auth::user()->id;
                $invoice->save();

              
                $siteInvoice=SiteInvoice::where('site_id',$site_item['site_id'])->where('id',$invoice->id)->first();

                foreach ($check_items as $k => $item) {

                   // dd($item);

                    $invoiceDetail = new SiteInvoiceDetail();

                    if (count($invoiceDetail->ownFields) > 0) {
                        foreach ($invoiceDetail->ownFields as $ownField) {
                            if ($item[$ownField]) {
                                $invoiceDetail->{$ownField} = $item[$ownField];
                            }
                        }
                    }
                    $invoiceDetail->invoice_id = $siteInvoice->id;
                    $invoiceDetail->item_details_id = $item['item_details_id'];
                    $invoiceDetail->save();
                }
         //   }

            $this->createHistory($invoice->id, 'draft', 'New Invoice:' . $invoice->invoice_no . ' created Successfully');

            }

            //check previous due_id
            // if ($previous_due_id) {
            //     $pre_invoice = $this->invoice
            //         ->where("id", $previous_due_id)
            //         ->first();

            //     $pre_invoice->carried_invoice_id = $this->invoice->id;
            //     $pre_invoice->status_code = 'carried';
            //     $pre_invoice->save();

            //     $this->createHistory($pre_invoice->id, 'carried', 'The Invoice:' . $pre_invoice->invoice_no . ' Carried to ' . $this->invoice->invoice_no . ' Successfully');
            // }
            }

          //  DB::commit();
            return response()->json(['message' => $this->invoice->invoice_no . ' Successfully Created!'], 200, []);
        dd($request->all());
    }



    public function getInvoiceListBySite(Request $request)
    {

        $invoice_no = $request->invoice_no;
        $paginate = $request->paginate ?? 20;

        if(isset($request->date_range) && is_array($request->date_range)) {
            $start_date = isset($request->date_range['start']) ? $request->date_range['start'] : null;
            $end_date = isset($request->date_range['end']) ? $request->date_range['end'] : null;
        } else {
            // Handle the case where $request->date_range is null or not an array
            $start_date = null;
            $end_date = null;
        }

        if ($request->date_range) {
            if (!$start_date || !$end_date) {
                throw new Error('Please Select Both Date');
            }
        }

        $list = $this->invoice
            ->when(isset($start_date) && isset($end_date), function ($query) use ($start_date, $end_date) {
                return $query->whereBetween('invoice_date', [$start_date, $end_date]);
            })->when($invoice_no, function ($query) use ($invoice_no) {
                return $query->where('invoice_no', 'like', '%' . $invoice_no . '%');
            })
            ->where('site_id', Session::get('SITE_ID'))
            ->orderBy('id', 'DESC')
            ->paginate($paginate);


        return response()->json([$list], 200);

    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function getDataForNewInvoiceBySite($type, $site_id)
    {
        try {


            $the_site = $this->siteInfo->where('id', $site_id)->first();
            $site_membership = $the_site->siteMembership;


            if (!$site_membership) {
                throw new Error('No Site MemberShip Found For The Site!');
            }
            $last_invoice = null;
            if ($type == 1) {//with due
                $last_invoice = $this->invoice
                    ->where('site_id', $site_id)
                    ->whereIn('status_code', ['partial', 'approved'])
                    ->orderBy('id', 'DESC')
                    ->first();
            }


            $months = AcademicMonthName::all();

            //dd($last_invoice);


            $data = [];
            //$data['invoice_no'] = $invoice_no;
            $data['previous_due'] = $last_invoice->amount_due ?? 0;
            $data['previous_due_id'] = $last_invoice->id ?? 0;
            $data['site_membership'] = $site_membership;
            $data['months'] = $months;

            return response()->json($data, 200, []);
        } catch (Exception $exception) {
            return response()->json($exception->getMessage(), 411, []);

        }


    }

    public function getInvoiceDetailsForPayment($id)
    {
        $list = $this->invoice
            ->with(['details.item', 'details.month', 'siteInfo'])
            ->where('id', $id)
            ->first();
        return response()->json($list, 200);

    }


    public function getInvoiceHistories($id)
    {
        try {
            $list = $this->invoice
                ->with(['histories', 'siteInfo'])
                ->where('id', $id)
                ->first();
            return response()->json($list, 200, []);
        } catch (Exception $exception) {
            return response()->json($exception->getMessage(), 411, []);

        }

    }

    private function invoiceNumberGeneration($invoice_number = null)
    {

        $new_invoice = null;
        $initial_part = 'EINV-';
        $part_length = strlen($initial_part);


        if ($invoice_number) {

            $current_number = (int)substr($invoice_number, $part_length);
            $next_number = $current_number + 1;
            $new_invoice = $initial_part . sprintf("%06d", $next_number);

            // dd($invoice_number);

        } else {

            $invoice_existed = $this->invoice
                ->whereRaw("invoice_no REGEXP '^{$initial_part}([0-9]*)?$'")
                ->orderBy('id', 'DESC')
                ->first();

            //dd($invoice_existed);

            if ($invoice_existed) {
                $current_number = (int)substr($invoice_existed->invoice_no, $part_length);
                $next_number = $current_number + 1;
                $new_invoice = $initial_part . sprintf("%06d", $next_number);

            } else {
                $new_invoice = $initial_part . sprintf("%06d", 1);
            }
        }

        $check_invoice = $this->invoice
            ->where("invoice_no", $new_invoice)
            ->first();

        if ($check_invoice) {
            $invoice_no = ($check_invoice->invoice_no) ?? ($initial_part . sprintf("%06d", 1));
            return $this->invoiceNumberGeneration($invoice_no);

        } else {
            return $new_invoice;
        }


    }


    /**
     * @param $id
     */
    public function getInvoicePdfReport($id)
    {
        try {


            if (Session::get('USER_TYPE') == 'eduworld') {

                $the_invoice = $this->invoice
                    ->findOrFail($id);

            } else {


                $the_invoice = $this->invoice
                    ->where('id', $id)
                    ->where('site_id', Session::get('SITE_ID'))
                    ->first();

            }


//        dd($the_invoice->payments->last()->payment_date ??  '');
            $report_tittle = 'Invoice Report-' . $the_invoice->invoice_no;


            // return view('default.admin.edu.site-payment.payment-report', compact('report_tittle', 'the_invoice'));
            $pdf = PDF::loadView('default.admin.edu.site-payment.payment-report', compact('report_tittle', 'the_invoice'));
            return $pdf->stream(time() . '-invoice-no-' . $id . '.pdf');
        } catch (Exception $exception) {
            return $exception->getMessage();
        }
    }
}
