<?php

namespace App\Http\Controllers\Form;

use App\Forms\FormControll;
use App\Forms\MetaDataForm;
use App\Http\Controllers\ProjectController;
use App\Models\Meta\MetaSetting;
use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Forms\DataHelper;
use App\Http\Controllers\Language\Lang;
use App\Http\Requests\Validator;
use App\Models\User\User;


class FormSettingController extends ProjectController
{

    use FormControll, DataHelper;

    private $metaSetting;

    public function __construct(MetaSetting $metaSetting)
    {

        $this->middleware('auth');
        $this->metaSetting = $metaSetting;

    }

    public function index()
    {

        $viewType = 'Form SiteSetting List';
        $allSettings = $this->metaSetting->paginate(5);

        return view('default.admin.form.index',compact('allSettings','viewType'));

    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function createSettingsForm()
    {
        $viewType = 'Form SiteSetting Options';
        return view('default.admin.form.create-setting',compact('viewType'));
    }

    /**
     * @param MetaSetting $metaSetting
     * @param Request $request
     * @return mixed
     */
    public function createSettings(Requests\Validator $request)
    {

        //dd($this->metaSetting->ownFields);

        if(isset($this->metaSetting->ownFields)) {
            foreach($this->metaSetting->ownFields as $ownField){
                if($request->{$ownField})
                    $this->metaSetting->{$ownField} = $request->{$ownField} ;
            }
        }



        //$metaSetting->save();
        //dd($this->metaSetting);

        return  $this->metaSetting->save()?back()->withSuccess('Successfully Created'):null;
        //return back()->withSuccess('successfully created');
    }

    /**
     * @param $id
     * @param MetaSetting $metaSetting
     * @param MetaDataForm $metaDataForm
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function editSettingForm($id,MetaSetting $metaSetting,MetaDataForm $metaDataForm)
    {
        $viewType = 'Edit Settings';
        $editSettingForm = $metaDataForm;
        $settingsToEdit =$this->editFormModel($metaSetting->findOrFail($id)) ;
        return view('default.admin.form.edit-setting',compact('settingsToEdit','viewType','editSettingForm'));

    }

    /**
     * @param $id
     * @param MetaSetting $metaSetting
     * @param Request $request
     * @return mixed
     */
    public function editSettings($id, Requests\Validator $request)
    {

        $settingToEdit = $this->metaSetting->findOrFail($id);

        if(isset($settingToEdit->ownFields)){
            foreach($settingToEdit->ownFields as $ownField){
                if($request->{$ownField})
                    $settingToEdit->{$ownField} = $request->{$ownField} ;
            }
        }

        $settingToEdit->save();

        return back()->withSuccess('Successfully Updated');
    }

    /**
     * @param $id
     * @param MetaSetting $metaSetting
     * @return $this|\Illuminate\Http\RedirectResponse
     */
    public function deleteSettigs($id,MetaSetting $metaSetting)
    {
        $settingToDelete = $metaSetting->findOrFail($id);

        if($settingToDelete->delete()){

            return back();
        }
        return back()->withErrors('Not successfully deleted');
    }


}
