<?php

namespace App\Http\Controllers\Module;

use App\Models\Modules\Module;
use App\Models\Modules\SubModule;
use Exception;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Response;

class ModuleController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');

    }

    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|max:200|unique:modules',
            'module_for' => 'required'
        ]);

        Module::create([
            'name' => $request->name,
            'module_for' => $request->module_for,
        ]);

        return Response::json(['message' => 'New Module Successfully Added!']);

    }


    public function update(Request $request, $id)
    {

        $this->validate($request, [
            'name' => 'required|max:200',
            'module_for' => 'required'

        ]);

        $theModule = Module::findOrFail($id);
        $theModule->update([
            'name' => $request->name,
            'module_for' => $request->module_for,

        ]);

        return Response::json(['message' => 'Module Successfully Updated!']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return JsonResponse
     */
    public function destroy($id)
    {
        //first check module in site group
        $subModuleExist = SubModule::whereModuleId($id)->first();

        if ($subModuleExist) {
            return Response::json(['message' => 'Module Has Sub Module!'], 301);

        }

        $theModule = Module::findOrFail($id);
        $theModule->delete();
        return Response::json(['message' => 'Module Successfully Deleted!']);
    }


    public function attachment()
    {
        $viewType = 'Sub Module Attached List';
        return view('default.admin.module.attached-list', compact('viewType'));
    }


    public function getModuleList()
    {
        return Module::latest()->paginate(500);
    }

    public function getModuleListWithSubModule()
    {
        return Module::with('subModule')
            ->orderBy('id', 'DESC')
            ->get();
    }


    public function saveSubModuleIds(Request $req)
    {

        $sub_module_ids = $req->sub_module_ids;
        $module_id = $req->module_id;

        $sub_module_ids_exploded = implode($sub_module_ids, ',');
        $total = count($sub_module_ids);

        Module::where('id', $module_id)->update([
            'sub_module_ids' => $sub_module_ids_exploded
        ]);

        return Response::json(['message' => $total . ' Sub Module Attached Done Successfully!']);

    }


}
