<?php

namespace App\Http\Controllers\Religion;

use App\Forms\DataHelper;
use App\Forms\FormControll;
use App\Http\Controllers\Language\Lang;
use App\Http\Controllers\ProjectController;
use App\Models\Religion\Religion;
use App\Models\Site\SiteInfo;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Session;

class ReligionController extends ProjectController
{
    use  Lang, FormControll, DataHelper;

    private $religion;

    public function __construct(Religion $religion)
    {

        $this->middleware('auth');

        $this->religion = $religion;
    }


    public function index()
    {
        $model = $this->religion->orderBy('id', 'DESC')->paginate(10);
        //dd($model);
        $viewType = 'Relgion List';

        return view('default.admin.religion.index', compact('viewType', 'model'));
    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function createReligionForm()
    {
        $viewType = 'Create Religion';
        return view('default.admin.religion.create', compact('viewType'));

    }

    /**
     * @param Religion $religion
     */
    public function createReligion(Religion $religion, Requests\Validator $validatedRequest)
    {
        // dd($validatedRequest->get('status'));
        $religion->status = $validatedRequest->get('status');


        $this->translatedAttrToSave($religion, $validatedRequest);

        return redirect()->route('religion-list')->withSuccess('Successfully Created');
    }


    private function translatedAttrToSave(Religion $religion, Requests\Validator $validatedRequest)
    {
        foreach ($religion->translatedAttributes as $field) {
            foreach ($this->locales() as $locale => $value) {
                //dd($validatedRequest->get($field . '_' . $locale));

                if ($validatedRequest->get($field . '_' . $locale)) {

                    \Log::info($field . '_' . $locale);
                    $religion->translateOrNew($locale)->{$field} = $validatedRequest->get($field . '_' . $locale);
                }
            }
        }
        //dd($user->first_name);

        if ($religion->save()) {

            return true;
        }
        return false;
    }


    public function editReligionForm($id)
    {
        $viewType = 'Edit Religion';

        $religionToEdit = $this->editFormModel($this->religion->findOrFail($id));

        return view('default.admin.religion.edit', compact('religionToEdit', 'viewType'));

    }

    public function editReligion($id, Religion $religion, Requests\Validator $validatedRequest)
    {
        $religionToEdit = $this->religion->findOrFail($id);

        $isEdited = $religionToEdit->status = $validatedRequest->get('status');

        $this->translatedAttrToSave($religionToEdit, $validatedRequest);

        return $isEdited ? redirect()->route('religion-list')->withSuccess('Successfully Updated') : null;
    }

    /**
     * @param $id
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function viewReligion($id)
    {
        $religionToView = $this->religion->findOrFail($id);
        //dd($religionToView);
        return view('default.admin.religion.view', compact('religionToView'));

    }

    public function getReligionList()
    {


        if(Session::get(SITE_ID)){
            $sitereligionlist=SiteInfo::select('religion_ids')->where('id', Session::get(SITE_ID))->first();

            $religionlistsplite = explode(',', $sitereligionlist->religion_ids);
            $religionlist = Religion::whereIn('id', $religionlistsplite)->get();

            return $religionlist;
        }
        else{
            $religionlist = Religion::get();
        }

        return $religionlist;

    }



    public function deleteReligion($id)
    {
        $religionToDelete = $this->religion->findOrFail($id);

        if ($religionToDelete->delete()) {

            return back();
        }
        return back()->withErrors('Not successfully deleted');
    }
}
