<?php

/**
 * Created by PhpStorm.
 * User: Abdul Aziz
 * Date: 5/3/2016
 * Time: 10:42 AM
 */
namespace App\Http\Controllers\Room;

use App\Forms\RoomForm;
use App\Http\Controllers\Controller;
use App\Forms\DataHelper;
use App\Forms\FormControll;
use App\Http\Controllers\Language\Lang;
use App\Http\Controllers\ProjectController;
use App\Http\Requests\Validator;
use App\Http\Requests;
use App\Models\Building\Building;
use App\Models\Floor\Floor;
use App\Models\Room\Room;
use Illuminate\Http\Request;
use Response;

class RoomController extends ProjectController
{
    use Lang, FormControll, DataHelper;

    private $room;

    /**
     * @param Room $room
     */
    public function __construct(Room $room)
    {

        $this->middleware('auth');

        $this->room = $room;
    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
//    public function createRoomForm()
//    {
//        $viewType = 'Create Room';
//
//        return view('default.admin.room.create',compact('viewType'));
//    }

    public function index(){

        $viewType = 'Room';
        return view('default.admin.layouts.master', compact('viewType', 'building_floor_room_list'));

//        return compact('building_floor_room_list');

    }

    public function getRoomList(Request $request){

        $data = $request->all();

        $building_floor_room=Building::with(['floors'=>function($q) use ($data){
            $q->with(['rooms']);
            $q->when(!empty($data['floor_id']), function ($query) use ($data) {
                return $query->where('id', $data['floor_id']);
            });
        }])
            ->when(!empty($data['building_id']), function ($query) use ($data) {
                return $query->where('id', $data['building_id']);
            })
            ->get();


        $building_arr=Array();
        $building_floor_room_list=[];
        foreach ($building_floor_room as $key => $value) {


            $room_count_array=[];
            foreach ($value->floors as $keys => $values) {
                $room_count_array[]=count($values->rooms);
            }

            $building_arr['row_span']=array_sum($room_count_array) + count($value->floors);
            $building_arr['floor_count']=count($value->floors);

            $building_floor_room_list[$key]=array_merge($value->toArray(), $building_arr);
        }
       return $building_floor_room_list;

//        return compact('building_floor_room_list');

    }

    /**
     * @param Validator $validatedRequest
     * @return mixed
     */
    public function createRoom(Request $request)
    {
        $check_data=$this->room
            ->where('building_id', $request->building_id)
            ->where('floor_id', $request->floor_id)
            ->where('room_name', $request->room_name)
            ->first();

        if($check_data){
            if($check_data->status==0){
                $check_data->status=1;
                $check_data->save();
            }
            else if($check_data->status==1){
                return Response::json(['message' => 'This Room Name already present!.',
                    'mode' => 'Error!'], 200);
            }
        }
        else{
            $this->room->create([
                'building_id'=>$request->building_id,
                'floor_id'=>$request->floor_id,
                'room_name'=>$request->room_name,
                'status'=>1,
            ]);

            return Response::json(['message' => 'Save Successfully!', 'mode' => 'save!'], 200);
        }
    }


    /**
     * @param $id
     * @param Validator $validatedRequest
     * @return null
     */
    public function editRoom(Request $request)
    {
        $check_same_name=$this->room->where('building_id', $request->building_id)
            ->where('floor_id', $request->floor_id)
            ->where('room_name', $request->room_name)
            ->where('id', '!=', $request->id)
            ->first();

        if($check_same_name){
            return Response::json(['message' => 'This Floor Name already present!.',
                'mode' => 'Error!'], 200);
        }
        else{
            $this->room->where('id', $request->id)
                ->update([
                    'room_name'=>$request->room_name,
                    'status'=>1,
                ]);
        }
        return Response::json(['message' => 'Update Successfully!', 'mode' => 'save!'], 200);
    }

    /**
     * @param $id
     * @return $this
     */
    public function deleteRoom(Request $request)
    {
        $this->room->where('id', $request->id)->delete();

        return Response::json(['message' => 'Delete Successfully!', 'mode' => 'save!'], 200);
    }


    public function roomOfFloor($floorId, Floor $floor, Request $request)
    {
        $selectedFloor = $floor->findOrFail($floorId);
        //dd($selectedFloor);
        $roomForFloor = $selectedFloor->rooms;
        //dd($roomForFloor);
        if( $request->ajax()){
            return response()->json( [$roomForFloor]);
        }
    }

    public function getRoomListWithBuildingAndFloorAppended(){

        $rooms=$this->room->all();

        $final_array=array();
        foreach ($rooms as $k=>$room){

            $final_array[$room->id]['id']=$room->id;
            $final_array[$room->id]['room_name']=($room->building->building_name ?? '') .'->'.($room->floor->floor_name ?? '') .'('.$room->room_name.')';

        }
        return $rooms;

    }
}