<?php

namespace App\Http\Controllers\Site\Accounts\AccountsTransaction;

use App\Http\Controllers\ProjectController;
use App\Models\Academic\AcademicMonthName;
use App\Models\Edu\Accounts\AccountsHead;
use App\Models\Site\Accounts\Accounts;
use App\Models\Site\Accounts\AccountsGroup;
use App\Models\Site\Accounts\AccountsSubGroup;
use App\Models\Site\Accounts\AccountsVoucherDetails;
use App\Models\Site\Accounts\BankAccountDetails;
use App\Models\Site\Accounts\ChequeRegister;
use App\Models\Site\Accounts\Ledger;
use App\Models\Site\Accounts\Party;
use App\Models\Site\Accounts\SiteAccounts;
use App\Models\Site\Accounts\SiteAccountsBankAccountTransferCostRecord;
use App\Models\Site\Accounts\SiteAccountsEmployeeSalary;
use App\Models\Site\Accounts\SiteAccountsFixedAsset;
use App\Models\Site\Accounts\SiteAccountsVoucherChequeRegisterRecords;
use App\Models\Site\Accounts\SiteAccountsVoucherDetailsBankAccountDepositRecord;
use App\Models\Site\Accounts\SiteAccountsVoucherDetailsStudentPaymentHistoryRecord;
use App\Models\Site\Fee\Fine\SiteStudentFeeFine;
use App\Models\Site\Fee\SiteStudentFeeDemandSlipDetails;
use App\Models\Site\Fee\SiteStudentFeePaymentHistory;
use App\Models\User\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Carbon\Carbon;
use Error;
use PDF;
use Auth;
use Response;
use Storage;
use Session;

class AccountsTransactionController extends ProjectController
{

    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function creditVoucherindex()
    {
        $viewType = "Accounts Transaction";
        return view('default.admin.layouts.master', compact('viewType'));
    }
    public function debitVoucherindex()
    {
        $viewType = "Accounts Transaction";
        return view('default.admin.layouts.master', compact('viewType'));
    }
    public function contraVoucherindex()
    {
        $viewType = "Accounts Transaction";
        return view('default.admin.layouts.master', compact('viewType'));
    }
    public function journalVoucherindex()
    {
        $viewType = "Accounts Transaction";
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function getCreditVoucherListWithPagination(Request $request)
    {
        //        return $request;
        $date_start = $request->from_date ? $request->from_date : null;
        $date_end = $request->to_date ? $request->to_date : null;
        $paginate = $request->paginate;
        $search_txt = $request->search_txt;
        $transaction_for = $request->transaction_for;
        $txt = '%' . $search_txt . '%';

        $voucher_data_list = AccountsVoucherDetails::where('voucher_type', 'creditvoucher')
            ->with(['accounts' => function ($query) {
                $query->with('ledger');
                $query->with(['siteAccountsVoucherDetailsBankAccountDepositRecord' => function ($q) {
                    $q->with('BankAccountDetails');
                }]);
            }, 'user'])
            ->when($date_start, function ($qq) use ($date_start) {
                return $qq->whereDate('transaction_date', '>=', $date_start);
            })
            ->when($date_end, function ($qqq) use ($date_end) {
                return $qqq->whereDate('transaction_date', '<=', $date_end);
            })
            ->when($transaction_for, function ($qqr) use ($transaction_for) {
                return $qqr->where('transaction_for', $transaction_for);
            })
            ->when($search_txt, function ($qqqq) use ($txt) {
                return $qqqq->where('voucher_no', 'LIKE', $txt);
            })
            ->orderBy('id', 'DESC')->paginate($paginate);
        return $voucher_data_list;
    }

    public function getJournalVoucherListWithPagination(Request $request)
    {
        //        return $request;
        $date_start = $request->from_date ? $request->from_date : null;
        $date_end = $request->to_date ? $request->to_date : null;
        $paginate = $request->paginate;
        $search_txt = $request->search_txt;
        $transaction_for = $request->transaction_for;
        $txt = '%' . $search_txt . '%';

        $voucher_data_list = AccountsVoucherDetails::where('voucher_type', 'journalvoucher')
            ->with(['accounts' => function ($query) {
                $query->with('ledger');
            }, 'user'])
            ->when($date_start, function ($qq) use ($date_start) {
                return $qq->whereDate('transaction_date', '>=', $date_start);
            })
            ->when($date_end, function ($qqq) use ($date_end) {
                return $qqq->whereDate('transaction_date', '<=', $date_end);
            })
            ->when($transaction_for, function ($qqr) use ($transaction_for) {
                return $qqr->where('transaction_for', $transaction_for);
            })
            ->when($search_txt, function ($qqqq) use ($txt) {
                return $qqqq->where('voucher_no', 'LIKE', $txt);
            })
            ->orderBy('id', 'DESC')->paginate($paginate);
        return $voucher_data_list;
    }

    public function getDebitVoucherListWithPagination(Request $request)
    {
        //        return $request;
        $date_start = $request->from_date ? $request->from_date : null;
        $date_end = $request->to_date ? $request->to_date : null;
        $paginate = $request->paginate;
        $transaction_for = $request->transaction_for;
        $search_txt = $request->search_txt;
        $txt = '%' . $search_txt . '%';

        $voucher_data_list = AccountsVoucherDetails::where('voucher_type', 'debitvoucher')
            ->with(['accounts' => function ($query) {
                $query->with('ledger');
                $query->with(['siteAccountsVoucherDetailsBankAccountDepositRecord' => function ($q) {
                    $q->with('BankAccountDetails');
                }]);
            }, 'user', 'siteAccountsEmployeeSalary' => function ($q) {
                $q->with(['user', 'academicMonthName']);
            }])
            ->when($transaction_for, function ($qqr) use ($transaction_for) {
                return $qqr->where('transaction_for', $transaction_for);
            })
            ->when($date_start, function ($qq) use ($date_start) {
                return $qq->whereDate('transaction_date', '>=', $date_start);
            })
            ->when($date_end, function ($qqq) use ($date_end) {
                return $qqq->whereDate('transaction_date', '<=', $date_end);
            })
            ->when($search_txt, function ($qqqq) use ($txt) {
                return $qqqq->where('voucher_no', 'LIKE', $txt);
            })
            ->orderBy('id', 'DESC')->paginate($paginate);

        return $voucher_data_list;
    }

    public function getContraVoucherListWithPagination(Request $request)
    {
        //        $date_range = $request->date_range;
        $date_start = $request->from_date ? $request->from_date : null;
        $date_end = $request->to_date ? $request->to_date : null;
        $paginate = $request->paginate;
        $search_txt = $request->search_txt;
        $txt = '%' . $search_txt . '%';

        $voucher_data_list = AccountsVoucherDetails::where('voucher_type', 'contravoucher')
            ->with(['accounts' => function ($query) {
                $query->with(['ledger' => function ($q) {
                    $q->with('bankAccountDetails');
                }, 'siteAccountsVoucherDetailsBankAccountDepositRecord' => function ($qq) {
                    $qq->with('BankAccountDetails');
                }]);
            }, 'user'])
            ->when($date_start, function ($qq) use ($date_start) {
                return $qq->whereDate('transaction_date', '>=', $date_start);
            })
            ->when($date_end, function ($qqq) use ($date_end) {
                return $qqq->whereDate('transaction_date', '<=', $date_end);
            })
            ->when($search_txt, function ($qqqq) use ($txt) {
                return $qqqq->where('voucher_no', 'LIKE', $txt);
            })
            ->orderBy('id', 'DESC')->paginate($paginate);
        return $voucher_data_list;
    }

    public function getAccountsLedgerList()
    {
        $ledger_list = Ledger::with(['bankAccountDetails' => function ($q) {
            $q->with(['chequeRegisterForLedgerAccounts' => function ($qr) {
                $qr->where('cheque_status', 'active');
            }]);
        }])->where('status', 1)->where('site_accounts_bank_id', null)->where('count_as_cash_status', 0)->get();
        $final_data_list = [];
        if (count($ledger_list)) {
            foreach ($ledger_list as $k => $v) {
                $final_data_list[$k]['id'] = $v->id;
                $final_data_list[$k]['data'] = $v;
                $final_data_list[$k]['name'] = $v->ledger_code . '-' . $v->name;
                $ledger_balance = 0;
                $accounts_details = Accounts::where('site_accounts_ledger_id', $v->id)->get();
                if (count($accounts_details)) {
                    $debit_amount_list = $accounts_details->pluck('debit_amount');
                    //                    return $debit_amount_list;
                    $debit_total_amount = 0;
                    if ($debit_amount_list) {
                        foreach ($debit_amount_list as $kk => $vv) {
                            $debit_total_amount += $vv;
                        }
                    }

                    $credit_amount_list = $accounts_details->pluck('credit_amount');
                    $credit_total_amount = 0;
                    if ($credit_amount_list) {
                        foreach ($credit_amount_list as $kkk => $vvv) {
                            $credit_total_amount += $vvv;
                        }
                    }
                    $ledger_balance = $debit_total_amount - $credit_total_amount;
                }
                $initial_amount = $v->initial_amount ? $v->initial_amount : 0;
                $final_ledger_balance = $ledger_balance + $initial_amount;
                $final_data_list[$k]['balance'] = $final_ledger_balance;
            }
        }

        return $final_data_list;
    }

    public function getAccountsLedgerListForReport()
    {
        $ledger_list = Ledger::with(['bankAccountDetails' => function ($q) {
            $q->with(['chequeRegisterForLedgerAccounts' => function ($qr) {
                $qr->where('cheque_status', 'active');
            }]);
        }])->where('status', 1)->get();
        $final_data_list = [];
        if (count($ledger_list)) {
            foreach ($ledger_list as $k => $v) {
                $final_data_list[$k]['id'] = $v->id;
                $final_data_list[$k]['data'] = $v;
                $final_data_list[$k]['name'] = $v->ledger_code . '-' . $v->name;
            }
        }

        return $final_data_list;
    }

    public function creditVoucherForFeeAmount($type, $fee_start_date, $fee_end_date)
    {
        //        return [$fee_start_date, $fee_end_date];
        $total_amount = 0;
        $waiver_amount = 0;
        $fine_amount = 0;
        $fee_amount = 0;
        //        $fine = 0;
        $ids = [];
        $fine_ids = [];
        if ($type == 'cash') {
            $payment_history = SiteStudentFeePaymentHistory::where('accounts_received_status', 0)
                ->whereBetween('payment_date', array($fee_start_date, $fee_end_date))
                ->where('paid_by', 'cash')
                ->get();
            if (count($payment_history)) {
                foreach ($payment_history as $key => $value) {
                    $total_amount += $value->paid_amount;
                    $ids[] = $value->id;
                }
            }
        } else if ($type == 'bank') {
            $payment_history = SiteStudentFeePaymentHistory::where('accounts_received_status', 0)
                ->whereBetween('payment_date', array($fee_start_date, $fee_end_date))
                ->where('paid_by', 'bank')
                ->get();
            if (count($payment_history)) {
                foreach ($payment_history as $key => $value) {
                    $total_amount += $value->paid_amount;
                    $ids[] = $value->id;
                }
            }
        }else if ($type == 'SonaliPay') {
            $payment_history = SiteStudentFeePaymentHistory::where('accounts_received_status', 0)
                ->whereBetween('payment_date', array($fee_start_date, $fee_end_date))
                ->where('paid_by', 'SonaliPay')
                ->get();
            if (count($payment_history)) {
                foreach ($payment_history as $key => $value) {
                    $total_amount += $value->paid_amount;
                    $ids[] = $value->id;
                }
            }
        }else if ($type == 'receivable') {
            //            return 'ok';
            $waiver_amount = 0;
            $fee_amount = 0;
            $demand_slip_list = SiteStudentFeeDemandSlipDetails::where('accounts_received_status', 0)
                ->whereBetween('created_date', array($fee_start_date, $fee_end_date))
                ->get();
            if (count($demand_slip_list)) {
                foreach ($demand_slip_list as $key => $value) {
                    $fee_amount += $value->fee_amount;
                    $waiver_amount += $value->waiver_amount;
                    $amount = ($value->fee_amount - $value->waiver_amount);
                    $total_amount += $amount;
                    $ids[] = $value->id;
                }
            }
            //===========================total fine==========================
            $fine_amount = 0;

            $fine_list = SiteStudentFeeFine::where('accounts_received_status', 0)
                ->whereBetween('created_date', array($fee_start_date, $fee_end_date))
                ->get();
            if (count($fine_list)) {
                foreach ($fine_list as $k => $v) {
                    $fine_ids[] = $v->id;
                    $fine_amount += $v->fine_amount;
                }
            }
            $total_amount = $total_amount + $fine_amount;
        }

        return [$total_amount, $ids, $fine_ids, $waiver_amount, $fine_amount];
        //        return $final_data;

    }

    public function getOnlyCashAndBankAccountsLedgerList()
    {

        $ledger_list = Ledger::with(['bankAccountDetails' => function ($q) {
            $q->with(['chequeRegisterForLedgerAccounts' => function ($qr) {
                $qr->where('cheque_status', 'active');
            }]);
        }])->where('status', 1)->get();

        //        return $ledger_list;

        //        $ledger_list = Ledger::with('bankAccountDet')->where('site_accounts_bank_id', '!=', null)->where('status', 1)->get();
        //
        //        return $ledger_list;
        $final_data_list = [];
        $srl = 0;
        if (count($ledger_list)) {
            foreach ($ledger_list as $k => $v) {
                if ($v->site_accounts_bank_id || $v->count_as_cash_status) {

                    if (count($v->bankAccountDetails)) {
                        foreach ($v->bankAccountDetails as $kky => $vvl) {
                            $final_data_list[$srl]['ledger_id']           = $v->id;
                            $final_data_list[$srl]['data']                = $v;
                            $final_data_list[$srl]['name']                = $v->ledger_code . '-' . $v->name . ' (AC-' . $vvl->account_number . ')';
                            $final_data_list[$srl]['bank_id']             = $v->site_accounts_bank_id;
                            $final_data_list[$srl]['bank_account']        = $vvl->id;
                            $final_data_list[$srl]['bank_account_cheque'] = $vvl->chequeRegisterForLedgerAccounts;

                            $final_data_list[$srl]['bank_account'] = $vvl->id;
                            $bank_account_deposit_amount           = SiteAccountsVoucherDetailsBankAccountDepositRecord::where('site_accounts_bank_account_detail_id', $vvl->id)->sum('deposit_amount');
                            $bank_account_withdraw_amount          = SiteAccountsVoucherDetailsBankAccountDepositRecord::where('site_accounts_bank_account_detail_id', $vvl->id)->sum('withdraw_amount');
                            $bank_deposit_balance                  = $bank_account_deposit_amount - $bank_account_withdraw_amount;
                            $cheque_amount                         = ChequeRegister::where('site_accounts_bank_account_detail_id', $vvl->id)->sum('cheque_amount');
                            $final_data_list[$srl]['balance']      = ($vvl->account_balance + $bank_deposit_balance) - $cheque_amount;
                            $srl++;
                        }
                    } else {
                        $final_data_list[$srl]['ledger_id']    = $v->id;
                        $final_data_list[$srl]['data']         = $v;
                        $final_data_list[$srl]['name']         = $v->ledger_code . '-' . $v->name;
                        $final_data_list[$srl]['bank_id']      = "";
                        $final_data_list[$srl]['bank_account'] = "";

                        $ledger_balance = 0;
                        $accounts_details = Accounts::where('site_accounts_ledger_id', $v->id)->get();
                        if (count($accounts_details)) {
                            $debit_amount_list = $accounts_details->pluck('debit_amount');
                            //                    return $debit_amount_list;
                            $debit_total_amount = 0;
                            if ($debit_amount_list) {
                                foreach ($debit_amount_list as $kk => $vv) {
                                    $debit_total_amount += $vv;
                                }
                            }

                            $credit_amount_list = $accounts_details->pluck('credit_amount');
                            $credit_total_amount = 0;
                            if ($credit_amount_list) {
                                foreach ($credit_amount_list as $kkk => $vvv) {
                                    $credit_total_amount += $vvv;
                                }
                            }
                            $ledger_balance = $debit_total_amount - $credit_total_amount;
                        }
                        $initial_amount = $v->initial_amount ? $v->initial_amount : 0;
                        $final_ledger_balance = $ledger_balance + $initial_amount;
                        $final_data_list[$srl]['balance'] = $final_ledger_balance;
                        $srl++;
                    }
                }
            }
        }

        return $final_data_list;
    }

    public function getOnlyCashAndBankAccountsLedgerListForEdit()
    {
        //        $ledger_list = Ledger::with(['bankAccountDetails'=>function($q){
        //            $q->with('chequeRegisterForLedgerAccounts');
        //        }])->where('status', 1)->get();

        $ledger_list = Ledger::with(['bankAccountDetails' => function ($q) {
            $q->with('chequeRegisterForLedgerAccounts');
        }])->where('status', 1)->get();

        $final_data_list = [];
        $srl = 0;
        if (count($ledger_list)) {
            foreach ($ledger_list as $k => $v) {
                if ($v->site_accounts_bank_id || $v->count_as_cash_status) {

                    if (count($v->bankAccountDetails)) {
                        foreach ($v->bankAccountDetails as $kky => $vvl) {
                            $final_data_list[$srl]['ledger_id'] = $v->id;
                            $final_data_list[$srl]['data'] = $v;
                            $final_data_list[$srl]['name'] = $v->ledger_code . '-' . $v->name . ' (AC-' . $vvl->account_number . ')';
                            $final_data_list[$srl]['bank_id'] = $v->site_accounts_bank_id;
                            $final_data_list[$srl]['bank_account'] = $vvl->id;
                            $final_data_list[$srl]['bank_account_cheque'] = $vvl->chequeRegisterForLedgerAccounts;

                            $final_data_list[$srl]['bank_account'] = $vvl->id;

                            $bank_account_deposit_amount = SiteAccountsVoucherDetailsBankAccountDepositRecord::where('site_accounts_bank_account_detail_id', $vvl->id)->sum('deposit_amount');
                            $bank_account_withdraw_amount = SiteAccountsVoucherDetailsBankAccountDepositRecord::where('site_accounts_bank_account_detail_id', $vvl->id)->sum('withdraw_amount');
                            $bank_deposit_balance = $bank_account_deposit_amount - $bank_account_withdraw_amount;

                            $cheque_amount = ChequeRegister::where('site_accounts_bank_account_detail_id', $vvl->id)->sum('cheque_amount');
                            $final_data_list[$srl]['balance'] = ($vvl->account_balance + $bank_deposit_balance) - $cheque_amount;
                            $srl++;
                        }
                    } else {
                        $final_data_list[$srl]['ledger_id'] = $v->id;
                        $final_data_list[$srl]['data'] = $v;
                        $final_data_list[$srl]['name'] = $v->ledger_code . '-' . $v->name;
                        $final_data_list[$srl]['bank_id'] = "";
                        $final_data_list[$srl]['bank_account'] = "";

                        $ledger_balance = 0;
                        $accounts_details = Accounts::where('site_accounts_ledger_id', $v->id)->get();
                        if (count($accounts_details)) {
                            $debit_amount_list = $accounts_details->pluck('debit_amount');
                            //                       return $debit_amount_list;
                            $debit_total_amount = 0;
                            if ($debit_amount_list) {
                                foreach ($debit_amount_list as $kk => $vv) {
                                    $debit_total_amount += $vv;
                                }
                            }

                            $credit_amount_list = $accounts_details->pluck('credit_amount');
                            $credit_total_amount = 0;
                            if ($credit_amount_list) {
                                foreach ($credit_amount_list as $kkk => $vvv) {
                                    $credit_total_amount += $vvv;
                                }
                            }
                            $ledger_balance = $debit_total_amount - $credit_total_amount;
                        }
                        $initial_amount = $v->initial_amount ? $v->initial_amount : 0;
                        $final_ledger_balance = $ledger_balance + $initial_amount;
                        $final_data_list[$srl]['balance'] = $final_ledger_balance;
                        $srl++;
                    }
                }
            }
        }

        return $final_data_list;
    }

    public function getMonthList($emp_id = null, $mode)
    {


        $check_salary_month_ids = SiteAccountsEmployeeSalary::where('status', 1)->where('employee_id', $emp_id)->pluck('month_id');
        //        return $check_salary_month_ids;
        if ($check_salary_month_ids && $mode == 'false') {
            $month_ids = [];
            foreach ($check_salary_month_ids as $kk => $vv) {
                if ($vv) {
                    $month_ids[$kk] = $vv;
                }
            }
            $month_list = AcademicMonthName::whereNotIn('id', $month_ids)->get();
        } else {
            //            return $check_salary_month_ids;
            $month_list = AcademicMonthName::get();
        }

        $final_data = [];
        if (count($month_list)) {
            foreach ($month_list as $k => $v) {
                $final_data[$k]['id'] = $v->id;
                $final_data[$k]['name'] = $v->name;
                $final_data[$k]['check_status'] = false;
            }
        }
        return $final_data;
    }

    public function getAccountsExpenseLedgerList()
    {
        $accounts_head_expense = AccountsHead::where('key_name', 'expense')->first();
        $expense_ledger_list = [];
        $data_list = [];
        $srl_no = 0;

        if ($accounts_head_expense) {
            $data_list[$srl_no]['parent_id'] = $accounts_head_expense->id;
            $data_list[$srl_no]['parent_head_key'] = $accounts_head_expense->head_key;
            $srl_no++;
            $accounts_group_data = AccountsGroup::where('accounts_head_id', $accounts_head_expense->id)->get();
            if (count($accounts_group_data)) {
                foreach ($accounts_group_data as $key => $value) {
                    $data_list[$srl_no]['parent_id'] = $value->id;
                    $data_list[$srl_no]['parent_head_key'] = $value->head_key;
                    $srl_no++;

                    $accounts_sub_group = AccountsSubGroup::where('site_accounts_group_id', $value->id)->get();
                    if (count($accounts_sub_group)) {
                        foreach ($accounts_sub_group as $kk => $vv) {
                            $data_list[$srl_no]['parent_id'] = $vv->id;
                            $data_list[$srl_no]['parent_head_key'] = $vv->head_key;
                            $srl_no++;
                        }
                    }
                }
            }
        }
        //        return $data_list;
        if (count($data_list)) {
            foreach ($data_list as $kkk => $vvv) {
                $accounts_ledger = Ledger::where('parent_id', $vvv['parent_id'])->where('parent_head_key', $vvv['parent_head_key'])->get();
                if (count($accounts_ledger)) {
                    foreach ($accounts_ledger as $k => $v) {
                        $expense_ledger_list[$k] = $v;
                    }
                }
            }
        }
        return $expense_ledger_list;
    }

    public function createAccountsWithCreditVoucher(Request $request, AccountsVoucherDetails $accountsVoucherDetails)
    {
        //        return $request;

        //==================accounts voucher details entry=====================
        if (count($accountsVoucherDetails->ownFields) > 0) {
            foreach ($accountsVoucherDetails->ownFields as $field) {
                if ($request->{$field}) {
                    $accountsVoucherDetails->{$field} = $request->{$field};
                }
            }
            $accountsVoucherDetails->transaction_by = Auth::user()->id;
            $accountsVoucherDetails->voucher_type = 'creditvoucher';
            $accountsVoucherDetails->transaction_amount = $request->totalCreditAmount;
            $latest_voucher_details_data = AccountsVoucherDetails::orderBy('id', 'DESC')->first();
            if ($latest_voucher_details_data) {
                $new_voucher_no = (int)$latest_voucher_details_data->voucher_no + 1;
            } else {
                $new_voucher_no = 101;
            }
            $accountsVoucherDetails->voucher_no = $new_voucher_no;
        }
        //==================accounts and voucher payment history entry=====================

        if ($accountsVoucherDetails->save()) {
            $latest_acc_voucher_details_data = AccountsVoucherDetails::orderBy('id', 'DESC')->first();
            $accounts_voucher_id = $latest_acc_voucher_details_data->id;

            //=================voucher and payment hidtory entry=============

            //----------------------for cash or bank fee-------------------
            if ($request->transaction_for == "fee" && $request->collection_type == "cash" || $request->collection_type == "bank") {
                $site_student_payment_history = SiteStudentFeePaymentHistory::whereIn('id', $request->fee_ids)->update([
                    'accounts_received_status' => 1,
                ]);
                if (count($request->fee_ids)) {
                    foreach ($request->fee_ids as $kky => $vval) {
                        $site_accounts_voucher_details_student_payment_history_records = new SiteAccountsVoucherDetailsStudentPaymentHistoryRecord();
                        $site_accounts_voucher_details_student_payment_history_records->site_accounts_voucher_detail_id = $accounts_voucher_id;
                        $site_accounts_voucher_details_student_payment_history_records->site_student_fee_payment_history_id = $vval;
                        $site_accounts_voucher_details_student_payment_history_records->status = 1;
                        $site_accounts_voucher_details_student_payment_history_records->save();
                    }
                }
            }

            //----------------------for receivable fee------------------
            //                if($request->transaction_for == "fee" && $request->collection_type == "receivable"){
            //
            //                    $site_student_fee_demand_slip_details = SiteStudentFeeDemandSlipDetails::whereIn('id', $request->fee_ids)->update([
            //                        'accounts_received_status' => 1,
            //                    ]);
            //
            //                    if(count($request->fee_ids)){
            //                        foreach ($request->fee_ids as $kky => $vval){
            //                            $site_accounts_voucher_details_student_payment_history_records = new SiteAccountsVoucherDetailsStudentPaymentHistoryRecord();
            //                            $site_accounts_voucher_details_student_payment_history_records->site_accounts_voucher_detail_id = $accounts_voucher_id;
            //                            $site_accounts_voucher_details_student_payment_history_records->site_student_fee_demand_slip_detail_id = $vval;
            //                            $site_accounts_voucher_details_student_payment_history_records->status = 1;
            //                            $site_accounts_voucher_details_student_payment_history_records->save();
            //                        }
            //                    }
            //
            //                    $site_student_fee_fine = SiteStudentFeeFine::whereIn('id', $request->fee_fine_ids)->update([
            //                        'accounts_received_status' => 1,
            //                    ]);
            //
            //                    if(count($request->fee_fine_ids)){
            //                        foreach ($request->fee_fine_ids as $kky => $vval){
            //                            $site_accounts_voucher_details_student_payment_history_records = new SiteAccountsVoucherDetailsStudentPaymentHistoryRecord();
            //                            $site_accounts_voucher_details_student_payment_history_records->site_accounts_voucher_detail_id = $accounts_voucher_id;
            //                            $site_accounts_voucher_details_student_payment_history_records->site_student_fee_fine_id = $vval;
            //                            $site_accounts_voucher_details_student_payment_history_records->status = 1;
            //                            $site_accounts_voucher_details_student_payment_history_records->save();
            //                        }
            //                    }
            //                }

            //=========================credit data entry=====================
            $creditDataList = $request->creditRowDataList;
            if (count($creditDataList)) {
                foreach ($creditDataList as $key => $value) {

                    $accounts = new Accounts();
                    $accounts->site_accounts_ledger_id = $value['accounts_ledger_id']['id'];
                    $accounts->credit_amount = $value['amount'];
                    $accounts->created_by = Auth::user()->id;
                    $accounts->created_date = Carbon::today();
                    $accounts->entry = "cr";
                    $accounts->status = 1;
                    $accounts->site_accounts_voucher_detail_id = $latest_acc_voucher_details_data->id;
                    $accounts->save();
                }
            }
            //=============================debit data entry===================
            $debitDataList = $request->debitRowDataList;
            if (count($debitDataList)) {
                foreach ($debitDataList as $key => $value) {

                    $accounts = new Accounts();
                    $accounts->site_accounts_ledger_id = $value['accounts_ledger_id']['ledger_id'];
                    $accounts->debit_amount = $value['amount'];
                    $accounts->created_by = Auth::user()->id;
                    $accounts->created_date = Carbon::today();
                    $accounts->entry = "dr";
                    $accounts->status = 1;
                    $accounts->site_accounts_voucher_detail_id = $latest_acc_voucher_details_data->id;
                    $accounts->save();

                    if ($value['accounts_ledger_id']['bank_account']) {
                        $last_accounts_details = Accounts::orderBy('id', 'desc')->first();
                        $voucher_bank_account_deposit_record = new SiteAccountsVoucherDetailsBankAccountDepositRecord();
                        $voucher_bank_account_deposit_record->site_accounts_voucher_detail_id = $latest_acc_voucher_details_data->id;
                        $voucher_bank_account_deposit_record->site_accounts_bank_account_detail_id = $value['accounts_ledger_id']['bank_account'];
                        $voucher_bank_account_deposit_record->site_account_id = $last_accounts_details->id;
                        $voucher_bank_account_deposit_record->deposit_amount = $value['amount'];
                        $voucher_bank_account_deposit_record->transaction_date = Carbon::today();
                        $voucher_bank_account_deposit_record->status = 1;
                        $voucher_bank_account_deposit_record->save();
                    }
                }
            }
        }
        return Response::json(['message' => 'Successfully Saved!', 'mode' => 'Save', 'accountsVoucherID' => $accounts_voucher_id], 200);
    }

    public function updateAccountsWithCreditVoucher(Request $request)
    {

        if (auth()->user()->alias != 'eduworld') {
            throw new Error('Sorry, You have no permission!');
        }

        //=========================credit data entry=====================
        $newly_updatable_accounts_ids = [];
        $srl = 0;
        $creditDataList = $request->creditRowDataList;
        if (count($creditDataList)) {
            foreach ($creditDataList as $key => $value) {
                if ($value['accounts_id']) {
                    $newly_updatable_accounts_ids[$srl] = $value['accounts_id'];
                    $srl++;
                    $check_present_accounts = Accounts::where('id', $value['accounts_id'])->first();
                    $check_present_accounts->update([
                        'credit_amount' => $value['amount'],
                        'site_accounts_ledger_id' => $value['accounts_ledger_id']['id'],
                    ]);
                } else {
                    $accounts = new Accounts();
                    $accounts->site_accounts_ledger_id = $value['accounts_ledger_id']['id'];
                    $accounts->credit_amount = $value['amount'];
                    $accounts->created_by = Auth::user()->id;
                    $accounts->created_date = Carbon::today();
                    $accounts->entry = "cr";
                    $accounts->status = 1;
                    $accounts->site_accounts_voucher_detail_id = $request->id;
                    $accounts->save();
                }
            }
        }
        //=============================debit data entry===================
        $debitDataList = $request->debitRowDataList;
        if (count($debitDataList)) {
            foreach ($debitDataList as $key => $value) {
                if ($value['accounts_id']) {

                    $newly_updatable_accounts_ids[$srl] = $value['accounts_id'];
                    $srl++;

                    $check_present_accounts = Accounts::where('id', $value['accounts_id'])->first();
                    $check_present_accounts->update([
                        'debit_amount' => $value['amount'],
                        'site_accounts_ledger_id' => $value['accounts_ledger_id']['ledger_id'],
                    ]);

                    $check_present_bank_account = SiteAccountsVoucherDetailsBankAccountDepositRecord::where('site_account_id', $value['accounts_id'])->first();
                    if ($check_present_bank_account) {
                        $check_present_bank_account->update([
                            'deposit_amount' => $value['amount'],
                            'site_accounts_bank_account_detail_id' => $value['accounts_ledger_id']['bank_account'],
                        ]);
                    } else {
                        if ($value['accounts_ledger_id']['bank_account']) {

                            $voucher_bank_account_deposit_record = new SiteAccountsVoucherDetailsBankAccountDepositRecord();
                            $voucher_bank_account_deposit_record->site_accounts_voucher_detail_id = $request->id;
                            $voucher_bank_account_deposit_record->site_account_id = $value['accounts_id'];
                            $voucher_bank_account_deposit_record->site_accounts_bank_account_detail_id =  $value['accounts_ledger_id']['bank_account'];
                            $voucher_bank_account_deposit_record->deposit_amount = $value['amount'];
                            $voucher_bank_account_deposit_record->deposit_date = Carbon::today();;
                            $voucher_bank_account_deposit_record->status = 1;
                            $voucher_bank_account_deposit_record->save();
                        }
                    }
                } else {

                    $accounts = new Accounts();
                    $accounts->site_accounts_ledger_id = $value['accounts_ledger_id']['ledger_id'];
                    $accounts->debit_amount = $value['amount'];
                    $accounts->created_by = Auth::user()->id;
                    $accounts->created_date = Carbon::today();
                    $accounts->entry = "dr";
                    $accounts->status = 1;
                    $accounts->site_accounts_voucher_detail_id = $request->id;
                    $accounts->save();

                    if ($value['accounts_ledger_id']['bank_account']) {

                        $last_accounts_data = Accounts::orderBy('id', 'desc')->first();

                        $voucher_bank_account_deposit_record = new SiteAccountsVoucherDetailsBankAccountDepositRecord();
                        $voucher_bank_account_deposit_record->site_accounts_voucher_detail_id = $request->id;
                        $voucher_bank_account_deposit_record->site_account_id = $last_accounts_data->id;
                        $voucher_bank_account_deposit_record->site_accounts_bank_account_detail_id =  $value['accounts_ledger_id']['bank_account'];
                        $voucher_bank_account_deposit_record->deposit_amount = $value['amount'];
                        $voucher_bank_account_deposit_record->deposit_date = Carbon::today();;
                        $voucher_bank_account_deposit_record->status = 1;
                        $voucher_bank_account_deposit_record->save();
                    }
                }
            }
        }

        //=============delete data======================

        $past_accounts_ids = $request->accounts_exist_ids;
        $present_accounts_ids = $newly_updatable_accounts_ids;
        $deletable_accounts_ids = array_diff($past_accounts_ids, $present_accounts_ids);

        $accounts_data_delete = Accounts::whereIn('id', $deletable_accounts_ids)->delete();

        $accounts_bank_record_data_delete = SiteAccountsVoucherDetailsBankAccountDepositRecord::whereIn('site_account_id', $deletable_accounts_ids)->delete();

        //=================update voucher===============

        $voucher_data = AccountsVoucherDetails::findOrFail($request->id);
        if ($voucher_data->transaction_amount != $request->totalCreditAmount) {
            $voucher_data->update([
                'transaction_amount' => $request->totalCreditAmount,
            ]);
        }

        return Response::json(['message' => 'Successfully Updated!', 'mode' => 'Update'], 200);
    }

    public function updateAccountsWithJournalVoucher(Request $request)
    {
        if (auth()->user()->alias != 'eduworld') {
            throw new Error('Sorry, You have no permission!');
        }

        //===============validation==============
        $rowDataList = $request->rowDataList;
        $ledger_ids = [];
        if (count($rowDataList)) {
            foreach ($rowDataList as $key => $value) {
                $ledger_ids[$key] = $value['accounts_ledger_id']['id'];
            }

            if (count($ledger_ids) !== count(array_unique($ledger_ids))) {
                throw new Error('Sorry, transaction can not be proceeded in same account!');
            }

            //            $check_duplicate_id = 0;
            //            foreach ($ledger_ids as $k => $v){
            //                $check_duplicate_id = 0;
            //                foreach ($rowDataList as $kk => $vv){
            //                    if($v == $vv['accounts_ledger_id']['id']){
            //                        $check_duplicate_id+=1;
            //                    }
            //                }
            //            }
            //            if($check_duplicate_id>1){
            //                throw new Error('Sorry! transaction can not be in same account!');
            //            }
        }

        $newly_updatable_accounts_ids = [];
        if (count($request->rowDataList)) {
            foreach ($request->rowDataList as $key => $value) {
                if ($value['accounts_id']) {
                    $newly_updatable_accounts_ids[] = $value['accounts_id'];
                    $accounts_data = Accounts::where('id', $value['accounts_id'])->update([
                        'debit_amount' => $value['debit_amount'],
                        'credit_amount' => $value['credit_amount'],
                        'site_accounts_ledger_id' => $value['accounts_ledger_id']['id'],
                    ]);
                } else {
                    $accounts = new Accounts();
                    $accounts->site_accounts_ledger_id = $value['accounts_ledger_id']['id'];
                    $accounts->debit_amount = $value['debit_amount'];
                    $accounts->credit_amount = $value['credit_amount'];
                    $accounts->created_by = Auth::user()->id;
                    $accounts->created_date = Carbon::today();
                    if ($value['debit_amount'] > 0) {
                        $accounts->entry = "dr";
                    }
                    if ($value['credit_amount'] > 0) {
                        $accounts->entry = "cr";
                    }
                    $accounts->status = 1;
                    $accounts->site_accounts_voucher_detail_id = $request->id;
                    $accounts->save();
                }
            }
        }

        //=============delete data======================

        $past_accounts_ids = $request->accounts_exist_ids;
        $present_accounts_ids = $newly_updatable_accounts_ids;
        $deletable_accounts_ids = array_diff($past_accounts_ids, $present_accounts_ids);

        $accounts_data_delete = Accounts::whereIn('id', $deletable_accounts_ids)->delete();

        //==============update voucher=================
        $voucher_data = AccountsVoucherDetails::findOrFail($request->id);
        if ($voucher_data->transaction_amount != $request->totalCreditAmount) {
            $voucher_data->update([
                'transaction_amount' => $request->totalCreditAmount,
            ]);
        }
        return Response::json(['message' => 'Successfully Updated!', 'mode' => 'Update'], 200);
    }

    public function getAccountsCreditVoucherPdf($voucher_id)
    {
        //        return $voucher_id;
        $title_view = "Credit Voucher";
        $voucher_details = AccountsVoucherDetails::findOrFail($voucher_id);

        $accounts_details = Accounts::with('ledger')->where('site_accounts_voucher_detail_id', $voucher_id)->where('entry', 'cr')->get();
        $total_amount = 0;
        if (count($accounts_details)) {
            foreach ($accounts_details as $key => $value) {
                $total_amount += $value->credit_amount;
            }
        }
        $total_amount = number_format($total_amount);
        $total_amount_in_word = $this->convertNumberToWord($total_amount);

        $report_tittle = '<b>Credit Voucher</b><br>' . '<b>' . $voucher_details->transaction_date . '</b>';
        $report_tittle2  = '<b>Voucher No: ' . $voucher_details->voucher_no . '</b>';



        $pdf = PDF::loadView(
            'default.admin.site.accounts.accounts-credit-voucher-pdf',
            compact('report_tittle', 'report_tittle2', 'voucher_details', 'accounts_details', 'total_amount', 'total_amount_in_word', 'title_view')
        );
        return $pdf->stream(time() . '-credit-voucher.pdf');
    }

    public function createAccountsWithDebitVoucher(Request $request, AccountsVoucherDetails $accountsVoucherDetails, SiteAccountsFixedAsset $accountsFixedAsset)
    {

        //================validation==================

        $debit_arr = $request->debit_ledger_id_list;
        $credit_arr = $request->credit_ledger_id_list;

        if (count($debit_arr) !== count(array_unique($debit_arr))) {
            throw new Error('Sorry, same debit account can not be added in transaction!');
        } else if (count($credit_arr) !== count(array_unique($credit_arr))) {
            throw new Error('Sorry, same credit account can not be added in transaction!');
        }

        $creditDataList = $request->creditRowDataList;
        if (count($creditDataList)) {
            foreach ($creditDataList as $key => $value) {
                if (count($value['cheque_list']) && !$value['cheque_id']) {
                    throw new Error('Please, select cheque for this transaction!');
                }
            }
        }
        //        return 'sorry';
        if ($request->transaction_for == 'fixedasset') {
            if (!$request->item_name || !$request->purchase_date || !$request->asset_type) {
                throw new Error('Sorry! fill required item details!');
            }
            if ($request->depriciation_status) {
                if (!$request->depriciation_type || !$request->depriciation_amount || !$request->active_date || !$request->expense_ledger_id || !$request->count_type) {
                    throw new Error('Sorry! fill required depriciation details!');
                }
            }
            if ($request->amortization_status) {
                if (!$request->amortization_type || !$request->amortization_amount || !$request->active_date || !$request->expense_ledger_id || !$request->count_type) {
                    throw new Error('Sorry! fill required amortization details!');
                }
            }
            $item_toal_cost = 0;
            if ($request->unit_price &&  $request->qty) {
                $item_toal_cost = $request->unit_price * $request->qty;
                if ($item_toal_cost != $request->totalDebitAmount) {
                    throw new Error('Sorry! item cost and transaction amount are not matched!');
                }
            }
        }
        //==================accounts voucher details entry=====================
        if (count($accountsVoucherDetails->ownFields) > 0) {
            foreach ($accountsVoucherDetails->ownFields as $field) {
                if ($request->{$field}) {
                    $accountsVoucherDetails->{$field} = $request->{$field};
                }
            }
            $accountsVoucherDetails->transaction_by = Auth::user()->id;
            $accountsVoucherDetails->voucher_type = 'debitvoucher';
            $accountsVoucherDetails->transaction_amount = $request->totalDebitAmount;
            $latest_voucher_details_data = AccountsVoucherDetails::orderBy('id', 'DESC')->first();
            if ($latest_voucher_details_data) {
                $new_voucher_no = (int)$latest_voucher_details_data->voucher_no + 1;
            } else {
                $new_voucher_no = 101;
            }
            $accountsVoucherDetails->voucher_no = $new_voucher_no;
        }
        //        $latest_acc_voucher_details_data = AccountsVoucherDetails::orderBy('id','DESC')->first();
        //==================accounts and voucher payment history entry=====================
        if ($accountsVoucherDetails->save()) {

            $accounts_voucher_id = $accountsVoucherDetails->id;
            //=================voucher and salary entry=============
            //----------------------for employee salary-------------------
            if ($request->transaction_for == "employee" && $request->payment_type == "salary") {
                $month_ids = [];
                $total_month = 0;
                foreach ($request->monthList as $k => $v) {
                    if ($v['check_status']) {
                        $month_ids[] = $v['id'];
                        $total_month += 1;
                    }
                }
                $per_month_salary = $request->totalDebitAmount / $total_month;

                foreach ($month_ids as $kk => $vv) {
                    $employee_salary = new SiteAccountsEmployeeSalary();
                    $employee_salary->employee_id = $request->employee_id;
                    $employee_salary->month_id = $vv;
                    $employee_salary->site_accounts_voucher_detail_id = $accounts_voucher_id;
                    $employee_salary->payment_type = $request->payment_type;
                    $employee_salary->amount = $per_month_salary;
                    $employee_salary->status = 1;
                    $employee_salary->save();
                }
            }
            //----------------------for employee bonus---------------------
            if ($request->transaction_for == "employee" && $request->payment_type == "bonus") {
                $employee_salary = new SiteAccountsEmployeeSalary();
                $employee_salary->employee_id = $request->employee_id;
                $employee_salary->site_accounts_voucher_detail_id = $accounts_voucher_id;
                $employee_salary->payment_type = $request->payment_type;
                $employee_salary->amount = $request->totalDebitAmount;
                $employee_salary->status = 1;
                $employee_salary->save();
            }
            //==============================fixed asset=======================
            if ($request->transaction_for == 'fixedasset') {
                if (count($accountsFixedAsset->ownFields) > 0) {
                    foreach ($accountsFixedAsset->ownFields as $field) {
                        if ($request->{$field}) {
                            $accountsFixedAsset->{$field} = $request->{$field};
                        }
                    }
                    $accountsFixedAsset->site_accounts_voucher_detail_id = $accounts_voucher_id;
                    $accountsFixedAsset->purchase_cost = $request->totalDebitAmount;
                    $accountsFixedAsset->status = 1;
                    $accountsFixedAsset->created_by = Auth::user()->id;
                    $accountsFixedAsset->created_date = Carbon::today();
                    $accountsFixedAsset->save();
                }
            }
            //=============================debit data entry===================
            $debitDataList = $request->debitRowDataList;
            if (count($debitDataList)) {
                foreach ($debitDataList as $key => $value) {
                    $accounts = new Accounts();
                    $accounts->site_accounts_ledger_id = $value['accounts_ledger']['id'];
                    $accounts->debit_amount = $value['amount'];
                    $accounts->created_by = Auth::user()->id;
                    $accounts->created_date = Carbon::today();
                    $accounts->entry = "dr";
                    $accounts->status = 1;
                    $accounts->site_accounts_voucher_detail_id = $accounts_voucher_id;
                    $accounts->save();
                }
            }

            //=========================credit data entry=====================
            $creditDataList = $request->creditRowDataList;
            if (count($creditDataList)) {
                foreach ($creditDataList as $key => $value) {

                    $accounts = new Accounts();
                    $accounts->site_accounts_ledger_id = $value['accounts_ledger']['ledger_id'];
                    $accounts->credit_amount = $value['amount'];
                    $accounts->created_by = Auth::user()->id;
                    $accounts->created_date = Carbon::today();
                    $accounts->entry = "cr";
                    $accounts->status = 1;
                    $accounts->site_accounts_voucher_detail_id = $accounts_voucher_id;
                    $accounts->save();

                    if ($value['cheque_id']) {
                        $voucher_cheque_register = new SiteAccountsVoucherChequeRegisterRecords();
                        $voucher_cheque_register->site_accounts_voucher_detail_id = $accounts_voucher_id;
                        $voucher_cheque_register->site_accounts_cheque_register_id = $value['cheque_id']['id'];
                        $voucher_cheque_register->site_accounts_bank_account_detail_id = $value['cheque_id']['site_accounts_bank_account_detail_id'];
                        $voucher_cheque_register->site_account_id = $accounts->id;
                        $voucher_cheque_register->status = 1;
                        if ($voucher_cheque_register->save()) {
                            $cheque_register = ChequeRegister::findOrFail($value['cheque_id']['id']);
                            $cheque_register->update([
                                'cheque_status' => 'reconcile'
                            ]);
                        }


                        $voucher_bank_account_deposit_record = new SiteAccountsVoucherDetailsBankAccountDepositRecord();
                        $voucher_bank_account_deposit_record->site_accounts_voucher_detail_id = $accounts_voucher_id;
                        $voucher_bank_account_deposit_record->site_accounts_bank_account_detail_id = $value['cheque_id']['site_accounts_bank_account_detail_id'];
                        $voucher_bank_account_deposit_record->site_account_id = $accounts->id;

                        $voucher_bank_account_deposit_record->withdraw_amount = $value['amount'];

                        $voucher_bank_account_deposit_record->transaction_date = Carbon::today();
                        $voucher_bank_account_deposit_record->status = 1;
                        $voucher_bank_account_deposit_record->save();
                    } else {


                        $voucher_bank_account_deposit_record = new SiteAccountsVoucherDetailsBankAccountDepositRecord();
                        $voucher_bank_account_deposit_record->site_accounts_voucher_detail_id = $accountsVoucherDetails->id;
                        $voucher_bank_account_deposit_record->site_accounts_bank_account_detail_id = $value['accounts_ledger']['bank_account'];
                        $voucher_bank_account_deposit_record->site_account_id = $accounts->id;

                        $voucher_bank_account_deposit_record->withdraw_amount = $value['amount'];

                        $voucher_bank_account_deposit_record->transaction_date = Carbon::today();
                        $voucher_bank_account_deposit_record->status = 1;
                        $voucher_bank_account_deposit_record->save();
                    }
                }
            }
        }
        return Response::json(['message' => 'Successfully Saved!', 'mode' => 'Save', 'accountsVoucherID' => $accounts_voucher_id], 200);
    }

    public function updateAccountsWithDebitVoucher(Request $request)
    {

        if (auth()->user()->alias != 'eduworld') {
            throw new Error('Sorry, You have no permission!');
        }

        //================validation==================

        $debit_arr = $request->debit_ledger_id_list;
        $credit_arr = $request->credit_ledger_id_list;

        if (count($debit_arr) !== count(array_unique($debit_arr))) {
            throw new Error('Sorry, same debit account can not be added in transaction!');
        } else if (count($credit_arr) !== count(array_unique($credit_arr))) {
            throw new Error('Sorry, same credit account can not be added in transaction!');
        }

        $creditDataList = $request->creditRowDataList;
        if (count($creditDataList)) {
            foreach ($creditDataList as $key => $value) {

                if (count($value['cheque_list']) && !$value['cheque_id']) {
                    throw new Error('Please, select cheque for this transaction!');
                }
                if (count($value['cheque_list']) && $value['cheque_id'] && $value['exist_cheque_id'] && $value['cheque_id']['id'] != $value['exist_cheque_id']['id']) {

                    $cheque_reg = ChequeRegister::where('id', $value['cheque_id']['id'])->where('cheque_status', 'reconcile')->first();
                    if ($cheque_reg) {

                        throw new Error('Sorry! this cheque is reconciled in another transaction!');
                    }
                }
                if (count($value['cheque_list']) && $value['cheque_id'] && !$value['exist_cheque_id']) {
                    $cheque_reg = ChequeRegister::where('id', $value['cheque_id']['id'])->where('cheque_status', 'reconcile')->first();
                    if ($cheque_reg) {
                        throw new Error('Sorry! this cheque is reconciled in another transaction!');
                    }
                }
            }
        }
        if ($request->transaction_for == 'fixedasset') {
            if (!$request->item_name || !$request->purchase_date || !$request->asset_type) {
                throw new Error('Sorry! fill required item details!');
            }
            if ($request->depriciation_status) {
                if (!$request->depriciation_type || !$request->depriciation_amount || !$request->active_date || !$request->expense_ledger_id || !$request->count_type) {
                    throw new Error('Sorry! fill required depriciation details!');
                }
            }
            if ($request->amortization_status) {
                if (!$request->amortization_type || !$request->amortization_amount || !$request->active_date || !$request->expense_ledger_id || !$request->count_type) {
                    throw new Error('Sorry! fill required amortization details!');
                }
            }
            $item_toal_cost = 0;
            if ($request->unit_price &&  $request->qty) {
                $item_toal_cost = $request->unit_price * $request->qty;
                if ($item_toal_cost != $request->totalDebitAmount) {
                    throw new Error('Sorry! item cost and transaction amount are not matched!');
                }
            }
        }

        //==================accounts voucher details entry=====================

        $accountsVoucherDetails = AccountsVoucherDetails::findOrFail($request->id);
        $accountsVoucherDetails->transaction_by = Auth::user()->id;
        $accountsVoucherDetails->transaction_date = $request->transaction_date;
        $accountsVoucherDetails->transaction_amount = $request->totalDebitAmount;

        //==================accounts and voucher payment history entry=====================

        if ($accountsVoucherDetails->save()) {

            $accounts_voucher_id = $request->id;

            //=================voucher and salary entry=============

            //----------------------for employee salary-------------------

            if ($request->transaction_for == "employee" && $request->payment_type == "salary") {
                $month_details = SiteAccountsEmployeeSalary::where('site_accounts_voucher_detail_id', $request->id)
                    ->where('payment_type', 'salary')->get();
                $month_ids = [];
                $total_month = 0;
                foreach ($request->monthList as $k => $v) {
                    if ($v['check_status']) {
                        $month_ids[] = $v['id'];
                        $total_month += 1;
                    }
                }
                $per_month_salary = $request->totalDebitAmount / $total_month;

                if (count($month_details) > 0) {
                    foreach ($month_details as $ke => $vl) {
                        foreach ($month_ids as $kke => $vvl) {
                            if ($vl->month_id == $vvl) {
                                $vl->month_id = $per_month_salary;
                                $vl->save();
                            }
                        }
                    }
                }

                //===============delete employee salary data===============

                $old_month_ids = $month_details->pluck('month_id');
                $deletable_month = array_merge(array_diff($old_month_ids->toArray(), $month_ids), array_diff($month_ids, $old_month_ids->toArray()));
                $deletable_data = $month_details->whereIn('month_id', $deletable_month);
                if (count($deletable_data) > 0) {
                    foreach ($deletable_data as $kk => $vv) {
                        $vv->delete();
                    }
                }

                //===============new employee salary data entry============

                if (count($deletable_month) > 0) {
                    foreach ($deletable_month as $kkk => $vvv) {
                        $check_exist_data = $month_details->where('month_id', $vvv)->first();
                        if (!$check_exist_data) {
                            $employee_salary = new SiteAccountsEmployeeSalary();
                            $employee_salary->employee_id = $request->employee_id;
                            $employee_salary->month_id = $vvv;
                            $employee_salary->site_accounts_voucher_detail_id = $accounts_voucher_id;
                            $employee_salary->payment_type = $request->payment_type;
                            $employee_salary->amount = $per_month_salary;
                            $employee_salary->status = 1;
                            $employee_salary->save();
                        }
                    }
                }
            }

            //----------------------for employee bonus---------------------

            if ($request->transaction_for == "employee" && $request->payment_type == "bonus") {
                $bonus_details = SiteAccountsEmployeeSalary::where('site_accounts_voucher_detail_id', $request->id)->where('payment_type', 'bonus')->first();
                if ($bonus_details) {
                    $bonus_details->amount = $request->totalDebitAmount;
                    $bonus_details->save();
                }
            }

            //==============================fixed asset=======================

            if ($request->transaction_for == 'fixedasset') {
                $accountsFixedAsset = SiteAccountsFixedAsset::where('site_accounts_voucher_detail_id', $request->id)->first();
                if (count($accountsFixedAsset->ownFields) > 0) {
                    foreach ($accountsFixedAsset->ownFields as $field) {
                        if ($request->{$field}) {
                            $accountsFixedAsset->{$field} = $request->{$field};
                        }
                    }
                    $accountsFixedAsset->site_accounts_voucher_detail_id = $accounts_voucher_id;
                    $accountsFixedAsset->purchase_cost = $request->totalDebitAmount;
                    $accountsFixedAsset->status = 1;
                    $accountsFixedAsset->created_by = Auth::user()->id;
                    $accountsFixedAsset->created_date = Carbon::today();
                    $accountsFixedAsset->save();
                }
            }

            //=============================debit data entry===================

            $newly_updatable_accounts_ids = [];
            $srl = 0;
            $debitDataList = $request->debitRowDataList;
            if (count($debitDataList)) {
                foreach ($debitDataList as $key => $value) {
                    if ($value['accounts_id']) {
                        $newly_updatable_accounts_ids[$srl] = $value['accounts_id'];
                        $srl++;
                        $check_present_accounts = Accounts::where('id', $value['accounts_id'])->first();
                        $check_present_accounts->update([
                            'debit_amount' => $value['amount'],
                            'site_accounts_ledger_id' => $value['accounts_ledger']['id'],
                        ]);
                    } else {
                        $accounts = new Accounts();
                        $accounts->site_accounts_ledger_id = $value['accounts_ledger']['id'];
                        $accounts->debit_amount = $value['amount'];
                        $accounts->created_by = Auth::user()->id;
                        $accounts->created_date = Carbon::today();
                        $accounts->entry = "dr";
                        $accounts->status = 1;
                        $accounts->site_accounts_voucher_detail_id = $request->id;
                        $accounts->save();
                    }
                }
            }

            //=========================credit data entry=====================
            $voucher_bank_account_deposit_record_update_ids = [];
            $voucher_bank_account_deposit_record_exist_ids = SiteAccountsVoucherDetailsBankAccountDepositRecord::where('site_accounts_voucher_detail_id', $accounts_voucher_id)->pluck('id');

            $creditDataList = $request->creditRowDataList;
            if (count($creditDataList)) {
                foreach ($creditDataList as $key => $value) {
                    if ($value['accounts_id']) {

                        $newly_updatable_accounts_ids[$srl] = $value['accounts_id'];
                        $srl++;

                        $check_present_accounts = Accounts::where('id', $value['accounts_id'])->first();
                        $check_present_accounts->update([
                            'credit_amount' => $value['amount'],
                            'site_accounts_ledger_id' => $value['accounts_ledger']['ledger_id'],
                        ]);

                        //--------------------------update cheque register-------------------

                        $check_present_bank_acccount_cheque_reg = SiteAccountsVoucherChequeRegisterRecords::where('site_account_id', $value['accounts_id'])->first();
                        if ($check_present_bank_acccount_cheque_reg) {
                            $present_cheque_reg_check = ChequeRegister::where('id', $check_present_bank_acccount_cheque_reg->site_accounts_cheque_register_id)
                                ->update([
                                    'cheque_status' => 'active',
                                ]);
                            if ($value['cheque_id']) {
                                $check_present_bank_acccount_cheque_reg->update([
                                    'deposit_amount' => $value['amount'],
                                    'site_accounts_cheque_register_id' => $value['cheque_id']['id'],
                                    'site_accounts_bank_account_detail_id' =>  $value['cheque_id']['site_accounts_bank_account_detail_id'],
                                ]);
                                $check_present_bank_acccount_cheque_reg->site_accounts_voucher_detail_id = $accounts_voucher_id;
                                $check_present_bank_acccount_cheque_reg->site_accounts_cheque_register_id = $value['cheque_id']['id'];
                                $check_present_bank_acccount_cheque_reg->site_accounts_bank_account_detail_id = $value['cheque_id']['site_accounts_bank_account_detail_id'];
                                $check_present_bank_acccount_cheque_reg->site_account_id = $value['accounts_id'];
                                $check_present_bank_acccount_cheque_reg->status = 1;
                                if ($check_present_bank_acccount_cheque_reg->save()) {
                                    $cheque_register = ChequeRegister::findOrFail($value['cheque_id']['id']);
                                    $cheque_register->update([
                                        'cheque_status' => 'reconcile'
                                    ]);
                                }
                            } else {
                                $check_present_bank_acccount_cheque_reg->delete();
                            }
                        } else if ($value['cheque_id']) {
                            $voucher_cheque_register = new SiteAccountsVoucherChequeRegisterRecords();
                            $voucher_cheque_register->site_accounts_voucher_detail_id = $accounts_voucher_id;
                            $voucher_cheque_register->site_accounts_cheque_register_id = $value['cheque_id']['id'];
                            $voucher_cheque_register->site_accounts_bank_account_detail_id = $value['cheque_id']['site_accounts_bank_account_detail_id'];
                            $voucher_cheque_register->site_account_id = $value['accounts_id'];
                            $voucher_cheque_register->status = 1;
                            if ($voucher_cheque_register->save()) {
                                $cheque_register = ChequeRegister::findOrFail($value['cheque_id']['id']);
                                $cheque_register->update([
                                    'cheque_status' => 'reconcile'
                                ]);
                            }
                        }

                        //----------------------update bank account deposit record-----------------------

                        $voucher_bank_account_deposit_record = SiteAccountsVoucherDetailsBankAccountDepositRecord::where('site_accounts_voucher_detail_id', $accounts_voucher_id)

                            ->where('site_account_id', $value['accounts_id'])
                            ->first();

                        if ($voucher_bank_account_deposit_record) {
                            if ($value['cheque_id']) {
                                $voucher_bank_account_deposit_record_update_ids[] = $voucher_bank_account_deposit_record->id;

                                $voucher_bank_account_deposit_record->site_accounts_voucher_detail_id = $accountsVoucherDetails->id;
                                $voucher_bank_account_deposit_record->site_accounts_bank_account_detail_id = $value['cheque_id']['site_accounts_bank_account_detail_id'];
                                $voucher_bank_account_deposit_record->site_account_id = $value['accounts_id'];
                                $voucher_bank_account_deposit_record->withdraw_amount = $value['amount'];
                                $voucher_bank_account_deposit_record->transaction_date = Carbon::today();
                                $voucher_bank_account_deposit_record->status = 1;
                                $voucher_bank_account_deposit_record->save();
                            }
                            //                            else{
                            //                                $voucher_bank_account_deposit_record->delete();
                            //                            }



                        } else if ($value['cheque_id']) {

                            $voucher_bank_account_deposit_record = new SiteAccountsVoucherDetailsBankAccountDepositRecord();

                            $voucher_bank_account_deposit_record->site_accounts_voucher_detail_id = $accountsVoucherDetails->id;
                            $voucher_bank_account_deposit_record->site_accounts_bank_account_detail_id = $value['cheque_id']['site_accounts_bank_account_detail_id'];
                            $voucher_bank_account_deposit_record->site_account_id = $value['accounts_id'];
                            $voucher_bank_account_deposit_record->withdraw_amount = $value['amount'];
                            $voucher_bank_account_deposit_record->transaction_date = Carbon::today();
                            $voucher_bank_account_deposit_record->status = 1;
                            $voucher_bank_account_deposit_record->save();
                        }
                    } else {

                        $accounts = new Accounts();
                        $accounts->site_accounts_ledger_id = $value['accounts_ledger']['ledger_id'];
                        $accounts->credit_amount = $value['amount'];
                        $accounts->created_by = Auth::user()->id;
                        $accounts->created_date = Carbon::today();
                        $accounts->entry = "cr";
                        $accounts->status = 1;
                        $accounts->site_accounts_voucher_detail_id = $request->id;
                        $accounts->save();

                        if ($value['cheque_id']) {
                            $voucher_cheque_register = new SiteAccountsVoucherChequeRegisterRecords();
                            $voucher_cheque_register->site_accounts_voucher_detail_id = $request->id;
                            $voucher_cheque_register->site_accounts_cheque_register_id = $value['cheque_id']['id'];
                            $voucher_cheque_register->site_accounts_bank_account_detail_id = $value['cheque_id']['site_accounts_bank_account_detail_id'];
                            $voucher_cheque_register->site_account_id = $accounts->id;
                            $voucher_cheque_register->status = 1;
                            if ($voucher_cheque_register->save()) {
                                $cheque_register = ChequeRegister::findOrFail($value['cheque_id']['id']);
                                $cheque_register->update([
                                    'cheque_status' => 'reconcile'
                                ]);
                            }

                            $voucher_bank_account_deposit_record = new SiteAccountsVoucherDetailsBankAccountDepositRecord();

                            $voucher_bank_account_deposit_record->site_accounts_voucher_detail_id = $accountsVoucherDetails->id;
                            $voucher_bank_account_deposit_record->site_accounts_bank_account_detail_id = $value['cheque_id']['site_accounts_bank_account_detail_id'];
                            $voucher_bank_account_deposit_record->site_account_id = $value['accounts_id'];
                            $voucher_bank_account_deposit_record->withdraw_amount = $value['amount'];
                            $voucher_bank_account_deposit_record->transaction_date = Carbon::today();
                            $voucher_bank_account_deposit_record->status = 1;
                            $voucher_bank_account_deposit_record->save();
                        }
                    }
                }

                $deletable_ids = array_diff($voucher_bank_account_deposit_record_exist_ids->toArray(), $voucher_bank_account_deposit_record_update_ids);
                $delete_record = SiteAccountsVoucherDetailsBankAccountDepositRecord::whereIn('id', $deletable_ids)->delete();
            }

            //=============delete data======================

            $past_accounts_ids = $request->accounts_exist_ids;
            $present_accounts_ids = $newly_updatable_accounts_ids;
            $deletable_accounts_ids = array_diff($past_accounts_ids, $present_accounts_ids);

            $accounts_data_delete = Accounts::whereIn('id', $deletable_accounts_ids)->delete();

            $accounts_bank_cheque_reg_record_data_delete = SiteAccountsVoucherChequeRegisterRecords::whereIn('site_account_id', $deletable_accounts_ids)->get();
            if (count($accounts_bank_cheque_reg_record_data_delete) > 0) {
                foreach ($accounts_bank_cheque_reg_record_data_delete as $keyy => $vval) {
                    $cheque_reg_data = ChequeRegister::where('id', $vval->site_accounts_cheque_register_id)->update([
                        'cheque_status' => 'active',
                    ]);
                    $vval->delete();
                }
            }
        }
        return Response::json(['message' => 'Successfully Saved!', 'mode' => 'Save', 'accountsVoucherID' => $accounts_voucher_id], 200);
    }

    public function getAccountsDebitVoucherPdf($voucher_id)
    {
        //    return $voucher_id;
        $title_view = "Debit Voucher";
        $voucher_details = AccountsVoucherDetails::findOrFail($voucher_id);

        //==========employee salary details================
        $emp_salary_data = SiteAccountsEmployeeSalary::where('site_accounts_voucher_detail_id', $voucher_id)->get();
        $emp_details = [];
        $month_list = [];
        if (count($emp_salary_data)) {
            $emp_id = $emp_salary_data->pluck('employee_id');
            $emp_details = User::whereIn('id', $emp_id)->get();

            $month_ids = $emp_salary_data->pluck('month_id');
            $month_list = AcademicMonthName::whereIn('id', $month_ids)->get();
        }
        //===================Accounts==============================

        $accounts_details = Accounts::with('ledger')->where('site_accounts_voucher_detail_id', $voucher_id)->where('entry', 'dr')->get();
        $total_amount = 0;
        if (count($accounts_details)) {
            foreach ($accounts_details as $key => $value) {
                $total_amount += $value->debit_amount;
            }
        }
        $total_amount = number_format($total_amount);
        $total_amount_in_word = $this->convertNumberToWord($total_amount);

        //====================party details===========================
        $party_details = "";
        if ($accounts_details[0]->ledger->site_accounts_party_id) {
            $party_details = Party::findOrFail($accounts_details[0]->ledger->site_accounts_party_id);
        }

        //=================payment method details=========================
        $credit_accounts_details = Accounts::with('ledger')->where('site_accounts_voucher_detail_id', $voucher_id)->where('entry', 'cr')->get();
        $payment_method_details = [];
        $srl_no = 1;
        foreach ($credit_accounts_details as $ke => $val) {
            if (!$val->ledger->site_accounts_bank_id) {
                $payment_method_details[$srl_no]['cash'] = "Yes";
                $payment_method_details[$srl_no]['cheque_serial'] = "";
                $payment_method_details[$srl_no]['cheque_number'] = "";
                $payment_method_details[$srl_no]['bank'] = "";
                $payment_method_details[$srl_no]['date'] = $voucher_details->transaction_date;
                $payment_method_details[$srl_no]['transaction_note'] = $voucher_details->transaction_note;
                $payment_method_details[$srl_no]['amount'] = number_format($val->credit_amount);
                $srl_no++;
            }
        }
        $cheque_reg_ids = SiteAccountsVoucherChequeRegisterRecords::where('site_accounts_voucher_detail_id', $voucher_id)->pluck('site_accounts_cheque_register_id');
        $cheque_details = ChequeRegister::whereIn('id', $cheque_reg_ids)->with(['bankAccountDetails' => function ($q) {
            $q->with('bank');
        }])->get();
        //            return $cheque_details->count();
        if (count($cheque_details)) {
            foreach ($cheque_details as $kkk => $vvv) {
                $payment_method_details[$srl_no]['cash'] = "";
                $payment_method_details[$srl_no]['cheque_serial'] = $vvv->cheque_serial_no;
                $payment_method_details[$srl_no]['cheque_number'] = $vvv->cheque_number;
                $payment_method_details[$srl_no]['bank'] = $vvv->bankAccountDetails->bank->name;
                $payment_method_details[$srl_no]['date'] = $vvv->cheque_issue_date;
                $payment_method_details[$srl_no]['transaction_note'] = $voucher_details->transaction_note;
                $payment_method_details[$srl_no]['amount'] = number_format($vvv->cheque_amount);
                $srl_no++;
            }
        }

        $transaction_note = $voucher_details->transaction_note ?? null;

        $pdf = PDF::loadView(
            'default.admin.site.accounts.accounts-debit-voucher-pdf',
            compact('voucher_details', 'accounts_details', 'total_amount', 'total_amount_in_word', 'transaction_note', 'title_view', 'emp_details', 'month_list', 'payment_method_details', 'party_details')
        );
        return $pdf->stream(time() . '-credit-voucher.pdf');
    }

    public function createAccountsWithJournalVoucher(Request $request, AccountsVoucherDetails $accountsVoucherDetails)
    {
        //        return $request;

        //===============vakidation==============
        $rowDataList = $request->rowDataList;
        $ledger_ids = [];
        if (count($rowDataList)) {
            foreach ($rowDataList as $key => $value) {
                $ledger_ids[$key] = $value['accounts_ledger_id']['id'];
            }

            if (count($ledger_ids) !== count(array_unique($ledger_ids))) {
                throw new Error('Sorry, transaction can not be proceeded in same account!');
            }

            //            $check_duplicate_id = 0;
            //            foreach ($ledger_ids as $k => $v){
            //                $check_duplicate_id = 0;
            //                foreach ($rowDataList as $kk => $vv){
            //                    if($v == $vv['accounts_ledger_id']['id']){
            //                        $check_duplicate_id+=1;
            //                    }
            //                }
            //            }
            //            if($check_duplicate_id>1){
            //                throw new Error('Sorry! transaction can not be in same account!');
            //            }
        }
        //==================accounts voucher details entry=====================
        if (count($accountsVoucherDetails->ownFields) > 0) {
            foreach ($accountsVoucherDetails->ownFields as $field) {
                if ($request->{$field}) {
                    $accountsVoucherDetails->{$field} = $request->{$field};
                }
            }
            $accountsVoucherDetails->transaction_by = Auth::user()->id;
            $accountsVoucherDetails->voucher_type = 'journalvoucher';
            $accountsVoucherDetails->fee_start_date = $request->fee_start_date;
            $accountsVoucherDetails->fee_end_date = $request->fee_end_date;
            $accountsVoucherDetails->transaction_amount = $request->totalDebitAmount;
            $latest_voucher_details_data = AccountsVoucherDetails::orderBy('id', 'DESC')->first();
            if ($latest_voucher_details_data) {
                $new_voucher_no = (int)$latest_voucher_details_data->voucher_no + 1;
            } else {
                $new_voucher_no = 101;
            }
            $accountsVoucherDetails->voucher_no = $new_voucher_no;
        }

        if ($accountsVoucherDetails->save()) {
            //            $latest_acc_voucher_details_data = AccountsVoucherDetails::orderBy('id','DESC')->first();
            $accounts_voucher_id = $accountsVoucherDetails->id;

            //----------------------for receivable fee------------------
            if ($request->transaction_for == "fee") {

                $site_student_fee_demand_slip_details = SiteStudentFeeDemandSlipDetails::whereIn('id', $request->fee_ids)->update([
                    'accounts_received_status' => 1,
                ]);

                if (count($request->fee_ids)) {
                    foreach ($request->fee_ids as $kky => $vvl) {
                        $site_accounts_voucher_details_student_payment_history_records = new SiteAccountsVoucherDetailsStudentPaymentHistoryRecord();
                        $site_accounts_voucher_details_student_payment_history_records->site_accounts_voucher_detail_id = $accounts_voucher_id;
                        $site_accounts_voucher_details_student_payment_history_records->site_student_fee_demand_slip_detail_id = $vvl;
                        $site_accounts_voucher_details_student_payment_history_records->status = 1;
                        $site_accounts_voucher_details_student_payment_history_records->save();
                    }
                }

                $site_student_fee_fine = SiteStudentFeeFine::whereIn('id', $request->fee_fine_ids)->update([
                    'accounts_received_status' => 1,
                ]);

                if (count($request->fee_fine_ids)) {
                    foreach ($request->fee_fine_ids as $kkky => $vvvl) {
                        $site_accounts_voucher_details_student_payment_history_records = new SiteAccountsVoucherDetailsStudentPaymentHistoryRecord();
                        $site_accounts_voucher_details_student_payment_history_records->site_accounts_voucher_detail_id = $accounts_voucher_id;
                        $site_accounts_voucher_details_student_payment_history_records->site_student_fee_fine_id = $vvvl;
                        $site_accounts_voucher_details_student_payment_history_records->status = 1;
                        $site_accounts_voucher_details_student_payment_history_records->save();
                    }
                }
            }


            //====================accounts data entry===================
            $rowDataList = $request->rowDataList;
            if (count($rowDataList)) {
                foreach ($rowDataList as $key => $value) {
                    $accounts = new Accounts();
                    $accounts->site_accounts_ledger_id = $value['accounts_ledger_id']['id'];
                    $accounts->debit_amount = $value['debit_amount'] ? $value['debit_amount'] : 0;
                    $accounts->credit_amount = $value['credit_amount'] ? $value['credit_amount'] : 0;
                    $accounts->created_by = Auth::user()->id;
                    $accounts->created_date = Carbon::today();
                    if ($value['debit_amount'] > 0) {
                        $accounts->entry = "dr";
                    }
                    if ($value['credit_amount'] > 0) {
                        $accounts->entry = "cr";
                    }
                    $accounts->status = 1;
                    $accounts->site_accounts_voucher_detail_id = $accounts_voucher_id;
                    $accounts->save();
                }
                return Response::json(['message' => 'Successfully Saved!', 'mode' => 'Save', 'accountsVoucherID' => $accounts_voucher_id], 200);
            }
        }
    }

    public function createAccountsWithContraVoucher(Request $request, AccountsVoucherDetails $accountsVoucherDetails)
    {


        //=============================validation==================================

        $first_data = $request->rowDataList[0];
        $second_data = $request->rowDataList[1];

        $check_duplicate_id = false;
        if ($first_data['accounts_ledger_id']['ledger_id'] == $second_data['accounts_ledger_id']['ledger_id']) {
            if ($first_data['accounts_ledger_id']['bank_account'] && $second_data['accounts_ledger_id']['bank_account']) {
                if ($first_data['accounts_ledger_id']['bank_account'] == $second_data['accounts_ledger_id']['bank_account']) {
                    $check_duplicate_id = true;
                } else {
                    $check_duplicate_id = false;
                }
            } else {
                $check_duplicate_id = true;
            }
        }
        if ($check_duplicate_id) {
            throw new Error('Sorry! transaction can not be in same account!');
        }

        //=====================accounts voucher details entry=======================

        if (count($accountsVoucherDetails->ownFields) > 0) {
            foreach ($accountsVoucherDetails->ownFields as $field) {
                if ($request->{$field}) {
                    $accountsVoucherDetails->{$field} = $request->{$field};
                }
            }
            $accountsVoucherDetails->transaction_by = Auth::user()->id;
            $accountsVoucherDetails->voucher_type = 'contravoucher';
            $accountsVoucherDetails->transaction_amount = $request->totalDebitAmount;
            $latest_voucher_details_data = AccountsVoucherDetails::orderBy('id', 'DESC')->first();
            if ($latest_voucher_details_data) {
                $new_voucher_no = (int)$latest_voucher_details_data->voucher_no + 1;
            } else {
                $new_voucher_no = 101;
            }
            $accountsVoucherDetails->voucher_no = $new_voucher_no;
        }

        //==========================accounts data entry============================

        if ($accountsVoucherDetails->save()) {

            $accounts_voucher_id = $accountsVoucherDetails->id;

            $rowDataList = $request->rowDataList;
            if (count($rowDataList)) {
                foreach ($rowDataList as $key => $value) {
                    $accounts = new Accounts();
                    $accounts->site_accounts_ledger_id = $value['accounts_ledger_id']['ledger_id'];
                    $accounts->debit_amount = $value['debit_amount'];
                    $accounts->credit_amount = $value['credit_amount'];
                    $accounts->created_by = Auth::user()->id;
                    $accounts->created_date = Carbon::today();
                    if ($value['debit_amount'] > 0) {
                        $accounts->entry = "dr";
                    }
                    if ($value['credit_amount'] > 0) {
                        $accounts->entry = "cr";
                    }
                    $accounts->status = 1;
                    $accounts->site_accounts_voucher_detail_id = $accountsVoucherDetails->id;

                    if ($accounts->save()) {


                        if ($value['accounts_ledger_id']['bank_account']) {
                            //                        $last_accounts_details = Accounts::orderBy('id','desc')->first();
                            $voucher_bank_account_deposit_record = new SiteAccountsVoucherDetailsBankAccountDepositRecord();
                            $voucher_bank_account_deposit_record->site_accounts_voucher_detail_id = $accountsVoucherDetails->id;
                            $voucher_bank_account_deposit_record->site_accounts_bank_account_detail_id = $value['accounts_ledger_id']['bank_account'];
                            $voucher_bank_account_deposit_record->site_account_id = $accounts->id;

                            if ($accounts->entry == "dr") {
                                $voucher_bank_account_deposit_record->deposit_amount = $value['debit_amount'];
                            } else if ($accounts->entry == "cr") {
                                $voucher_bank_account_deposit_record->withdraw_amount = $value['credit_amount'];
                            }

                            $voucher_bank_account_deposit_record->transaction_date = Carbon::today();
                            $voucher_bank_account_deposit_record->status = 1;
                            $voucher_bank_account_deposit_record->save();
                        }
                    }
                }
            }
            //=========================bank account transaction cost entry=========================

            if ($first_data['accounts_ledger_id']['bank_account'] && $second_data['accounts_ledger_id']['bank_account']) {
                $bank_account_transfer_cost_record = new SiteAccountsBankAccountTransferCostRecord();
                $bank_account_transfer_cost_record->site_accounts_voucher_detail_id = $accounts_voucher_id;
                if ($first_data['credit_amount'] > 0) {
                    $bank_account_transfer_cost_record->site_accounts_bank_account_detail_id = $first_data['accounts_ledger_id']['bank_account'];
                } else {
                    $bank_account_transfer_cost_record->site_accounts_bank_account_detail_id = $second_data['accounts_ledger_id']['bank_account'];
                }
                $bank_account_transfer_cost_record->transaction_cost = $request->transaction_cost;
                $bank_account_transfer_cost_record->transaction_date = $request->transaction_date;
                $bank_account_transfer_cost_record->status = $request->status;
                $bank_account_transfer_cost_record->save();
            }
            return Response::json(['message' => 'Successfully Saved!', 'mode' => 'Save'], 200);
        }
    }

    public function updateAccountsWithContraVoucher(Request $request)
    {
        if (auth()->user()->alias != 'eduworld') {
            throw new Error('Sorry, You have no permission!');
        }
        //=============================validation==================================

        $first_data = $request->rowDataList[0];
        $second_data = $request->rowDataList[1];

        $check_duplicate_id = false;
        if ($first_data['accounts_ledger_id']['ledger_id'] == $second_data['accounts_ledger_id']['ledger_id']) {
            if ($first_data['accounts_ledger_id']['bank_account'] && $second_data['accounts_ledger_id']['bank_account']) {
                if ($first_data['accounts_ledger_id']['bank_account'] == $second_data['accounts_ledger_id']['bank_account']) {
                    $check_duplicate_id = true;
                } else {
                    $check_duplicate_id = false;
                }
            } else {
                $check_duplicate_id = true;
            }
        }
        if ($check_duplicate_id) {
            throw new Error('Sorry! transaction can not be in same account!');
        }

        //=====================accounts voucher details entry=======================
        $accountsVoucherDetails = AccountsVoucherDetails::findOrFail($request->id);

        if (count($accountsVoucherDetails->ownFields) > 0) {
            foreach ($accountsVoucherDetails->ownFields as $field) {
                if ($request->{$field}) {
                    $accountsVoucherDetails->{$field} = $request->{$field};
                }
            }
            $accountsVoucherDetails->transaction_by = Auth::user()->id;
            $accountsVoucherDetails->transaction_amount = $request->totalDebitAmount;
        }

        //==========================accounts data entry============================

        if ($accountsVoucherDetails->save()) {

            $accounts_voucher_id = $request->id;

            $voucher_bank_account_deposit_record_exist_ids = SiteAccountsVoucherDetailsBankAccountDepositRecord::where('site_accounts_voucher_detail_id', $request->id)->pluck('id');
            $voucher_bank_account_deposit_record_update_ids = [];

            $rowDataList = $request->rowDataList;
            if (count($rowDataList)) {
                foreach ($rowDataList as $key => $value) {
                    $accounts = Accounts::findOrFail($value['accounts_id']);
                    $accounts->site_accounts_ledger_id = $value['accounts_ledger_id']['ledger_id'];
                    $accounts->debit_amount = $value['debit_amount'];
                    $accounts->credit_amount = $value['credit_amount'];
                    $accounts->created_by = Auth::user()->id;
                    $accounts->created_date = Carbon::today();
                    if ($value['debit_amount'] > 0) {
                        $accounts->entry = "dr";
                    }
                    if ($value['credit_amount'] > 0) {
                        $accounts->entry = "cr";
                    }

                    if ($accounts->save()) {
                        if ($value['accounts_ledger_id']['bank_account']) {

                            $voucher_bank_account_deposit_record = SiteAccountsVoucherDetailsBankAccountDepositRecord::where('site_accounts_voucher_detail_id', $accountsVoucherDetails->id)
                                ->where('site_accounts_bank_account_detail_id', $value['accounts_ledger_id']['bank_account'])
                                ->where('site_account_id', $accounts->id)
                                ->first();

                            if ($voucher_bank_account_deposit_record) {

                                $voucher_bank_account_deposit_record_update_ids[] = $voucher_bank_account_deposit_record->id;

                                $voucher_bank_account_deposit_record->site_accounts_voucher_detail_id = $accountsVoucherDetails->id;
                                $voucher_bank_account_deposit_record->site_accounts_bank_account_detail_id = $value['accounts_ledger_id']['bank_account'];
                                $voucher_bank_account_deposit_record->site_account_id = $accounts->id;

                                if ($accounts->entry == "dr") {
                                    $voucher_bank_account_deposit_record->deposit_amount = $value['debit_amount'];
                                    $voucher_bank_account_deposit_record->withdraw_amount = "";
                                } else if ($accounts->entry == "cr") {
                                    $voucher_bank_account_deposit_record->withdraw_amount = $value['credit_amount'];
                                    $voucher_bank_account_deposit_record->deposit_amount = "";
                                }

                                $voucher_bank_account_deposit_record->transaction_date = Carbon::today();
                                $voucher_bank_account_deposit_record->status = 1;
                                $voucher_bank_account_deposit_record->save();
                            } else {
                                $voucher_bank_account_deposit_record = new SiteAccountsVoucherDetailsBankAccountDepositRecord();
                                $voucher_bank_account_deposit_record->site_accounts_voucher_detail_id = $accountsVoucherDetails->id;
                                $voucher_bank_account_deposit_record->site_accounts_bank_account_detail_id = $value['accounts_ledger_id']['bank_account'];
                                $voucher_bank_account_deposit_record->site_account_id = $accounts->id;

                                if ($accounts->entry == "dr") {
                                    $voucher_bank_account_deposit_record->deposit_amount = $value['debit_amount'];
                                } else if ($accounts->entry == "cr") {
                                    $voucher_bank_account_deposit_record->withdraw_amount = $value['credit_amount'];
                                }

                                $voucher_bank_account_deposit_record->transaction_date = Carbon::today();
                                $voucher_bank_account_deposit_record->status = 1;
                                $voucher_bank_account_deposit_record->save();
                            }
                        }
                    }
                }

                $deletable_ids = array_diff($voucher_bank_account_deposit_record_exist_ids->toArray(), $voucher_bank_account_deposit_record_update_ids);
                $delete_record = SiteAccountsVoucherDetailsBankAccountDepositRecord::whereIn('id', $deletable_ids)->delete();
            }
            //=========================bank account transaction cost entry=========================

            if ($first_data['accounts_ledger_id']['bank_account'] && $second_data['accounts_ledger_id']['bank_account']) {
                $bank_account_transfer_cost_record = SiteAccountsBankAccountTransferCostRecord::where('site_accounts_voucher_detail_id', $accounts_voucher_id)->first();
                if ($bank_account_transfer_cost_record) {
                    $bank_account_transfer_cost_record->site_accounts_voucher_detail_id = $accounts_voucher_id;
                    if ($first_data['credit_amount'] > 0) {
                        $bank_account_transfer_cost_record->site_accounts_bank_account_detail_id = $first_data['accounts_ledger_id']['bank_account'];
                    } else {
                        $bank_account_transfer_cost_record->site_accounts_bank_account_detail_id = $second_data['accounts_ledger_id']['bank_account'];
                    }
                    $bank_account_transfer_cost_record->transaction_cost = $request->transaction_cost;
                    $bank_account_transfer_cost_record->transaction_date = $request->transaction_date;
                    $bank_account_transfer_cost_record->status = $request->status;
                    $bank_account_transfer_cost_record->save();
                } else if ($request->transaction_cost > 0) {
                    $bank_account_transfer_cost_record = new SiteAccountsBankAccountTransferCostRecord();
                    $bank_account_transfer_cost_record->site_accounts_voucher_detail_id = $accounts_voucher_id;
                    if ($first_data['credit_amount'] > 0) {
                        $bank_account_transfer_cost_record->site_accounts_bank_account_detail_id = $first_data['accounts_ledger_id']['bank_account'];
                    } else {
                        $bank_account_transfer_cost_record->site_accounts_bank_account_detail_id = $second_data['accounts_ledger_id']['bank_account'];
                    }
                    $bank_account_transfer_cost_record->transaction_cost = $request->transaction_cost;
                    $bank_account_transfer_cost_record->transaction_date = $request->transaction_date;
                    $bank_account_transfer_cost_record->status = $request->status;
                    $bank_account_transfer_cost_record->save();
                }
            } else {
                $bank_account_transfer_cost_record = SiteAccountsBankAccountTransferCostRecord::where('site_accounts_voucher_detail_id', $accounts_voucher_id)->delete();
            }
            return Response::json(['message' => 'Successfully Updated!', 'mode' => 'Update'], 200);
        }
    }

    public function getAccountsJournalVoucherPdf($voucher_id)
    {
        //        return $voucher_id;
        $title_view = "Journal Voucher";
        $voucher_details = AccountsVoucherDetails::findOrFail($voucher_id);

        $debit_accounts_details = Accounts::with('ledger')->where('site_accounts_voucher_detail_id', $voucher_id)->where('entry', 'dr')->get();
        $credit_accounts_details = Accounts::with('ledger')->where('site_accounts_voucher_detail_id', $voucher_id)->where('entry', 'cr')->get();
        $total_debit_amount = 0;
        $total_credit_amount = 0;

        if (count($debit_accounts_details)) {
            foreach ($debit_accounts_details as $key => $value) {
                $total_debit_amount += $value->debit_amount;
            }
        }
        if (count($credit_accounts_details)) {
            foreach ($credit_accounts_details as $key => $value) {
                $total_credit_amount += $value->credit_amount;
            }
        }

        $total_debit_amount = number_format($total_debit_amount);
        $total_credit_amount = number_format($total_credit_amount);

        $total_amount_in_word = $this->convertNumberToWord($total_debit_amount);

        $report_tittle = '<b>Journal Voucher</b><br>' . '<b>' . $voucher_details->transaction_date . '</b>';
        $report_tittle2  = '<b>Voucher No: ' . $voucher_details->voucher_no . '</b>';

        $pdf = PDF::loadView(
            'default.admin.site.accounts.accounts-journal-voucher-pdf',
            compact('voucher_details', 'report_tittle', 'report_tittle2', 'debit_accounts_details', 'credit_accounts_details', 'total_debit_amount', 'total_credit_amount', 'total_amount_in_word', 'title_view')
        );
        return $pdf->stream(time() . '-journal-voucher.pdf');
    }

    public function getAccountsContraVoucherPdf($voucher_id)
    {
        //        return $voucher_id;
        $title_view = "Contra Voucher";
        $voucher_details = AccountsVoucherDetails::findOrFail($voucher_id);

        $accounts_details = Accounts::with('ledger')->where('site_accounts_voucher_detail_id', $voucher_id)->get();
        //        $credit_accounts_details = Accounts::with('ledger')->where('site_accounts_voucher_detail_id', $voucher_id)->where('entry','cr')->get();
        $total_debit_amount = 0;
        $total_credit_amount = 0;

        if (count($accounts_details)) {
            foreach ($accounts_details as $key => $value) {
                if ($value->entry == 'dr') {
                    $total_debit_amount += $value->debit_amount;
                } else if ($value->entry == 'cr') {
                    $total_credit_amount += $value->credit_amount;
                }
            }
        }

        $total_debit_amount = number_format($total_debit_amount);
        $total_credit_amount = number_format($total_credit_amount);

        $total_amount_in_word = $this->convertNumberToWord($total_debit_amount);

        $report_tittle = '<b>Contra Voucher</b><br>' . '<b>' . $voucher_details->transaction_date . '</b>';
        $report_tittle2  = '<b>Voucher No: ' . $voucher_details->voucher_no . '</b>';

        $pdf = PDF::loadView(
            'default.admin.site.accounts.accounts-contra-voucher-pdf',
            compact('voucher_details', 'report_tittle', 'report_tittle2', 'accounts_details', 'total_debit_amount', 'total_credit_amount', 'total_amount_in_word', 'title_view')
        );
        return $pdf->stream(time() . '-journal-voucher.pdf');
    }

    public function creditVoucherDetailsForUpdate($id)
    {

        //        return $id;

        $voucher_data = AccountsVoucherDetails::with(['accounts' => function ($query) {
            $query->with(['ledger' => function ($qq) {
                $qq->with(['bankAccountDetails' => function ($qqq) {
                    $qqq->with(['chequeRegisterForLedgerAccounts' => function ($qqqr) {
                        $qqqr->where('cheque_status', 'active');
                    }]);
                }]);
            }, 'siteAccountsVoucherDetailsBankAccountDepositRecord']);
        }, 'user'])->where('id', $id)->first();


        $demand_slip_no = "";
        //        if($voucher_data->siteAccountsVoucherDetailsStudentPaymentHistoryRecord && $voucher_data->collection_type == 'single'){
        //            $demand_slip_id = $voucher_data->siteAccountsVoucherDetailsStudentPaymentHistoryRecord[0]->siteStudentFeePaymentHistory->site_student_fee_demand_slip_details_id;
        //            $demand_slip_no = 100000 + (int)$demand_slip_id;
        //        }
        return [$voucher_data, $demand_slip_no];
    }

    public function cotraVoucherDetailsForUpdate($id)
    {

        //        return $id;

        $voucher_data = AccountsVoucherDetails::with(['accounts' => function ($query) {
            $query->with(['ledger' => function ($qq) {
                $qq->with('bankAccountDetails');
            }, 'siteAccountsVoucherDetailsBankAccountDepositRecord']);
        }, 'siteAccountsBankAccountTransferCostRecord'])->where('id', $id)->first();


        return [$voucher_data];
    }

    public function journalVoucherDetailsForUpdate($id)
    {
        $voucher_data = AccountsVoucherDetails::with(['accounts' => function ($query) {
            $query->with('ledger');
        }, 'user'])->where('id', $id)->first();

        return $voucher_data;
    }

    public function debitVoucherDetailsForUpdate($id)
    {
        //        $voucher_data = AccountsVoucherDetails::with(['accounts'=>function($query){
        //            $query->with(['ledger'=>function($qq){
        //                $qq->with(['bankAccountDetails'=>function($qqq){
        //                    $qqq->with(['chequeRegisterForLedgerAccounts'=>function($qqqr){
        //                        $qqqr->where('cheque_status', 'active');
        //                    }]);
        //                }]);
        //
        //            },'siteAccountsVoucherDetailsBankAccountDepositRecord']);
        //        },'user'])->where('id', $id)->first();

        $voucher_data = AccountsVoucherDetails::with(['accounts' => function ($query) {
            $query->with(['ledger' => function ($qq) {
                $qq->with(['bankAccountDetails' => function ($qqq) {
                    $qqq->with(['chequeRegisterForLedgerAccounts' => function ($qqqr) {
                        $qqqr->where('cheque_status', 'active');
                    }]);
                }]);
            }, 'siteAccountsVoucherChequeRegisterRecords' => function ($qu) {
                $qu->with('chequeRegister');
            }]);
        }, 'siteAccountsEmployeeSalary' => function ($q) {
            $q->with(['user', 'academicMonthName']);
        }, 'siteAccountsFixedAsset'])->where('id', $id)->first();


        $getAccountsLedgerList = $this->getAccountsLedgerList();
        $getOnlyCashAndBankAccountsLedgerList = $this->getOnlyCashAndBankAccountsLedgerListForEdit();

        return [$voucher_data, $getAccountsLedgerList, $getOnlyCashAndBankAccountsLedgerList];
    }

    public function deleteAccountsCreditVoucher($id)
    {

        if (auth()->user()->alias != 'eduworld') {
            throw new Error('Sorry, You have no permission!');
        }

        $voucher_details = AccountsVoucherDetails::findOrFail($id);
        if ($voucher_details->delete()) {
            $account_delete = Accounts::where('site_accounts_voucher_detail_id', $id)->delete();
            $voucher_bank_account_details = SiteAccountsVoucherDetailsBankAccountDepositRecord::where('site_accounts_voucher_detail_id', $id)->delete();
            $voucher_payment_history = SiteAccountsVoucherDetailsStudentPaymentHistoryRecord::where('site_accounts_voucher_detail_id', $id)->get();
            //        return $voucher_payment_history;
            if (count($voucher_payment_history) > 0) {
                $payment_history_ids =  $voucher_payment_history->where('site_student_fee_payment_history_id', '!=', null)->pluck('site_student_fee_payment_history_id');
                $student_payment_details = SiteStudentFeePaymentHistory::whereIn('id', $payment_history_ids)->update([
                    'accounts_received_status' => 0
                ]);

                $fee_demand_slip_ids =  $voucher_payment_history->where('site_student_fee_demand_slip_detail_id', '!=', null)->pluck('site_student_fee_demand_slip_detail_id');
                $student_payment_details = SiteStudentFeeDemandSlipDetails::whereIn('id', $fee_demand_slip_ids)->update([
                    'accounts_received_status' => 0
                ]);

                $fee_fine_ids =  $voucher_payment_history->where('site_student_fee_fine_id', '!=', null)->pluck('site_student_fee_fine_id');
                $student_payment_details = SiteStudentFeeFine::whereIn('id', $fee_fine_ids)->update([
                    'accounts_received_status' => 0
                ]);
                //                $voucher_payment_history->delete();
                foreach ($voucher_payment_history as $key => $value) {
                    $value->delete();
                }
            }

            return Response::json(['message' => 'Successfully Deleted!', 'mode' => 'Delete'], 200);
        }
    }

    public function deleteAccountsDebitVoucher($id)
    {
        if (auth()->user()->alias != 'eduworld') {
            throw new Error('Sorry, You have no permission!');
        }

        $voucher_details = AccountsVoucherDetails::findOrFail($id);
        if ($voucher_details->delete()) {
            $account_delete = Accounts::where('site_accounts_voucher_detail_id', $id)->delete();
            $employee_salary_delete = SiteAccountsEmployeeSalary::where('site_accounts_voucher_detail_id', $id)->delete();
            $fixed_asset_delete = SiteAccountsFixedAsset::where('site_accounts_voucher_detail_id', $id)->delete();
            $site_accounts_bank_deposit_rec_delete = SiteAccountsVoucherDetailsBankAccountDepositRecord::where('site_accounts_voucher_detail_id', $id)->delete();
            $site_accounts_cheque_reg_rec_delete = SiteAccountsVoucherChequeRegisterRecords::where('site_accounts_voucher_detail_id', $id)->get();
            
            if (count($site_accounts_cheque_reg_rec_delete) > 0) {
                foreach ($site_accounts_cheque_reg_rec_delete as $key => $value) {
                    $site_accounts_cheque = ChequeRegister::where('id', $value->site_accounts_cheque_register_id)->update([
                        'cheque_status' => 'active'
                    ]);
                    $value->delete();
                }
            }

            return Response::json(['message' => 'Successfully Deleted!', 'mode' => 'Delete'], 200);
        }
    }

    public function deleteAccountsJournalVoucher($id)
    {
        if (auth()->user()->alias != 'eduworld') {
            throw new Error('Sorry, You have no permission!');
        }

        $voucher_details = AccountsVoucherDetails::findOrFail($id);
        if ($voucher_details->delete()) {

            $delete_accounts = Accounts::where('site_accounts_voucher_detail_id', $id)->delete();

            $voucher_payment_history = SiteAccountsVoucherDetailsStudentPaymentHistoryRecord::where('site_accounts_voucher_detail_id', $id)->get();

            if (count($voucher_payment_history) > 0) {
                $fee_demand_slip_ids =  $voucher_payment_history->where('site_student_fee_demand_slip_detail_id', '!=', null)->pluck('site_student_fee_demand_slip_detail_id');
                $student_payment_details = SiteStudentFeeDemandSlipDetails::whereIn('id', $fee_demand_slip_ids)->update([
                    'accounts_received_status' => 0
                ]);

                $fee_fine_ids =  $voucher_payment_history->where('site_student_fee_fine_id', '!=', null)->pluck('site_student_fee_fine_id');
                $student_payment_details = SiteStudentFeeFine::whereIn('id', $fee_fine_ids)->update([
                    'accounts_received_status' => 0
                ]);

                foreach ($voucher_payment_history as $key => $value) {
                    $value->delete();
                }
            }

            return Response::json(['message' => 'Successfully Deleted!', 'mode' => 'Delete'], 200);
        }
    }

    public function deleteAccountsContraVoucher($id)
    {
        if (auth()->user()->alias != 'eduworld') {
            throw new Error('Sorry, You have no permission!');
        }

        $voucher_details = AccountsVoucherDetails::findOrFail($id);
        if ($voucher_details->delete()) {
            $account_delete = Accounts::where('site_accounts_voucher_detail_id', $id)->delete();
            $site_accounts_bank_account_deposit_delete = SiteAccountsVoucherDetailsBankAccountDepositRecord::where('site_accounts_voucher_detail_id', $id)->delete();
            $site_accounts_bank_account_transfer_rec_delete = SiteAccountsBankAccountTransferCostRecord::where('site_accounts_voucher_detail_id', $id)->delete();

            return Response::json(['message' => 'Successfully Deleted!', 'mode' => 'Delete'], 200);
        }
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
