<?php

namespace App\Http\Controllers\Site\Accounts\Party;

use App\Models\Site\Accounts\Party;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Carbon\Carbon;
use Error;
use Auth;
use Response;
use Storage;
use Session;

class AccountsPartyController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType = "Accounts Party";
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function getAccountsPartyList()
    {
        $party_list = Party::where('status', 1)->get();
        if(!count($party_list)){
            throw new Error('Sorry! no party found!');
        }
        return $party_list;
    }

    public function getAccountsPartyListWithPagination(Request $request)
    {

        $search_text = $request->search_text;
        $txt = '%' . $search_text . '%';
        $paginate = $request->paginate;

        //=================bank data list===============
        $accounts_party_list = Party::where('status', 1)
            ->when($txt, function ($qr) use($txt){
                $qr->where('name', 'LIKE', $txt)
                    ->orWhere('contact_no', 'LIKE', $txt);

            })
            ->where('site_id',session()->get('SITE_ID'))
            ->orderBy('id','ASC')->paginate($paginate);


        return $accounts_party_list;

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request, Party $party)
    {

        //=============validation==========
        if(!$request->name || !$request->contact_no){
            throw new Error('Please, fill the required fields!');
        }
        //==============create=============
        if (count($party->ownFields) > 0) {
            foreach ($party->ownFields as $field) {
                if ($request->{$field}) {
                    $party->{$field} = $request->{$field};
                }
            }
            $party->created_date = Carbon::today();
            $party->status = (int)$request->status;
            $party->created_by = Auth::user()->id;

            if($party->save()){
                return Response::json(['message' => 'Successfully Saved!', 'mode' => 'Save'], 200);
            }
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        //=============validation==========
        if(!$request->name || !$request->contact_no){
            throw new Error('Please, fill the required fields!');
        }
        //==============update=============
        $party = Party::findOrFail($request->id);
        if (count($party->ownFields) > 0) {
            foreach ($party->ownFields as $field) {
                if ($request->{$field}) {
                    $party->{$field} = $request->{$field};
                }
            }
            $party->created_date = Carbon::today();
            $party->status = (int)$request->status;
            $party->created_by = Auth::user()->id;

            if($party->save()){
                return Response::json(['message' => 'Successfully Updated!', 'mode' => 'Update'], 200);
            }
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete($id)
    {
        $bank = Party::findOrFail($id);
        if ($bank->delete()){
            return Response::json(['message' => 'Successfully Deleted!', 'mode' => 'Delete'], 200);
        }
    }
}
