<?php

namespace App\Http\Controllers\Site\AssessmentResult;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicAssessmentCombineResultType;
use App\Models\Academic\AcademicAssessmentPrimaryResultType;
use App\Models\Assessment\AssessmentExpertise;
use App\Models\Assessment\AssessmentResultScaleSystemSetting;
use App\Models\Assessment\AssessmentType;
use App\Models\Assessment\AssessmentTypeNo;
use App\Models\AssessmentResult\AssessmentCombineResultSetting;
use App\Models\AssessmentResult\AssessmentResultPrimarySetting;
use App\Models\Site\Assessment\SiteAssessmentDeclare;
use App\Models\Site\Assessment\SiteAssessmentDeclareStudent;
use App\Models\Site\Assessment\SiteAssessmentDeclareStudentSubject;
use App\Models\Site\Assessment\SiteIndividualCombineSubjectAssessmentResultStore;
use App\Models\Site\AssessmentResult\SiteStudentAssessmentResultDetail;
use App\Models\Site\AssessmentResult\SiteAssessmentResultPrimarySetting;
use App\Models\Site\AssessmentResult\SiteStudentAssessmentCombineFinalResultDetail;
use App\Models\Site\AssessmentResult\SiteStudentAssessmentPrimaryResultDetail;
use App\Models\Student\StudentHistory;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use Response;
use Session;

class SiteBaseAssessmentFinalResultGenerateController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
    }

    public function index()
    {
        $viewType = 'Assessment Final Result';
        return view('default.admin.layouts.master', compact('viewType'));
    }

 

    public function getAssessmentFianlGeneratedList(Request $request){

      
        $data = $request->all();

        $student_history_ids = StudentHistory::where('academic_version_id', $request->academic_version_id)
        ->where('academic_year_id', $request->academic_year_id)
        ->where('academic_shift_id', $request->academic_shift_id)
        ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
            return $query->where('academic_department_id', $data['academic_department_id']);
        })
        ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
            return $query->where('academic_class_id', $data['academic_class_id']);
        })
        ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
            return $query->where('academic_class_group_id', $data['academic_class_group_id']);
        })
        ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
            return $query->where('academic_session_id', $data['academic_session_id']);
        })
//       ->where('status', true)
        ->pluck('id');



        $result_primary_type_ids = SiteStudentAssessmentPrimaryResultDetail::whereIn('student_history_id', $student_history_ids)
            ->pluck('academic_assessment_result_primary_type_id')
            ->unique()
            ->filter();
          //  dd($result_primary_type_ids);
       
        $primary_type_ids =  AssessmentCombineResultSetting::where('status', true)
            ->whereIn('academic_assessment_result_primary_type_id',$result_primary_type_ids)
            ->pluck('academic_assessment_result_primary_type_id')
            ->unique();

        $primary_result_type =  AcademicAssessmentCombineResultType::whereIn('id',$primary_type_ids)->get();

          
          $test_arr=Array();
          $resultlist=[];
          foreach ($primary_result_type as $key => $value){
  
              $check_result_present=SiteStudentAssessmentPrimaryResultDetail::whereIn('student_history_id', $student_history_ids)
                  ->where('academic_assessment_result_primary_type_id', $value->id)
                  ->pluck('id');

  
              if(count($check_result_present)>0){
                  $test_arr['result_generate_status']=true;
              }
              else{
                  $test_arr['result_generate_status']=false;
              }
  
  
              $check_result__publish_emp_panel=SiteStudentAssessmentPrimaryResultDetail::whereIn('student_history_id', $student_history_ids)
                  ->where('academic_assessment_result_primary_type_id', $value->id)
                  ->where('result_employee_publish_status', true)
                  ->first();
  
              $check_result_publish_std_panel=SiteStudentAssessmentPrimaryResultDetail::whereIn('student_history_id', $student_history_ids)
                  ->where('academic_assessment_result_primary_type_id', $value->id)
                  ->where('result_student_publish_status', true)
                  ->first();
  
              $check_result_publish_public=SiteStudentAssessmentPrimaryResultDetail::whereIn('student_history_id', $student_history_ids)
                  ->where('academic_assessment_result_primary_type_id', $value->id)
                  ->where('result_public_publish_status', true)
                  ->first();
  
              if($check_result__publish_emp_panel){
                  $test_arr['result_employee_publish_status']=true;
              }else{
                  $test_arr['result_employee_publish_status']=false;
              }
  
  
              if($check_result_publish_std_panel){
                  $test_arr['result_student_publish_status']=true;
              }else{
                  $test_arr['result_student_publish_status']=false;
              }
  
              if($check_result_publish_public){
                  $test_arr['result_public_publish_status']=true;
              }else{
                  $test_arr['result_public_publish_status']=false;
              }
  
  
  
              $test_arr['loading_result_generate_image']=false;
  
              $resultlist[$key]=array_merge($test_arr, $value->toArray());
          }
          
          return $resultlist;
          
    }


    public function createUpdateAssessmentFinalResult(Request $request){

        $data=$request->all();

        $resultSettingList = AssessmentCombineResultSetting::where('academic_assessment_result_combine_type_id', $request->academic_assessment_result_combine_type_id)->get();

        $primary_type_ids=$resultSettingList->pluck('academic_assessment_result_primary_type_id');

        $student_list_ids = StudentHistory::where('academic_version_id', $request->academic_version_id)
                ->where('academic_year_id', $request->academic_year_id)
                ->where('academic_shift_id', $request->academic_shift_id)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->where('status', true)
                ->pluck('id');

   
        $assessmentResultList=SiteStudentAssessmentPrimaryResultDetail::whereIn('academic_assessment_result_primary_type_id',$primary_type_ids)
                ->whereIn('student_history_id',$student_list_ids)
                ->get();

        $assessment_type_ids=$assessmentResultList->pluck('assessment_type_id')->unique()->filter();

        foreach($assessment_type_ids as $assessment_type_id){

            
        $studentIdsList=$assessmentResultList->where('assessment_type_id',$assessment_type_id)
                ->pluck('student_history_id')
                ->unique()
                ->filter();
             
        $generateStudentRest=array_diff($studentIdsList->toArray(), $request->select_student_history_ids);

        if(count($generateStudentRest)>0){
            $tenStudentIDs=collect($generateStudentRest)->take(10);
        }else{
            $tenStudentIDs=[];
        }
       

        $generatedStudentIDs=array_merge($tenStudentIDs->toArray(), $request->select_student_history_ids);

        $classAllStudentlist=StudentHistory::whereIn('id', $studentIdsList)->pluck('id');

      
   
        foreach($classAllStudentlist as $key=>$student_history_id){

           $studentResultList = $assessmentResultList->where('student_history_id', $student_history_id)
                ->where('assessment_type_id',$assessment_type_id);
        
                $all_type_no_result_array=[];
                $key=0;

                foreach($studentResultList as $primaryResult){
                    foreach($primaryResult->result_details as $subject_result){

                        foreach($subject_result['type_no_list'] as $type_no){
                            $all_type_no_result_array[]=$type_no;
                            $key++;

                        }

                    }
                  
                }

                $expertise_id_list=collect($all_type_no_result_array)
                    ->pluck('expertise_id')
                    ->unique()
                    ->filter();
                 //   dd($expertise_ids);

               // if($assessment_type_id==2){
                    $ew_expertise_list=[];
                    $ew_keysss=0;
                    foreach($expertise_id_list as $exp_id){
                       
                        $expertise_data_list=collect($all_type_no_result_array)
                            ->where('expertise_id',$exp_id)
                            ->where('assessment_type_no_subject_total_mark','!=',null);
                          

                        $assessmentExpertise=AssessmentExpertise::where('id',$exp_id)->first();

                        //========= formula and scale use
                        $total_type_nos=count($expertise_data_list);
                        $highest_type_nos=count($expertise_data_list->where('assessment_type_no_subject_total_mark','triangle'));
                        $lowest_type_nos=count($expertise_data_list->where('assessment_type_no_subject_total_mark','rectangle'));

                    $expsertise_lavel_factor = (($highest_type_nos-$lowest_type_nos)/$total_type_nos)*100;

                        $scale_setting=AssessmentResultScaleSystemSetting::with('assessmentScale')
                                ->where('level_from', '<=', ceil($expsertise_lavel_factor) )
                                ->Where('level_to', '>=', ceil($expsertise_lavel_factor))
                                ->first();
            
                                $ew_expertise_list[$ew_keysss]['expertise_name']=$assessmentExpertise->name;
                                $ew_expertise_list[$ew_keysss]['expertise_description']=$assessmentExpertise->description;
                                $ew_expertise_list[$ew_keysss]['graph_level']=$scale_setting->graph_level;
                                $ew_expertise_list[$ew_keysss]['pass_fail_status']=$scale_setting->pass_fail_status;
                                $ew_expertise_list[$ew_keysss]['expertise_level']=$scale_setting->assessmentScale->name;

                                $ew_keysss++;
                    }

                 //   dd($ew_expertise_list);
                   
              //  }

             
                $site_subject_group_condition_setting_ids=collect($all_type_no_result_array)
                    ->pluck('site_subject_group_condition_setting_id')
                    ->unique()
                    ->filter();
   
                 //   dd($site_subject_group_condition_setting_ids);
              
                $subject_array=[];
                $s_key=0;
                foreach($site_subject_group_condition_setting_ids as $subject_condition_id){
                   
                    $subject_type_no_list=collect($all_type_no_result_array)
                            ->where('site_subject_group_condition_setting_id',$subject_condition_id);

                    $expertise_ids=$subject_type_no_list->pluck('expertise_id')->unique()->filter();

                    $expertise_list=[];
                    $e_key=0;
                    foreach($expertise_ids as $expertise_id){

                        $expertise_data_list=$subject_type_no_list
                                ->where('expertise_id',$expertise_id)
                                ->where('assessment_type_no_subject_total_mark','!=',null);

                        $assessmentExpertise=AssessmentExpertise::where('id',$expertise_id)->first();

                        //========= formula and scale use
                        $total_type_nos=count($expertise_data_list);
                        $highest_type_nos=count($expertise_data_list->where('assessment_type_no_subject_total_mark','triangle'));
                        $lowest_type_nos=count($expertise_data_list->where('assessment_type_no_subject_total_mark','rectangle'));

                       $expsertise_lavel_factor = (($highest_type_nos-$lowest_type_nos)/$total_type_nos)*100;

                        $scale_setting=AssessmentResultScaleSystemSetting::with('assessmentScale')
                                ->where('level_from', '<=', ceil($expsertise_lavel_factor) )
                                ->Where('level_to', '>=', ceil($expsertise_lavel_factor))
                                ->first();
                            
                        $expertise_list[$e_key]['expertise_name']=$assessmentExpertise->name;
                        $expertise_list[$e_key]['expertise_description']=$assessmentExpertise->description;
                        $expertise_list[$e_key]['graph_level']=$scale_setting->graph_level;
                        $expertise_list[$e_key]['pass_fail_status']=$scale_setting->pass_fail_status;
                        $expertise_list[$e_key]['expertise_level']=$scale_setting->assessmentScale->name;
                        //=====
                        $e_key++;
                    }

                    $subject_array[$s_key]['site_subject_group_condition_setting_id']=$subject_condition_id;
                    $subject_array[$s_key]['expertise_list']=$expertise_list;

                    $s_key++;

            }

     //       dd($subject_array);

            
            $primaryResult = SiteStudentAssessmentCombineFinalResultDetail::where('student_history_id',$student_history_id)
                ->where('academic_assessment_result_combine_type_id',$request->academic_assessment_result_combine_type_id)
                ->where('assessment_type_id',$assessment_type_id)
                ->first();

            if($assessment_type_id==1){
                $result_type_key='PI';
            }else{
                $result_type_key='BI';
            }


            if($primaryResult){

                $primaryResult->result_details=json_encode($subject_array);
                $primaryResult->expertise_wise_result_details=json_encode($ew_expertise_list);
                $primaryResult->status=true;
                $primaryResult->save();
            }else{

                SiteStudentAssessmentCombineFinalResultDetail::create([
                    'site_id'=>Session::get('SITE_ID'),
                    'student_history_id'=>$student_history_id,
                    'assessment_type_id'=>$assessment_type_id,
                    'academic_assessment_result_combine_type_id'=>$request->academic_assessment_result_combine_type_id,
                    'result_details'=>json_encode($subject_array),
                    'expertise_wise_result_details'=>json_encode($ew_expertise_list),
                    'result_type_key'=>$result_type_key,
                    'status'=>true,
                ]);

            }

    
        }
        }


        $count_student=count($classAllStudentlist);
        $completed_percent=ceil(count($generatedStudentIDs)*100/$count_student);


        if(count($tenStudentIDs)>0){

            return response()->json(
                [
                    'generatedStudentIDs'=>$generatedStudentIDs,
                    'count_student'=>$count_student,
                    'completed_percent'=>$completed_percent,
                ]);

        }else{
            return Response::json(['message' => 'information Save Successfully!', 'mode' => 'Saved!'], 200);
        }





    }
    


    public function publishPauseAssessmentResultToPanel(Request $request){

        $data = $request->all();

        $student_list_ids = StudentHistory::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
//                ->where('status', true)
            ->pluck('id');


        SiteStudentAssessmentResultDetail::whereIn('student_history_id', $student_list_ids)
            ->where('assessment_declare_id', $request->assessment_declare_id)
            ->update([
                'result_employee_publish_status'=>$request->result_employee_publish_status,
                'result_student_publish_status'=>$request->result_student_publish_status,
                'result_public_publish_status'=>$request->result_public_publish_status,
            ]);


        if($request->result_employee_publish_status && $request->result_student_publish_status){
            return Response::json(['message' => 'Result Published to Employee & Student Panel Successfully!', 'mode' => 'Saved!'], 200);
        }
        else if(!$request->result_employee_publish_status && $request->result_student_publish_status){
            return Response::json(['message' => 'Result Pause to Employee & Published to Student Panel Successfully!', 'mode' => 'Saved!'], 200);
        }
        else if($request->result_employee_publish_status && !$request->result_student_publish_status){
            return Response::json(['message' => 'Result Published to Employee & Pause to Student Panel Successfully!', 'mode' => 'Saved!'], 200);
        }
        else if(!$request->result_employee_publish_status && !$request->result_student_publish_status){
            return Response::json(['message' => 'Result Pause to Employee & Student Panel Successfully!', 'mode' => 'Saved!'], 200);
        }
        else if($request->result_public_publish_status){
            return Response::json(['message' => 'Result Published to public', 'mode' => 'Saved!'], 200);
        }
        else if(!$$request->result_public_publish_status){
            return Response::json(['message' => 'Result Pause to public', 'mode' => 'Saved!'], 200);
        }


    }


    public function deleteAssessmentResultToPanel(Request $request){
        $data = $request->all();

        $student_list_ids = StudentHistory::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
//                ->where('status', true)
            ->pluck('id');

           // dd($request->all());

        // SiteStudentAssessmentResultDetail::whereIn('student_history_id', $student_list_ids)
        //     ->where('assessment_declare_id', $request->assessment_declare_id)
        //     ->update([
        //         'result_employee_publish_status'=>0,
        //         'result_student_publish_status'=>0,
        //         'result_public_publish_status'=>0,
        //     ]);

        return Response::json(['message' => 'Assessment result Delete ', 'mode' => 'Saved!'], 200);

    }

}