<?php

namespace App\Http\Controllers\Site\Birthday;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Site\Employee\Employee;
use App\Models\Site\Employee\SiteEmployeBirthdaySetting;
use Carbon\Carbon;

class SiteEmployeeBirthdayController extends Controller
{

    private $Employees;
    private $SiteEmployeBirthdaySetting;
    public function __construct(Employee $Employee, SiteEmployeBirthdaySetting $SiteEmployeBirthdaySetting)
    {
        $this->middleware('auth');

        $this->Employees = $Employee;
        $this->SiteEmployeBirthdaySetting = $SiteEmployeBirthdaySetting;
    }
    public function index()
    {
        $viewType = 'Employee Birthdaylist List';
        return view('default.admin.layouts.master', compact('viewType'));
    }
    public function siteGetEmployeeBirthdaySettngsStore(Request $request)
    {
        $site_id = session()->get('SITE_ID');
        $status = $request->status;
        $message = $request->message;
        $SiteEmployeBirthdaySetting =  $this->SiteEmployeBirthdaySetting->first();
        if ($SiteEmployeBirthdaySetting) {
            $SiteEmployeBirthdaySetting->status = $status;
            $SiteEmployeBirthdaySetting->message = $message;
            $SiteEmployeBirthdaySetting->site_id = $site_id;
            $SiteEmployeBirthdaySetting->save();
        } else {
            $SiteEmployeBirthdaySetting = new SiteEmployeBirthdaySetting();
            $SiteEmployeBirthdaySetting->status = $status;
            $SiteEmployeBirthdaySetting->message = $message;
            $SiteEmployeBirthdaySetting->site_id = $site_id;
            $SiteEmployeBirthdaySetting->save();
        }
        return $this->SiteEmployeBirthdaySetting->get();
    }
    public function siteGetEmployeeBirthdayList(Request $request)
    {
        $paginate = $request->paginate;
        $search_txt = $request->search_txt;
        $txt = '%' . $search_txt . '%';
        $selectedMonth = $request->selectedMonth;






        try {
            $employees = $this->Employees->select('id', 'username', 'designation_id', 'contact_number', 'date_of_birth')
                ->whereRaw('MONTH(date_of_birth) = ?', [$selectedMonth])
                ->when($search_txt, function ($q) use ($txt) {
                    return $q->where(function ($query) use ($txt) {
                        $query->where('username', 'LIKE', $txt)
                            ->orWhere('email', 'LIKE', $txt)
                            ->orWhere('contact_number', 'LIKE', $txt)
                            ->orWhereTranslationLike('first_name', $txt)
                            ->orWhereTranslationLike('last_name', $txt);
                    });
                })
                ->orderBy('employee_serial', 'ASC')
                ->where('status', true)
                ->paginate($paginate);

             $employees->getCollection()->transform(function ($employee) {
                $dateOfBirth = Carbon::parse($employee->date_of_birth);
                $employee->designation_name = $employee->designation ? $employee->designation->name   : null;
                $employee->birthday    =  $dateOfBirth->format('d F Y');
                return $employee;
            });

            return response()->json(['employees' => $employees]);
        } catch (\Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }
}
