<?php

namespace App\Http\Controllers\Site;

use App\Models\Site\SiteInfo;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use App\Models\Academic\AcademicClass;
use App\Models\Site\SiteClassSimilarity;
use Response;

class ClassSimilarityController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     *
     *   */
    private $siteClassSimilarity;

    public function __construct(SiteClassSimilarity $siteClassSimilarity)
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
        $this->siteClassSimilarity = $siteClassSimilarity;
    }

    public function index()
    {
        $viewType = 'Class Similarities List';


        return view('default.admin.class-similarity.index', compact('viewType'));
    }


    public function  getSiteClassSimilaritiesList()
    {

$classSimilar=$this->siteClassSimilarity->with(['academicClass','classSimilarity'])->get();
        return $classSimilar;
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $validatedRequest)
    {
        $this->validate($validatedRequest, [
            'similar_class_id' => 'required|different:academic_class_id',

        ]);


        $this->siteClassSimilarity->academic_class_id = $validatedRequest->get('academic_class_id');
        $this->siteClassSimilarity->similar_class_id = $validatedRequest->get('similar_class_id');
        $this->siteClassSimilarity->status = $validatedRequest->get('status');

        if ($this->siteClassSimilarity->save()) {

            return Response::json(['message' => 'Save Successfully!']);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $this->validate($request, [
            'similar_class_id' => 'required|different:academic_class_id',

        ]);

        $siteClassSimilarity =  $this->siteClassSimilarity->findOrFail($id);

        $siteClassSimilarity->update([
            'academic_class_id'=>$request->get('academic_class_id'),
            'similar_class_id'=>$request->get('similar_class_id'),
            'status'=>$request->get('status'),
        ]);

        return Response::json(['message' => 'Site Class Similarity Successfully Updated!']);

    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $siteclasssimiliarityToDelete = $this->siteClassSimilarity->findOrFail($id);

        $siteclasssimiliarityToDelete->delete();
        return Response::json(['message' => 'Site Class Similiarity Successfully Deleted!']);
    }

}
