<?php

namespace App\Http\Controllers\Site\Employee\Attendance;


use App\Models\AcademicYear\AcademicYear;
use App\Models\Edu\Device\DeviceLog;
use App\Models\Site\Employee\Employee;
use App\Models\Site\Academic\SitePeriodTypeDuration;
use App\Models\Site\Employee\EmployeeAttendance;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Traits\Site\Leave\Employee\LeaveFunction;
use App\Traits\SmsFunctionsTrait;
use Auth;
use DateInterval;
use DatePeriod;
use DateTime;
use Error;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Forms\DataHelper;
use App\Models\Setting\Setting;
use App\Models\User\User;
use App\Models\Academic\AcademicShift;
use App\Models\Edu\Issue\IssueDetail;
use App\Models\Site\Employee\EmployeeGeolocationSetting;
use App\Models\Site\Employee\GlobalEmployeeAttendance;
use App\Models\Site\Employee\GlobalEmployeeShift;
use App\Models\Site\GlobalSiteShiftDetails;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use Carbon\Carbon;
use Exception;
use App\Models\Site\SiteShiftDetails;
use App\Traits\Device\OrganizeSavedDeviceLogTrait;
use Response;
use Session;
use PDF;
use DB;
use App\Traits\RequestHandlingWithMachine;
use App\Traits\Site\Attendance\AttendanceRequestSave;
use App\Traits\Site\Duty\Employee\DutyFunction;

class EmployeeAttendanceController extends Controller
{
    use  DataHelper,LeaveFunction, DutyFunction;

    use AttendanceRequestSave;

    use RequestHandlingWithMachine, OrganizeSavedDeviceLogTrait;

    private $carbon_now;

    private $employeeAttendance;
    private $studentAttendance;

    private $setting;
    private $user;
    private $siteShiftDetails;
    private $employee;
    private $periodTypeDuration;
    private $deviceLog;
    private $siteInfo;


    public function __construct(EmployeeAttendance $employeeAttendance, Setting $setting, User $user, Employee $employee, SitePeriodTypeDuration $periodTypeDuration,
    GlobalSiteShiftDetails $siteShiftDetails, DeviceLog $deviceLog, SiteInfo $siteInfo)
    {

        $this->middleware('auth');
        $this->middleware('sitepagechecker');


        $this->carbon_now = Carbon::now();
        $this->employeeAttendance = $employeeAttendance;
        $this->setting = $setting;
        $this->user = $user;
        $this->periodTypeDuration = $periodTypeDuration;
        $this->siteShiftDetails = $siteShiftDetails;
        $this->employee = $employee;
        $this->deviceLog = $deviceLog;
        $this->siteInfo = $siteInfo;


    }


    public function index()
    {
        $viewType = 'Employee Attendance List';
        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.site.employee.attendance.view-employee-attendance', compact('viewType'));
    }

    public function employeeIndividualAttendanceMaster()
    {


        $date = Carbon::now()->toDateString();
        $id = Auth::user()->id;

        $data = EmployeeAttendance::where('user_id', $id)->orderBy('id', 'DESC')->paginate(30);

        $viewType = 'Employee Attendance List';
        return view('default.admin.layouts.master', compact('viewType'));

        return view('default.site.employee.attendance.individual-employee-attendance', compact('viewType', 'data'));
    }
    public function getIndividualAttendance(Request $request)
    {


        $date = $request->attendance_date ?? Carbon::now()->toDateString();
        $id = Auth::user()->id;
        $paginate=$request->paginate ?? 20;

        $emp_att_list = $this->employeeAttendance
        ->where('user_id', $id)
            ->orderBy('id', 'DESC')
           // ->where('present_day', $date)
            ->paginate($paginate);



        $emp_att_list->getCollection()->transform(function ($emp_att) {

            return [

                'user_id' => $emp_att->user_id ?? 0,
                'full_name' => $emp_att->employee->full_name ?? 'n/a',
                'contact_number' => $emp_att->employee->contact_number ?? 'n/a',
                'date' => $emp_att->present_date ?? 'n/a',
                'in_time' => $emp_att->in_time ?? null,
                'out_time' => $emp_att->out_time ?? null,
                'status' => $emp_att->late_status ? 'Late' : 'Intime',
            ];
        });



       return response()->json($emp_att_list,200);
    }

    public function index1()
    {
        try {

            /*  $month_id = $request->month_id;
              $acc_shift_id = $request->acc_shift_id;*/

            $year = 4;// $request->acc_shift_id;
            $the_acc_year = AcademicYear::findOrFail($year);


            $att_type = 2;// emp wise
            $emp_id = 795;// emp wise
            $start_date = '2019-08-01';
            $end_date = $the_acc_year->end_date;
            $acc_shift_id = 1;// $request->acc_shift_id;


            $site = $this->siteInfo->findOrFail(Session::get('SITE_ID'));

            $sl = 0;


            $data = [];
            $employee_full_name = '';


            if ($att_type == 2) {//all month wise


                $report_tittle = 'Employee Date and Shift Attendance Report';

                //dd($the_acc_year->start_date);


                $start = new DateTime($start_date);
                $start->modify('first day of this month');
                $end = new DateTime($end_date);
                $end->modify('first day of next month');
                $interval = DateInterval::createFromDateString('1 month');
                $period = new DatePeriod($start, $interval, $end);


                $employee_full_name = $this->employee
                        ->where('id', $emp_id)
                        ->first()->full_name ?? '';


                $sl = 0;

                foreach ($period as $key => $dt) {

                    $year = $dt->format("Y");
                    $month = $dt->format("m");


                    //  dd($year,$month);


                    $attendances = $this->employeeAttendance
                        /*   ->whereHas('shiftDetail',function ($query)use ($acc_shift_id) {
                               $query->where('academic_shift_id', $acc_shift_id);
                           })*/
                        ->where('user_id', $emp_id)
                        ->where('present_year', $year)
                        ->where('present_month', $month)
                        ->get();

                    //   dd($attendances);


                    $total_class = 100;

                    $attendances_count = $attendances->count();
                    $absent_count = ($total_class - $attendances_count);
                    $leave_count = $attendances->count();
                    $late_count = $attendances->where('late_status', 1)->count();


                    //   dd($emp_count);


                    $data[$sl]['total_class'] = $total_class;
                    $data[$sl]['total_present'] = $attendances_count;
                    $data[$sl]['total_absent'] = $absent_count ?? 'n/a';
                    $data[$sl]['total_leave'] = 0 ?? 'n/a';
                    $data[$sl]['total_late'] = $late_count ?? 'n/a';
                    $data[$sl]['year'] = $year;
                    $data[$sl]['month'] = $month;

                    $sl++;

                }

                //  dd($data);

                $pdf = PDF::loadView('default.admin.site.employee.attendance.report.emp-yearly-report', compact('employee_full_name', 'start_date', 'end_date', 'report_tittle', 'data', 'site'));
                return $pdf->stream(time() . '-routine.pdf');


            } elseif ($att_type == 2) {


                $employee_full_name = $this->employee
                        ->where('id', $emp_id)
                        ->first()->full_name ?? '';


                $begin = new DateTime($start_date);
                $end = new DateTime($end_date);

                $interval = DateInterval::createFromDateString('1 day');
                $period = new DatePeriod($begin, $interval, $end);


                foreach ($period as $key => $dt) {

                    $date = $dt->format("Y-m-d");


                    $emp_attendances_check = $this->employeeAttendance
                        ->where('user_id', $emp_id)
                        ->where('present_date', $date)
                        ->first();

                    if ($emp_attendances_check) {
                        $data[$sl]['data'] = $emp_attendances_check;
                        $data[$sl]['date'] = $date;
                        $data[$sl]['type'] = $emp_attendances_check;
                    } else {
                        $data[$sl]['data'] = null;
                        $data[$sl]['date'] = $date;
                        $data[$sl]['type'] = 'Absent';

                    }


                    $sl++;




                }




                $report_tittle = 'Employee Date and Shift Attendance Report';


                if (count($data) < 1) {
                    return Response::json(['message' => 'No Data Found For The Criteria'], 410);
                }


            }


            $pdf = PDF::loadView('default.admin.site.employee.attendance.report.month-wise-report', compact('start_date', 'end_date', 'employee_full_name', 'report_tittle', 'data', 'site'));
            return $pdf->stream(time() . '-routine.pdf');


            $path = storage_path() . '/pdf';

            $time = Auth::user()->id . '-' . Carbon::now()->unix();

            $pdf = PDF::loadView('default.admin.site.employee.attendance.report.month-wise-report', compact('month_name', 'year', 'report_tittle', 'emp_list', 'site'));


            $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');


            $name = $time . '.pdf';

            return Response::json(['message' => $name], 200);


        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);
        }

    }


    public function getShiftList()
    {
        $site_academic_class_shift_ids_list = SiteInfoSetting::select('shift_ids')->first();

        $site_academic_shift_ids_list_split = explode(',', $site_academic_class_shift_ids_list->shift_ids);

        $site_academic_shift_list = AcademicShift::whereIn('id', $site_academic_shift_ids_list_split)->get();


        return response()->json($site_academic_shift_list, 200, []);
    }

    public function getAllEmployeeAttendanceListByShiftDate(Request $request)
    {

        try {


            $att_date = $request->att_date;
            $acc_shift_id = $request->acc_shift_id;
            $att_type = $request->att_type;
            $username = $request->username;

            // throw  new Error($att_date);

            $advance_date = ($this->carbon_now->toDateString() < $att_date);

            if ($advance_date) {
                throw new Error('The attendance date cant be future date!');
            }

            $final_emp = $this->employeeAttendanceListByShiftDate($att_type, $att_date, $acc_shift_id, $username);

            return response()->json([$final_emp], 200, []);

        } catch (Exception $exception) {
            return response()->json($exception->getMessage(), 411, []);

        }

    }


    public function employeeAttendanceListByShiftDate($att_type, $att_date, $acc_shift_id, $username = '')
    {
        try {
            $day = date('D', strtotime($att_date));

            $st_list = null;
            $final_emp = [];
            $previous_att_total = 0;
            $total_in_leave = 0;
            $total_absent = 0;




             $get_period_type_duration = $this->periodTypeDuration
                ->where('start_date', '<=', $att_date)
                ->where('end_date', '>=', $att_date)
                ->first();


            if (!$get_period_type_duration) {
                throw new Error('No Period Found On ' . $att_date);
            }

            if ($att_type == '1') {

                if (!$att_date || !$acc_shift_id) {
                    throw new Error('Select * Marked Fields!');
                }


                $emp_shift_details = $this->siteShiftDetails
                    ->where('academic_shift_id', $acc_shift_id)
                    ->where('belongs_to', 'employee')
                    ->where('academic_period_type_id', $get_period_type_duration->academic_period_type_id)
                    ->where('week_day', $day)
                    ->where('site_id', Session::get('SITE_ID'))
                    ->where('status', true)
                    ->where('day_on', true)
                    ->first();


                if (!$emp_shift_details) {
                    throw  new Error("No Shift Details Found For:" . $day . " Shift:" . $acc_shift_id . " Period Type:" . $get_period_type_duration);
                }

                $shift_att_found = $this->employeeAttendance
                    ->where('present_date', $att_date)
                    ->where('site_shift_details_id', $emp_shift_details->id)
                    ->where(function ($query) {
                        $query->where('present_type', 'device')
                            ->orWhere('present_type', 'web');
                    })
                    ->first();
                    //dd($shift_att_found);

                if ($shift_att_found) {


                    $emp_list = $this->employee->with(['attendance' => function ($query) use ($att_date, $shift_att_found) {
                        $query->where('present_date', $att_date)
                            ->where('site_shift_details_id', $shift_att_found->site_shift_details_id);
                        }])
                        ->whereHas('empShifts', function ($q) use ($acc_shift_id) {
                            $q->where('academic_shift_id', $acc_shift_id)
                                ->whereNull('release_date');

                        })
                        ->select(['id', 'username', 'contact_number'])
                        ->where('status', 1)
                        ->orderBy('employee_serial', 'ASC')
                        ->get();


                    if (count($emp_list) > 0) {

                        $emp_shift_detail = $this->siteShiftDetails
                            ->where('id', $shift_att_found->site_shift_details_id)
                            ->where('site_id', Session::get('SITE_ID'))
                            ->first();
                       //     dd($emp_shift_detail);

                        $previous_att = $this->employeeAttendance
                            ->where('present_date', $att_date)
                            ->where('site_shift_details_id', $emp_shift_detail->id)
                            ->get();

                        $previous_att_total = count($previous_att);

                        foreach ($emp_list as $key => $value) {

                            $emp_att = $previous_att
                                ->where('user_id', $value->id)
                                ->first();

                            if ($emp_att) {

                                $final_emp[$key] = $value;
                                $final_emp[$key]['contact_number'] = $value->contact_number ?? 'n/a';

                                $final_emp[$key]['attendance_id'] = $emp_att->id;
                                $final_emp[$key]['site_shift_details_id'] = $emp_att->site_shift_details_id;

                                $final_emp[$key]['in_sms_id'] = $emp_att->in_sms_id;
                                $final_emp[$key]['in_sms_sending'] = false;
                                $final_emp[$key]['out_sms_id'] = $emp_att->out_sms_id;
                                $final_emp[$key]['out_sms_sending'] = false;

                                $final_emp[$key]['in_time'] = $emp_att->in_time ?? $shift_att_found->site_shift_details_id;
                                $final_emp[$key]['out_time'] = $emp_att->out_time ?? $emp_shift_detail->out_time;
                                $final_emp[$key]['present_date'] = $emp_att->present_date;
                                $final_emp[$key]['present_type'] = $emp_att->present_type;
                                $final_emp[$key]['late_status'] = $emp_att->late_status;
                                $final_emp[$key]['present'] = true;

                            } else {

                                $is_in_leave = $this->getEmployeeInLeave($value->id, $att_date);

                                $att_condition = false;

                                if ($is_in_leave) {
                                    $att_condition = 'leave';
                                }else{
                                    $is_in_duty = $this->getEmployeeInDuty($value->id, $att_date);
                                    $att_condition = false;
                                    if ($is_in_duty) {
                                        $att_condition = 'duty';
                                    }
                                }

                                $final_emp[$key] = $value;
                                $final_emp[$key]['contact_number'] = $value->contact_number ?? 'n/a';

                                $final_emp[$key]['attendance_id'] = null;
                                $final_emp[$key]['site_shift_details_id'] = $shift_att_found->site_shift_details_id;

                                $final_emp[$key]['in_sms_id'] = null;
                                $final_emp[$key]['in_sms_sending'] = false;
                                $final_emp[$key]['out_sms_id'] = null;
                                $final_emp[$key]['out_sms_sending'] = false;


                                $final_emp[$key]['in_time'] = $shift_att_found->in_time;
                                $final_emp[$key]['out_time'] = $emp_shift_detail->out_time;
                                $final_emp[$key]['present_date'] = $att_date;
                                $final_emp[$key]['present_type'] = null;

                                $final_emp[$key]['late_status'] = false;
                                $final_emp[$key]['present'] = $att_condition;
                            }
                        }

                        return [$final_emp, $previous_att_total];
                    }

                    throw new Error('No Employee Found!' . $att_date . ' on ' . $day);


                } else {// at least no att found for the shift


                    if (!$emp_shift_details) {
                        throw  new Error("No Shift Details Found For:" . $day . " Shift:" . $acc_shift_id . " Period Type:" . $get_period_type_duration);
                    }

                    if (!$emp_shift_details->day_on && !$emp_shift_details->att_allowed) {
                        throw new Error($att_date . ' Is off day & attendance not allowed, found in Shift Setting');
                    }


                    $emp_list = $this->employee->whereHas('empShifts', function ($q) use ($acc_shift_id) {
                        $q->where('academic_shift_id', $acc_shift_id)
                            ->whereNull('release_date');
                    })->select(['id', 'username', 'contact_number'])
                        ->where('status', 1)
                        ->orderBy('employee_serial', 'ASC')
                        ->get();


                    if (count($emp_list) > 0) {
                        foreach ($emp_list as $key => $value) {

                            $is_in_leave = $this->getEmployeeInLeave($value->id, $att_date);

                            $att_condition = false;

                            if ($is_in_leave) {
                                $att_condition = 'leave';
                            }else{
                                $is_in_duty = $this->getEmployeeInDuty($value->id, $att_date);
                                $att_condition = false;
                                if ($is_in_duty) {
                                    $att_condition = 'duty';
                                }
                            }

                            $final_emp[$key] = $value;
                            $final_emp[$key]['contact_number'] = $value->contact_number ?? 'n/a';
                            $final_emp[$key]['attendance_id'] = null;

                            $final_emp[$key]['in_sms_id'] = null;
                            $final_emp[$key]['in_sms_sending'] = false;
                            $final_emp[$key]['out_sms_id'] = null;
                            $final_emp[$key]['out_sms_sending'] = false;

                            $final_emp[$key]['site_shift_details_id'] = $emp_shift_details->id;
                            $final_emp[$key]['in_time'] = $emp_shift_details->in_time;
                            $final_emp[$key]['out_time'] = null;
                            $final_emp[$key]['late_status'] = false;
                            $final_emp[$key]['present_date'] = $att_date;
                            $final_emp[$key]['present_type'] = null;

                            $final_emp[$key]['present'] = $att_condition;
                        }
                    }
                }
            } elseif ($att_type == '2') {//username wise

                if (!$att_date || $username == '') {
                    throw new Error('Select * Marked Fields!' . $username);
                }

                $the_emp = $this->employee
                    ->whereHas('empShifts', function ($q) {
                        $q->whereNull('release_date');
                        $q->orderBy('id', 'DESC');
                    })
                    ->where('username', $username)
                    ->select(['id', 'username', 'contact_number'])
                    ->first();

                $emp_shift_id = $the_emp->empShifts[0]->academic_shift_id ?? 0;

                if (!$emp_shift_id) {
                    throw new Error('The employee has no shift assigned!');
                }


                $shift_att_found = $this->employeeAttendance
                    ->where('present_date', $att_date)
                    ->where('user_id', $the_emp->id)
                    ->first();

                $key = 0;
                $previous_att_total = 1;
                if ($shift_att_found) {// attendance taken previously

                    $final_emp[$key] = $the_emp;
                    $final_emp[$key]['contact_number'] = $the_emp->contact_number ?? 'n/a';

                    $final_emp[$key]['attendance_id'] = $shift_att_found->id;
                    $final_emp[$key]['site_shift_details_id'] = $shift_att_found->site_shift_details_id;

                    $final_emp[$key]['in_sms_id'] = $shift_att_found->in_sms_id;
                    $final_emp[$key]['in_sms_sending'] = false;
                    $final_emp[$key]['out_sms_id'] = $shift_att_found->out_sms_id;
                    $final_emp[$key]['out_sms_sending'] = false;

                    $final_emp[$key]['in_time'] = $shift_att_found->in_time;
                    $final_emp[$key]['out_time'] = $shift_att_found->out_time;
                    $final_emp[$key]['present_date'] = $shift_att_found->present_date;
                    $final_emp[$key]['present_type'] = $shift_att_found->present_type;

                    $final_emp[$key]['late_status'] = $shift_att_found->late_status;
                    $final_emp[$key]['present'] = true;
                } else {


                    $is_in_leave = $this->getEmployeeInLeave($the_emp->id, $att_date);

                        $att_condition = false;

                        if ($is_in_leave) {
                            $att_condition = 'leave';
                        }else{
                            $is_in_duty = $this->getEmployeeInDuty($the_emp->id, $att_date);
                            $att_condition = false;
                            if ($is_in_duty) {
                                $att_condition = 'duty';
                            }
                        }





                    $emp_shift_details = $this->siteShiftDetails
                        ->where('academic_shift_id', $emp_shift_id)
                        ->where('belongs_to', 'employee')
                        ->where('academic_period_type_id', $get_period_type_duration->academic_period_type_id)
                        ->where('week_day', $day)
                        ->where('site_id', Session::get('SITE_ID'))
                        ->where('status', true)
                        ->first();


                    if (!$emp_shift_details) {
                        throw new Error('Shift Setting Not found for the day');
                    }


                    $final_emp[$key] = $the_emp;
                    $final_emp[$key]['contact_number'] = $the_emp->contact_number ?? 'n/a';
                    $final_emp[$key]['site_shift_details_id'] = $emp_shift_details->id;


                    $final_emp[$key]['attendance_id'] = null;
                    $final_emp[$key]['site_shift_details_id'] = null;

                    $final_emp[$key]['in_sms_id'] = null;
                    $final_emp[$key]['in_sms_sending'] = false;
                    $final_emp[$key]['out_sms_id'] = null;
                    $final_emp[$key]['out_sms_sending'] = false;


                    $final_emp[$key]['in_time'] = $emp_shift_details->in_time;
                    $final_emp[$key]['out_time'] = $emp_shift_details->out_time;
                    $final_emp[$key]['present_date'] = $att_date;
                    $final_emp[$key]['present_type'] = null;

                    $final_emp[$key]['late_status'] = false;
                    $final_emp[$key]['present'] = $att_condition;
                }


            } elseif ($att_type == '3') {//only date
                //first check if attendance exist
                $att_found = $this->employeeAttendance
                ->where('present_date', $att_date)
                ->get();

                if (count($att_found) < 1) {
                    throw new Error('No attendance found for the day.');
                }


                $emp_list = $this->employee
                ->select(['id', 'username', 'contact_number'])
                ->where('status', 1)
                ->orderBy('employee_serial', 'ASC')
                ->get();
                $previous_att_total = count($att_found);


                foreach ($emp_list as $key => $value) {

                    $emp_att_found = $att_found
                        ->where('user_id', $value->id)
                        ->first();

                    if ($emp_att_found) {

                        $final_emp[$key] = $value;
                        $final_emp[$key]['contact_number'] = $value->contact_number ?? 'n/a';
                        $final_emp[$key]['attendance_id'] = null;
                        $final_emp[$key]['site_shift_details_id'] = $emp_att_found->site_shift_details_id;


                        $final_emp[$key]['in_sms_id'] = $emp_att_found->in_sms_id;
                        $final_emp[$key]['in_sms_sending'] = false;
                        $final_emp[$key]['out_sms_id'] = $emp_att_found->out_sms_id;
                        $final_emp[$key]['out_sms_sending'] = false;
                        $final_emp[$key]['attendance_id'] = $emp_att_found->id;

                        $final_emp[$key]['in_time'] = $emp_att_found->in_time;
                        $final_emp[$key]['out_time'] = $emp_att_found->out_time;
                        $final_emp[$key]['late_status'] = $emp_att_found->late_status;
                        $final_emp[$key]['present_date'] = $att_date;
                        $final_emp[$key]['present_type'] = $emp_att_found->present_type;

                        $final_emp[$key]['present'] = true;

                    } else {

                        $is_in_leave = $this->getEmployeeInLeave($value->id, $att_date);

                        $att_condition = false;

                        if ($is_in_leave) {
                            $att_condition = 'leave';
                        }else{
                            $is_in_duty = $this->getEmployeeInDuty($value->id, $att_date);
                            $att_condition = false;
                            if ($is_in_duty) {
                                $att_condition = 'duty';
                            }
                        }




                        $final_emp[$key] = $value;
                        $final_emp[$key]['contact_number'] = $value->contact_number ?? 'n/a';
                        $final_emp[$key]['attendance_id'] = null;
                        $final_emp[$key]['site_shift_details_id'] = null;

                        $final_emp[$key]['in_sms_id'] = null;
                        $final_emp[$key]['in_sms_sending'] = false;
                        $final_emp[$key]['out_sms_id'] = null;
                        $final_emp[$key]['out_sms_sending'] = false;

                        $final_emp[$key]['attendance_id'] = null;

                        $final_emp[$key]['in_time'] = null;
                        $final_emp[$key]['out_time'] = null;
                        $final_emp[$key]['late_status'] = false;
                        $final_emp[$key]['present_date'] = $att_date;
                        $final_emp[$key]['present_type'] = null;
                        $final_emp[$key]['present'] = $att_condition;

                    }

                }

            }

           // dd($final_emp[1]);

            return [$final_emp, $previous_att_total];


        } catch (Exception $exception) {
            throw new Error($exception->getMessage());

        }

    }


    public function sendSms(Request $request)
    {
        try {

            $sms_type = $request->type;
            $att_id = $request->att_id;
            $site_id = Session::get('SITE_ID');
            $name = $request->name;
            $contact_number = $request->contact_number;

            // throw new Error('Your SMS Stock Finished! Plz Purchase SMS'.$contact_number);


            $the_att = $this->employeeAttendance->findOrFail($att_id);


            $site = SiteInfo::whereId($site_id)->first();


            $sms_txt = '';
            $att_data_for_queue = [];


            if ($sms_type == 'in') {// in sms

                if (!$site->emp_in_sms) {
                    throw new Error('Please Change Option to send In SMS <a href="' . route('site-option-view-form') . '" target="_blank">Click</a>');
                }

                if (!$the_att->in_time) {
                    throw new Error('Save InTime First!');
                }


                $sms_txt = $name;
                $sms_txt .= 'nl' . 'In Time: ' . date('g:i A', strtotime($the_att->in_time));
                $sms_txt .= 'nl' . 'Attendance Date: ' . date('d-m-Y', strtotime($the_att->present_date));
                $sms_txt .= 'nl' . 'Regards: ' . $site->site_name;


                $att_data_for_queue['att_user_type'] = 'employee';
                $att_data_for_queue['att_type'] = 'in';//in or out
                $att_data_for_queue['att_table_id'] = $att_id;

                $the_att->in_sms_id = 1;
                $the_att->save();

            }


            if ($site && $sms_type == 'out') {// out sms

                if (!$site->emp_out_sms) {
                    throw new Error('Please Change Option to send In SMS');
                }

                if (!$the_att->out_time) {
                    throw new Error('Save Out Time First!');
                }

                $sms_txt = $name;
                $sms_txt .= 'nl' . 'Out Time: ' . date('g:i A', strtotime($the_att->out_time));
                $sms_txt .= 'nl' . 'Attendance Date: ' . date('d-m-Y', strtotime($the_att->present_date));
                $sms_txt .= 'nl' . 'Regards: ' . $site->site_name;

                $att_data_for_queue['att_user_type'] = 'employee';
                $att_data_for_queue['att_type'] = 'out';//in or out
                $att_data_for_queue['att_table_id'] = $att_id;

                $the_att->out_sms_id = 1;
                $the_att->save();
            }

            $this->sendAttendanceSms([$contact_number], $sms_txt, $site_id, $att_data_for_queue);
            return response()->json(['message' => 'Congrats, Employee Will Receive SMS Soon'], 200, []);

        } catch (Exception $exception) {
            return response()->json(['message' => $exception->getMessage()], 411, []);
        }

    }


    public function takeAccessTime(Request $request)
    {
        try {

            $type = $request->type;
            $access_time = $request->access_time;
            $device_log_id = $request->device_log_id;
            $attendance_id = $request->attendance_id;


            if ($attendance_id) {

                $the_att = $this->employeeAttendance->findOrFail($attendance_id);
                $the_att->{$type} = $access_time;
                $the_att->present_type = 'device';
                $the_att->save();

            } else {

                // throw new Error($site_shift_details_id);
                $get_device_log = $this->deviceLog
                    ->where('id', $device_log_id)
                    ->orderBy('access_time', 'ASC')
                    ->get();

                if (count($get_device_log) < 1) {
                    throw  new Error('Log not found!');
                }

                $saved_updated_att_ids = $this->organizeSavedDeviceLog($get_device_log);

                $emp_att_saved = count($saved_updated_att_ids[2]);

                if ($emp_att_saved < 1) {
                    throw  new Error('Attendance not saved!');

                }
            }

            return Response::json(['message' => 'Successfully Taken The Time!'], 200);


        } catch (Exception $exception) {
            throw new Error($exception->getMessage());

        }
    }


    public function updateEmployeeAttendance(Request $request)
    {

        $data = $request->employeeAttendanceList;
        $att_date = $request->att_date;
        $acc_shift_id = $request->acc_shift_id;
        $att_type = $request->att_type;

      ///===temporary condition===
     //   return Response::json(['message' => 'only for super admin!'], 410);
      ///======

        if (count($data) <= 0) {
            return Response::json(['message' => 'No Date Found!'], 410);
        }

        if ($att_type == 3) {
            return Response::json(['message' => 'You can not update date wise data!'], 410);
        }

        if (Session::get('SITE_ID')==174) {
            if ($att_type!=2) {
                return Response::json(['message' => 'only for super admin'], 410);
            }
        }else{
           // if ($att_type!=174 ) {
                return Response::json(['message' => 'only for super admin'], 410);
           // }
        }

     //   $empAttendance = new EmployeeAttendance();

        if (count($data) > 0) {
            foreach ($data as $item) {
                $check_previous_att = $this->employeeAttendance
                    ->where('user_id', $item['id'])
                    ->where('present_date', $item['present_date'])
                    ->where('site_shift_details_id', $item['site_shift_details_id'])
                    ->get();

                if (count($check_previous_att) > 0) {//previous found

                    if (count($check_previous_att) > 1) {//previous found more than 1
                        $this->employeeAttendance->delete($check_previous_att->pluck('id'));//first delete then inser new one
                    }

                    $existed = $this->employeeAttendance
                        ->where('user_id', $item['id'])
                        ->where('present_date', $item['present_date'])
                        ->where('site_shift_details_id', $item['site_shift_details_id'])
                        ->first();

                    if ($existed && $item['present']) {

                        $existed->user_id = $item['id'];
                        $existed->site_shift_details_id = $item['site_shift_details_id'];
                        $existed->in_time = $item['in_time'];
                        $existed->out_time = $item['out_time'];
                        $existed->present_date = $item['present_date'];
                        $existed->present_type = $item['present_type'];
                        $existed->present_year = date('Y', strtotime($item['present_date']));
                        $existed->present_month = date('m', strtotime($item['present_date']));
                        $existed->present_day = date('d', strtotime($item['present_date']));
                        $existed->late_status = $item['late_status'];
                        $existed->updated_by = Auth::user()->id;
                        $existed->save();

                    } elseif (!$existed && $item['present']) {

                        $this->employeeAttendance = new EmployeeAttendance();
                        $this->employeeAttendance->user_id = $item['id'];
                        $this->employeeAttendance->site_shift_details_id = $item['site_shift_details_id'];
                        $this->employeeAttendance->present_type = 'web';
                        $this->employeeAttendance->in_time = $item['in_time'];
                        $this->employeeAttendance->out_time = $item['out_time'];
                        $this->employeeAttendance->present_date = $item['present_date'];
                        $this->employeeAttendance->present_year = date('Y', strtotime($item['present_date']));
                        $this->employeeAttendance->present_month = date('m', strtotime($item['present_date']));
                        $this->employeeAttendance->present_day = date('d', strtotime($item['present_date']));
                        $this->employeeAttendance->late_status = $item['late_status'];
                        $this->employeeAttendance->created_by = Auth::user()->id;
                        $this->employeeAttendance->save();
                    } elseif ($existed && !$item['present']) {
                        $existed->delete();
                    }

                } else {//no previous att found for the day and shift and the emp
                    if ($item['present'] && $item['in_time'] != null) {

                        $this->employeeAttendance = new EmployeeAttendance();
                        $this->employeeAttendance->user_id = $item['id'];
                        $this->employeeAttendance->site_shift_details_id = $item['site_shift_details_id'];
                        $this->employeeAttendance->present_type = 'web';
                        $this->employeeAttendance->in_time = $item['in_time'];
                        $this->employeeAttendance->out_time = $item['out_time'];
                        $this->employeeAttendance->present_date = $item['present_date'];
                        $this->employeeAttendance->present_year = date('Y', strtotime($item['present_date']));
                        $this->employeeAttendance->present_month = date('m', strtotime($item['present_date']));
                        $this->employeeAttendance->present_day = date('d', strtotime($item['present_date']));
                        $this->employeeAttendance->late_status = $item['late_status'];
                        $this->employeeAttendance->created_by = Auth::user()->id;
                        $this->employeeAttendance->save();
                    }
                }
            }

            return Response::json(['message' => 'Employee Attendance Updated'], 200);

        }
    }


    public function checkEmployeeAttendanceActivity(){

        $currentDateTime = Carbon::now();
        $att_date = $currentDateTime->toDateString();
        $present_time = $currentDateTime->toTimeString();

        $year = date('Y', strtotime($att_date));
        $month = date('m', strtotime($att_date));
        $day = date('d', strtotime($att_date));
        $week_day = date('D', strtotime($att_date));
        $site_id=Session::get('SITE_ID');

        $username=Auth::user()->username;

        $get_user = Employee::whereHas('empShifts', function ($q) {
                $q->whereNull('release_date');
                $q->orderBy('id', 'DESC');
            })
            ->where('username', $username)
            ->select(['id', 'username', 'contact_number'])
            ->first();

        if(!$get_user){
            return Response::json(['message' => 'This chennel have no permission'], 410);
        }


        $empShifts = $get_user->empShifts[0];

        $emp_shift_id = $empShifts->academic_shift_id ?? 0;

        $get_period_type_duration = $this->periodTypeDuration
            ->where('start_date', '<=', $att_date)
            ->where('end_date', '>=', $att_date)
            ->first();

        $emp_shift_details = $this->siteShiftDetails
            ->where('academic_shift_id', $emp_shift_id)
            ->where('belongs_to', 'employee')
            ->where('academic_period_type_id', $get_period_type_duration->academic_period_type_id)
            ->where('week_day', $week_day)
            ->where('site_id', $site_id)
            ->where('status', true)
            ->first();

            if(!$emp_shift_details){
                return Response::json(['message' => 'You have no shift assigned!'], 410);
            }

        $data=[];

        $checkEmployeeAttendance = GlobalEmployeeAttendance::where('present_date', $att_date)
            ->where('user_id', $get_user->id)
            ->where('site_shift_details_id', $emp_shift_details->id)
            ->first();

        if($checkEmployeeAttendance){
            if($checkEmployeeAttendance->in_time){
                $data['att_in_status']=true;
            }else{
                $data['att_in_status']=false;
            }

            if($checkEmployeeAttendance->out_time){
                $data['att_out_status']=true;
            }else{
                $data['att_out_status']=false;
            }

        }else{
            $data['att_in_status']=false;
            $data['att_out_status']=false;
        }

    //    $data['att_activity_status']=$checkEmployeeAttendance;

        if($this->isAttendanceInvalid($present_time, $emp_shift_details)){
            $data['att_activity_status']=false;
        }else{
            $data['att_activity_status']=true;
        }


        return $data;


    }


    private function isAttendanceInvalid($a_time, $the_site_shift)
    {

        $in_time_allowed_min = $the_site_shift->in_time_allowed_min;

        $shift_time = strtotime($the_site_shift->in_time);//10:01:00 AM
        $given_access_time = strtotime($a_time);

        $difference = (($shift_time - $given_access_time) / 60);

        if (($in_time_allowed_min != 0 || $in_time_allowed_min != null) && $difference > 0 && ($difference > $in_time_allowed_min)) {
            return true;// in valid
        }

        return false;// valid

    }



    public function employeeGeoLocationAttendance(Request $request){

        $checkSettings=EmployeeGeolocationSetting::first();

        if(!$checkSettings){
            return Response::json(['message'=>'Undefine Settings'],410);
        }

        $latitudeCenter = $checkSettings->latitude;
        $longitudeCenter = $checkSettings->longitude;

        $radius = $checkSettings->radius;

        // ইউজারের প্রদানকৃত অবস্থান
        $latitudeFrom = $request->latitude;
        $longitudeFrom = $request->longitude;

        // $latitudeFrom = 22.3609957;
        // $longitudeFrom = 91.8098733;


        // দূরত্ব হিসাব করে ভেরিফিকেশন
        $distance = $this->calculateDistance($latitudeFrom, $longitudeFrom, $latitudeCenter, $longitudeCenter);

        if ($distance <= $radius) {
            $request_chennel='web-gps';
            $request_ip_address=$request->ip();
           return $this->saveOwnAttendance($request_chennel,$request_ip_address);
        } else {

            // check network type
            $clientIp = $request->ip();
            $networkType = 'unknown';

            if ($request->header('Network-Type')) {
                $networkType = $request->header('Network-Type');
            } elseif (filter_var($clientIp, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE) !== false) {
                $networkType = 'mobile';
            } else {
                $networkType = 'wifi';
            }

            if($networkType=='wifi'){
                return Response::json(['message' => 'The network has found that you are outside the area. You can try with mobile internet'], 410);
            }


            return response()->json(['message' => 'You are outside the area!'],410);
        }
    }

    public function employeeAttendanceByQrcode(Request $request){

      //  dd($request->ip());

        $checkSettings=EmployeeGeolocationSetting::first();

        if(!$checkSettings){
            return Response::json(['message'=>'Undefine Settings'],410);
        }

        $latitudeCenter = $checkSettings->latitude;
        $longitudeCenter = $checkSettings->longitude;

        $latitudeFrom = $checkSettings->latitude;
        $longitudeFrom = $checkSettings->longitude;

        $radius = $checkSettings->radius;

        // ইউজারের প্রদানকৃত অবস্থান
        // $latitudeFrom = $request->latitude;
        // $longitudeFrom = $request->longitude;


        // দূরত্ব হিসাব করে ভেরিফিকেশন
        $distance = $this->calculateDistance($latitudeFrom, $longitudeFrom, $latitudeCenter, $longitudeCenter);

        if ($distance <= $radius) {
            $request_chennel='qr';
            $request_ip_address=$request->ip();
            $this->saveOwnAttendance($request_chennel,$request_ip_address);

            return redirect()->route('site-employee-individual-attendance');
        } else {

            // check network type
            $clientIp = $request->ip();
            $networkType = 'unknown';

            if ($request->header('Network-Type')) {
                $networkType = $request->header('Network-Type');
            } elseif (filter_var($clientIp, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE) !== false) {
                $networkType = 'mobile';
            } else {
                $networkType = 'wifi';
            }

            if($networkType=='wifi'){
                return Response::json(['message' => 'The network has found that you are outside the area. You can try with mobile internet'], 410);
            }


            return response()->json(['message' => 'You are outside the area!'],410);
        }
    }


    function calculateDistance($latitudeFrom, $longitudeFrom, $latitudeTo, $longitudeTo, $earthRadius = 6371) {
        $latFrom = deg2rad($latitudeFrom);
        $lonFrom = deg2rad($longitudeFrom);
        $latTo = deg2rad($latitudeTo);
        $lonTo = deg2rad($longitudeTo);

        $latDelta = $latTo - $latFrom;
        $lonDelta = $lonTo - $lonFrom;

        $angle = 2 * asin(sqrt(pow(sin($latDelta / 2), 2) +
                cos($latFrom) * cos($latTo) * pow(sin($lonDelta / 2), 2)));
        return $angle * $earthRadius * 1000; // distance in meters
    }

    public function getAttendanceQrCode(){

        dd('sf');

    }


}
