<?php

namespace App\Http\Controllers\Site\Employee;


use App\Models\EmployeeGrade\EmpGrade;
use App\Forms\DataHelper;
use App\Forms\FormControll;
use App\Http\Controllers\Language\Lang;
use App\Jobs\SendSmsJob;
use App\Mail\SendMailToUserWithQueue;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicResidence;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicStudentQuata;
use App\Models\Academic\AcademicTransport;
use App\Models\BloodGroup\BloodGroup;
use App\Models\Designation\Designation;
use App\Models\Edu\Issue\IssueDetail;
use App\Models\Employee\EmployeeEducationBackground;
use App\Models\Employee\SiteCategoryPositionSetting;
use App\Models\Employee\SiteEmployeeCategoryPosition;
use App\Models\Employee\SiteEmployeeDepartmentClassSubject;
use App\Models\EmployeeCategory\EmpCategory;
use App\Models\EmploymentHistory\EmploymentHistory;
use App\Models\Examinations\Examination;
use App\Models\Gender\Gender;
use App\Models\Religion\Religion;
use App\Models\Site\Employee\Employee;
use App\Models\Site\Employee\SiteEmployeeSiteShift;
use App\Models\Site\Role\SiteRole;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use App\Models\User\EmployeeHistory;
use App\Models\User\GlobalUser;
use App\Models\User\UserForUsername;
use App\Traits\Site\UserPermission\UserAccessTrait;
use Auth;
use Carbon\Carbon;
use DateTime;
use DB;
use PDF;
use Exception;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicSubject;
use Illuminate\Support\Facades\Log;
use App\Models\Image\Photo;
use App\Models\Site\SiteGroupSetting;
use Image;
use Mail;
use Session;
use Response;

class EmployeeAttachController extends Controller
{


    use Lang, FormControll, DataHelper, UserAccessTrait;


    private $user;
    private $employee;

    private $siteInfo;


    public function __construct(Employee $user, SiteInfo $siteInfo)
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');

        $this->user = $user;
        $this->employee = $user;
        $this->siteInfo = $siteInfo;
    }


    public function employeeAttachForm()
    {

        $viewType = 'Attach Employee';
        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.site.employee.employee-attach', compact('viewType'));
    }


    /**
     * @return string
     */
    public function employeePage()
    {

        //dd('s');
        // dd(\Route::currentRouteName());\Route::getFacadeRoot()->current()->uri();
        $locale = $this->chosenLanguage();
        $defaultLocale = $this->defaultLocale();
        //        dd(request()->user()->designation);

        //        return view('default.employee.index', compact('locale','defaultLocale'));
        return view('default.employee.index', compact('locale', 'defaultLocale'));
    }
    public function getEmployeeAcademicAssignSubjectList()
    {
        $GlobalSiteInfoSetting =  GlobalSiteInfoSetting::where('academic_group_id', session()->get('ACADEMIC_GROUP_ID'))
            ->where('site_id', session()->get('SITE_ID'))->first();
        $academic_subject_ids =  explode(',', $GlobalSiteInfoSetting->academic_subject_ids);
        $AcademicSubject      =  AcademicSubject::whereIn('id', $academic_subject_ids)->get();

        $AcademicSubject->transform(function ($value) {
            return [
                'id' => $value->id,
                'subject_name' => $value->subject_name,
            ];
        });

        return $AcademicSubject;
    }

    /**
     * @return array
     */
    public function employeeDesignationReligionGenderList()
    {

        $gender_list = Gender::get();
        $religion_list = Religion::get();

        $siteInfo_setting_list = GlobalSiteInfoSetting::where('site_id', Session::get('SITE_ID'))->pluck('designation_ids')->toArray();
        $designation_ids       = join(',', $siteInfo_setting_list);

        $exploded_designation_ids = explode(',', $designation_ids);
        $designations = Designation::whereIn('id', $exploded_designation_ids)->get();


        return [$gender_list, $religion_list, $designations];
    }


    public function getResidenceEmpgradeTransportQuataBloodgroupList()
    {

        $siteInfolist = SiteInfo::where('id', Session::get('SITE_ID'))->first();


        $residencelistsplite = explode(',', $siteInfolist->employee_academic_residence_ids);
        $residencelist = AcademicResidence::whereIn('id', $residencelistsplite)->get();


        $gradelistsplite = explode(',', $siteInfolist->emp_grade_ids);
        $gradelist = EmpGrade::whereIn('id', $gradelistsplite)->get();


        $transportlistsplite = explode(',', $siteInfolist->employee_academic_transport_ids);
        $transportlist = AcademicTransport::whereIn('id', $transportlistsplite)->get();


        $quatalistsplite = explode(',', $siteInfolist->employee_academic_student_quata_ids);
        $quatalist = AcademicStudentQuata::whereIn('id', $quatalistsplite)->get();


        $bloodlist = BloodGroup::get();


        return [$residencelist, $gradelist, $transportlist, $quatalist, $bloodlist];
    }


    public function getEmployeeExaminationList()
    {
        $siteInfolist = SiteInfo::where('id', Session::get('SITE_ID'))->first();

        $examinationlistsplite = explode(',', $siteInfolist->employee_examination_ids);
        $examinationlist = Examination::whereIn('id', $examinationlistsplite)->get();

        return $examinationlist;
    }


    /**
     * @param User $emp
     * @param Request $requests
     */
    public function employeeCreate(
        Employee $emp,
        EmployeeHistory $emphistory,
        EmployeeEducationBackground $empEdu,
        Request $requests
    ) {


        $this->validate($requests, [
            "first_name" => "required",
            "designation_id" => "required",
            "religion_id" => "required",
            "gender_id" => "required",
            "contact_number" => "required",
        ]);

        DB::beginTransaction();

        try {


            $employeeUsername = $this->employeeUserNameCreate($requests);

            $employeePassword = mt_rand(100000, 200000);

            //Insert into Users table
            if (isset($emp->ownFields)) {
                foreach ($emp->ownFields as $ownField) {
                    if ($requests->{$ownField}) {
                        if (is_array($requests->{$ownField})) {
                            $emp->{$ownField} = collect($requests->{$ownField})->implode(',');
                        } else {
                            $emp->{$ownField} = $requests->{$ownField};
                        }
                    }
                }
                $emp->username = $employeeUsername;
                $emp->password = $employeePassword;
                $emp->address = $requests->present_address;

                $emp->user_type = 'employee';
                $emp->site_id = Session::get('SITE_ID');
                $emp->status = 1;
            }
            if ($emp->save()) {

                $employeeUserid = $emp->id;
                $roleEmployee = SiteRole::where('key', 'employee')->first();
                $emp->siteRoles()->attach([$roleEmployee->id]);
                $this->setTheUserPermission($emp);
            }


            /* // this below code will be made functional later

                        if ($requests->sendSms) {
                            if ($requests->student_contact_number) {

                                $site=SiteInfo::findOrFail($site_id);
                                $url = config('app.url');

                                $sms_txt = 'Congrats, '.$student->full_name;
                                $sms_txt .= 'nl' .'Login Details: ' .$url;
                                $sms_txt .= 'nl' . 'Username: ' . $studentUsername;
                                $sms_txt .= 'nl' . 'Password: ' . $studentpassword;
                                $sms_txt .= 'nl' . 'Regards: ' . $site->site_name;

                                $tt = $this->sendSms($site_id, [$requests->student_contact_number],$sms_txt );
                            } else {
                                throw new Error('Please Input Contact Number Field');
                            }
                        }*/


            //Insert into EmployeeHistories table
            if (isset($emphistory->ownFields)) {
                foreach ($emphistory->ownFields as $ownField) {


                    if ($requests->{$ownField}) {
                        if (is_array($requests->{$ownField})) {
                            $emphistory->{$ownField} = collect($requests->{$ownField})->implode(',');
                        } else {
                            $emphistory->{$ownField} = $requests->{$ownField};
                        }
                    }
                }

                $emphistory->user_id = $employeeUserid;
                $emphistory->is_teacher = $requests->is_teacher;
                $emphistory->site_id = Session::get('SITE_ID');
                $emphistory->status = 1;
            }
            if ($emphistory->save()) {
                $emphistoryid = $emphistory->id;
            }


            //Insert into Employee Education Background data
            if (count($requests->QualificationList) > 0) {
                foreach ($requests->QualificationList as $qvalue) {

                    $data = array(
                        'user_id' => $employeeUserid,
                        'examination_id' => $qvalue['examination_id'],
                        'board_university_name' => $qvalue['board_university_name'],
                        'passing_year' => $qvalue['passing_year'],
                        'result_type_id' => $qvalue['result_type_id'],
                        'time_duration' => $qvalue['time_duration'],
                        'gpa' => $qvalue['gpa'],
                        'status' => 1,
                        'site_id' => Session::get('SITE_ID'),
                    );
                    $empEdu->insert($data);
                }
            }


            //Insert into Employee Education Background data
            if (count($requests->ExperianceList) > 0) {

                foreach ($requests->ExperianceList as $qvalue) {
                    $experiance = new EmploymentHistory;
                    $experiance->user_id = $employeeUserid;
                    $experiance->site_id = Session::get('SITE_ID');
                    $experiance->status = 1;


                    $experiance->company_name = $qvalue['company_name'];
                    $experiance->company_location = $qvalue['company_location'];
                    $experiance->position_held = $qvalue['position_held'] ? $qvalue['position_held'] : null;
                    $experiance->responsibilites = $qvalue['responsibilites'] ? $qvalue['responsibilites'] : null;
                    $experiance->from_date = $qvalue['from_date'] ?? '0000-00-00 00:00:00';
                    $experiance->to_date = $qvalue['to_date'] ?? '0000-00-00 00:00:00';
                    $experiance->currently_working = $qvalue['currently_working'] ? $qvalue['currently_working'] : false;

                    $experiance->save();
                }
            }

            DB::commit();

            if ($requests->signature) {
                $this->saveSignature($emp, $requests);
            }

            if ($requests->employee_image) {
                $this->savePhoto($emp, $requests);
                $this->sendMail($emp, $employeeUsername, $employeePassword);
                //  $this->sendSms($emp, $employeeUsername, $employeePassword);
                return Response::json(['message' => 'information Save Successfully with Picture!', 'mode' => 'Saved!'], 200);
            }


            $this->sendMail($emp, $employeeUsername, $employeePassword);
            //  $this->sendSms($emp, $employeeUsername, $employeePassword);
            return Response::json(['message' => 'information Save Successfully!', 'mode' => 'Saved!']);
        } catch (Exception $exception) {
            DB::rollBack();
            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }


    public function getEmployeeListForEdit($id)
    {

        $empUserlist = $this->employee->with(['latestPhoto'])
            ->where('id', $id)
            ->first();
        //return $empUserlist;


        //  $this->sendMail($empUserlist, 'test', 222222);


        $empHistory = EmployeeHistory::where('user_id', $id)->orderBy('id', 'desc')->limit(1)->first();

        $emplist = array_merge(
            $empUserlist->toArray(),
            ($empHistory ? $empHistory->toArray() : [])
        );

        //  Log::info($empHistory);

        $empEdu = EmployeeEducationBackground::where('user_id', $id)->where('status', 1)->get();

        $empExperiance = EmploymentHistory::where('user_id', $id)->where('status', 1)->get();

        return [$emplist, $empEdu, $empExperiance];
    }


    public function employeeUpdate(Request $requests)
    {

        $this->validate($requests, [
            "first_name" => "required",
            "designation_id" => "required",
            "religion_id" => "required",
            "gender_id" => "required",
            "contact_number" => "required",

        ]);

        DB::beginTransaction();
        try {

            //Update into Users table
            $employeeUser = $this->employee->where('id', $requests->user_id)->first();
            if (isset($employeeUser->ownFields)) {
                foreach ($employeeUser->ownFields as $ownField) {


                    if ($requests->{$ownField}) {
                        if (is_array($requests->{$ownField})) {
                            $employeeUser->{$ownField} = collect($requests->{$ownField})->implode(',');
                        } else {
                            $employeeUser->{$ownField} = $requests->{$ownField};
                        }
                    }
                }

                $employeeUser->address = $requests->present_address;
                $employeeUser->institute_head = $requests->institute_head;
            }
            $employeeUser->save();


            //Update into EmployeeHistories table
            $employeehistory = EmployeeHistory::where('id', $requests->id)->first();
            if (isset($employeehistory->ownFields)) {
                foreach ($employeehistory->ownFields as $ownField) {


                    if ($requests->{$ownField}) {
                        if (is_array($requests->{$ownField})) {
                            $employeehistory->{$ownField} = collect($requests->{$ownField})->implode(',');
                        } else {
                            $employeehistory->{$ownField} = $requests->{$ownField};
                        }
                    }

                    $employeehistory->is_teacher = $requests->is_teacher;
                }
            }
            $employeehistory->save();


            //Update into Employee Education Background data
            $experiance = EmploymentHistory::where('user_id', $requests->user_id)->pluck('id');

            $updatedExperianceArray = [];
            foreach ($requests->ExperianceList as $qvalue) {
                $checkValue = $qvalue['id'] ?? 0;
                if ($checkValue) {
                    array_push($updatedExperianceArray, $qvalue['id']);
                }
            }
            $diffArrayExp = [];
            $diffArrayExp = array_diff($experiance->toArray(), $updatedExperianceArray);
            EmploymentHistory::whereIn('id', $diffArrayExp)->delete();


            if (count($requests->ExperianceList) > 0) {

                foreach ($requests->ExperianceList as $qvalue) {

                    $checkValue = $qvalue['id'] ?? 0;
                    if ($checkValue) {


                        $experiance = EmploymentHistory::where('id', $qvalue['id'])->first();


                        $experiance->company_name = $qvalue['company_name'];
                        $experiance->company_location = $qvalue['company_location'];
                        $experiance->position_held = $qvalue['position_held'] ? $qvalue['position_held'] : null;
                        $experiance->responsibilites = $qvalue['responsibilites'] ? $qvalue['responsibilites'] : null;
                        $experiance->from_date = $qvalue['from_date'] ?? '0000-00-00 00:00:00';
                        $experiance->to_date = $qvalue['to_date'] ?? '0000-00-00 00:00:00';
                        $experiance->currently_working = $qvalue['currently_working'];

                        $experiance->save();
                    } else {

                        $experiance = new EmploymentHistory;


                        $experiance->user_id = $requests->user_id;
                        $experiance->site_id = Session::get('SITE_ID');
                        $experiance->status = true;


                        $experiance->company_name = $qvalue['company_name'];
                        $experiance->company_location = $qvalue['company_location'];
                        $experiance->position_held = $qvalue['position_held'] ? $qvalue['position_held'] : null;
                        $experiance->responsibilites = $qvalue['responsibilites'] ? $qvalue['responsibilites'] : null;
                        $experiance->from_date = $qvalue['from_date'] ?? '0000-00-00 00:00:00';
                        $experiance->to_date = $qvalue['to_date'] ?? '0000-00-00 00:00:00';
                        $experiance->currently_working = $qvalue['currently_working'] ?? false;

                        $experiance->save();
                    }
                }
            }


            //Update into Employee Education Background data
            $experiance = EmployeeEducationBackground::where('user_id', $requests->user_id)->pluck('id');

            $updatedExperianceArray = [];
            foreach ($requests->QualificationList as $qvalue) {
                $checkValue = $qvalue['id'] ?? 0;
                if ($checkValue) {
                    array_push($updatedExperianceArray, $qvalue['id']);
                }
            }
            $diffArrayExp = [];
            $diffArrayExp = array_diff($experiance->toArray(), $updatedExperianceArray);
            EmployeeEducationBackground::whereIn('id', $diffArrayExp)->delete();


            if (count($requests->QualificationList) > 0) {
                foreach ($requests->QualificationList as $qvalue) {

                    $checkValue = $qvalue['id'] ?? 0;
                    if ($checkValue) {


                        $employeeQualification = EmployeeEducationBackground::where('id', $qvalue['id'])->first();

                        $employeeQualification->examination_id = $qvalue['examination_id'];
                        $employeeQualification->board_university_name = $qvalue['board_university_name'];
                        $employeeQualification->passing_year = $qvalue['passing_year'];
                        $employeeQualification->result_type_id = $qvalue['result_type_id'];
                        $employeeQualification->time_duration = $qvalue['time_duration'];
                        $employeeQualification->gpa = $qvalue['gpa'];

                        $employeeQualification->save();
                    } else {
                        $empEdu = new EmployeeEducationBackground;
                        $data = array(
                            'user_id' => $requests->user_id,
                            'examination_id' => $qvalue['examination_id'],
                            'board_university_name' => $qvalue['board_university_name'],
                            'passing_year' => $qvalue['passing_year'],
                            'result_type_id' => $qvalue['result_type_id'],
                            'time_duration' => $qvalue['time_duration'],
                            'gpa' => $qvalue['gpa'],
                            'status' => true,
                            'site_id' => Session::get('SITE_ID'),

                        );
                        $empEdu->insert($data);
                    }
                }
            }

            DB::commit();
            if ($requests->employee_image) {
                $this->saveSignature($employeeUser, $requests);
            }

            $checkPhoto = $this->employee->with(['latestPhoto'])->where('id', $employeeUser->id)->first();
            if ($checkPhoto->latestPhoto->name != $requests->employee_image) {
                if ($requests->employee_image) {
                    $this->savePhoto($employeeUser, $requests);
                    DB::commit();
                    return Response::json(['message' => 'Information Save Successfully with Picture!', 'mode' => 'Saved!'], 200);
                }
            }


            return Response::json(['message' => 'Information Update Successfully!', 'mode' => 'Saved!']);
        } catch (Exception $exception) {
            DB::rollBack();

            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }


    private function employeeUserNameCreate(Request $requests)
    {

        if ($requests->joining_date) {
            $date = new Carbon($requests->joining_date);
            $year = $date->format('Y');
        } else {
            $year = date('Y');
        }

        $yearCode = substr($year, 2, 2);

        $siteCode = sprintf("%03d", Session::get('SITE_ID'));

        $yearSiteCode = 'e' . $yearCode . $siteCode;
        $yearSiteCodeLength = strlen($yearSiteCode);


        $userRows = UserForUsername::whereRaw("username REGEXP '^{$yearSiteCode}([0-9]*)?$'")
            ->orderBy('username', 'desc')
            ->first();


        if ($userRows) {
            $extructData = substr($userRows->username, $yearSiteCodeLength);
            $countValue = (int)$extructData;
            $countUser = $countValue + 1;
            $studentUserNameCre = $yearSiteCode . sprintf("%04d", $countUser);
        } else {
            $studentUserNameCre = $yearSiteCode . sprintf("%04d", 1);
        }

        return $studentUserNameCre;
    }


    private function savePhoto(Employee $newlyCreatedUser, Request $request)
    {

        //  Log::info($request->employee_image);
        if ($request->employee_image == "image-not.png") {
            $fileName = $request->employee_image;
        } else {
            $name = time() . '.' . explode('/', explode(':', substr($request->employee_image, 0, strpos($request->employee_image, ';')))[1])[1];
            $fileName = $name;
            Image::make($request->employee_image)->resize(440, 442)->save(public_path('uploads/') . $name);
        }

        $newlyCreatedUser->photos()->create([
            'user_id' => Auth::user()->id,
            'path' => '/uploads/' . $fileName,
            'name' => $fileName
        ]);
    }

    private function saveSignature(Employee $newlyCreatedUser, Request $request)
    {

        if (strlen($request->signature) < 200) {
            $fileName = $request->signature;
        } else {
            $name = time() . '.' . explode('/', explode(':', substr($request->signature, 0, strpos($request->signature, ';')))[1])[1];
            $fileName = '/img/signature/' . $name;
            Image::make($request->signature)->resize(235, 40)->save(public_path('/img/signature/') . $name);
        }


        $newlyCreatedUser->signature = $fileName;
        $newlyCreatedUser->save();
    }

    public function getActiveEmployeeList()
    {
        $emp = $this->employee
            ->where('status', true)
            ->with(['latestPhoto'])
            ->with(['designation'])
            ->orderBy('employee_serial', 'ASC')
            ->select('id', 'designation_id')
            ->get();

        return $emp;
    }

    public function getPauseEmployeeList()
    {

        $emp = $this->employee->with(['latestPhoto'])
            ->with(['designation'])
            ->where('user_type', 'employee')
            ->where('status', false)
            ->select('id', 'designation_id')
            ->get();

        return $emp;
    }

    public function getDeletedEmployeeList()
    {


        $emp = GlobalUser::onlyTrashed()
            ->with(['latestPhoto'])
            ->with(['designation'])
            ->where('user_type', 'employee')
            ->where('site_id', Session::get('SITE_ID'))
            ->select('id', 'designation_id')
            ->get();

        return $emp;
    }

    public function employeePause($id)
    {

        DB::beginTransaction();
        try {

            $employeeUser = $this->employee->where('id', $id)->first();
            $employeeUser->status = false;
            $employeeUser->save();


            $employeeHistory = EmployeeHistory::where('user_id', $id)->orderBy('id', 'desc')->limit(1)->first();
            $employeeHistory->status = false;
            $employeeHistory->save();

            DB::commit();

            return Response::json(['message' => 'Employee Has Been Paused Successfully!', 'mode' => 'Update!']);
        } catch (Exception $exception) {
            DB::rollBack();

            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }

    public function employeeActiveFromPause($id)
    {
        DB::beginTransaction();
        try {

            $the_emp = $this->employee->where('id', $id)->first();
            $the_emp->status = true;
            $the_emp->save();


            $employeeHistory = EmployeeHistory::where('user_id', $id)->orderBy('id', 'desc')->limit(1)->first();
            $employeeHistory->status = true;
            $employeeHistory->save();


            DB::commit();

            return Response::json(['message' => 'Employee Successfully Activated!', 'mode' => 'Update!']);
        } catch (Exception $exception) {
            DB::rollBack();

            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }


    public function employeeDelete($id)
    {
        DB::beginTransaction();
        try {

            $experiance = EmploymentHistory::where('user_id', $id)->get();
            if (count($experiance) > 0) {
                foreach ($experiance as $value) {
                    $value->delete();
                }
            }


            $employeeQualification = EmployeeEducationBackground::where('user_id', $id)->get();
            if (count($employeeQualification) > 0) {
                foreach ($employeeQualification as $value) {
                    $value->delete();
                }
            }


            $employeeHistory = EmployeeHistory::where('user_id', $id)->get();
            if (count($employeeHistory) > 0) {
                foreach ($employeeHistory as $value) {
                    $value->delete();
                }
            }

            $employeeUser = User::where('id', $id)->first();
            $employeeUser->delete();


            DB::commit();

            return Response::json(['message' => 'Employee Successfully Deleted!', 'mode' => 'Delete!']);
        } catch (Exception $exception) {
            DB::rollBack();

            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }


    private function translatedAttrToSave(EmploymentHistory $experiance, Request $request)
    {
        //dd($validatedRequest->first_name);
        foreach ($experiance->translatedAttributes as $field) {
            foreach ($this->locales() as $locale => $value) {
                if ($request->get($field . '_' . $locale)) {
                    $experiance->translateOrNew($locale)->{$field} = $request->get($field . '_' . $locale);
                }
            }
        }
        //dd($user->first_name);

        if ($experiance->save()) {

            return true;
        }
        return false;
    }


    public function siteEmployeeGetDepartmentClassSubjectList($empUserID)
    {

        //        $runningYear=date('Y');


        // dd($empUserID);


        $siteClass = SiteInfoSetting::select('academic_class_ids', 'academic_department_ids')->first();


        if ($siteClass->academic_department_ids) {

            $siteDepartmentIds = explode(',', $siteClass->academic_department_ids);
            $siteDepartmentList = AcademicDepartment::whereIn('id', $siteDepartmentIds)->get();
        }


        $siteClassIds = explode(',', $siteClass->academic_class_ids);
        $siteClassList = AcademicClass::whereIn('id', $siteClassIds)->get();


        $SubjectGroupConditionSettingList = SubjectGroupConditionSetting::select('academic_department_id', 'academic_class_id', 'academic_subject_id')
            ->with(['academicDepartment'])
            ->with(['academicClass'])
            ->with(['academicSubject'])
            ->distinct('academic_subject_id')
            ->where('status', 1)
            ->get();
        //return $SubjectGroupConditionSettingList;

         $employeeSelectedSubject = SiteEmployeeDepartmentClassSubject::where('user_id', $empUserID)
            ->whereNull('release_date')->get();


        if (count($employeeSelectedSubject) <= 0) {


            $testClassArr = array();
            $ClassArray = [];
            foreach ($SubjectGroupConditionSettingList as $key => $value) {
                // dd ($value->academicClass->class_name);
                $testClassArr['academic_department_id'] = $value->academic_department_id;
                $testClassArr['academic_department'] = $value->academicDepartment->name ?? null;
                $testClassArr['academic_class_id'] = $value->academic_class_id;
                $testClassArr['academic_class'] = $value->academicClass->class_name;
                $testClassArr['academic_subject_id'] = $value->academic_subject_id;
                $testClassArr['subject_name'] = $value->academicSubject->subject_name;


                $testClassArr['assign_date'] = null;

                $testClassArr['select_academic_department_id'] = false;
                $testClassArr['select_academic_class_id'] = false;
                $testClassArr['select_academic_subject_id'] = false;


                $testClassArr['mejor_department'] = false;
                $testClassArr['mejor_class'] = false;
                $testClassArr['mejor_subject'] = false;

                $ClassArray[$key] = array_merge($testClassArr);
            }
        } else {


            $testClassArr = array();
            $ClassArray = [];

            foreach ($SubjectGroupConditionSettingList as $keys => $values) {

                //                Log::info('1');

                $presenttestClassArr = array();
                $presentClassArray = [];

                $deptFound = false;
                $classFound = false;
                $subjectFound = false;

                $deptMejor = false;
                $classMejor = false;
                $subjectMejor = false;

                $assign_date = null;
                foreach ($employeeSelectedSubject as $key => $value) {


                    if ($value->academic_department_id != null && $value->academic_department_id == $values->academic_department_id) {

                        $deptFound = true;

                        $deptMejor = $value->mejor_department;
                    }


                    if (
                        $value->academic_department_id == $values->academic_department_id &&
                        $value->academic_class_id == $values->academic_class_id
                    ) {

                        $classFound = true;
                        $classMejor = $value->mejor_class;
                    }


                    if (
                        $value->academic_department_id == $values->academic_department_id &&
                        $value->academic_class_id == $values->academic_class_id &&
                        $value->academic_subject_id == $values->academic_subject_id
                    ) {

                        $subjectFound = true;
                        $subjectMejor = $value->mejor_subject;
                        $assign_date = $value->assign_date;
                    }
                }



                if ($deptFound) {
                    $presenttestClassArr['select_academic_department_id'] = true;
                } else {
                    $presenttestClassArr['select_academic_department_id'] = false;
                }


                if ($classFound) {
                    $presenttestClassArr['select_academic_class_id'] = true;
                } else {
                    $presenttestClassArr['select_academic_class_id'] = false;
                }

                if ($subjectFound) {
                    $presenttestClassArr['select_academic_subject_id'] = true;
                } else {
                    $presenttestClassArr['select_academic_subject_id'] = false;
                }

                $presenttestClassArr['academic_department_id'] = $values->academic_department_id;
                $presenttestClassArr['academic_department'] = $values->academicDepartment ? $values->academicDepartment->name : null;
                $presenttestClassArr['academic_class_id'] = $values->academic_class_id;
                $presenttestClassArr['academic_class'] = $values->academicClass->class_name;
                $presenttestClassArr['academic_subject_id'] = $values->academic_subject_id;
                $presenttestClassArr['subject_name'] = $values->academicSubject->subject_name;


                $presenttestClassArr['assign_date'] = $assign_date;


                $presenttestClassArr['mejor_department'] = $deptMejor == 0 ? false : $deptMejor;
                $presenttestClassArr['mejor_class'] = $classMejor == 0 ? false : $classMejor;
                $presenttestClassArr['mejor_subject'] = $subjectMejor == 0 ? false : $subjectMejor;

                $ClassArray[$keys] = array_merge($presenttestClassArr);
            }
        }


        if ($siteClass->academic_department_ids) {


            $deptClassSubjectList = [];
            $deptClassSubjectArray = array();
            foreach ($siteDepartmentList as $keyR => $valueR) {


                $deptArray = [];
                $deptArr = array();
                foreach ($ClassArray as $keyt => $valuet) {


                    if ($valueR->id == $valuet['academic_department_id']) {

                        $deptArr['academic_department_id'] = $valuet['academic_department_id'];
                        $deptArr['academic_department_name'] = $valuet['academic_department'];
                        $deptArr['academic_class_id'] = $valuet['academic_class_id'];
                        $deptArr['class_name'] = $valuet['academic_class'];
                        $deptArr['academic_subject_id'] = $valuet['academic_subject_id'];
                        $deptArr['subject_name'] = $valuet['subject_name'];
                        $deptArr['select_academic_subject_id'] = $valuet['select_academic_subject_id'];
                        $deptArr['select_academic_class_id'] = $valuet['select_academic_class_id'];

                        $deptArr['mejor_class'] = $valuet['mejor_class'];
                        $deptArr['mejor_subject'] = $valuet['mejor_subject'];


                        $deptArr['assign_date'] = $valuet['assign_date'];


                        $deptArray[$keyt] = array_merge($deptArr);


                        $classListWithSubject = [];
                        $classListWithSubjectArr = array();
                        foreach ($siteClassList as $key => $value) {
                            $classArray = [];
                            $classArr = array();
                            foreach ($deptArray as $keys => $values) {

                                if ($value->id == $values['academic_class_id']) {

                                    $classArr['academic_subject_id'] = $values['academic_subject_id'];
                                    $classArr['subject_name'] = $values['subject_name'];
                                    $classArr['select_academic_subject_id'] = $values['select_academic_subject_id'];
                                    $classArr['mejor_subject'] = $values['mejor_subject'];


                                    $classArr['assign_date'] = $values['assign_date'];

                                    $classArray[$keys] = array_merge($classArr);


                                    $classListWithSubjectArr['select_academic_class_id'] = $values['select_academic_class_id'];
                                    $classListWithSubjectArr['mejor_class'] = $values['mejor_class'];
                                    $classListWithSubjectArr['academic_subject'] = $classArray;

                                    $classListWithSubject[$key] = array_merge($value->toArray(), $classListWithSubjectArr);
                                }
                            }
                        }


                        $deptClassSubjectArray['mejor_department'] = $valuet['mejor_department'];
                        $deptClassSubjectArray['select_academic_department_id'] = $valuet['select_academic_department_id'];
                        $deptClassSubjectArray['academic_class'] = $classListWithSubject;
                        $deptClassSubjectList[$keyR] = array_merge($valueR->toArray(), $deptClassSubjectArray);
                    }
                }
            }
        } else {


            $classListWithSubject = [];
            $classListWithSubjectArr = array();
            foreach ($siteClassList as $key => $value) {
                $classArray = [];
                $classArr = array();
                foreach ($ClassArray as $keys => $values) {


                    if ($value->id == $values['academic_class_id']) {

                        $classArr['academic_subject_id'] = $values['academic_subject_id'];
                        $classArr['subject_name'] = $values['subject_name'];
                        $classArr['select_academic_subject_id'] = $values['select_academic_subject_id'];
                        $classArr['mejor_subject'] = $values['mejor_subject'];
                        $classArr['assign_date'] = $values['assign_date'];

                        $classArray[$keys] = array_merge($classArr);
                        $classListWithSubjectArr['select_academic_class_id'] = $values['select_academic_class_id'];
                        $classListWithSubjectArr['mejor_class'] = $values['mejor_class'];
                        $classListWithSubjectArr['academic_subject'] = $classArray;

                        $classListWithSubject[$key] = array_merge($value->toArray(), $classListWithSubjectArr);
                    }
                }
            }
        }


        //dd($classListWithSubject);


        if ($siteClass->academic_department_ids) {
            return ['dept', $deptClassSubjectList];
        } else {
            return ['class', $classListWithSubject];
        }
    }


    public function getEmployeeAssignedSubjectByVersionYearShift(Request $request)
    {

        $academic_version_id = $request->academic_version_id;
        $academic_year_id = $request->academic_year_id;
        $academic_shift_id = $request->academic_shift_id;
        $employee_id = $request->employee_id;


        $siteClass = SiteInfoSetting::select('academic_class_ids', 'academic_department_ids')->first();


        if ($siteClass->academic_department_ids) {

            $siteDepartmentIds = explode(',', $siteClass->academic_department_ids);
            $siteDepartmentList = AcademicDepartment::whereIn('id', $siteDepartmentIds)->get();
        }


        $siteClassIds = explode(',', $siteClass->academic_class_ids);
        $siteClassList = AcademicClass::whereIn('id', $siteClassIds)->get();


        $SubjectGroupConditionSettingList = SubjectGroupConditionSetting::
            // select('academic_department_id', 'academic_class_id', 'academic_subject_id')
            with(['academicDepartment'])
            ->with(['academicClass'])
            ->with(['academicSubject'])
            ->orderBy('subject_position', 'ASC')
            ->groupBy('academic_department_id', 'academic_class_id', 'academic_subject_id')
            ->get();


        //   dd($SubjectGroupConditionSettingList);


        $employeeSelectedSubject = SiteEmployeeDepartmentClassSubject::where('user_id', $employee_id)
            ->whereNull('release_date')->get();


        if (count($employeeSelectedSubject) <= 0) {


            $testClassArr = array();
            $ClassArray = [];
            foreach ($SubjectGroupConditionSettingList as $key => $value) {
                // dd ($value->academicClass->class_name);
                $testClassArr['academic_department_id'] = $value->academic_department_id;
                $testClassArr['academic_department'] = $value->academicDepartment->name ?? null;
                $testClassArr['academic_class_id'] = $value->academic_class_id;
                $testClassArr['academic_class'] = $value->academicClass->class_name;
                $testClassArr['academic_subject_id'] = $value->academic_subject_id;
                $testClassArr['subject_name'] = $value->academicSubject->subject_name;


                $testClassArr['assign_date'] = null;

                $testClassArr['select_academic_department_id'] = false;
                $testClassArr['select_academic_class_id'] = false;
                $testClassArr['select_academic_subject_id'] = false;


                $testClassArr['mejor_department'] = false;
                $testClassArr['mejor_class'] = false;
                $testClassArr['mejor_subject'] = false;

                $ClassArray[$key] = array_merge($testClassArr);
            }
        } else {


            $testClassArr = array();
            $ClassArray = [];


            // dd($SubjectGroupConditionSettingList);

            foreach ($SubjectGroupConditionSettingList as $keys => $values) {

                //                Log::info('1');

                $presenttestClassArr = array();
                $presentClassArray = [];

                $deptFound = false;
                $classFound = false;
                $subjectFound = false;

                $deptMejor = false;
                $classMejor = false;
                $subjectMejor = false;

                $assign_date = null;
                foreach ($employeeSelectedSubject as $key => $value) {


                    if ($value->academic_department_id != null && $value->academic_department_id == $values->academic_department_id) {

                        $deptFound = true;

                        $deptMejor = $value->mejor_department;
                    }


                    if (
                        $value->academic_department_id == $values->academic_department_id &&
                        $value->academic_class_id == $values->academic_class_id
                    ) {

                        $classFound = true;
                        $classMejor = $value->mejor_class;
                    }


                    if (
                        $value->academic_department_id == $values->academic_department_id &&
                        $value->academic_class_id == $values->academic_class_id &&
                        $value->academic_subject_id == $values->academic_subject_id
                    ) {

                        $subjectFound = true;
                        $subjectMejor = $value->mejor_subject;
                        $assign_date = $value->assign_date;
                    }
                }

                //                Log::info($deptFound);

                if ($deptFound) {
                    $presenttestClassArr['select_academic_department_id'] = true;
                } else {
                    $presenttestClassArr['select_academic_department_id'] = false;
                }


                if ($classFound) {
                    $presenttestClassArr['select_academic_class_id'] = true;
                } else {
                    $presenttestClassArr['select_academic_class_id'] = false;
                }

                if ($subjectFound) {
                    $presenttestClassArr['select_academic_subject_id'] = true;
                } else {
                    $presenttestClassArr['select_academic_subject_id'] = false;
                }

                $presenttestClassArr['academic_department_id'] = $values->academic_department_id;
                $presenttestClassArr['academic_department'] = $values->academicDepartment ? $values->academicDepartment->name : null;
                $presenttestClassArr['academic_class_id'] = $values->academic_class_id;
                $presenttestClassArr['academic_class'] = $values->academicClass->class_name;
                $presenttestClassArr['academic_subject_id'] = $values->academic_subject_id;
                $presenttestClassArr['subject_name'] = $values->academicSubject->subject_name;


                $presenttestClassArr['assign_date'] = $assign_date;


                $presenttestClassArr['mejor_department'] = $deptMejor == 0 ? false : $deptMejor;
                $presenttestClassArr['mejor_class'] = $classMejor == 0 ? false : $classMejor;
                $presenttestClassArr['mejor_subject'] = $subjectMejor == 0 ? false : $subjectMejor;

                $ClassArray[$keys] = array_merge($presenttestClassArr);
            }
            //  dd($presenttestClassArr);
        }

        //  dd($ClassArray);


        if ($siteClass->academic_department_ids) {


            $deptClassSubjectList = [];
            $deptClassSubjectArray = array();
            foreach ($siteDepartmentList as $keyR => $valueR) {


                $deptArray = [];
                $deptArr = array();
                foreach ($ClassArray as $keyt => $valuet) {


                    if ($valueR->id == $valuet['academic_department_id']) {

                        $deptArr['academic_department_id'] = $valuet['academic_department_id'];
                        $deptArr['academic_department_name'] = $valuet['academic_department'];
                        $deptArr['academic_class_id'] = $valuet['academic_class_id'];
                        $deptArr['class_name'] = $valuet['academic_class'];
                        $deptArr['academic_subject_id'] = $valuet['academic_subject_id'];
                        $deptArr['subject_name'] = $valuet['subject_name'];
                        $deptArr['select_academic_subject_id'] = $valuet['select_academic_subject_id'];
                        $deptArr['select_academic_class_id'] = $valuet['select_academic_class_id'];

                        $deptArr['mejor_class'] = $valuet['mejor_class'];
                        $deptArr['mejor_subject'] = $valuet['mejor_subject'];


                        $deptArr['assign_date'] = $valuet['assign_date'];


                        $deptArray[$keyt] = array_merge($deptArr);


                        $classListWithSubject = [];
                        $classListWithSubjectArr = array();
                        foreach ($siteClassList as $key => $value) {
                            $classArray = [];
                            $classArr = array();
                            foreach ($deptArray as $keys => $values) {

                                if ($value->id == $values['academic_class_id']) {

                                    $classArr['academic_subject_id'] = $values['academic_subject_id'];
                                    $classArr['subject_name'] = $values['subject_name'];
                                    $classArr['select_academic_subject_id'] = $values['select_academic_subject_id'];
                                    $classArr['mejor_subject'] = $values['mejor_subject'];


                                    $classArr['assign_date'] = $values['assign_date'];

                                    $classArray[$keys] = array_merge($classArr);


                                    $classListWithSubjectArr['select_academic_class_id'] = $values['select_academic_class_id'];
                                    $classListWithSubjectArr['mejor_class'] = $values['mejor_class'];
                                    $classListWithSubjectArr['academic_subject'] = $classArray;

                                    $classListWithSubject[$key] = array_merge($value->toArray(), $classListWithSubjectArr);
                                }
                            }
                        }


                        $deptClassSubjectArray['mejor_department'] = $valuet['mejor_department'];
                        $deptClassSubjectArray['select_academic_department_id'] = $valuet['select_academic_department_id'];
                        $deptClassSubjectArray['academic_class'] = $classListWithSubject;
                        $deptClassSubjectList[$keyR] = array_merge($valueR->toArray(), $deptClassSubjectArray);
                    }
                }
            }
        } else {

            //   dd($siteClassList,$ClassArray);


            $classListWithSubject = [];
            $classListWithSubjectArr = array();
            foreach ($siteClassList as $key => $value) {
                $classArray = [];
                $classArr = array();
                foreach ($ClassArray as $keys => $values) {


                    if ($value->id == $values['academic_class_id']) {

                        $classArr['academic_subject_id'] = $values['academic_subject_id'];
                        $classArr['subject_name'] = $values['subject_name'];
                        $classArr['select_academic_subject_id'] = $values['select_academic_subject_id'];
                        $classArr['mejor_subject'] = $values['mejor_subject'];
                        $classArr['assign_date'] = $values['assign_date'];

                        $classArray[$keys] = array_merge($classArr);
                        $classListWithSubjectArr['select_academic_class_id'] = $values['select_academic_class_id'];
                        $classListWithSubjectArr['mejor_class'] = $values['mejor_class'];
                        $classListWithSubjectArr['academic_subject'] = $classArray;

                        $classListWithSubject[$key] = array_merge($value->toArray(), $classListWithSubjectArr);
                    }
                }
            }
        }


        if ($siteClass->academic_department_ids) {
            return ['dept', $deptClassSubjectList];
        } else {
            return ['class', $classListWithSubject];
        }
    }


    public function createEmployeeDepartmentClassSubject(SiteEmployeeDepartmentClassSubject $empDepartmentClassSubject, Request $request)
    {

        Log::info($request);

        $today = Carbon::now();
        $charges = [];
        $employeeSubjectList = SiteEmployeeDepartmentClassSubject::where('user_id', $request->user_id)->whereNull('release_date')->get();

        if (count($employeeSubjectList) <= 0) {

            if (count($request->departmentClassSubject) > 0) {

                foreach ($request->departmentClassSubject as $key => $value) {

                    if ($value['select_academic_department_id']) {

                        foreach ($value['academic_class'] as $keys => $values) {

                            if ($values['select_academic_class_id']) {

                                foreach ($values['academic_subject'] as $keyst => $valuest) {
                                    if ($valuest['select_academic_subject_id']) {

                                        $charges[] = [
                                            'user_id' => $request->user_id,
                                            'academic_department_id' => $value['id'],
                                            'academic_class_id' => $values['id'],
                                            'academic_subject_id' => $valuest['academic_subject_id'],
                                            'mejor_department' => $value['mejor_department'],
                                            'mejor_class' => $values['mejor_class'],
                                            'mejor_subject' => $valuest['mejor_subject'],
                                            'status' => true,
                                            'assign_date' => $request->assign_release_date ? $request->assign_release_date : $today,
                                            'site_id' => Session::get('SITE_ID'),
                                            'academic_group_id' => Session::get('ACADEMIC_GROUP_ID'),
                                        ];
                                    }
                                }
                            } //select_academic_class_id
                        }
                    } //select_academic_department_id
                }
            } else if (count($request->ClassSubjectList) > 0) {
                foreach ($request->ClassSubjectList as $key => $value) {

                    if ($value['select_academic_class_id']) {

                        foreach ($value['academic_subject'] as $keyst => $values) {
                            if ($values['select_academic_subject_id']) {

                                $charges[] = [
                                    'user_id' => $request->user_id,
                                    'academic_class_id' => $value['id'],
                                    'academic_subject_id' => $values['academic_subject_id'],
                                    'mejor_class' => $value['mejor_class'],
                                    'mejor_subject' => $values['mejor_subject'],
                                    'status' => true,
                                    'assign_date' => $request->assign_release_date ? $request->assign_release_date : $today,
                                    'site_id' => Session::get('SITE_ID'),
                                    'academic_group_id' => Session::get('ACADEMIC_GROUP_ID'),
                                ];
                            }
                        }
                    }
                }
            }

            $empDepartmentClassSubject->insert($charges);
        } else {

            $employeeSubjectListArray = SiteEmployeeDepartmentClassSubject::where('user_id', $request->user_id)
                ->whereNull('release_date')
                ->pluck('id');

            if (count($request->departmentClassSubject) > 0) {

                $charges = [];
                $idsArray = [];

                foreach ($request->departmentClassSubject as $key => $value) {
                    if ($value['select_academic_department_id']) {
                        foreach ($value['academic_class'] as $keys => $values) {
                            if ($values['select_academic_class_id']) {
                                foreach ($values['academic_subject'] as $keyst => $valuest) {


                                    if ($valuest['select_academic_subject_id']) {


                                        $empSubject = SiteEmployeeDepartmentClassSubject::where('user_id', $request->user_id)
                                            ->where('academic_department_id', $value['id'])
                                            ->where('academic_class_id', $values['id'])
                                            ->where('academic_subject_id', $valuest['academic_subject_id'])
                                            ->whereNull('release_date')
                                            ->first();

                                        if ($empSubject) {
                                            $idsArray[] = $empSubject->id;

                                            $datetime1 = new DateTime($request->assign_release_date);
                                            $datetime2 = new DateTime($empSubject->assign_date);
                                            $interval = $datetime1->diff($datetime2);
                                            $days = $interval->format('%a');

                                            if ($days < 7) {
                                                $empSubject->assign_date = $request->assign_release_date ? $request->assign_release_date : $today;
                                            }


                                            $empSubject->mejor_department = $value['mejor_department'];
                                            $empSubject->mejor_class = $values['mejor_class'];
                                            $empSubject->mejor_subject = $valuest['mejor_subject'];
                                            $empSubject->site_id = Session::get('SITE_ID');
                                            $empSubject->academic_group_id = Session::get('ACADEMIC_GROUP_ID');
                                            $empSubject->save();
                                        } else {

                                            $charges[] = [
                                                'user_id' => $request->user_id,
                                                'academic_department_id' => $value['id'],
                                                'academic_class_id' => $values['id'],
                                                'academic_subject_id' => $valuest['academic_subject_id'],
                                                'mejor_department' => $value['mejor_department'],
                                                'mejor_class' => $values['mejor_class'],
                                                'mejor_subject' => $valuest['mejor_subject'],
                                                'status' => true,
                                                'assign_date' => $request->assign_release_date ? $request->assign_release_date : $today,
                                                'site_id' => Session::get('SITE_ID'),
                                                'academic_group_id' => Session::get('ACADEMIC_GROUP_ID'),
                                            ];
                                        }
                                    }
                                }
                            } //select_academic_class_id
                        }
                    } //select_academic_department_id
                }


                if (count($charges) > 0) {
                    $empDepartmentClassSubject->insert($charges);
                }
            } elseif (count($request->ClassSubjectList) > 0) {

                $charges = [];

                $idsArray = [];
                foreach ($request->ClassSubjectList as $key => $value) {

                    if ($value['select_academic_class_id']) {

                        foreach ($value['academic_subject'] as $keyst => $values) {
                            if ($values['select_academic_subject_id']) {

                                $empSubject = SiteEmployeeDepartmentClassSubject::where('user_id', $request->user_id)
                                    ->where('academic_class_id', $value['id'])
                                    ->where('academic_subject_id', $values['academic_subject_id'])
                                    ->whereNull('release_date')
                                    ->first();

                                //                                        Log::info($request->assign_release_date);

                                if ($empSubject) {
                                    $idsArray[] = $empSubject->id;

                                    $datetime1 = new DateTime($request->assign_release_date);
                                    $datetime2 = new DateTime($empSubject->assign_date);
                                    $interval = $datetime1->diff($datetime2);
                                    $days = $interval->format('%a');

                                    if ($days < 7) {
                                        $empSubject->assign_date = $request->assign_release_date ? $request->assign_release_date : $today;
                                    }


                                    $empSubject->mejor_class = $value['mejor_class'];
                                    $empSubject->mejor_subject = $values['mejor_subject'];
                                    $empSubject->site_id = Session::get('SITE_ID');
                                    $empSubject->academic_group_id = Session::get('ACADEMIC_GROUP_ID');

                                    $empSubject->save();

                                    //                                            Log::info($empSubject);
                                } else {

                                    $charges[] = [
                                        'user_id' => $request->user_id,
                                        'academic_class_id' => $value['id'],
                                        'academic_subject_id' => $values['academic_subject_id'],
                                        'mejor_class' => $value['mejor_class'],
                                        'mejor_subject' => $values['mejor_subject'],
                                        'status' => true,
                                        'assign_date' => $request->assign_release_date ? $request->assign_release_date : $today,
                                        'site_id' => Session::get('SITE_ID'),
                                        'academic_group_id' => Session::get('ACADEMIC_GROUP_ID'),

                                    ];
                                }
                            }
                        }
                    }
                }
                if (count($charges) > 0) {
                    $empDepartmentClassSubject->insert($charges);
                }
            }


            $diff = array_diff($employeeSubjectListArray->toArray(), $idsArray);
            Log::info($diff);

            foreach ($diff as $key => $value) {
                $empSubjectk = SiteEmployeeDepartmentClassSubject::where('id', $value)
                    ->first();


                $datetime1 = new DateTime($request->assign_release_date ? $request->assign_release_date : $today);
                $datetime2 = new DateTime($empSubjectk->assign_date);
                $interval = $datetime1->diff($datetime2);
                $days = $interval->format('%a');


                if ($days > 2) {
                    $empSubjectk->release_date = $request->assign_release_date ? $request->assign_release_date : $today;
                    $empSubjectk->save();
                } else {
                    $empSubjectk->delete();
                }
            }
        }


        return Response::json(['message' => 'information Save Successfully!', 'mode' => 'Saved!'], 200);
    }


    public function getSingleEmployeeDetail($empUserId)
    {


        $empUserlist = $this->employee->with([
            'latestPhoto',
            'gender',
            'religion',
            'designation',
            'presentCountry',
            'permanentCountry',
            'presentDivision',
            'permanentDivision',
            'presentDistrict',
            'permanentDistrict',
            'presentThana',
            'permanentThana',
            'bloodGroup'
        ])
            ->withTranslation('en', 'bn')
            ->where('id', $empUserId)
            ->first();

        $empHistory = EmployeeHistory::where('user_id', $empUserId)->orderBy('id', 'desc')->limit(1)->first();
        $emplist = array_merge($empUserlist->toArray(), ($empHistory ? $empHistory->toArray() : []));




        $empEdu = EmployeeEducationBackground::with('examination')->where('user_id', $empUserId)->where('status', 1)->get();

        $empExperiance = EmploymentHistory::where('user_id', $empUserId)->where('status', 1)->get();

        $empClassSubject = SiteEmployeeDepartmentClassSubject::with(['emClass', 'department', 'emSubject'])
            ->where('user_id', $empUserId)
            ->get();


        $empClassSubjectWithdatediff = [];
        $datediffArray = array();
        foreach ($empClassSubject as $key => $value) {

            $release_date = $value->release_date ? $value->release_date : Carbon::now();

            // Declare and define two dates
            $date1 = strtotime($value->assign_date);
            $date2 = strtotime($release_date);

            $diff = abs($date2 - $date1);

            $years = floor($diff / (365 * 60 * 60 * 24));


            $months = floor(($diff - $years * 365 * 60 * 60 * 24)
                / (30 * 60 * 60 * 24));


            $days = floor(($diff - $years * 365 * 60 * 60 * 24 -
                $months * 30 * 60 * 60 * 24) / (60 * 60 * 24));


            $datediffArray['year'] = $years;
            $datediffArray['month'] = $months;
            $datediffArray['day'] = $days;


            $empClassSubjectWithdatediff[$key] = array_merge($value->toArray(), $datediffArray);
        }


        return [$emplist, $empEdu, $empExperiance, $empClassSubjectWithdatediff];
    }


    public function siteEmployeeGetCategoryPositionList($user_id)
    {


        //employee shift Get start
        $siteShiftId = SiteInfoSetting::select('shift_ids')->first();


        $siteShiftIds = explode(',', $siteShiftId->shift_ids);
        $siteShiftList = AcademicShift::whereIn('id', $siteShiftIds)->get();


        $SiteEmployeeSiteShiftPresent = SiteEmployeeSiteShift::where('user_id', $user_id)->whereNull('release_date')->get();

        if (count($SiteEmployeeSiteShiftPresent) <= 0) {
            $shiftArr = array();
            $shiftArray = [];
            foreach ($siteShiftList as $key => $value) {
                $shiftArr['select_shift_id'] = false;
                $shiftArr['in_time_grace'] = 0;
                $shiftArr['out_time_grace'] = 0;
                $shiftArr['flaxibility_present'] = false;

                $shiftArray[$key] = array_merge($value->toArray(), $shiftArr);
            }
        } else {


            $shiftArray = [];
            $shiftPresentArr = array();
            foreach ($siteShiftList as $key => $value) {


                $checkvalue = $SiteEmployeeSiteShiftPresent->where('academic_shift_id', $value->id)->first();


                if ($checkvalue) {
                    $shiftPresentArr['select_shift_id'] = $checkvalue->academic_shift_id;
                    $shiftPresentArr['in_time_grace'] = $checkvalue->in_time_grace;
                    $shiftPresentArr['out_time_grace'] = $checkvalue->out_time_grace;
                    $shiftPresentArr['flaxibility_present'] = $checkvalue->flaxibility_present;
                } else {
                    $shiftPresentArr['select_shift_id'] = false;
                    $shiftPresentArr['in_time_grace'] = 0;
                    $shiftPresentArr['out_time_grace'] = 0;
                    $shiftPresentArr['flaxibility_present'] = false;
                }

                $shiftArray[$key] = array_merge($value->toArray(), $shiftPresentArr);
            }
        }


        //category Get start
        $siteCtegoryList = SiteCategoryPositionSetting::with(['employeeCategory', 'employeePosition'])
            ->get();


        $categoryIDarr = $siteCtegoryList->pluck('emp_category_id');

        $categoryList = EmpCategory::whereIn('id', $categoryIDarr)->get();

        $EmployeeCategoryPositionPresentList = SiteEmployeeCategoryPosition::whereNull('release_date')->get();


        if (count($EmployeeCategoryPositionPresentList) <= 0) {

            $categoryPositionArray = [];
            $categoryPositionArr = array();
            foreach ($categoryList as $key => $value) {

                $categoryArr = array();
                $categoryArray = [];
                foreach ($siteCtegoryList as $keys => $values) {


                    if ($value->id == $values['emp_category_id']) {
                        $categoryArr['emp_position_id'] = $values->emp_position_id;
                        $categoryArr['position_name'] = $values->employeePosition->name;
                        $categoryArr['select_position_id'] = false;

                        $categoryArray[$keys] = array_merge($categoryArr);
                    }
                }

                $categoryPositionArr['position_list'] = $categoryArray;
                $categoryPositionArr['select_category_id'] = false;


                $categoryPositionArray[$key] = array_merge($value->toArray(), $categoryPositionArr);
            }

            return response()->json([$categoryPositionArray, $shiftArray], 200, [], JSON_NUMERIC_CHECK);
        } else {


            $categoryArray = [];
            $categoryArr = array();
            foreach ($categoryList as $key => $value) {

                $categoryPresent = $EmployeeCategoryPositionPresentList->where('emp_category_id', $value['id'])->first();

                if ($categoryPresent) {
                    $categoryArr['select_category_id'] = true;
                } else {
                    $categoryArr['select_category_id'] = false;
                }


                $categoryBasePositionList = $siteCtegoryList->where('emp_category_id', $value['id']);


                $positionArr = array();
                $posotionArray = [];
                foreach ($categoryBasePositionList as $keys => $values) {
                    $categoryPositionList = $EmployeeCategoryPositionPresentList
                        ->where('emp_category_id', $value['id'])
                        ->where('emp_position_id', $values->emp_position_id)
                        ->first();

                    $positionArr['emp_position_id'] = $values->emp_position_id;
                    $positionArr['position_name'] = $values->employeePosition->name;

                    if ($categoryPositionList) {
                        $positionArr['select_position_id'] = true;
                        $positionArr['assign_date'] = $categoryPositionList->assign_date;
                    } else {
                        $positionArr['select_position_id'] = false;
                        $positionArr['assign_date'] = null;
                    }
                    $posotionArray[$keys] = array_merge($positionArr);
                }

                $categoryArr['position_list'] = $posotionArray;


                $categoryArray[$key] = array_merge($value->toArray(), $categoryArr);
            }

            return response()->json([$categoryArray, $shiftArray], 200, [], JSON_NUMERIC_CHECK);
        }
    }


    public function createUpdateEmployeeCategoryPosition(Request $request)
    {

        $today = Carbon::today();


        $SiteEmployeeSiteShiftPresent = SiteEmployeeSiteShift::where('user_id', $request->user_id)
            ->whereNull('release_date')
            ->get();

        $acc_gr_id = Session::get('ACADEMIC_GROUP_ID');


        if (count($SiteEmployeeSiteShiftPresent) <= 0) {

            $charges = [];
            foreach ($request->shiftIntimeOuttimeList as $key => $value) {


                if ($value['select_shift_id']) {
                    $charges[] = [
                        'user_id' => $request->user_id,
                        'academic_group_id' => $acc_gr_id,
                        'assign_date' => $request->shift_assign_release_date ? $request->shift_assign_release_date : $today,
                        'academic_shift_id' => $value['id'],
                        'in_time_grace' => $value['in_time_grace'],
                        'out_time_grace' => $value['out_time_grace'],
                        'site_id' => Session::get('SITE_ID'),
                        'status' => true,
                        'flaxibility_present' => $value['flaxibility_present'],
                    ];
                }
            }

            if (count($charges) > 0) {
                SiteEmployeeSiteShift::insert($charges);
            }
        } else {


            $presentShiftIDArray = $SiteEmployeeSiteShiftPresent->pluck('id');

            $charges = [];
            $presentShiftID = [];
            $presentShiftTableIDArray = [];
            foreach ($request->shiftIntimeOuttimeList as $key => $value) {

                if ($value['select_shift_id']) {

                    $checkPresentShiftDate = $SiteEmployeeSiteShiftPresent
                        ->where('academic_shift_id', $value['id'])
                        ->first();


                    if ($checkPresentShiftDate) {
                        $presentShiftID[$key] = $checkPresentShiftDate->id;

                        $checkPresentShiftDate->in_time_grace = $value['in_time_grace'];
                        $checkPresentShiftDate->out_time_grace = $value['out_time_grace'];
                        $checkPresentShiftDate->flaxibility_present = $value['flaxibility_present'];
                        $checkPresentShiftDate->save();
                    } else {
                        $charges[] = [
                            'user_id' => $request->user_id,
                            'academic_group_id' => $acc_gr_id,
                            'assign_date' => $request->shift_assign_release_date ? $request->shift_assign_release_date : $today,
                            'academic_shift_id' => $value['id'],
                            'in_time_grace' => $value['in_time_grace'],
                            'out_time_grace' => $value['out_time_grace'],
                            'site_id' => Session::get('SITE_ID'),
                            'status' => true,
                            'flaxibility_present' => $value['flaxibility_present'],
                        ];
                    }

                    $presentShiftTableIDArray[$key] = array_merge($presentShiftID);
                }
            }

            if (count($charges) > 0) {
                SiteEmployeeSiteShift::insert($charges);
            }


            $collectionShift = collect($presentShiftTableIDArray);
            $shiftArrayCollapsed = ($collectionShift->collapse())->unique();


            $ShiftAbsentCheck = array_diff($presentShiftIDArray->toArray(), $shiftArrayCollapsed->toArray());

            foreach ($ShiftAbsentCheck as $key => $value) {

                $checkPresentDate = $SiteEmployeeSiteShiftPresent
                    ->where('id', $value)
                    ->first();


                $datetime1 = new DateTime($request->shift_assign_release_date ? $request->shift_assign_release_date : $today);
                $datetime2 = new DateTime($checkPresentDate->assign_date);
                $interval = $datetime1->diff($datetime2);
                $days = $interval->format('%a');

                if ($days > 2) {
                    $checkPresentDate->release_date = $request->shift_assign_release_date ? $request->shift_assign_release_date : $today;

                    $checkPresentDate->save();
                } else {
                    SiteEmployeeSiteShift::where('id', $value)->delete();
                }
            }
        }


        $categoryPositionPresent = SiteEmployeeCategoryPosition::where('user_id', $request->user_id)
            ->whereNull('release_date')
            ->get();


        if (count($categoryPositionPresent) <= 0) {

            $charges = [];
            foreach ($request->categoryPositionList as $key => $value) {

                if ($value['select_category_id']) {

                    foreach ($value['position_list'] as $keys => $values) {
                        if ($values['select_position_id']) {
                            $charges[] = [
                                'user_id' => $request->user_id,
                                'assign_date' => $request->category_assign_release_date ? $request->category_assign_release_date : $today,
                                'emp_category_id' => $value['id'],
                                'emp_position_id' => $values['emp_position_id'],
                                'status' => true,
                                'site_id' => Session::get('SITE_ID'),
                                'academic_group_id' => Session::get('ACADEMIC_GROUP_ID'),


                            ];
                        }
                    }
                }
            }

            if (count($charges) > 0) {
                SiteEmployeeCategoryPosition::insert($charges);
            }
        } else {


            $presentIDArray = $categoryPositionPresent->pluck('id');

            $charges = [];
            $presentID = [];
            $presentTableIDArray = [];
            foreach ($request->categoryPositionList as $key => $value) {

                if ($value['select_category_id']) {

                    foreach ($value['position_list'] as $keys => $values) {
                        if ($values['select_position_id']) {


                            $checkPresentDate = $categoryPositionPresent
                                ->where('emp_category_id', $value['id'])
                                ->where('emp_position_id', $values['emp_position_id'])
                                ->first();


                            if ($checkPresentDate) {
                                $presentID[$keys] = $checkPresentDate->id;
                            } else {
                                $charges[] = [
                                    'user_id' => $request->user_id,
                                    'emp_category_id' => $value['id'],
                                    'emp_position_id' => $values['emp_position_id'],
                                    'status' => true,
                                    'site_id' => Session::get('SITE_ID'),
                                    'academic_group_id' => Session::get('ACADEMIC_GROUP_ID'),
                                    'assign_date' => $request->category_assign_release_date ? $request->category_assign_release_date : $today,
                                ];
                            }
                        }

                        $presentTableIDArray[$key] = array_merge($presentID);
                    }
                }
            }

            if (count($charges) > 0) {
                SiteEmployeeCategoryPosition::insert($charges);
            }


            $collection = collect($presentTableIDArray);
            $categoryArrayCollapsed = ($collection->collapse())->unique();


            $categoryAbsentCheck = array_diff($presentIDArray->toArray(), $categoryArrayCollapsed->toArray());

            foreach ($categoryAbsentCheck as $key => $value) {

                $checkPresentDate = $categoryPositionPresent
                    ->where('id', $value)
                    ->first();


                $datetime1 = new DateTime($request->category_assign_release_date ? $request->category_assign_release_date : $today);
                $datetime2 = new DateTime($checkPresentDate->assign_date);
                $interval = $datetime1->diff($datetime2);
                $days = $interval->format('%a');

                if ($days > 2) {
                    $checkPresentDate->release_date = $request->category_assign_release_date ? $request->category_assign_release_date : $today;

                    $checkPresentDate->save();
                } else {
                    SiteEmployeeCategoryPosition::where('id', $value)->delete();
                }
            }
        }


        return Response::json(['message' => 'Information Saved Successfully!', 'mode' => 'Saved!'], 200);
    }


    private function sendMail(Employee $emp, $username, $password)
    {

        try {

            $site = SiteInfo::whereId($emp->site_id)->first();

            $sub_domain = config('app.url');
            $subject = 'Employee Login Details';

            $data = [
                'name' => ucwords($emp->first_name) . ' ' . ucwords($emp->last_name),
                'username' => $username,
                'sub_domain' => $sub_domain,
                'password' => $password,
                'message' => 'Employee Successfully Added!',
                'user_id' => Auth::user()->username
            ];

            Mail::to([$site->site_email, 'eduworlderp@gmail.com'])->send(new SendMailToUserWithQueue($subject, $data));
        } catch (Exception $exception) {

            $issue = new    IssueDetail();
            $issue->issue_type = 'email';
            $issue->issue_details = json_encode($exception->getMessage());
            $issue->site_id = $site->id ?? 0;
            $issue->save();
        }
    }


    //================================-------------report---------------------=================


}

/*
$emp->username = $employeeUsername;
$emp->password = $employeePassword;
$emp->address = $requests->present_address;

$emp->user_type = 'employee';
$emp->site_id = Session::get('SITE_ID');
$emp->status = 1;
}
if ($emp->save()) {

    $employeeUserid = $emp->id;
    $roleEmployee = SiteRole::where('name', 'employee')->first();
    $emp->siteRoles()->attach([$roleEmployee->id]);*/
