<?php

namespace App\Http\Controllers\Site\Employee\IdCard;

use Carbon\Carbon;
use Error;
use Exception;

use App\Models\Site\Employee\Employee;
use App\Models\User\EmployeeHistory;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicSubject;
use App\Models\Employee\SiteEmployeeDepartmentClassSubject;
use App\Models\Site\Employee\IDCard\EmployeeIdCardSetting;
use App\Models\Site\SiteInfo;
use Illuminate\Support\Facades\Session as FacadesSession;
use PDF;
use Response;
use Session;
use View;
use Image;


class EmployeeIdCardController extends Controller
{


    private $employeeHistory;
    private $employee, $cardSetting;

    public function __construct(Employee $employee, EmployeeHistory $employeeHistory, EmployeeIdCardSetting $employeeIdCardSetting)
    {

        $this->middleware('auth');
        $this->middleware('sitepagechecker');

        $this->employeeHistory = $employeeHistory;
        $this->employee = $employee;
        $this->cardSetting = $employeeIdCardSetting;
    }
    public function getSettingData(){
        $data = $this->cardSetting->active()->first();
        return response()->json($data, 200);
    }
    public function createUpdateIdcardSettingData(Request $request)
    {

        if (!$request->card_template || !$request->status) {
            throw new Error("Please Select Card Template And Status!");
        }
        $data = $this->cardSetting->active()->first();

        if ($request->site_logo_path) {
            if (strlen($request->site_logo_path) < 200) {
                $bg_img = explode('/', $request->site_logo_path);
                $siteLogoFileName = $bg_img[2];
            } else {

                $name = 'logo' . time() . '.' . explode('/', explode(':', substr($request->site_logo_path, 0, strpos($request->site_logo_path, ';')))[1])[1];
                $siteLogoFileName = $name;
                // Image::make($request->site_logo_path)->resize(440, 442)->save(public_path('uploads/') . $name);
                Image::make($request->site_logo_path)->save(public_path('uploads/') . $name);

                if ($data) {

                    if (file_exists('uploads/' . $data->site_logo_path)) {
                        unlink('uploads/' . $data->site_logo_path);
                    }
                }
            }
        } else {
            $siteLogoFileName = '';
        }

        if ($request->bg_path) {
            if (strlen($request->bg_path) < 200) {
                $bg_img = explode('/', $request->bg_path);
                $bgPathFileName = $bg_img[2];
            } else {

                $name = 'bg' . time() . '.' . explode('/', explode(':', substr($request->bg_path, 0, strpos($request->bg_path, ';')))[1])[1];
                $bgPathFileName = $name;
                Image::make($request->bg_path)->save(public_path('uploads/') . $name);

                if ($data) {
                    if (file_exists('uploads/' . $data->bg_path)) {
                        unlink('uploads/' . $data->bg_path);
                    }
                }
            }
        } else {
            $bgPathFileName = '';
        }

        if ($data) {

            $data->site_logo_path = $siteLogoFileName;
            $data->bg_path = $bgPathFileName;

            $data->card_template = $request->card_template;
            $data->signature_text = $request->signature_text;
            $data->site_id = session()->get('SITE_ID');
            $data->status = $request->status;
            $data->body_font_size = $request->body_font_size;
            $data->institute_name_font_size = $request->institute_name_font_size;
            $data->name_font_size = $request->name_font_size;
            $data->save();
        } else {

            $idcard = new EmployeeIdCardSetting;

            $idcard->site_logo_path = $siteLogoFileName;
            $idcard->bg_path = $bgPathFileName;
            $idcard->card_template = $request->card_template;
            $idcard->signature_text = $request->signature_text;
            $idcard->site_id = session()->get('SITE_ID');
            $idcard->status = $request->status;
            $idcard->body_font_size = $request->body_font_size;
            $idcard->institute_name_font_size = $request->institute_name_font_size;
            $idcard->name_font_size = $request->name_font_size;

            $idcard->save();
        }

        return response()->json(['message' => 'ID card save successfully'], 200);
    }

    public function getEmployees(Request $request)
    {

        try {


            $user_type = $request->types ?? 'employee';
            //$is_teacher_or_staff = $request->is_teacher_or_staff;

            $search_txt = $request->search_txt;
            $paginate = (int)$request->paginate;
            $status = $request->status;
            $is_teacher = $request->is_teacher ?? [0, 1]; //

            if (!$user_type) {
                throw new Exception('Check At Least One Type!' . $user_type);
            }

            $txt = '%' . $search_txt . '%';

            $employees = $this->employee
                ->where('user_type', $user_type)
                ->when($status == 1, function ($q) use ($status) {
                    return $q->whereHas('activeHistory', function ($q) use ($status) {
                    });
                })
                ->whereHas('empHistories', function ($q1) use ($is_teacher) {
                    return $q1->whereIn('is_teacher', $is_teacher);
                })
                ->when($status < 2, function ($q) use ($status) {
                    return $q->where('status', $status);
                })
                ->when($status == 2, function ($q) {
                    return $q->whereNotNull('deleted_at');
                })
                ->when($search_txt, function ($q) use ($txt) {
                    return $q->where(function ($query) use ($txt) {
                        $query->where('username', 'LIKE', $txt)
                            ->orWhere('email', 'LIKE', $txt)
                            ->orWhere('contact_number', 'LIKE', $txt)
                            ->orWhereTranslationLike('first_name', $txt)
                            ->orWhereTranslationLike('last_name', $txt);
                    });
                })
                ->with(['designation', 'latestPhoto', 'site' => function ($q) {
                    $q->select('id', 'site_logo');
                }, 'bloodGroup'])
                ->select('id', 'username', 'user_type', 'date_of_birth', 'blood_group_id', 'employee_id', 'nid_number', 'email', 'ex_id_card_code', 'present_id_card_code', 'contact_number','emergency_contact', 'status', 'finger_taken', 'attendance_sms', 'designation_id', 'signature', 'institute_head', 'site_id','employee_index_number','employee_academic_subject_id')
                ->orderBy('employee_serial', 'ASC')
                ->paginate($paginate);


            $employees->getCollection()->transform(function ($value) {
                $empClassSubject = SiteEmployeeDepartmentClassSubject::with(['emSubject'])
                ->where('user_id', $value->id)
                ->first();

                return [
                    'id' => $value->id,
                    'employee_id' => $value->employee_id,
                    'email' => $value->email,
                    'employee_index_number' => $value->employee_index_number,

                    'nid_number' => $value->nid_number,
                    'subject_name' => $empClassSubject && $empClassSubject->emSubject ? $empClassSubject->emSubject->subject_name : null,
                    'subject' => AcademicSubject::where('id', $value->employee_academic_subject_id)->first()->subject_name	?? null,
                    'permanent_address' => $value->permanent_address,
                    'full_name' => $value->full_name,
                    'father_name' => $value->father_name,
                    'mother_name' => $value->mother_name,
                    'username' => $value->username,
                    'blood_group_name' => $value->bloodGroup->blood_group_name ?? null,
                    'date_of_birth' => $value->date_of_birth ?? null,
                    'institute_joining_date' => $value->institute_joining_date ?? null,
                    'contact_number' => $value->contact_number ?? null,
                    'emergency_contact' => $value->emergency_contact ?? null,
                    'department' => $value->department->name ?? null,
                    'designation_name' => $value->designation->name ?? null,
                    'latest_photo_path' => $value->latestPhoto->path ?? "/uploads/image-not.png",


                    'present_id_card_code' => $value->present_id_card_code,
                    'ex_id_card_code' => $value->ex_id_card_code,
                    'site_name' => $value->site->site_name ?? '',
                    'site_logo' => ($value->site->site_logo) ?? '',
                ];
            });


            if (count($employees) < 1) {
                throw new Error('No Student Found!');
            }

            $institute_head = $this->employee->where('institute_head', 1)->first();

            $get_signature = $institute_head->signature ?? '/img/signature/signature.png';
            $get_designation = $institute_head->designation->name ?? 'Institution Head';


            return Response::json([$employees, $get_signature, $get_designation], 200);
        } catch (ModelNotFoundException $exception) {
            throw new Error($exception->getMessage());
        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }


    public function saveIdCardStudent(Request $request)
    {

        try {

            $id_card_ids = $request->idcard_ids;
            $id = $request->id;
            $full_name = $request->full_name;

            if ($id) {
                $existed = $this->IdCard
                    ->findOrFail($id);
                if ($existed && $existed->confirmed) {
                    return Response::json(['message' => 'The ID Already Confirmed'], 412);
                }
                $existed->delete();
                return Response::json(['message' => 'Successfully Cancelled: ' . $full_name], 200);
            } else {


                if (count($id_card_ids) < 1) {
                    throw new Error('No Student Found!');
                }

                foreach ($id_card_ids as $k => $card_id) {

                    $existed = $this->IdCard
                        ->where('history_id', $card_id)
                        ->first();


                    if ($existed) {

                        if ($existed->confirmed) {
                        } else {
                        }
                    } else {

                        $the_hist = $this->studentHistory->findOrFail($card_id);
                        $this->IdCard = new StudentIDCard();
                        $this->IdCard->user_id = $the_hist->user_id;
                        $this->IdCard->history_id = $card_id;
                        $this->IdCard->save();
                    }
                }

                return Response::json(['message' => 'Successfully Taken The Order For :' . count($id_card_ids) . ' Students'], 200);
            }
        } catch (ModelNotFoundException $exception) {
            throw new Error($exception->getMessage());
        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }

    public function saveUpdateStudentRfIdCardCode(Request $request)
    {


        foreach ($request->employeeList as $key => $value) {

            $this->employee->where('id', $value['id'])->update([

                'present_id_card_code' => $value['present_id_card_code'],
                'ex_id_card_code' => $value['ex_id_card_code'],
            ]);
        }

        return Response::json(['message' => 'Information Update Successfully!', 'mode' => 'Update!']);
    }


    public function idCardViewPdf(Request $request)
    {

        ini_set('memory_limit', '-1');
        // \Log::info($request->studentlist[0]['student']['latest_photo']['name']);


        $page_tittle = "Employee ID Card View Report";
        $report_tittle = "<b>Employee ID Card View Report</b> <br/>";
        $report_tittle2 = " ";
        $card_data = $request->employeeList;

        $signature = $request->signature;
        $designation = $request->designation;
        $card_setting = $this->cardSetting->active()->first();

        $site_id   =  session()->get('SITE_ID');
        $site_info =  SiteInfo::findOrFail($site_id);


        if (count($card_data) < 1) {
            return Response::json(['message' => 'Please Select Student To See PDF'], 410);
        }

        $site_id=Session::get('SITE_ID');
        $site_info =  SiteInfo::findOrFail($site_id);
        if($site_info->domain_name==null){
             $alias = $site_info->site_alias;
            $url = config('app.url');
            $parsedUrl = parse_url($url);
            $host = $parsedUrl['host'];
            $host_names = explode(".", $host);
            $bottom_host_name = $host_names[count($host_names) - 2] . "." . $host_names[count($host_names) - 1];

            if ($host_names[count($host_names) - 1] == 'bd') {
                $bottom_host_name = $host_names[count($host_names) - 2] . "." . $host_names[count($host_names) - 1];
            }
            if (count($host_names) == 2) {
                $bottom_host_name = $host_names[count($host_names) - 1];
            }
            $domain = $parsedUrl['scheme'] . '://' . $alias . '.' . $bottom_host_name;

        }else{
            $domain = $site_info->domain_name;
        }


        if ($request->type == 1) {

            if (!$card_setting) {
                return Response::json(['message' => 'First make ID card setting'], 410);
            }

            if(file_exists("/img/site/idcard/".Session::get('ALIAS1').".jpg")){
                $default_bg = "/img/site/idcard/".Session::get('ALIAS1').".jpg";
            }else{
                $default_bg = '/uploads/image-not.png';
            }
            if(!file_exists(Session::get('LOGO_PATH'))){
                $default_logo = Session::get('LOGO_PATH');
            }else{
                $default_logo = '/uploads/image-not.png';
            }

            $site_logo_path            = $card_setting->site_logo_path ? 'uploads/'.$card_setting->site_logo_path :$default_logo;
            $bg_path                   = $card_setting->bg_path        ? 'uploads/'.$card_setting->bg_path        :$default_bg;
            $institute_name_font_size  = $card_setting->institute_name_font_size ? $card_setting->institute_name_font_size . 'px' : 10 . 'px' ;
            $body_font_size            = $card_setting->body_font_size ? $card_setting->body_font_size .'px' : 10 .'px' ;
            $name_font_size            = $card_setting->name_font_size ? $card_setting->name_font_size .'px' : 10 .'px' ;


            if ($card_setting->card_template == 'epson_l805') {
                return 'jahin';
            }elseif ($card_setting->card_template == 'zebra') {

                if (view()->exists('custom.' . Session::get('ALIAS1') . '.employee.id-card.card-view-report-in-zebra')) {
                    $pdf = PDF::loadView('custom.' . Session::get('ALIAS1') . '.employee.id-card.card-view-report-in-zebra', compact('domain','bg_path','site_info','site_logo_path','name_font_size','body_font_size','institute_name_font_size','card_data', 'signature', 'designation', 'report_tittle', 'page_tittle', ))->setWarnings(false);;

                } else {

                    $pdf = PDF::loadView('default.site.employee.id-card.card-view-report-vertical', compact('domain','bg_path','site_info','site_logo_path','name_font_size','body_font_size','institute_name_font_size','card_data', 'signature', 'designation', 'report_tittle', 'page_tittle'))->setPaper('a4', 'landscape');
                }

            }elseif ($card_setting->card_template == 'uv') {

                if (view()->exists('custom.' . Session::get('ALIAS1') . '.employee.id-card.card-view-report-uv')) {
                    $pdf = PDF::loadView('custom.' . Session::get('ALIAS1') . '.employee.id-card.card-view-report-uv', compact('domain','bg_path','site_info','site_logo_path','name_font_size','body_font_size','institute_name_font_size','card_data', 'signature', 'designation', 'report_tittle', 'page_tittle', ))->setWarnings(false);;

                } else {

                    $pdf = PDF::loadView('default.site.employee.id-card.card-view-report-vertical', compact('domain','bg_path','site_info','site_logo_path','name_font_size','body_font_size','institute_name_font_size','card_data', 'signature', 'designation', 'report_tittle', 'page_tittle'))->setPaper('a4', 'landscape');
                }

            }
            else{
                if (view()->exists('custom.' . Session::get('ALIAS1') . '.employee.id-card.card-view-report-vertical')) {

                    $pdf = PDF::loadView('custom.' . Session::get('ALIAS1') . '.employee.id-card.card-view-report-vertical', compact('domain','bg_path','site_info','site_logo_path','name_font_size','body_font_size','institute_name_font_size','card_data', 'signature', 'designation', 'report_tittle', 'page_tittle', ))->setPaper('a4', 'landscape');
                } else {
                    $pdf = PDF::loadView('default.site.employee.id-card.card-view-report-vertical', compact('domain','bg_path','site_info','site_logo_path','name_font_size','body_font_size','institute_name_font_size','card_data', 'signature', 'designation', 'report_tittle', 'page_tittle', ))->setPaper('a4', 'landscape');
                }

            }
        } else {
            $page_tittle = "Student ID Card Proof Report";

            $report_tittle = "<b>Student ID Card Proof Report</b> <br/>";

            $pdf = PDF::loadView('default.site.employee.id-card.card-view-report-proof', compact('domain','card_data', 'report_tittle', 'page_tittle', 'report_tittle2'))->setPaper('a4', 'landscape');
        }


        $path = storage_path() . '/pdf';
        $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        $name = $time . '.pdf';

        return Response::json(['link' => route('open-pdf-file-storage', [$name]), 'message' => 'Successfully Created Card Report'], 200);
    }
}
