<?php

namespace App\Http\Controllers\Site\Employee\TeacherAssignToClass;

use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicSubject;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Site\Employee\Employee;
use App\Models\Site\Employee\StudentAssignToTeacher;
use App\Models\Site\Employee\TeacherAssignToClassSection;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use App\Models\Student\StudentHistory;
use App\Models\User\EmployeeHistory;
use Carbon\Carbon;
use Error;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Response;

class TeacherAssignToClassSectionController extends Controller
{
    private $teacherAssignToClassSection;
    private $employee;

    public function __construct(TeacherAssignToClassSection $teacherAssignToClassSection, Employee $employee)
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');

        $this->teacherAssignToClassSection = $teacherAssignToClassSection;
        $this->employee = $employee;

    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        $viewType ="Global Academic Calendar";
        return view('default.admin.layouts.master',compact('viewType'));
        return view('default.admin.site.employee.teacherAssignToClassSection.index',compact('viewType'));
//
    }


    public function getStudentList(Request $request){

        $data = $request->all();
        $paginate = 1000;

        if($request->academic_class_id){

            $siteStudentIDs = [];

            if($request->academic_class_group_present){

                $siteStudentIDs=StudentHistory::with(['student'=>function($query){
                    $query->select(['id','username']);
                }])
                    ->where('academic_version_id',$request->academic_version_id)
                    ->where('academic_shift_id',$request->academic_shift_id)
                    ->where('academic_year_id',$request->academic_year_id)
                    ->where('academic_class_id',$request->academic_class_id)
                    ->where('status',1)
                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                        return $query->where('academic_section_id', $data['academic_section_id']);
                    })
                    ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                        return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                    })
                    ->orderBy('academic_class_id', 'ASC')
                    ->orderBy('academic_class_group_id', 'ASC')
                    ->orderBy('academic_section_id', 'ASC')
                    ->orderBy('student_roll_number', 'ASC')
                    ->paginate($paginate);

            }else{

                $siteStudentIDs=StudentHistory::with(['student'=>function($query){
                    $query->select(['id','username']);
                }])
                    ->where('academic_version_id',$request->academic_version_id)
                    ->where('academic_shift_id',$request->academic_shift_id)
                    ->where('academic_year_id',$request->academic_year_id)
                    ->where('academic_class_id',$request->academic_class_id)
                    ->where('status',1)
                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                        return $query->where('academic_section_id', $data['academic_section_id']);
                    })
                    ->orderBy('academic_class_id', 'ASC')
                    ->orderBy('academic_class_group_id', 'ASC')
                    ->orderBy('academic_section_id', 'ASC')
                    ->orderBy('student_roll_number', 'ASC')
                    ->paginate($paginate);
            }

            if($request->employee_id){

                $student_assign_to_teacher = StudentAssignToTeacher::where('employee_id', $request->employee_id)
                                                    ->where('academic_version_id',$request->academic_version_id)
                                                    ->where('academic_shift_id',$request->academic_shift_id)
                                                    ->where('academic_year_id',$request->academic_year_id)
                                                    ->where('academic_class_id',$request->academic_class_id)
                                                    ->where('status',1)
                                                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                                                        return $query->where('academic_department_id', $data['academic_department_id']);
                                                    })
                                                    ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                                                        return $query->where('academic_section_id', $data['academic_section_id']);
                                                    })
                                                    ->first();

                if($student_assign_to_teacher){

                    $assigned_student_history_ids = explode(',', $student_assign_to_teacher->student_history_ids);
                    $siteStudentIDs->getCollection()->transform(function ($value) use($assigned_student_history_ids) {
                        if(in_array($value->id, $assigned_student_history_ids)){
                            return [
                                'id' => $value->id,
                                'user_id' => $value->user_id,
                                'student_roll_number' => $value->student_roll_number,
                                'student' => $value->student,
                                'check_status' => true,
                            ];
                        }else{
                            return [
                                'id' => $value->id,
                                'user_id' => $value->user_id,
                                'student_roll_number' => $value->student_roll_number,
                                'student' => $value->student,
                                'check_status' => false,
                            ];
                        }

                    });
                    return $siteStudentIDs;

                }else{
                    $siteStudentIDs->getCollection()->transform(function ($value) {
                        return [
                            'id' => $value->id,
                            'user_id' => $value->user_id,
                            'student_roll_number' => $value->student_roll_number,
                            'student' => $value->student,
                            'check_status' => false,
                        ];
                    });
                    return $siteStudentIDs;
                }
            }else{
                $siteStudentIDs->getCollection()->transform(function ($value) {
                    return [
                        'id' => $value->id,
                        'user_id' => $value->user_id,
                        'student_roll_number' => $value->student_roll_number,
                        'student' => $value->student,
                        'check_status' => false,
                    ];
                });
                return $siteStudentIDs;
            }


        }

    }

    public function assignStudentToTeacher(Request $request)
    {
//        return $request;
        $academic_department_id = $request->academic_department_id;
        $academic_section_id = $request->academic_section_id;

        $check_ids = [];
        foreach ($request->studentList as $key => $value){
            if($value['check_status']){
                $check_ids[] = $value['id'];
            }
        }
//        return $check_ids;


        $check_student_history_ids_string = implode(',', $check_ids);

        $student_assign_to_teacher = StudentAssignToTeacher::where('employee_id', $request->employee_id)
            ->where('academic_version_id',$request->academic_version_id)
            ->where('academic_shift_id',$request->academic_shift_id)
            ->where('academic_year_id',$request->academic_year_id)
            ->where('academic_class_id',$request->academic_class_id)
            ->where('status',1)
            ->when($academic_department_id, function ($query) use ($academic_department_id) {
                return $query->where('academic_department_id',$academic_department_id);
            })
            ->when($academic_section_id, function ($query) use ($academic_section_id) {
                return $query->where('academic_section_id', $academic_section_id);
            })
            ->first();

        if($student_assign_to_teacher){
//            return 'sorry';
            if($check_student_history_ids_string){
                $student_assign_to_teacher->update([
                    'student_history_ids'=>$check_student_history_ids_string
                ]);
            }else{
                $student_assign_to_teacher->delete();
            }

        }else{

            $std_assign_to_teacher = new StudentAssignToTeacher();
            $std_assign_to_teacher->employee_id = $request->employee_id;
            $std_assign_to_teacher->academic_version_id = $request->academic_version_id;
            $std_assign_to_teacher->academic_shift_id = $request->academic_shift_id;
            $std_assign_to_teacher->academic_year_id = $request->academic_year_id;
            $std_assign_to_teacher->academic_class_id = $request->academic_class_id;
            $std_assign_to_teacher->academic_department_id = $request->academic_department_id;
            $std_assign_to_teacher->academic_section_id = $request->academic_section_id;
            $std_assign_to_teacher->student_history_ids = $check_student_history_ids_string;
            $std_assign_to_teacher->assigned_by =  Auth::user()->id;
            $std_assign_to_teacher->assign_date =  Carbon::today();
            $std_assign_to_teacher->status =  1;

            $std_assign_to_teacher->save();

        }

        return Response::json(['message' => 'Successfully Updated!', 'mode' => 'Saved!'], 200);

    }

    public function assignDetails(Request $request){
//        return $request;
        $academic_version_id = $request->academic_version_id;
        $academic_year_id = $request->academic_year_id;
        $academic_shift_id = $request->academic_shift_id;
        $academic_department_id = $request->academic_department_id;
        $academic_class_id = $request->academic_class_id;
        $academic_class_group_id = $request->academic_class_group_id;
        $academic_section_id = $request->academic_section_id;
        $academic_session_id = $request->academic_session_id;



        $student_assign_to_teacher_list = StudentAssignToTeacher::where('academic_version_id', $academic_version_id)
            ->where('academic_year_id', $academic_year_id)
            ->where('academic_shift_id', $academic_shift_id)
            ->when($academic_class_id, function ($query) use ($academic_class_id) {
                return $query->where('academic_class_id', $academic_class_id);
            })
            ->when($academic_department_id, function ($query) use ($academic_department_id) {
                return $query->where('academic_department_id', $academic_department_id);
            })
            ->when($academic_section_id, function ($query) use ($academic_section_id) {
                return $query->where('academic_section_id', $academic_section_id);
            })
            ->when($academic_class_group_id, function ($query) use ($academic_class_group_id) {
                return $query->where('academic_class_group_id', $academic_class_group_id);
            })
            ->when($academic_session_id, function ($query) use ($academic_session_id) {
                return $query->where('academic_session_id', $academic_session_id);
            })
            ->with(['accClass','department'])
            ->get();

        $employees = $this->employee->whereHas('empHistories', function ($q1) {
            return $q1->where('is_teacher', true)->where('status', true);
        })->get();

        if(count($employees)>0){
            $data = [];
//            $srl = 0;
            foreach ($employees as $key => $value){
                $data[$key]['employee'] = $value;
                $filtered_data = $student_assign_to_teacher_list->where('employee_id', $value->id);
                if(count($filtered_data)>0){

                    if(count($filtered_data)>0){
                        foreach ($filtered_data as $kk => $vl){
                            $data[$key]['assigned_class_list'][] = $vl->accClass;
                        }
                    }
//                    $srl++;
                }else{
                    $data[$key]['assigned_class_list'][] = "";
                }
            }
            return $data;
        }
    }

    private function classGroupSectionValidation($request){

        $check_group_section=SiteShiftClassGroupSectionSetting::
        where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->first();



        if($check_group_section->academic_department_id && !$request->academic_department_id){
            return Response::json(['message' => 'Plese Select Department!', 'mode' => 'Error'], 200);
        }

//        if($check_group_section->academic_class_group_id && !$request->academic_class_group_id){
//            return Response::json(['message' => 'Plese Select Group!', 'mode' => 'Error'], 200);
//        }
//
//        if($check_group_section->academic_section_ids && !$request->academic_section_id){
//            return Response::json(['message' => 'Plese Select Section!', 'mode' => 'Error'], 200);
//        }

    }


    public function getTeacherList(Request $request)
    {
//        $teacher_list = EmployeeHistory::where('is_teacher',1)->where('status', 1)->with(['employee' => function ($query) {
//            $query->select('id');
//        }]) ->get(['id', 'user_id']);

//        $is_teacher = 1;
//        $status = 1;


        $data=$request->all();


        $valiedation=$this->classGroupSectionValidation($request);


        if($valiedation){

            return $valiedation;
        }


        $employees = $this->employee->whereHas('empHistories', function ($q1) {
                                return $q1->where('is_teacher', true)->where('status', true);
                            })->get();


        $assigned_emp_list=TeacherAssignToClassSection::whereIn('employee_id', $employees->pluck('id')->unique())
            ->when($data['academic_version_id'], function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
            ->when($data['academic_year_id'], function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->where('status', 1)
            ->get();




        $emp_arr=Array();
        $emp_array=[];
        foreach ($employees as $key => $value){

            $assigned_emp=null;
            if(count($assigned_emp_list)>0){
                $assigned_emp=$assigned_emp_list->where('employee_id', $value->id)->first();
            }



            if($assigned_emp){
                $emp_arr['select_employee_id']=true;
            }else{
                $emp_arr['select_employee_id']=false;
            }
            $emp_array[$key]=array_merge($emp_arr, $value->toArray());

        }
        $employee_number = $employees->count();


        return [$emp_array, $employee_number];
    }

    public function assignTeacherToClassSectionList(Request $request)
    {
        $year_id =  $request->year_id;
        $shift_id = $request->shift_id;
        $department_id = $request->department_id;
        $class_id = $request->class_id;
        $search_text = $request->search_text;
        $paginate = $request->paginate;

        $txt = '%' . $search_text . '%';

        $is_teacher = 1;
        $status = 1;

        $employees = $this->employee->whereHas('empHistories', function ($q1) use ($is_teacher,$status) {
                                        return $q1->where('is_teacher', $is_teacher)->where('status', $status);
                                    })
                                    ->when($search_text, function ($q) use ($txt) {
                                        return $q->where(function ($query) use ($txt) {
                                            $query->where('username', 'LIKE', $txt)
                                                ->orWhere('email', 'LIKE', $txt)
                                                ->orWhere('contact_number', 'LIKE', $txt)
                                                ->orWhereTranslationLike('first_name', $txt)
                                                ->orWhereTranslationLike('last_name', $txt);
                                        });
                                    })->get();
//        return $employees;
        $ids = [];

        if(count($employees)){
            foreach ($employees as $kk => $vv){
                $data_list = $this->teacherAssignToClassSection->where('status', 1)->where('employee_id', $vv->id)->first();
                if($data_list){
                    $ids[$kk] = $vv->id;
                }

            }

        }


        $data_list = $this->teacherAssignToClassSection->whereIn('employee_id', $ids)
                                                        ->when($year_id, function ($q) use ($year_id) {
                                                                $q->where('academic_year_id', $year_id);
                                                        })
                                                        ->when($shift_id, function ($q) use ($shift_id) {
                                                                $q->where('academic_shift_id', $shift_id);
                                                        })
                                                        ->when($department_id, function ($q) use ($department_id) {
                                                                $q->where('academic_department_id', $department_id);
                                                        })
                                                        ->when($class_id, function ($q) use ($class_id) {
                                                                $q->where('academic_class_id', $class_id);
                                                        })
                                                        ->where('status', 1)
                                                        ->get();
        if(count($data_list)){
            foreach ($data_list as $key => $value){
                $employees = $this->employee->where('id', $value->employee_id)->first();
                $academic_year = AcademicYear::where('id', $value->academic_year_id)->first();
                $academic_shift = AcademicShift::where('id', $value->academic_shift_id)->first();
                $department = AcademicDepartment::where('id', $value->academic_department_id)->first();
                $class = AcademicClass::where('id', $value->academic_class_id)->first();
                $group = AcademicClassGroup::where('id', $value->academic_class_group_id)->first();

//            $acc_section_ids = explode(',', $class_section_data->academic_section_ids);
//            $academic_section_data = AcademicSection::whereIn('id', $acc_section_ids)->get();

                $section = AcademicSection::where('id', $value->academic_section_id)->first();
                $final_data[$key]['full_name'] = $employees->full_name;
                $final_data[$key]['user_name'] = $employees->username;;
                $final_data[$key]['academic_year'] = $academic_year->year_name;
                $final_data[$key]['academic_shift'] = $academic_shift->shift_name;
                $final_data[$key]['department_name'] = $department ? $department->name : "";
                $final_data[$key]['class_name'] = $class->class_name;
                $final_data[$key]['group_name'] = $group->group_name??null;
                $final_data[$key]['section_name'] = $section->section_name??null;
            }

            $site_info_setting_data =  SiteInfoSetting::first();

            //----------------year list----------------------
            $acc_year_ids = explode(',', $site_info_setting_data->academic_year_ids);
            $year_list = AcademicYear::whereIn('id', $acc_year_ids)->get();

            //----------------shift list----------------------
            $acc_shift_ids = explode(',', $site_info_setting_data->shift_ids);
            $academic_shift_list = AcademicShift::whereIn('id', $acc_shift_ids)->get();

            //----------------class list----------------------
            $acc_class_ids = explode(',', $site_info_setting_data->academic_class_ids);
            $academic_class_list = AcademicClass::whereIn('id', $acc_class_ids)->get();

            //----------------department list----------------------
            $acc_department_ids = explode(',', $site_info_setting_data->academic_department_ids);
            $academic_department_list = AcademicDepartment::whereIn('id', $acc_department_ids)->get();

            //----------------group list----------------------
            $acc_group_ids = explode(',', $site_info_setting_data->academic_class_group_ids);
            if($acc_group_ids){
                $academic_group_list = AcademicClass::whereIn('id', $acc_group_ids)->get();

            }else{
                $academic_group_list = null;
            }



            return [$final_data, $year_list, $academic_shift_list, $academic_class_list, $academic_group_list, $academic_department_list];
        }else{
            throw new Error('Teacher Not Assigned Yet!!');

        }

    }

    public function getClassSectionList(Request $request)
    {
//        return $request;
        $academic_department_id = $request->academic_department_id;
        $academic_class_group_id = $request->academic_class_group_id;
        $class_section_data = SiteShiftClassGroupSectionSetting::where('academic_year_id', $request->academic_year_id)
                                                                ->where('academic_shift_id', $request->academic_shift_id)
                                                                ->where('academic_class_id', $request->academic_class_id)
                                                                ->where('academic_version_id', $request->academic_version_id)
                                                                ->when(!empty($academic_department_id), function ($query) use ($academic_department_id) {
                                                                    return $query->where('academic_department_id', $academic_department_id);
                                                                })
                                                                ->when(!empty($academic_class_group_id), function ($query) use ($academic_class_group_id) {
                                                                    return $query->where('academic_class_group_id', $academic_class_group_id);
                                                                })
                                                                ->first();
        if($class_section_data){
            $acc_section_ids = explode(',', $class_section_data->academic_section_ids);
            $academic_section_data = AcademicSection::whereIn('id', $acc_section_ids)->get();
            $final_data = [];
            foreach ($academic_section_data as $key => $value){
                $final_data[$key]['id'] = $value->id;
                $final_data[$key]['section_name'] = $value->section_name;

                $check_section_assign = TeacherAssignToClassSection::where('academic_year_id', $request->academic_year_id)
                                                                    ->where('academic_shift_id', $request->academic_shift_id)
                                                                    ->where('academic_class_id', $request->academic_class_id)
                                                                    ->where('academic_version_id', $request->academic_version_id)
                                                                    ->where('academic_section_id', $value->id)
                                                                    ->where('employee_id', $request->teacher_id)
                                                                    ->where('status', 1)
                                                                    ->when(!empty($academic_department_id), function ($query) use ($academic_department_id) {
                                                                        return $query->where('academic_department_id', $academic_department_id);
                                                                    })
                                                                    ->when(!empty($academic_class_group_id), function ($query) use ($academic_class_group_id) {
                                                                        return $query->where('academic_class_group_id', $academic_class_group_id);
                                                                    })
                                                                    ->first();
//                return $check_section_assign;
                if($check_section_assign){
                    $final_data[$key]['check_section_assign'] = true;
                }else{
                    $final_data[$key]['check_section_assign'] = false;
                }
            }
            return $final_data;
        }

    }

    public function assignTeacherToClassSection(Request $request)
    {
//        return $request;


        if($request->academic_version_id == 0 || $request->academic_year_id ==0 || $request->academic_shift_id == 0 || $request->academic_class_id == 0) {

            throw new Error('Select * Marked Fields!');
        }


        $employees=collect($request->siteTeacherList)->where('select_employee_id', true);

        $data=$request->all();

        $assigned_emp_list=TeacherAssignToClassSection::
//            whereIn('employee_id', $employees->pluck('id')->unique())
            when($data['academic_version_id'], function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
            ->when($data['academic_year_id'], function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->get();

        $assigned_emp_list_ids=$assigned_emp_list->pluck('id');


        $exist_emp_id=[];
        $charges=[];
        foreach ($employees as $key => $value){

            $assigned_emp=null;
            if(count($assigned_emp_list)>0){
                $assigned_emp=$assigned_emp_list->where('employee_id', $value['id'])->first();
            }

            if($assigned_emp){
                $exist_emp_id[]=$assigned_emp->id;
                if($assigned_emp->status==false){
                    $assigned_emp->status=true;
                    $assigned_emp->save();
                }

            }
            else{
                $charges[] = [
                    'employee_id' =>$value['id'],
                    'academic_version_id' => $request->academic_version_id,
                    'academic_year_id' => $request->academic_year_id,
                    'academic_shift_id' => $request->academic_shift_id,
                    'academic_class_id' => $request->academic_class_id,
                    'academic_department_id' => $request->academic_department_id,
                    'academic_section_id' => $request->academic_section_id,
                    'academic_class_group_id' => $request->academic_class_group_id,
                    'assign_date' =>  Carbon::today(),
                    'site_id' =>  \Session::get('SITE_ID'),
                    'academic_group_id' =>  \Session::get('ACADEMIC_GROUP_ID'),
                    'assigned_by' => Auth::user()->id,
                    'created_at' => Carbon::now(),
                    'status' => 1,
                ];
            }

        }



        if(count($charges)>0){
            TeacherAssignToClassSection::insert($charges);
        }


        $uncheck_employee=array_diff($assigned_emp_list_ids->toArray(), $exist_emp_id);


        TeacherAssignToClassSection::whereIn('id', $uncheck_employee)
            ->update([
                'status'=> false
            ]);



        return Response::json(['message' => 'Successfully', 'mode' => 'Saved!'], 200);


    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
