<?php

namespace App\Http\Controllers\Site\EmployeeDuty;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Jobs\EmployeeDutyAplication\EmployeeDutyApplicationCancelJob;
use App\Jobs\EmployeeDutyAplication\EmployeeDutyApplicationJob;
use App\Models\Academic\AcademicDutyType;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Designation\Designation;
use App\Models\Gender\Gender;
use App\Models\Site\Employee\Employee;
use App\Models\Site\EmployeeDuty\SiteEmployeeAssignDutyHistory;
use App\Models\Site\EmployeeDuty\SiteEmployeeDutyHistory;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Models\User\EmployeeHistory;
use App\Traits\Site\Duty\Employee\DutyFunction;
use App\Traits\Site\Leave\Employee\LeaveFunction;
use Carbon\Carbon;
use Carbon\CarbonPeriod;
use DateInterval;
use DatePeriod;
use DateTime;
use Exception;
use Illuminate\Support\Facades\Auth;
use Response;
use Error;
use Session;

class SiteEmployeeDutyController extends Controller
{

    use DutyFunction;

    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType = 'Employee Duty';
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function getEmployeeListForAssignDuty()
    {

        $employee_history = EmployeeHistory::with('SiteEmployeeAssignDutyHistory')->whereHas('SiteEmployeeAssignDutyHistory')
            ->where('status', true)->get();


            $transformed_data = $employee_history->transform(function ($value) {
                return [
                    'id' => $value->id,
                    'full_name' => $value->full_name ?? null,
                    'designation_name' => $value->designation_name ?? null,
                    'assign_duty_history' => $value->SiteEmployeeAssignDutyHistory->map(function ($history) {
                    
                        $SiteInfo = SiteInfo::where('id',$history->assign_site_id)->first();
                        return [
                            'start_time' => $history->start_time ?? null,
                            'end_time' => $history->end_time ?? null,
                            'selected_week' => Carbon::now()->startOfWeek(Carbon::SUNDAY)->addDays($history->selected_week  - 1)->format('l') ?? null,
                            'assign_site_name' => $SiteInfo->site_name,
                        ];
                    })
                ];
            });

        return $transformed_data;
    }
    public function getEmployeeListForDuty()
    {
        $employee_history = EmployeeHistory::with('employee')->whereHas('user')->where('status', true)->get();
        return $employee_history;
    }

    public function getAcademicDuty()
    {

        $duty_list = AcademicDutyType::get();
        return $duty_list;
    }

    public function createEmployeeDutyAssignInInstitute(Request $request)
    {
        $this->validate($request, [
            "employeeID" => "required",
            "site_id" => "required",
            "SelectedWeek" => "required",
        ]);

        $data = [];
        $data =  $request->all();
        foreach ($data['SelectedWeek'] as $week) {

            $SiteEmployeeAssignDutyHistory =  SiteEmployeeAssignDutyHistory::where('employee_history_id', $data['employeeID'])
                ->where('selected_week', $week)
                ->where('assign_site_id', $data['site_id'])
                ->first();

            if (!$SiteEmployeeAssignDutyHistory) {
                $SiteEmployeeAssignDutyHistory                      = new SiteEmployeeAssignDutyHistory();
                $SiteEmployeeAssignDutyHistory->employee_history_id = $data['employeeID'];
                $SiteEmployeeAssignDutyHistory->start_time          = $data['start_time'];
                $SiteEmployeeAssignDutyHistory->end_time            = $data['end_time'];
                $SiteEmployeeAssignDutyHistory->selected_week       = $week;
                $SiteEmployeeAssignDutyHistory->reason              = $data['reason'];
                $SiteEmployeeAssignDutyHistory->assign_site_id      = $data['site_id'];
                $SiteEmployeeAssignDutyHistory->save();
            } else {
                $weekdayName  = Carbon::now()->startOfWeek(Carbon::SUNDAY)->addDays($week - 1)->format('l');
                throw new Error($weekdayName . ' has been added. Please unselect ' . $weekdayName);
                break;
            }
        }
    }
    public function createEmployeeDuty(Request $request)
    {

        try {

            $duty_type = AcademicDutyType::where('id', $request->academic_duty_type_id)->first();

            if ($duty_type->type_key == "assign_duty") {
                if ($request->site_id == null) {
                    throw new Error('please select Institute');
                }
            }

            $this->validate($request, [
                "employeeID" => "required",
                "academic_duty_type_id" => "required",
                "date" => "required"
            ]);



            $employee_history_id = $request->employeeID;
            $data_range = $request->date;
            $current_date = Carbon::now()->toDateString();


            $check_duty = $this->checkDutyIfExist($data_range, $employee_history_id);
            if ($check_duty) {
                return Response::json(['message' => 'Request date already exist!'], 411);
            }

            if (strtotime($request->date['start']) < strtotime($current_date)) {
                return Response::json(['message' => 'This date is not valid'], 411);
            }

            $create_data = SiteEmployeeDutyHistory::create([
                'employee_history_id'  => $employee_history_id,
                'academic_duty_type_id' => $request->academic_duty_type_id,
                'assign_site_id'       =>  $request->site_id,
                'request_date'         => $current_date,
                'from_date'            => $request->date['start'],
                'to_date'              => $request->date['end'],
                'reason'               => $request->reason,
                'duty_status'          => 'approved',
                'status'               => true,
                'user_id'              => Auth::id(),
            ]);

            $user_id = EmployeeHistory::where('id', $create_data->employee_history_id)->first()->user_id ?? 0;

            $route = route('site-notice-view', ['']);

            dispatch(new EmployeeDutyApplicationJob($create_data, $user_id, $route));


            if ($create_data) {
                return Response::json(['message' => 'Duty Generate Successfully'], 200);
            } else {
                return Response::json(['message' => 'Something is Wroung'], 411);
            }
        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }
    public function getEmployeeDutyDetails(Request $request)
    {
        $getSiteShift = SiteInfo::where('id', $request->assign_site_id)->first();

        if ($getSiteShift) {
            return [
                'site_name' => $getSiteShift->site_name,
                'address' => $getSiteShift->address,
                'site_email' => $getSiteShift->site_email,
                'site_phone' => $getSiteShift->site_phone,
                'site_logo' => $getSiteShift->site_logo,
            ];
        }

        return response()->json(['message' => 'Site not found'], 404);
    }
    public function getEmployeeDutyList()
    {


        //    SiteEmployeeDutyHistory::get();

        $siteInfoSettingDetails =  SiteInfoSetting::where('site_id', Session::get('SITE_ID'))->first();

        $defined_designation_ids = Employee::whereIn('designation_id', explode(',', $siteInfoSettingDetails->designation_ids))->pluck('designation_id')->unique();

        $designation_list = Designation::whereIn('id', $defined_designation_ids)->get();

        $duty_type_list = AcademicDutyType::whereIn('id',  explode(',', $siteInfoSettingDetails->academic_leave_type_ids))->get();

        $academic_year_list = AcademicYear::whereIn('id', explode(',', $siteInfoSettingDetails->academic_year_ids))->orderBy('serial_no', 'DESC')->get();

        $gender_list = Gender::whereIn('id', explode(',', $siteInfoSettingDetails->gender_ids))->get();

        $employee_history = EmployeeHistory::where('status', true)->select('id', 'user_id')->get();


        return response()->json([$designation_list, $duty_type_list, $academic_year_list, $gender_list, $employee_history], 200);
    }

    public function getApplicationList(Request $request)
    {
        //    dd($request->all());

        $employee_history_id = $request->employee_history_id;
        $academic_duty_type_id = $request->academic_duty_type_id;
        $designation_id = $request->designation_id;
        $academic_year_id = $request->academic_year_id;
        $gender_id = $request->gender_id;
        $search_text = $request->search_text;
        $search_date = $request->search_date;
        $search_leave_status = $request->search_leave_status;
        $paginate = $request->paginate ?? 20;

        //        return $request;

        $txt = '%' . $search_text . '%';

        $duty_history =  SiteEmployeeDutyHistory::with('employeeHistory', 'academicDutyType')
            ->when($employee_history_id, function ($q) use ($employee_history_id) {
                $q->where('employee_history_id', $employee_history_id);
            })
            ->when($academic_duty_type_id, function ($q) use ($academic_duty_type_id) {
                $q->where('academic_duty_type_id', $academic_duty_type_id);
            })
            ->when(!empty($designation_id), function ($query) use ($designation_id) {
                return $query->whereHas('employeeHistory', function ($q) use ($designation_id) {
                    $q->where('designation_id', $designation_id);
                });
            })
            ->when(!empty($gender_id), function ($query) use ($gender_id) {
                $query->whereHas('employeeHistory', function ($qq) use ($gender_id) {
                    return $qq->whereHas('employee', function ($q) use ($gender_id) {
                        $q->where('gender_id', $gender_id);
                    });
                });
            })
            ->when(!empty($search_date), function ($q) use ($search_date) {
                $q->where('from_date', '<=', $search_date)
                    ->where('to_date', '>=', $search_date);
            })
            ->when(!empty($academic_year_id), function ($q) use ($academic_year_id) {
                $q->where('academic_year_id', $academic_year_id);
            })

            ->when($search_leave_status, function ($query) use ($search_leave_status) {
                $query->where('leave_status', $search_leave_status);
            })
            ->where('status', 1)
            ->orderBy('id', 'DESC')
            ->paginate($paginate);

        $mytime = Carbon::now();
        $to_date =  $mytime->toDateString();

        return [$duty_history, $to_date];
    }


    public function employeeDutyCancel($id)
    {
        //        return $id;
        try {
            $employee_id = Auth::user()->id;
            $mytime = Carbon::now();
            $create_data = $mytime->toDateString();

            $duty_history = SiteEmployeeDutyHistory::findOrFail($id);

            $user_id = EmployeeHistory::where('id', $duty_history->employee_history_id)->first()->user_id ?? 0;

            $route = route('site-notice-view', ['']);


            if ($duty_history->duty_status == 'pending') {
                $duty_history->duty_status = 'approved';
                $duty_history->save();

                dispatch(new EmployeeDutyApplicationJob($create_data, $user_id, $route));
            } else {
                $duty_history->duty_status = 'cancel';
                $duty_history->save();

                dispatch(new EmployeeDutyApplicationCancelJob($duty_history, $user_id, $route));
            }

            return ['message' => 'Successfully Status Change!'];
        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }
}
