<?php

namespace App\Http\Controllers\Site\EmployeeLeave;

use App\Jobs\EmployeeLeaveApplication\EmployeeLeaveApplicationApproveJob;
use App\Jobs\EmployeeLeaveApplication\EmployeeLeaveApplicationCancelJob;
use App\Jobs\EmployeeLeaveApplication\EmployeeLeaveApplicationJob;
use App\Models\Academic\AcademicLeaveCategory;
use App\Models\Academic\AcademicLeaveType;
use App\Models\Event\Event;
use App\Models\Site\EmployeeLeave\SiteEmployeeLeaveGenerate;
use App\Models\Site\EmployeeLeave\SiteEmployeeLeaveHistory;
use App\Models\Site\EmployeeLeave\SiteLeavePolicy;
use App\Models\Site\Role\SiteRole;
use App\Models\User\EmployeeHistory;
use App\Models\User\GlobalUser;
use App\User;
use Auth;
use Carbon\Carbon;
use Carbon\CarbonPeriod;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use Psr\Log\LoggerAwareInterface;
use Response;
use Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\DB ;
use Dotenv\Exception\ValidationException;

class SiteEmployeeLeaveHistoryController extends Controller
{
    private $employeeLeaveHistory;
    private $employeeHistory;
    private $siteLeavePolicy;
    private $academicLeaveType;
    private $academicLeaveCategory;
    private $employeeLeaveGenerate;


    public function __construct(SiteEmployeeLeaveHistory $employeeLeaveHistory,
                                EmployeeHistory $employeeHistory, SiteLeavePolicy $siteLeavePolicy,
                                AcademicLeaveType $academicLeaveType, AcademicLeaveCategory $academicLeaveCategory, SiteEmployeeLeaveGenerate $employeeLeaveGenerate)
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
        $this->employeeLeaveHistory = $employeeLeaveHistory;
        $this->employeeHistory = $employeeHistory;
        $this->academicLeaveType = $academicLeaveType;
        $this->siteLeavePolicy = $siteLeavePolicy;
        $this->academicLeaveCategory = $academicLeaveCategory;
        $this->employeeLeaveGenerate = $employeeLeaveGenerate;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType = 'Employee Leave History View';
        return view('default.admin.layouts.master', compact('viewType'));

//        return view('default.admin.sites.employee-leave.employee-leave-history-view', compact('viewType'));
    }

    public function getEmployeeList()
    {
        $employee_history = EmployeeHistory::with('employee')->whereHas('user')->where('site_id',Session::get('SITE_ID'))->where('status',true)->get();
        return $employee_history;
    }

    public function getLeaveTypeLeaveCategoryList($id = null)
    {
        if($id == null){
            $employee_id = Auth::user()->id;
            $employee_history = EmployeeHistory::where('user_id', $employee_id)->where('status', 1)->with('user')->first();

        }else{
            $employee_history = EmployeeHistory::where('id', $id)->where('status', 1)->with('user')->first();
        }


        if($employee_history){
            $gender_id =  $employee_history->user['gender_id'];

            $leave_policy_without_gender = $this->siteLeavePolicy->where('employee_designation_id', $employee_history->designation_id)->where('status', 1)->where('gender_id', null)->get();

            $leave_policy_with_gender = $this->siteLeavePolicy->where('employee_designation_id', $employee_history->designation_id)->where('status', 1)->where('gender_id', $gender_id)->get();

            if(count($leave_policy_with_gender)){
                $leave_policy = array_merge($leave_policy_without_gender->toArray(), $leave_policy_with_gender->toArray());
            }else{
                $leave_policy = $leave_policy_without_gender;
            }

//            return $leave_policy;
            $leave_type_ids = array();
            $leave_category_ids = array();
            foreach ($leave_policy as $key => $vlue){
                $leave_type_ids[] = $vlue['academic_leave_type_id'];
                $leave_category_ids[] = $vlue['academic_leave_category_id'];
            }

//            return $leave_type_ids;

//            $leave_type_ids = $leave_policy->pluck('academic_leave_type_id');

            $leave_type_list = $this->academicLeaveType->whereIn('id', $leave_type_ids)->get();

//            $leave_category_ids = $leave_policy->pluck('academic_leave_category_id');

            $leave_category_list = $this->academicLeaveCategory->whereIn('id', $leave_category_ids)->get();


//            return $leave_category_list;
            return response()->json([$leave_type_list, $leave_category_list], 200, [], JSON_NUMERIC_CHECK);


        }
    }

    public function employeeLeaveApplicationList(Request $request)
    {
        $search_leave_type = $request->search_leave_type;
        $search_leave_category = $request->search_leave_category;
        $search_leave_policy = $request->search_leave_policy;
        $search_designation = $request->search_designation;
        $search_text = $request->search_text;
        $search_date = $request->search_date;
        $search_leave_status = $request->search_leave_status;
        $paginate = $request->paginate ?? 20;

//        return $request;

        $txt = '%' . $search_text . '%';

        $leave_history =  $this->employeeLeaveHistory
                ->with(['siteEmployeeLeaveGenerate'=>function($query){
                    $query->with(['siteLeavePolicy'=>function($q){
                        $q->with('academicLeaveType','academicLeaveCategory','designation');
                    }]);
                }])
                ->with(['employeeHistory'=>function ($qr){
                    $qr->with('user');
                }])
                ->when($search_leave_type, function ($query) use($search_leave_type){
                    return $query->whereHas('siteEmployeeLeaveGenerate', function ($qr) use($search_leave_type){
                        $qr->whereHas('siteLeavePolicy', function ($q) use($search_leave_type){
                            $q->where('academic_leave_type_id', $search_leave_type);


                        });
                    });
                })
                ->when($search_leave_category, function ($query) use($search_leave_category){
                    return $query->whereHas('siteEmployeeLeaveGenerate', function ($qr) use($search_leave_category){
                        $qr->whereHas('siteLeavePolicy', function ($q) use($search_leave_category){
                            $q->where('academic_leave_category_id', $search_leave_category);
                        });
                    });
                })
                ->when($search_leave_policy, function ($query) use($search_leave_policy){
                    return $query->whereHas('siteEmployeeLeaveGenerate', function ($qr) use($search_leave_policy){
                        $qr->whereHas('siteLeavePolicy', function ($q) use($search_leave_policy){
                            $q->where('id', $search_leave_policy);
                        });
                    });
                })
                ->when($search_designation, function ($query) use($search_designation){
                    return $query->whereHas('siteEmployeeLeaveGenerate', function ($qr) use($search_designation){
                        $qr->whereHas('siteLeavePolicy', function ($q) use($search_designation){
                            $q->where('employee_designation_id', $search_designation);
                        });
                    });
                })
                ->when($search_text, function($query) use($txt){
                    return $query->whereHas('employeeHistory', function ($qr) use ($txt){
                        $qr->whereHas('employee', function ($q) use ($txt){
                            $q->where(function ($query) use ($txt) {
                                $query->whereTranslationLike('first_name', $txt)
                                    ->orWhereTranslationLike('last_name', $txt);

                            });
                        });
                    });
                })

                ->when($search_date, function($query) use($search_date){
                    $query->where(function ($query) use ($search_date) {
                        return $query->where('request_date', $search_date)
                                    ->orWhere('cancel_date', $search_date)
                                    ->orWhere('approve_date', $search_date);
                    });

                })
                ->when($search_leave_status, function($query) use($search_leave_status) {
                    $query->where('leave_status', $search_leave_status);
                })
                ->where('status', 1)
                ->orderBy('id', 'DESC')
                ->paginate($paginate);
//                                                    ->get();
        $mytime = Carbon::now();
        $to_date =  $mytime->toDateString();
        return [$leave_history,$to_date];
    }

    public function getEmployeeLeaveBalanceList(Request $request)
    {


        $search_leave_type = $request->search_leave_type;
        $search_leave_category = $request->search_leave_category;
        $paginate = $request->paginate ?? 15;


        $employee_id = Auth::user()->id;


        $employee_history = $this->employeeHistory->where('user_id', $employee_id)->where('status', 1)->with('user')->first();
       
        if($employee_history){
            
        $leave_generate =  $this->employeeLeaveGenerate->with(['siteLeavePolicy'=>function($query){
                                    $query->with('academicLeaveType','academicLeaveCategory');
                            }])
                            ->when($search_leave_type, function ($query) use($search_leave_type){
                                return $query->whereHas('siteLeavePolicy', function ($qr) use($search_leave_type){
                                    $qr->whereHas('academicLeaveType', function ($q) use($search_leave_type){
                                       $q->where('id', $search_leave_type);
                                    });
                                });
                            })
                            ->when($search_leave_category, function ($query) use($search_leave_category){
                                return $query->whereHas('siteLeavePolicy', function ($qr) use($search_leave_category){
                                    $qr->whereHas('academicLeaveCategory', function ($q) use($search_leave_category){
                                       $q->where('id', $search_leave_category);
                                    });
                                });
                            })
                            ->where('status', 1)
                            ->where('employee_history_id', $employee_history->id)
                            ->orderBy('id', 'ASC')
                            ->paginate($paginate);
//return $leave_generate;

        if(count($leave_generate)){

            foreach ($leave_generate as $key => $value){

                    $leave_type_array[$key] = $value->siteLeavePolicy->academicLeaveType;
                    $leave_category_array[$key] = $value->siteLeavePolicy->academicLeaveCategory;

                    //=================leave balance list data===================

                    $leave_history =  $this->employeeLeaveHistory->orderBy('id','DESC')->where('site_employee_leave_generate_id', $value->id)
                                        ->where('leave_status', 'approved')
                                        ->where('status', 1)
                                        ->first();
                    if($leave_history){
                        $final_data[$key]['leave_type'] = $value->siteLeavePolicy->academicLeaveType['name'];
                        $final_data[$key]['leave_category'] = $value->siteLeavePolicy->academicLeaveCategory['name'];
                        $final_data[$key]['total_days'] = $value->leave_days;
                        $final_data[$key]['spend_days'] = $value->previous_leave_days_remaining + $value->leave_days - $leave_history->remaining_days;
                        $final_data[$key]['remaining_days'] = $leave_history->remaining_days;
                    }else{
                        $final_data[$key]['leave_type'] = $value->siteLeavePolicy->academicLeaveType['name'];
                        $final_data[$key]['leave_category'] = $value->siteLeavePolicy->academicLeaveCategory['name'];
                        $final_data[$key]['total_days'] = $value->previous_leave_days_remaining + $value->leave_days;
                        $final_data[$key]['spend_days'] = 0;
                        $final_data[$key]['remaining_days'] = $value->previous_leave_days_remaining + $value->leave_days;;
                    }

            }

            $collection_leave_type = collect($leave_type_array);

            $leave_type_array = $collection_leave_type->unique()->values()->all();

            $collection_leave_category = collect($leave_category_array);

            $leave_category_array = $collection_leave_category->unique()->values()->all();

            return [$final_data, $leave_type_array, $leave_category_array];

        }
    }

    }

    public function getEmployeeLeaveHistoryList(Request $request)
    {
//        return $request;
        $search_date = $request->search_date;
//        $search_txt = $request->search_txt;
        $search_leave_type = $request->search_leave_type;
        $search_leave_status = $request->search_leave_status;
        $paginate = $request->paginate ?? 15;

//        $txt = '%' . $search_txt . '%';

        $employee_id = Auth::user()->id;

        $employee_history = $this->employeeHistory->where('user_id', $employee_id)->orderBy('id','DESC')->where('status', 1)->with('user')->first();

        $leave_history =  $this->employeeLeaveHistory->with(['siteEmployeeLeaveGenerate'=>function($query){
                             $query->with(['siteLeavePolicy'=>function($q){
                                    $q->with('academicLeaveType','academicLeaveCategory');
                            }]);
                        }])
                        ->when($search_leave_type, function ($query) use($search_leave_type){
                            return $query->whereHas('siteEmployeeLeaveGenerate', function ($qrr) use($search_leave_type){
                                $qrr->whereHas('siteLeavePolicy', function ($qr) use($search_leave_type){
                                   $qr->whereHas('academicLeaveType', function ($q) use($search_leave_type){
                                     $q->where('id',$search_leave_type);
                                   });
                                });
                            });
                        })
                        ->when($search_date, function ($query) use($search_date){
                            return $query->where('request_date', $search_date)
                                        ->orWhere('approve_date', $search_date)
                                        ->orWhere('cancel_date', $search_date)
                                        ->orWhere('from_date', $search_date)
                                        ->orWhere('to_date', $search_date);
                        })
                        ->when($search_leave_status, function ($query) use($search_leave_status){
                            $query->where('leave_status', $search_leave_status);
                        })
                        ->where('employee_history_id', $employee_history->id)
                        ->where('status', 1)
//                        ->get();
                        ->orderBy('id', 'DESC')
                        ->paginate($paginate);

        if($leave_history != null){
            return $leave_history;
        }else{
            return Response::json(['message' => 'Sorry! Data not found!'], 411);

        }

    }



    public function getEmployeeLeaveDays($academic_type_id, $academic_category_id, $id = null)
    {
//        $employee_id = Auth::user()->id;
//        $employee_history_list =  $this->employeeHistory->where('user_id', $employee_id)->where('status', 1)->first();
//        return  $employee_history_list;

        if($id == null){
            $employee_id = Auth::user()->id;
            $employee_history_list =  $this->employeeHistory->where('user_id', $employee_id)->where('status', 1)->first();
        }else{
            $employee_history_list =  $this->employeeHistory->where('id', $id)->where('status', 1)->first();
        }

        $gender_id = $employee_history_list->employee['gender_id'];

        $policy = $this->siteLeavePolicy->where('employee_designation_id', $employee_history_list->designation_id)
                ->where('gender_id', $gender_id)
                ->where('academic_leave_type_id', $academic_type_id)
                ->where('academic_leave_category_id', $academic_category_id)
                ->where('status', 1)
                ->orderBy('id', 'DESC')
                ->first();

        if(!$policy){
           
               $policy=SiteLeavePolicy::where('academic_leave_type_id',$academic_type_id)
                ->where('academic_leave_category_id',$academic_category_id)
                ->where('employee_designation_id',$employee_history_list->designation_id)
                ->orderBy('id', 'DESC')
                ->first();
        }


        if($policy){


            $check_leave_generate = SiteEmployeeLeaveGenerate::where('employee_history_id', $employee_history_list->id)
            ->where('site_leave_policy_id', $policy->id)
            ->where('status', 1)
           // ->orderBy('id', 'DESC')
            ->first();



    $exist_leave_generate_id = 0;
    if($check_leave_generate){
        $exist_leave_generate_id = $check_leave_generate->id;
    }

    $pending_txt = 'pending';
    $approved_txt = 'approved';

    $leave_history =  $this->employeeLeaveHistory
                        ->where('site_employee_leave_generate_id', $exist_leave_generate_id)
                        ->whereHas('siteEmployeeLeaveGenerate', function ($query) use($academic_type_id, $academic_category_id){
                            $query->whereHas('siteLeavePolicy', function ($qr) use($academic_type_id, $academic_category_id){
                                $qr->where('academic_leave_type_id', $academic_type_id)
                                    ->where('academic_leave_category_id', $academic_category_id);
                            });
                        })
                        ->where(function ($query) use($pending_txt,$approved_txt){
                            $query->where('leave_status', $pending_txt)
                                    ->orwhere('leave_status', $approved_txt);
                        })
                        ->where('status', 1)
                        ->orderBy('id','DESC')
                        ->first();

            
    if($leave_history){
        $leave_days =  $leave_history->remaining_days;
        $leave_generate_id =  $leave_history->site_employee_leave_generate_id;
        $employee_history_id =  $leave_history->employee_history_id;
        return [$leave_days, $leave_generate_id, $employee_history_id];
    }else{
        $leave_generate = $this->employeeLeaveGenerate
                        ->where('employee_history_id', $employee_history_list->id)
                        ->whereHas('siteLeavePolicy', function ($query) use($academic_type_id, $academic_category_id){
                            $query->where('academic_leave_type_id', $academic_type_id)
                                ->where('academic_leave_category_id', $academic_category_id);
                        })
                        ->where('status', 1)
                        ->first();
                     //   dd($leave_generate);
        if($leave_generate){
            $leave_days = $leave_generate->previous_leave_days_remaining + $leave_generate->leave_days;
            $leave_generate_id =  $leave_generate->id;
            $employee_history_id =  $leave_generate->employee_history_id;
           return [$leave_days, $leave_generate_id, $employee_history_id];
        }
    }


    }else{
         return [0, 0, $id];
    }
            
       


    }
    
    public function checkLeaveIfExist($request, $leave_generate_data)
    {
//        return [$request,$leave_generate_data];
        $st_date = $request->date['start'];
        $ed_date = $request->date['end'];

        $leave_history = SiteEmployeeLeaveHistory::where('site_employee_leave_generate_id', $leave_generate_data)
            ->where('leave_status', '!=', 'cancelled')
            ->get();

         //   dd($leave_history);

        if(count($leave_history)){
            $period = CarbonPeriod::create($st_date, $ed_date);
            foreach ($period as $date) {
                $dd = $date->format('Y-m-d');

                foreach ($leave_history as $key => $value){
                    $start_date = $value->from_date;
                    $end_date = $value->to_date;
                    $prd = CarbonPeriod::create($start_date, $end_date);

                    foreach ($prd as $dt){
                        $ddd = $dt->format('Y-m-d');
//                        return $ddd;
                        if($dd == $ddd){
//                            return $ddd;
                            return 'found';
                        }
                    }

                }

            }
            return 'not found';



        }
    }

    public function updateLeaveDaysAndApproved($id, $days)
    {
        $leave_history =  $this->employeeLeaveHistory->findOrFail($id);
        $day_sum = $leave_history->spend_leave_days + $leave_history->remaining_days;
        $remaining_days = $day_sum - $days;
        $update_leave_days = $leave_history->update([
           'spend_leave_days'=>$days,
           'remaining_days'=>$remaining_days,
        ]);

        $data = $this->empLeaveConditionalApprove($leave_history);
        if($data == "updated"){

            //======================notification========================
//                $employee_leave_history =  $this->employeeLeaveHistory->where('employee_history_id', $leave_history->employee_history_id)->orderBy('id', 'DESC')->with('employeeHistory')->first();

            $user_id = EmployeeHistory::where('id', $leave_history->employee_history_id)->first()->user_id ?? 0;
            $route=route('site-emp-leave-notification-view',['']);

            dispatch(new EmployeeLeaveApplicationApproveJob($leave_history,$user_id,$route));

            //======================end========================

            return ['message' => 'Successfully Approved!'];
        }else if($data == "notupdated"){
            return Response::json(['message' => 'Sorry! this leave can not be approved!'], 411);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function createApplication(Request $request)
    {

    DB::beginTransaction();
    try {

        $this->validate($request,[

            'academicLeaveType' => 'required',
            'academicLeaveCategory' => 'required',
            'date' => 'required',

        ]);

        $end_date_empty_check = $request->date['end'];

        if(!$end_date_empty_check){
            return Response::json(['message' => 'Please, enter To date!'], 411);
        }

        if($request->id !=null){

            //==================update=====================

            $update_application = $this->updateApplication($request);
            return $update_application;

        }else{

            //==================create=====================

            $academic_type_id = $request->academicLeaveType;
            $academic_category_id = $request->academicLeaveCategory;

            //================only for non-generated leave===============================

            if($request->employeeID == null){
                $employee_id = Auth::user()->id;
                $employee_history = EmployeeHistory::where('user_id', $employee_id)->where('status', 1)->with('employee')->first();
                $emp_history_id = $employee_history->id;
            }else{
                $emp_history_id = $request->employeeID;
                $employee_history = EmployeeHistory::where('id', $emp_history_id)->where('status', 1)->with('employee')->first();
                $employee_id = $employee_history->user_id;
            }


            $gender_id = $employee_history->employee['gender_id'];
            $leave_policy_with_gender = $this->siteLeavePolicy->where('employee_designation_id', $employee_history->designation_id)
                                ->where('gender_id', $gender_id)
                                ->where('academic_leave_type_id', $academic_type_id)
                                ->where('academic_leave_category_id', $academic_category_id)
                                ->where('status', 1)
                                ->orderBy('id', 'DESC')
                                ->first();

                               // dd($leave_policy_with_gender);
            $leave_array = $this->getEmployeeLeaveDays($academic_type_id,$academic_category_id, $emp_history_id);

            $leave_days = $leave_array[0];
            $leave_generate_id = $leave_array[1];
            $employee_history_id = $leave_array[2];

         //   dd($leave_generate_id);

            if ($leave_policy_with_gender){

                //--------------request days-------------------------

                $start_date = strtotime($request->date['start']);
                $end_date = strtotime($request->date['end']);
                $datediff = $end_date - $start_date;
                $days = round($datediff / (60 * 60 * 24)) + 1;

                //-------------request date--------------------------

                $mytime = Carbon::now();
                $request_date = $mytime->toDateString();

              //  $leave_days = $leave_policy_with_gender->leave_days;

                if($days<=$leave_days){

                    //----------------generate leave-----------------------------

                    $leave_generate = $this->employeeLeaveGenerate->where('employee_history_id', $employee_history->id)
                        ->where('site_leave_policy_id', $leave_policy_with_gender->id)
                        ->where('status', 1)
                        ->first();

                    if($leave_generate){
                        $leave_generate_data = $this->employeeLeaveGenerate->where('site_leave_policy_id', $leave_policy_with_gender->id)
                            ->orderBy('id', 'DESC')
                            ->where('employee_history_id', $employee_history->id)
                            ->where('status', 1)
                            ->first();

                        //==============check leave exist===========================
                        $leave_generate_id = $leave_generate_data->id;
                     //   dd($leave_generate_id);
                        $check_leave = $this->checkLeaveIfExist($request, $leave_generate_id);

                        if($check_leave == "found"){
                            DB::rollBack();
                            return Response::json(['message' => 'Request date already exist!'], 411);

                        }
                        //----------------create application-----------------------------

                        $employeeLeaveHistory = $this->employeeLeaveHistory->create([
                            'site_employee_leave_generate_id' => $leave_generate_data->id,
                            'employee_history_id' => $employee_history->id,
                            'spend_leave_days' => $days,
                            'remaining_days' => $leave_days - $days,
                            'from_date' => $request->date['start'],
                            'to_date' => $request->date['end'],
                            'reason' => $request->reason,
                            'request_date' => $request_date,
                            'leave_status' => 'pending',
                            'status' => $request->status, 
                        ]);
                        DB::commit();
                        return ['message' => 'Successfully Saved!'];
                    }else{
                        $employee_previous_history_list = EmployeeHistory::where('user_id', $employee_id)->orderBy('id', 'DESC')->where('status', 0)->with('user')->first();
                        if($employee_previous_history_list){
                            $employee_previous_history_id = $employee_previous_history_list->id;
                        }else{
                            $employee_previous_history_id = null;
                        }

                        $employeeLeaveGenerate=SiteEmployeeLeaveGenerate::create([
                            'site_leave_policy_id' => $leave_policy_with_gender->id,
                            'employee_previous_history_id' => $employee_previous_history_id,
                            'employee_history_id' => $employee_history->id,
                            'academic_fiscal_year_id' => null,
                            'previous_leave_days_remaining' => null,
                            'leave_days' => $leave_days,
                            'status' => $request->status
                        ]);

                        $leave_generate_data = $this->employeeLeaveGenerate->where('site_leave_policy_id', $leave_policy_with_gender->id)
                            ->orderBy('id', 'DESC')
                            ->where('employee_history_id', $employee_history->id)
                            ->where('status', 1)->first();

                        //----------------create application-----------------------------

                        $employeeLeaveHistory = $this->employeeLeaveHistory->create([
                            'site_employee_leave_generate_id' => $leave_generate_data->id,
                            'employee_history_id' => $employee_history->id,
                            'spend_leave_days' => $days,
                            'remaining_days' => $leave_days - $days,
                            'from_date' => $request->date['start'],
                            'to_date' => $request->date['end'],
                            'reason' => $request->reason,
                            'request_date' => $request_date,
                            'leave_status' => 'pending',
                            'status' => $request->status,
                        ]);

                        //======================notification========================

                        $employee_leave_history =  $this->employeeLeaveHistory->where('employee_history_id', $employee_history->id)->orderBy('id', 'DESC')
                            ->with(['employeeHistory' => function ($query) {
                                $query->with('employee');
                            }])->first();

                        $user_role = SiteRole::with('users')->where('name', 'admin')->first();

                        
                        $admin_user_details =  $user_role->users
                            ->where('status',true)
                        //    ->where('institute_head',true)
                            ->first();

                        if(!$admin_user_details){
                            DB::rollBack();
                            return Response::json(['message' => 'Sorry! you have no permission!'], 411);
                        }


                        $admin_user_details =  $user_role->users;
                        $admin_user_id =  $admin_user_details->id;

                        $data_array = array();
                        $data_array['employee_name'] = $employee_leave_history->employeeHistory->employee->full_name;
                        $data_array['employee_id'] = $employee_leave_history->employeeHistory->employee->username;
                        $data_array['employee_spend_leave_days'] = $employee_leave_history->spend_leave_days;
                        $data_array['form_date'] = $employee_leave_history->from_date;
                        $data_array['to_date'] = $employee_leave_history->to_date;
                        $data_array['id'] = $employee_leave_history->id;
                        $data_array['admin_user_id'] = $admin_user_id;

                        $route=route('site-emp-leave-application-notification-view',['']);


                        dispatch(new EmployeeLeaveApplicationJob($data_array, $route));

                        //======================end========================
                        DB::commit();
                        return ['message' => 'Successfully Saved!'];
                    }

                }else{
                    return Response::json(['message' => 'Sorry! you requested for exsessive days!'], 411);

                }
            }else{

                //================only for generated leave===============================

                // $leave_array = $this->getEmployeeLeaveDays($academic_type_id,$academic_category_id, $emp_history_id);
                // $leave_days = $leave_array[0];
                // $leave_generate_id = $leave_array[1];
                // $employee_history_id = $leave_array[2];

                //--------------request days-------------------------

                $start_date = strtotime($request->date['start']);
                $end_date = strtotime($request->date['end']);
                $datediff = $end_date - $start_date;
                $days = round($datediff / (60 * 60 * 24)) + 1;

                //-------------request date--------------------------

                $mytime = Carbon::now();
                $request_date = $mytime->toDateString();

                //==============check leave exist===========================
             
                $check_leave = $this->checkLeaveIfExist($request, $leave_generate_id);
              //  dd($check_leave);
                if($check_leave == "found"){
                    return Response::json(['message' => 'Request date already exist!'], 411);

                }

                //----------------create-----------------------------

                if($days<=$leave_days){
                    $employeeLeaveHistory = $this->employeeLeaveHistory->create([
                        'site_employee_leave_generate_id' => $leave_generate_id,
                        'employee_history_id' => $employee_history_id,
                        'spend_leave_days' => $days,
                        'remaining_days' => $leave_days - $days,
                        'from_date' => $request->date['start'],
                        'to_date' => $request->date['end'],
                        'reason' => $request->reason,
                        'request_date' => $request_date,
                        'leave_status' => 'pending',
                        'status' => $request->status,
                    ]);

                    //======================notification========================

                    $employee_leave_history =  $this->employeeLeaveHistory->where('employee_history_id', $employee_history->id)->orderBy('id', 'DESC')
                        ->with(['employeeHistory' => function ($query) {
                            $query->with('employee');
                        }])->first();

                    $user_role = SiteRole::with('users')->where('name','admin')->first();

                 //   dd($user_role);

                    $admin_user_details =  $user_role->users
                                    ->where('status',true)
                             //       ->where('institute_head',true)
                                    ->first();
                     if(!$admin_user_details){
                        return Response::json(['message' => 'Sorry! you have no permission!'], 411);
                     }
                    $admin_user_id =  $admin_user_details->id;

                    $data_array = array();
                    $data_array['employee_name'] = $employee_leave_history->employeeHistory->employee->full_name;
                    $data_array['employee_id'] = $employee_leave_history->employeeHistory->employee->username;
                    $data_array['employee_spend_leave_days'] = $employee_leave_history->spend_leave_days;
                    $data_array['form_date'] = $employee_leave_history->from_date;
                    $data_array['to_date'] = $employee_leave_history->to_date;
                    $data_array['id'] = $employee_leave_history->id;
                    $data_array['admin_user_id'] = $admin_user_id;
                     
                    $route=route('site-emp-leave-application-notification-view',['']);

                    dispatch(new EmployeeLeaveApplicationJob($data_array, $route));

                    //======================end========================
                    DB::commit();
                    return ['message' => 'Successfully Saved!'];
                }else{
                    return Response::json(['message' => 'Sorry! you requested for exsessive days!'], 411);

                }
            }

        }
   
        DB::commit();

    } catch (ValidationException $exception) {
        DB::rollBack();
        return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
    } catch (Exception $exception) {
        DB::rollBack();
        return Response::json(['message' => $exception->getMessage()], 410);
    }

    }

    public function getHolidayNumber($id)
    {
        $leave_history = $this->employeeLeaveHistory->findOrFail($id);
//        return $leave_history;

        $start_date = $leave_history['from_date'];
        $end_date = $leave_history['to_date'];
        $head_key = 'holiday';

        $holiday = 0;

        $period = CarbonPeriod::create($start_date, $end_date);
        foreach ($period as $date) {
            $dd = $date->format('Y-m-d');
            $event = Event::where('start_date', $dd)->whereHas('academicCalendarHead', function ($query) use($head_key){
                $query->where('head_key', $head_key);
            })->first();
            if($event){
                $holiday = $holiday;
                $holiday++;

            }
        }
        return $holiday;
    }

    public function employeeLeaveApprove($id, $holidayCheck = null){
     
        if($holidayCheck == null){
            
            $leave_history = $this->employeeLeaveHistory->with('employeeHistory')->findOrFail($id);
          //  dd($leave_history);
            $start_date = $leave_history['from_date'];
            $end_date = $leave_history['to_date'];
            $head_key = 'holiday';

            $period = CarbonPeriod::create($start_date, $end_date);
            foreach ($period as $date) {
                $dd = $date->format('Y-m-d');
                $event = Event::where('start_date', $dd)->whereHas('academicCalendarHead', function ($query) use($head_key){
                    $query->where('head_key', $head_key);
                })->first();
                if($event){
                    $holiday = "found";
                    return $holiday;
                }
            }
            $data = $this->empLeaveConditionalApprove($leave_history);
           // dd($data);
            if($data == "updated"){

                //======================notification========================
//                $employee_leave_history =  $this->employeeLeaveHistory->where('employee_history_id', $leave_history->employee_history_id)->orderBy('id', 'DESC')->with('employeeHistory')->first();
                $user_id = EmployeeHistory::where('id', $leave_history->employee_history_id)->first()->user_id ?? 0;
                $route=route('site-emp-leave-notification-view',['']);
                dispatch(new EmployeeLeaveApplicationApproveJob($leave_history,$user_id, $route));

                //======================end========================

                return ['message' => 'Successfully Approved!'];
            }else if($data == "notupdated"){
                return Response::json(['message' => 'Sorry! this leave can not be approved!'], 411);
            }

        }else{
            $leave_history = $this->employeeLeaveHistory->with('employeeHistory')->findOrFail($id);
           // dd($leave_history);
            $data = $this->empLeaveConditionalApprove($leave_history);
            if($data == "updated"){

                //======================notification========================
//                $employee_leave_history =  $this->employeeLeaveHistory->where('employee_history_id', $leave_history->employee_history_id)->orderBy('id', 'DESC')->with('employeeHistory')->first();

                $user_id = EmployeeHistory::where('id', $leave_history->employee_history_id)->first()->user_id ?? 0;
                $route=route('site-emp-leave-notification-view',['']);
                dispatch(new EmployeeLeaveApplicationApproveJob($leave_history,$user_id, $route));

                //======================end========================

                return ['message' => 'Successfully Approved!'];

            }else if($data == "notupdated"){
                return Response::json(['message' => 'Sorry! this leave can not be approved!'], 411);
            }
        }


    }

    public function empLeaveConditionalApprove($leave_history){

        $leave_history_list = $this->employeeLeaveHistory->where('employee_history_id', $leave_history->employee_history_id)->where('status', 1)->orderBy('id', 'DESC')->first();

        $employee_id = Auth::user()->id;
        $mytime = Carbon::now();
        $approved_date = $mytime->toDateString();


        if($leave_history_list->leave_status == 'pending' || $leave_history_list->leave_status == 'cancelled'){
            $find_approve = $this->employeeLeaveHistory->where('site_employee_leave_generate_id', $leave_history->site_employee_leave_generate_id)
                            ->where('leave_status', 'approved')->where('status', 1)->where('approve_status', 0)->orWhere('leave_status','cancelled')->orderBy('id', 'DESC')->first();

            if($find_approve){
                $update_history = $find_approve->update([
                    'approve_status' => 1,
                ]);
            }
            $leave_history_update = $leave_history->update([
                'leave_status' => 'approved',
                'approve_date' => $approved_date,
                'approved_or_cancelled_by' => $employee_id,
            ]);
            $data = 'updated';
            return $data;

        }else{
            $data = 'notupdated';
            return $data;

        }


    }


    public function employeeLeaveUndo($id){
//        return $id;
        $leave_history = $this->employeeLeaveHistory->findOrFail($id);
        $leave_history_list = $this->employeeLeaveHistory->where('employee_history_id', $leave_history->employee_history_id)
                                ->where('site_employee_leave_generate_id', $leave_history->site_employee_leave_generate_id)
                                ->where('status', 1)
                                ->orderBy('id', 'DESC')->first();

        if($leave_history_list->leave_status == 'approved'){
            $leave_history_update = $leave_history->update([
                'leave_status' => 'pending',
                'approve_date' => null,
                'approved_or_cancelled_by' => null,
            ]);
            return ['message' => 'Successfully Undo!'];
        }else{
            return Response::json(['message' => 'Sorry! this leave can not be undo! pending request exist!'], 411);
        }



    }

    public function employeeLeaveCancel($id){
//        return $id;

        $employee_id = Auth::user()->id;
        $mytime = Carbon::now();
        $cancel_date = $mytime->toDateString();

        $leave_history = $this->employeeLeaveHistory->with('employeeHistory')->findOrFail($id);
        $leave_history_update = $leave_history->update([
            'leave_status' => 'cancelled',
            'approve_date' => $cancel_date,
            'approved_or_cancelled_by' => $employee_id,
        ]);

        //======================notification========================
//                $employee_leave_history =  $this->employeeLeaveHistory->where('employee_history_id', $leave_history->employee_history_id)->orderBy('id', 'DESC')->with('employeeHistory')->first();

        $user_id = EmployeeHistory::where('id', $leave_history->employee_history_id)->first()->user_id ?? 0;

        $route=route('site-notice-view',['']);

        dispatch(new EmployeeLeaveApplicationCancelJob($leave_history, $user_id, $route));

        //======================end========================

        return ['message' => 'Successfully Cancel!'];

    }

    public function allEmployeeLeaveBalanceList(Request $request){



        //========================main=======================

        $search_leave_type = $request->search_leave_type;
        $search_leave_category = $request->search_leave_category;
        $search_leave_policy = $request->search_leave_policy;
        $search_designation = $request->search_designation;
        $search_text = $request->search_text;
        $paginate = $request->paginate ?? 15;

        $txt = '%' . $search_text . '%';


//        $employee_history_list = EmployeeHistory::where('status', 1)->with('user')->get();
        $sl = 1;
        $leave_generate= $this->employeeLeaveGenerate->with(['siteLeavePolicy'=>function ($query){
                                    $query->with('academicLeaveType','academicLeaveCategory','designation');
                                }])
                                ->with(['employeeHistory'=>function($qrr){
                                    $qrr->with('employee');
                                }])
                                ->when($search_leave_type, function($query) use($search_leave_type){
                                    return $query->whereHas('siteLeavePolicy', function ($qr) use ($search_leave_type){
                                        $qr->whereHas('academicLeaveType', function ($q) use ($search_leave_type){
                                            $q->where('id', $search_leave_type);
                                        });
                //                                    $q->where('id', $academic_leave_type);
                                    });
                                })
                                ->when($search_leave_category, function($query) use($search_leave_category){
                                    return $query->whereHas('siteLeavePolicy', function ($qr) use ($search_leave_category){
                                        $qr->whereHas('academicLeaveCategory', function ($q) use ($search_leave_category){
                                            $q->where('id', $search_leave_category);
                                        });
                //                                    $q->where('id', $academic_leave_type);
                                    });
                                })
                                ->when($search_designation, function($query) use($search_designation){
                                    return $query->whereHas('siteLeavePolicy', function ($qr) use ($search_designation){
                                        $qr->whereHas('designation', function ($q) use ($search_designation){
                                            $q->where('id', $search_designation);
                                        });
                //                                    $q->where('id', $academic_leave_type);
                                    });
                                })
                                ->when($search_text, function($query) use($txt){
                                    return $query->whereHas('employeeHistory', function ($qr) use ($txt){
                                        $qr->whereHas('employee', function ($q) use ($txt){
                                            $q->where(function ($query) use ($txt) {
                                                $query->where('username', 'LIKE', $txt)
                                                    ->orWhere('email', 'LIKE', $txt)
                                                    ->orWhere('contact_number', 'LIKE', $txt)
                                                    ->orWhereTranslationLike('first_name', $txt)
                                                    ->orWhereTranslationLike('last_name', $txt);
                                            });
                                        });
                                    });

                                })
                                ->when($search_leave_policy, function($query) use($search_leave_policy){
                                    $query->where('site_leave_policy_id', $search_leave_policy);
                                })

                                ->where('status', 1)
                                ->paginate($paginate);
//        return $leave_generate;


            if (count($leave_generate)){

                foreach ($leave_generate as $k => $v){
                    $leave_history = $this->employeeLeaveHistory->where('site_employee_leave_generate_id', $v->id)->where('leave_status', 'approved')->orderBy('id','DESC')->first();

                    if($leave_history){
                        $final_array[$k]['employee'] = $v->employeeHistory->employee['full_name'];
                        $final_array[$k]['leave_type'] = $v->siteLeavePolicy->academicLeaveType['name'];
                        $final_array[$k]['leave_category'] = $v->siteLeavePolicy->academicLeaveCategory['name'];
                        $final_array[$k]['total_leave_days'] = $v->previous_leave_days_remaining + $v->leave_days;
                        $final_array[$k]['spend_days'] = $v->previous_leave_days_remaining + $v->leave_days - $leave_history->remaining_days;
                        $final_array[$k]['remaining_days'] = $leave_history->remaining_days;
                    }else{
                        $final_array[$k]['employee'] = $v->employeeHistory->employee['full_name'];
                        $final_array[$k]['leave_type'] = $v->siteLeavePolicy->academicLeaveType['name'];
                        $final_array[$k]['leave_category'] = $v->siteLeavePolicy->academicLeaveCategory['name'];
                        $final_array[$k]['total_leave_days'] = $v->previous_leave_days_remaining + $v->leave_days;
                        $final_array[$k]['spend_days'] = 0;
                        $final_array[$k]['remaining_days'] = $v->previous_leave_days_remaining + $v->leave_days;
                    }

                    $sl++;
                }

            }else{
                return Response::json(['message' => 'Sorry! no data found!'], 411);
            }


            return [$final_array, $leave_generate];



    }

    public function updateApplication($request){

        $leave_history_data = $this->employeeLeaveHistory->findOrFail($request->id);

        $mytime = Carbon::now();
        $request_date = $mytime->toDateString();$fg = strtotime($request_date);
//        ===============new days====================
        $start_date = strtotime($request->date['start']);
        $end_date = strtotime($request->date['end']);
        $datediff = $end_date - $start_date;
        $new_days = round($datediff / (60 * 60 * 24)) + 1;

//        ==================old days=================
        $rest_days = $leave_history_data->spend_leave_days - $new_days;
        $remainig_days = $leave_history_data->remaining_days + $rest_days;
        $update_application = $leave_history_data->update([
            'spend_leave_days'=>$new_days,
            'remaining_days'=>$remainig_days,
            'from_date'=>$request->date['start'],
            'to_date'=>$request->date['end'],
            'reason'=>$request->reason,
            'request_date'=>$request_date,

        ]);

        return ['message' => 'Successfully Saved!'];

    }

    public function deleteLeaveHistory($id)
    {
        $leave_history_data = $this->employeeLeaveHistory->findOrFail($id);
        $delele_history = $leave_history_data->delete();
        return ['message' => 'Successfully Deleted!'];
    }


}
