<?php

namespace App\Http\Controllers\Site\Exam\SeatPlan;


use App\Models\Building\Building;
use App\Models\Floor\Floor;
use App\Models\Room\Room;
use App\Models\Site\Room\SiteBaseExamRoomSetting;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Response;
use Session;

class SiteExamRoomSettingController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');

    }




    public function getSiteBaseBuildingList(){

        $buildingList=Building::where('status', 1)->get();

        return compact('buildingList');
    }

    public function getSiteBuildingBaseFloorList($building_id){

        $floorList=Floor::where('building_id', $building_id)
            ->where('status', 1)
            ->get();

        return compact('floorList');
    }


    public function getSiteBuildingFloorBaseRoomListFormExam(Request $request){


        $roomlist=Room::where('building_id', $request->building_id)
            ->where('floor_id', $request->floor_id)
            ->where('status', 1)
            ->get();

        $roomSettingList=SiteBaseExamRoomSetting::where('building_id', $request->building_id)
            ->where('floor_id', $request->floor_id)
            ->where('status', true)
            ->get();


        $room_list_arr=Array();
        $room_list_array=[];
        foreach ($roomlist as $key => $value){

            $roomSettingCheck=$roomSettingList->where('room_id', $value->id);

            if(count($roomSettingCheck)>0){

                $column_position_ids=$roomSettingCheck->pluck('column_position')->unique();

                $roomSettingCheck_array=[];
                $roomSettingCheck_arr=Array();
                $count=0;
                foreach ($column_position_ids as $keys => $values){
                    $seat_count=$roomSettingCheck->where('column_position', $values)->count();

                    $roomSettingCheck_arr['seat_number']=$seat_count;
                    $roomSettingCheck_arr['column_position']=$values;

                    $roomSettingCheck_array[$count]=$roomSettingCheck_arr;
                    $count++;
                }

//                return $roomSettingCheck_array;

                $room_list_arr['column_number']=$value->column_number;
                $room_list_arr['invigilator_number']=$value->invigilator_number;
                $room_list_arr['door_seat_orientation']=$value->door_seat_orientation;
                $room_list_arr['total_exam_seat']=$value->total_seat==null?0:$value->total_seat;
                $room_list_arr['select_room_id']=true;
                $room_list_arr['room_column_row_array']=$roomSettingCheck_array;

            }
            else{

                $room_column_row_array=
                    [
                        [
                            'seat_number'=>0,
                            'column_position'=>1,
                            'id'=>0
                        ]
                    ];

                $room_list_arr['column_number']=1;
                $room_list_arr['invigilator_number']=1;
                $room_list_arr['door_seat_orientation']='right';
                $room_list_arr['total_exam_seat']=0;
                $room_list_arr['select_room_id']=false;
                $room_list_arr['room_column_row_array']=$room_column_row_array;
            }





            $room_list_array[$key]=array_merge($room_list_arr, $value->toArray());
        }


        return compact('room_list_array');

    }



    public function createUpdateSiteExamRoomSeatSetting(Request $request){

//        return $request;



        Room::where('id', $request['SeatSettingList']['id'])
            ->update([
                'column_number'=> $request['SeatSettingList']['column_number'],
                'door_seat_orientation'=> $request['SeatSettingList']['door_seat_orientation'],
                'total_exam_seat'=> $request['SeatSettingList']['total_exam_seat'],
                'invigilator_number'=> $request['SeatSettingList']['invigilator_number'],
            ]);


        $roomSettingList=SiteBaseExamRoomSetting::where('building_id', $request->building_id)
            ->where('floor_id', $request->floor_id)
            ->where('room_id', $request['SeatSettingList']['id'])
//            ->where('status', true)
            ->get();

        $SettingIDs=$roomSettingList->pluck('id');


        $created=[];
        $presentSettingIDs=[];
        $seat_position=1;
        foreach ($request['SeatSettingList']['room_column_row_array'] as $key => $value){

            if($value['column_position']>0 && $value['seat_number']>0 ){

                $roomSeatSettingList=$roomSettingList->where('column_position', $value['column_position']);

                for($i=1;$i<=$value['seat_number'];$i++){
                    $checkData=$roomSeatSettingList->where('seat_number', $i)->first();

                    if($checkData){

                        $presentSettingIDs[]=$checkData->id;

                        $checkData->seat_position= $seat_position;
                        $checkData->status=true;
                        $checkData->updated_at=Carbon::now();
                        $checkData->save();

                    }else{

                        $created[] = [
                            'building_id' => $request->building_id,
                            'floor_id' =>  $request->floor_id,
                            'room_id' => $request['SeatSettingList']['id'],
                            'column_position' => $value['column_position'],
                            'seat_number' => $i,
                            'seat_position' => $seat_position,
                            'status' => true,
                            'site_id' => Session::get('SITE_ID'),
                            'created_at' => Carbon::now(),

                        ];
                    }
                    $seat_position++;
                }

            }

        }

        if(count($created)>0){
            SiteBaseExamRoomSetting::insert($created);
        }

        $siteUncheckedColumn=array_diff($SettingIDs->toArray(), $presentSettingIDs);

        SiteBaseExamRoomSetting::whereIn('id', $siteUncheckedColumn)
            ->update([
                'status'=> false
            ]);

        return Response::json(['message' => 'Save Successfully!', 'mode' => 'Save!'], 200);
    }


}
