<?php

namespace App\Http\Controllers\Site\Exam\SeatPlan;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\AcademicYear\AcademicYear;

use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicExamType;
use App\Models\Academic\AcademicSection;
use App\Models\Examinations\Examination;
use App\Models\Room\Room;
use App\Models\Site\Exam\SiteExamDeclares;
use App\Models\Site\Exam\SiteExamDeclareStudent;
use App\Models\Site\Exam\SiteExamDeclareStudentSubject;
use App\Models\Site\Exam\SiteExamRoutine;
use App\Models\Site\Room\SiteBaseExamRoomSetting;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use App\Models\Student\StudentHistory;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use Response;
use Carbon\Carbon;
use PDF;


class SiteExamSeatPlanShowController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');

    }

    public function getExamRoomListForShow(Request $request){

        $exam_room_ids=SiteBaseExamRoomSetting::where('status', true)
            ->pluck('room_id')
            ->unique()
            ->filter();

        $roomlist=Room::whereIn('id', $exam_room_ids)
            ->orderBy('building_id')
            ->orderBy('floor_id')
            ->get();

        return compact('roomlist');
    }




    public function getExamRoomBaseSeatPlanForShow(Request $request){


        $exam_declare_ids=SiteExamDeclares::where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_version_id', $request->academic_version_id)
            ->where('examination_id', $request->examination_id)
            ->pluck('id');



        $exam_time_base_declare_routine_list=SiteExamRoutine::whereIn('site_exam_declare_id', $exam_declare_ids)
            ->where('exam_start_date', $request->examination_date)
            ->where('exam_start_time', $request->examination_time)
            ->get();

        $routine_ids=$exam_time_base_declare_routine_list->pluck('id')->unique()->filter();



        $selected_room_ids= collect($request->RoomList)->where('select_room_id', true)->pluck('id');


        $routine_base_student=SiteExamDeclareStudentSubject::with(['academicExamType'])
            ->whereIn('site_exam_routine_id', $routine_ids)
            ->whereIn('room_id', $selected_room_ids)
            ->select('id', 'room_id', 'column_position', 'student_history_id',
                'seat_number', 'academic_exam_type_id')
            ->get();





        $room_arr=Array();
        $room_array=[];
        foreach ($selected_room_ids as $keyRoomId => $valueRoomId) {

            $room_student_detail=$routine_base_student
                ->where('room_id', $valueRoomId);
            $room_student_ids=$room_student_detail->pluck('student_history_id')->unique();
            $student_details=StudentHistory::with(['department','stClass', 'shift', 'classGroup', 'section', 'session'])
                ->whereIn('id', $room_student_ids)
                ->select('id', 'user_id', 'student_roll_number', 'academic_department_id', 'academic_class_id', 'academic_shift_id',
                    'academic_class_group_id', 'academic_section_id', 'academic_session_id')
                ->get();

            $room=Room::where('id', $valueRoomId)->first();

            $room_detail=SiteBaseExamRoomSetting::with(['room'])
                ->where('room_id', $valueRoomId)
                ->where('status', true)
                ->get();

            $column_id_pluck=$room_detail->pluck('column_position')->unique();

            $column_count=count($column_id_pluck);

            $column_arr=Array();
            $column_array=[];
            $count=1;
            foreach ($column_id_pluck as $keyRoomSeat => $valueRoomSeat) {

                $row_span=$column_count-$count;
                $count++;

                $column_seat_list=$room_detail->where('column_position', $valueRoomSeat);

                $column_student_detail=$room_student_detail
                    ->where('column_position', $valueRoomSeat);
                $column_student_ids=$column_student_detail->pluck('student_history_id')->unique();

                $column_student_details=$student_details->whereIn('id', $column_student_ids);



                $seat_arr=Array();
                $seat_array=[];
                foreach ($column_seat_list as $keySeat => $valueSeat) {



                    $seat_student_detail=$column_student_detail
                        ->where('seat_number', $valueSeat->seat_number);

                    $seat_student_ids=$seat_student_detail->pluck('student_history_id')->unique();

                    $std_arr=Array();
                    $std_array=[];
                    foreach ($seat_student_ids as $keyStdSeat => $valueStdSeat) {

                        $seat_student_details=$student_details->where('id', $valueStdSeat)->first();

                        $student_exam_type_lists=$seat_student_detail->where('student_history_id', $valueStdSeat);

                        $std_arr['student_exam_type_list']=$student_exam_type_lists;


                        $std_array[$keyStdSeat]=array_merge($seat_student_details->toArray(), $std_arr);
                    }



                    $seat_arr['seat_number']=$valueSeat->seat_number;
                    $seat_arr['seat_position']=$valueSeat->seat_position;
                    $seat_arr['row_span']=$row_span;
                    $seat_arr['student_detail']=$std_array;

                    $seat_array[$valueSeat->seat_number]=$seat_arr;



                }


            //    $column_arr['column_position']=$valueRoomSeat['column_position'];
                $column_arr['column_student_count']=count($column_student_ids);
                $column_arr['column_seat_list']=$seat_array;

                $column_array[$keyRoomSeat]=$column_arr;

            }


            $room_arr['column_list']=$column_array;
            $room_arr['room_student_count']=count($room_student_ids);
            $room_arr['romm_id']=$valueRoomId;

            $room_array[$keyRoomId]=array_merge($room->toArray(), $room_arr);



        }

        return $room_array;



    }


    //===================Publish============

    public function getDateTimeListForSeatPlanPublish(Request $request){

        $data = $request->all();



        $declaredSubjectList = SiteExamDeclares::where('academic_year_id', $request->academic_year_id)
            ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when(!empty($data['academic_version_id']), function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
            ->where('examination_id', $request->examination_id)
            ->get(['id']);



        $exam_declare_ids=$declaredSubjectList->pluck('id')->unique();


        $exam_date_time_list=SiteExamRoutine::whereIn('site_exam_declare_id', $exam_declare_ids)
            ->select('id', 'examination_id', 'academic_exam_type_id', 'exam_start_date', 'exam_start_time',
                'seat_plan_publish_for_employee', 'seat_plan_publish_for_student')
            ->orderBy('exam_start_date')
            ->orderBy('exam_start_time')
            ->get();

        $exam_date_list=$exam_date_time_list->pluck('exam_start_date')->unique()->filter()->values();


        $date_time_arr=Array();
        $date_time_array=[];
        foreach ($exam_date_list as $key => $value) {

            $check_time=$exam_date_time_list->where('exam_start_date', $value)
                ->pluck('exam_start_time')->unique()->filter()->values();



            $time_arr=Array();
            $time_array=[];
            foreach ($check_time as $keys => $values) {

                $check_publish_employee=$exam_date_time_list
                    ->where('exam_start_date', $value)
                    ->where('exam_start_time', $values)
                    ->pluck('seat_plan_publish_for_employee')->unique()->filter()->values();

                if(count($check_publish_employee)==1){
                    $time_arr['seat_plan_publish_for_employee']=true;
                }else if(count($check_publish_employee)==0){
                    $time_arr['seat_plan_publish_for_employee']=false;
                }


                $check_publish_student=$exam_date_time_list
                    ->where('exam_start_date', $value)
                    ->where('exam_start_time', $values)
                    ->pluck('seat_plan_publish_for_student')->unique()->filter()->values();

                if(count($check_publish_student)==1){
                    $time_arr['seat_plan_publish_for_student']=true;
                }else if(count($check_publish_employee)==0){
                    $time_arr['seat_plan_publish_for_student']=false;
                }


                $time_arr['exam_time']=$values;

                $time_array[$keys]=$time_arr;
            }

            $date_time_arr['exam_date']=$value;
            $date_time_arr['time_list']=collect($time_array)->values();

            $date_time_array[$key]=$date_time_arr;
        }



        return $date_time_array;

    }




    public function publishPauseExamSeatPlanForEmployee(Request $request){

        $data = $request->all();

        $declaredSubjectList = SiteExamDeclares::where('academic_year_id', $request->academic_year_id)
            ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when(!empty($data['academic_version_id']), function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
            ->where('examination_id', $request->examination_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })

            ->get(['id']);



        $exam_declare_ids=$declaredSubjectList->pluck('id')->unique();



        if($request->action_type=='publish'){
            SiteExamRoutine::whereIn('site_exam_declare_id', $exam_declare_ids)
                ->where('exam_start_date', $request->exam_date)
                ->where('exam_start_time', date("H:i", strtotime($request->exam_time)))
                ->update([
                    'seat_plan_publish_for_employee'=>true
                ]);

            return Response::json(['message' => 'Seat Plan Publish Successfully For Employee', 'mode' => 'success' ], 200);
        }
        else if($request->action_type=='pause'){

            $routine_ids=SiteExamRoutine::whereIn('site_exam_declare_id', $exam_declare_ids)
                ->where('exam_start_date', $request->exam_date)
                ->where('exam_start_time', date("H:i", strtotime($request->exam_time)))
                ->pluck('id')
                ->unique()
                ->values();

            $check_exam_held=SiteExamDeclareStudentSubject::
                whereIn('site_exam_routine_id', $routine_ids)
                ->where('exam_held_status', true)
                ->first();

            if($check_exam_held){
                return Response::json(['message' => 'This Exam Already Held. You can not pause this seat plan.', 'mode' => 'Error' ], 200);
            }
            else{
                SiteExamRoutine::whereIn('site_exam_declare_id', $exam_declare_ids)
                    ->where('exam_start_date', $request->exam_date)
                    ->where('exam_start_time', date("H:i", strtotime($request->exam_time)))
                    ->update([
                        'seat_plan_publish_for_employee'=>false
                    ]);
            }




            return Response::json(['message' => 'Seat Plan Pause Successfully For Employee', 'mode' => 'success' ], 200);
        }
    }



    public function publishPauseExamSeatPlanForStudent(Request $request){

        $data = $request->all();

        $declaredSubjectList = SiteExamDeclares::where('academic_year_id', $request->academic_year_id)
            ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when(!empty($data['academic_version_id']), function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
            ->where('examination_id', $request->examination_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })

            ->get(['id']);



        $exam_declare_ids=$declaredSubjectList->pluck('id')->unique();



        if($request->action_type=='publish'){
            SiteExamRoutine::whereIn('site_exam_declare_id', $exam_declare_ids)
                ->where('exam_start_date', $request->exam_date)
                ->where('exam_start_time', date("H:i", strtotime($request->exam_time)))
                ->update([
                    'seat_plan_publish_for_student'=>true
                ]);

            return Response::json(['message' => 'Seat Plan Publish Successfully For Student', 'mode' => 'success' ], 200);
        }
        else if($request->action_type=='pause'){
            SiteExamRoutine::whereIn('site_exam_declare_id', $exam_declare_ids)
                ->where('exam_start_date', $request->exam_date)
                ->where('exam_start_time', date("H:i", strtotime($request->exam_time)))
                ->update([
                    'seat_plan_publish_for_student'=>false
                ]);

            return Response::json(['message' => 'Seat Plan Pause Successfully For Student', 'mode' => 'success' ], 200);
        }
    }


    private function getExamStudentList(Request $request){

        $data = $request->all();

        $exam_declare_ids = SiteExamDeclares::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('examination_id', $request->examination_id)
            ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->where('status', true)
            ->pluck('id');


        $student_ids=SiteExamDeclareStudent::whereIn('site_exam_declare_id', $exam_declare_ids)
            ->where('status', true)
            ->pluck('student_history_id')
            ->unique()
            ->values();

        $student_list=StudentHistory::with(['siteExamDeclareStudentSubject'=>function($query) use ($exam_declare_ids){
                $query->with(['subjectGroupConditionSetting'=>function($q){
                    $q->select('id', 'academic_subject_id','subject_code');
                    $q->orderBy('subject_position');
                    }]);
                $query->whereIn('site_exam_declare_id', $exam_declare_ids);
                $query->distinct('student_history_id', 'site_subject_group_condition_setting_id');
                $query->select('student_history_id', 'site_subject_group_condition_setting_id');
            }])
            ->with(['department','stClass', 'shift', 'classGroup', 'section', 'session', 'year', 'academicStudentCategory',
                'student'=>function($query){
                    $query->with(['gender', 'religion']);
                    $query->select('id', 'gender_id', 'religion_id');

                },
                'siteGroupStudentExamRoll' => fn($q) => $q->where('examination_id', $data['examination_id'])
                ])
            ->whereIn('id', $student_ids)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('student_roll_number', '>=', $request->roll_from)
            ->where('student_roll_number', '<=', $request->roll_to)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->select('id', 'user_id', 'student_roll_number', 'academic_year_id',
                'academic_department_id', 'academic_class_id', 'academic_shift_id', 'optional_subject_ids',
                'academic_student_category_id',
                'academic_class_group_id', 'academic_section_id', 'academic_session_id', 'student_roll_number_prefix')
            ->orderBy('student_roll_number')
            ->orderBy('academic_section_id')
            ->orderBy('academic_class_id')
            ->orderBy('academic_class_group_id')
            ->orderBy('academic_department_id')
            ->get();

           return $student_list;
    }

    public function getExamSeatPlanToken(Request $request){
        ini_set('memory_limit', '-1');

        $page_tittle = "Exam Seat";
        $report_tittle = "Exam Seat";
        $report_tittle2 = " ";
        $title_view = "Admit Card";

        $student_list=$this->getExamStudentList($request);

        $examination=Examination::where('id', $request->examination_id)->first();
        $examination_name=$examination->examination_name;

        $year=AcademicYear::where('id', $request->academic_year_id)->first();
        $year_name=$year->year_name;

        return Response::json(
            [
                 'student_list' =>$student_list,
                 'examination_name' => $examination_name,
                 'year_name' => $year_name,
                 'report_tittle' => $report_tittle,
             ], 200);

        // return compact('student_list', 'examination_name', 'year_name', 'report_tittle',
        //          'page_tittle', 'report_tittle2', 'title_view');


    }

    public function getExamSeatPlanPdfToken(Request $request){

        ini_set('memory_limit', '-1');

        $page_tittle = "Admit Card";
        $report_tittle = "<b>Admit Card</b> <br/>";
        $report_tittle2 = " ";
        $title_view = "Admit Card";

         $student_list=$this->getExamStudentList($request);

        $examination=Examination::where('id', $request->examination_id)->first();
        $examination_name=$examination->examination_name;

        $year=AcademicYear::where('id', $request->academic_year_id)->first();
        $year_name=$year->year_name;

        $site_id   =  $request->session()->get('SITE_ID');
        $site_info =  SiteInfo::findOrFail($site_id);

        if ($request->SeatPlan == 2) {
            $pdf = PDF::loadView('default.admin.site.exam.exam-seat-plan-token-two-pdf',
                        compact('student_list', 'examination_name', 'year_name', 'report_tittle','page_tittle', 'report_tittle2', 'title_view','site_info'))
                        ->setWarnings(false);
        }else {
            $pdf = PDF::loadView('default.admin.site.exam.exam-seat-plan-token-one-pdf',
                        compact('student_list', 'examination_name', 'year_name', 'report_tittle','page_tittle', 'report_tittle2', 'title_view','site_info'))
                        ->setWarnings(false);
        }


    //    $pdf = PDF::view('default.site.employee.id-card.card-view-report-vertical', compact('card_data', 'signature', 'designation', 'report_tittle', 'page_tittle', 'report_tittle2'))->setPaper('a4', 'landscape');

        $path = storage_path() . '/pdf';
        $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        $name = $time . '.pdf';

        return Response::json(['link' => route('open-pdf-file-storage', [$name]),
            'message' => 'Successfully Created Card Report'], 200);

    }


}
