<?php

namespace App\Http\Controllers\Site\Exam;

use App\Http\Controllers\ProjectController;
use App\Models\Employee\SiteEmployeeDepartmentClassSubject;
use App\Models\Site\Employee\Employee;
use App\Models\Site\Exam\SiteAnswerPaperDistributionDetail;
use App\Models\Site\Exam\SiteExamDeclares;
use App\Models\Site\Exam\SiteExamDeclareStudent;
use App\Models\Site\Exam\SiteExamDeclareStudentSubject;
use App\Models\Student\StudentHistory;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use App\Models\User\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Response;
use Session;

class SiteBaseAnswerPaperController extends ProjectController
{


    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
    }


    public function index()
    {
        $viewType = 'Site Result Setting Page';

        return view('default.admin.layouts.master', compact('viewType'));
//        return view('default.admin.site.exam.site-base-answer-paper-distribution', compact('viewType'));

    }




    public function getSiteBaseAnswerPaperDistribution(Request $request){

        $data = $request->all();

        $getSubjectID=SubjectGroupConditionSetting::where('id', $request->site_subject_group_condition_setting_id)
            ->where('status', true)
            ->first();

        $site_emp_user_list=SiteEmployeeDepartmentClassSubject::where('academic_subject_id', $getSubjectID->academic_subject_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->get();


        $site_emp_user_ids=$site_emp_user_list->pluck('user_id')->unique();

        $get_employee_list=Employee::whereIn('id', $site_emp_user_ids)
            ->select('id')
            ->where('status',true)
            ->get();

        $examDeclaredList = SiteExamDeclares::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('examination_id', $request->examination_id)
        //  ->where('exam_declared_by','site')
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            // ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
            //     return $query->where('academic_session_id', $data['academic_session_id']);
            // })
            ->pluck('id');



        $studentIds=StudentHistory::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->pluck('id');

          

        $declaredStudentList=SiteExamDeclareStudent::with(['siteExamDeclareStudentSubject'=>function($query) use ($request){
            $query->where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id);
            $query->with(['academicExamType']);
            $query->where('exam_held_status', true);
            $query->where('exam_attendance_status', true);
            $query->select('id', 'academic_exam_type_id', 'examination_id', 'site_exam_routine_id', 'student_history_id',
                'site_exam_declare_id', 'site_exam_declare_student_id');

        },
            'studentHistory'=>function($querys) use ($data){

                $querys->select('id', 'user_id', 'student_roll_number');
                $querys->when(!empty($data['academic_class_group_id']), function ($q) use ($data) {
                    return $q->where('academic_class_group_id', $data['academic_class_group_id']);
                });

            }])
            ->whereIn('site_exam_declare_id', $examDeclaredList)
            ->whereIn('student_history_id', $studentIds)
            ->get();

         //   dd($declaredStudentList);


        $student_asc_list=[];
        foreach ($declaredStudentList as $key => $value) {

            if(count($value->siteExamDeclareStudentSubject)>0){
                $student_asc_list[]=$value;
            }

        }

        $student_list=array_values(array_sort(collect($student_asc_list), function ($value) {
            return $value['student_roll_number'];
        }));


        $getExamType=SiteExamDeclareStudentSubject::with(['academicExamType'])
            ->whereIn('site_exam_declare_id', $examDeclaredList)
            ->whereIn('student_history_id', $studentIds)
            ->where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id)
            ->distinct('academic_exam_type_id')
            ->select('academic_exam_type_id')
            ->get();



        $getAnswerPaperDistList=SiteAnswerPaperDistributionDetail::where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->whereIn('site_exam_declare_id', $examDeclaredList)
            ->whereIn('user_id', $site_emp_user_ids)
            ->get();

            //    dd($getAnswerPaperDistList);

        if(count($getAnswerPaperDistList)>0){
            $emp_exam_type_list_arr=Array();
            $emp_exam_type_list_array=[];
            foreach ($get_employee_list as $key => $value) {

                $checkExaminer=$getAnswerPaperDistList->where('user_id', $value->id);
                if(count($checkExaminer)>0){
                    $emp_exam_type_list_arr['select_employee_id']=true;
                }else{
                    $emp_exam_type_list_arr['select_employee_id']=false;
                }



                $exam_type_list_arr=Array();
                $exam_type_list_array=[];
                foreach ($getExamType as $keys => $values) {

                    $checkExamType=$checkExaminer->where('academic_exam_type_id', $values->academic_exam_type_id);

                    if(count($checkExamType)>0){
                        $exam_type_list_arr['select_exam_type_id']=true;
                    }else{
                        $exam_type_list_arr['select_exam_type_id']=false;
                    }

                    if(count($checkExamType)>0){
                        $from_to_arr=Array();
                        $exam_roll_from_to_array=[];
                        foreach ($checkExamType as $keyst => $valuest) {
                            $from_to_arr['roll_from']=$valuest->roll_from;
                            $from_to_arr['roll_to']=$valuest->roll_to;
                            $from_to_arr['select_roll_from_to_id']=true;
                            $from_to_arr['id']=$valuest->id;


                            $exam_roll_from_to_array[$keyst]=array_merge($from_to_arr, $valuest->toArray());
                        }
                    }else{
                        $exam_roll_from_to_array=
                            [
                                [
                                    'roll_from'=>0,
                                    'roll_to'=>0,
                                    'select_roll_from_to_id'=>false,
                                    'id'=>0
                                ]
                            ];
                    }

                    $exam_type_list_arr['exam_roll_from_to']=$exam_roll_from_to_array;

                    $exam_type_list_array[$keys]=array_merge($exam_type_list_arr, $values->toArray());
                }

                $emp_exam_type_list_arr['exam_type_list']=$exam_type_list_array;

                $emp_exam_type_list_array[$key]=array_merge($emp_exam_type_list_arr, $value->toArray());
            }
        }
        else{

            $emp_exam_type_list_arr=Array();
            $emp_exam_type_list_array=[];
            foreach ($get_employee_list as $key => $value) {

                $exam_type_list_arr=Array();
                $exam_type_list_array=[];
                foreach ($getExamType as $keys => $values) {

                    $exam_roll_from_to_array=
                        [
                            [
                                'roll_from'=>0,
                                'roll_to'=>0,
                                'select_roll_from_to_id'=>false,
                                'id'=>0
                            ]
                        ];

                    $exam_type_list_arr['exam_roll_from_to']=$exam_roll_from_to_array;
                    $exam_type_list_arr['select_exam_type_id']=false;


                    $exam_type_list_array[$keys]=array_merge($exam_type_list_arr, $values->toArray());
                }


                $emp_exam_type_list_arr['exam_type_list']=$exam_type_list_array;
                $emp_exam_type_list_arr['select_employee_id']=false;


                $emp_exam_type_list_array[$key]=array_merge($emp_exam_type_list_arr, $value->toArray());
            }
        }

        return compact('emp_exam_type_list_array', 'student_list');

    }

    public function saveSiteBaseAnswerPaperDistribution(Request $request){

        $data = $request->all();
   
        $examDeclaredList = SiteExamDeclares::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('examination_id', $request->examination_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            // ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
            //     return $query->where('academic_session_id', $data['academic_session_id']);
            // })
            ->first();




        $getSubjectID=SubjectGroupConditionSetting::where('id', $request->site_subject_group_condition_setting_id)
            ->where('status', true)
            ->first();

        $site_emp_user_list=SiteEmployeeDepartmentClassSubject::where('academic_subject_id', $getSubjectID->academic_subject_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->get();
       

        $site_emp_user_ids=$site_emp_user_list->pluck('user_id')->unique();



        $getAnswerPaperDistList=SiteAnswerPaperDistributionDetail::where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->where('academic_subject_id', $getSubjectID->academic_subject_id)
            ->where('site_exam_declare_id', $examDeclaredList->id)
            ->whereIn('user_id', $site_emp_user_ids)
            ->get();


        $getAnswerPaperDistListIDs=$getAnswerPaperDistList->pluck('id')->unique();


        $created=[];
        $edited_list=[];
        foreach ($request['empExamTypeList'] as $key => $value) {

            if($value['select_employee_id']){

                foreach ($value['exam_type_list'] as $keys => $values) {

                    if($values['select_exam_type_id']){
                       
                        foreach ($values['exam_roll_from_to'] as $keyst => $valuest) {
                           
                            if($valuest['select_roll_from_to_id'] && ($valuest['roll_from']<=$valuest['roll_to'])){
                               
                                if($valuest['id']){
                                    $edited_list[]=$valuest['id'];


                                    SiteAnswerPaperDistributionDetail::where('id', $valuest['id'])
                                    ->update([
                                        'roll_from'=> $valuest['roll_from'],
                                        'roll_to'=> $valuest['roll_to'],
                                        'site_subject_group_condition_setting_id'=> $request->site_subject_group_condition_setting_id,
                                        'academic_subject_id'=> $getSubjectID->academic_subject_id,
                                        'academic_class_id' => $request->academic_class_id,
                                        'academic_session_id' => $request->academic_session_id,
                                        'academic_section_id' => $request->academic_section_id,
                                    ]);


                                }else{
                                  
                                    $created[] = [
                                        'academic_group_id' => Session::get('ACADEMIC_GROUP_ID'),
                                        'academic_class_group_id' => $request->academic_class_group_id,
                                        'academic_year_id' => $request->academic_year_id,
                                        'academic_version_id' => $request->academic_version_id,
                                        'academic_shift_id' => $request->academic_shift_id,
                                        'academic_department_id' => $request->academic_department_id,
                                        'academic_class_id' => $request->academic_class_id,
                                        'academic_session_id' => $request->academic_session_id,
                                        'academic_section_id' => $request->academic_section_id,
                                        'site_exam_declare_id' => $examDeclaredList?$examDeclaredList->id:null,
                                        'academic_subject_id' =>$getSubjectID->academic_subject_id,
                                        'site_subject_group_condition_setting_id' => $request->site_subject_group_condition_setting_id,
                                        'academic_exam_type_id' =>$values['academic_exam_type_id'] ,
                                        'examination_id' => $request->examination_id,
                                        'roll_from' => $valuest['roll_from'],
                                        'roll_to' => $valuest['roll_to'],
                                        'user_id' => $value['id'],
                                        'status' => true,
                                        'site_id' => Session::get('SITE_ID'),

                                    ];
                                }



                            }
                        }
                    }
                }
            }

        }

     
        if(count($created)>0){
            SiteAnswerPaperDistributionDetail::insert($created);
        }

       
        $siteAnswerPaperCheck=array_diff($getAnswerPaperDistListIDs->toArray(), $edited_list);
       // dd($edited_list);

        SiteAnswerPaperDistributionDetail::whereIn('id', $siteAnswerPaperCheck)->delete();


        return Response::json(['message' => 'Save Successfully!', 'mode' => 'Save!'], 200);


    }

}
