<?php

namespace App\Http\Controllers\Site\Exam;

use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicExamType;
use App\Models\Academic\AcademicSubject;
use App\Models\Academic\AcademicSubjectTopic;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Site\Exam\SiteExamQuestion;
use App\Models\Site\Exam\SiteExamQuestionDetails;
use App\Models\Site\Exam\SiteExamQuestionInfo;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Carbon\Carbon;
use Auth;
use Illuminate\Support\Facades\Storage;
use Session;
use Response;
use File;
use Error;
//use Illuminate\Pagination\Paginator;
use PDF;
use Image;
use App\Models\Image\Photo;

class SiteExamQuestionController extends Controller
{
    
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType = "Exam Question";
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function getSiteExamQuestionListView()
    {
        $viewType = "Exam Question List";
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function editQuestionView()
    {
        $viewType = "Exam Question Edit";
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function getSiteExamQuestionList()
    {

        $exam_question_list = SiteExamQuestion::get();
        return $exam_question_list;
    }

    

    public function getQuestionListWithPagination(Request $request)
    {
//       return $request;

//        return $request->academic_department_id;
//        return $request->date_range['end'];
        $question_status = $request->question_status;
        $search_txt = $request->search_txt;
        $academic_year_id = $request->academic_year_id;
        $academic_department_id = $request->academic_department_id;
        $academic_class_id = $request->academic_class_id;
        $academic_subject_id = $request->academic_subject_id;
        $topic_id = $request->topic_id;
        $exam_type_id = $request->exam_type ? $request->exam_type : '';
        $written_type = $request->written_type;
        $question_level = $request->question_level;
//        $date_range = $request->date_range ? json_decode($request->date_range) : null;
        $date_start = $request->date_range ? $request->date_range['start'] : null;
        $date_end = $request->date_range ? $request->date_range['end'] : null;
        $paginate = $request->paginate ??
            $txt = '%' . $search_txt . '%';

        $user_role = request()->user()->roles()->pluck('key')->first();

        if($user_role == 'admin'){
            $user_id = "";
        }else{
            $user_id = Auth::user()->id;
        }
//
//        $date_start = $date_range->start;
//        $date_end = $date_range->end ?? $date_start;

        //=====================question list==================

        $question_data = SiteExamQuestion::when($search_txt, function ($q) use ($search_txt) {
            return $q->where(function ($query) use ($search_txt) {
                $query->whereTranslationLike('question', $search_txt)
                    ->orWhere('question_no', $search_txt);
            });
        })
            ->where('module_key','exam')
            ->when($question_status, function ($qq) use ($question_status) {
                return $qq->where('question_status', $question_status);
            })
            ->when($question_level, function ($qqq) use ($question_level) {
                return $qqq->where('question_level', $question_level);
            })
            ->when($date_start, function ($qqqq) use ($date_start) {
                return $qqqq->whereHas('siteExamQuestionInfo', function ($qqqqr) use ($date_start) {
                    return $qqqqr->whereDate('created_date', '>=', $date_start);
                });
            })
            ->when($date_end, function ($qqqqq) use ($date_end) {
                return $qqqqq->whereHas('siteExamQuestionInfo', function ($qqqqqr) use ($date_end) {
                    return $qqqqqr->whereDate('created_date', '<=', $date_end);
                });
            })
            ->when($academic_year_id, function ($qqqqqqr) use ($academic_year_id) {
                return $qqqqqqr->whereHas('siteExamQuestionInfo', function ($qqqqqqrr) use ($academic_year_id) {
                    return $qqqqqqrr->where('academic_year_id', $academic_year_id);
                });
            })
            ->when($academic_department_id, function ($qqqqqq) use ($academic_department_id) {
                return $qqqqqq->whereHas('siteExamQuestionInfo', function ($qqqqqqr) use ($academic_department_id) {
                    return $qqqqqqr->where('academic_department_id', $academic_department_id);
                });
            })
            ->when($academic_class_id, function ($qqqqqqq) use ($academic_class_id) {
                return $qqqqqqq->whereHas('siteExamQuestionInfo', function ($qqqqqqqr) use ($academic_class_id) {
                    return $qqqqqqqr->where('academic_class_id', $academic_class_id);
                });
            })
            ->when($academic_subject_id, function ($qqqqqqqq) use ($academic_subject_id) {
                return $qqqqqqqq->whereHas('siteExamQuestionInfo', function ($qqqqqqqqr) use ($academic_subject_id) {
                    return $qqqqqqqqr->where('academic_subject_id', $academic_subject_id);
                });
            })
            ->when($topic_id, function ($qqqqqqqqq) use ($topic_id) {
                return $qqqqqqqqq->whereHas('siteExamQuestionInfo', function ($qqqqqqqqqr) use ($topic_id) {
                    return $qqqqqqqqqr->where('academic_subject_topic_id', $topic_id);
                });
            })
            ->when($exam_type_id, function ($qqqqqqqqqq) use ($exam_type_id) {
                return $qqqqqqqqqq->whereHas('siteExamQuestionInfo', function ($qqqqqqqqqqr) use ($exam_type_id) {
                    return $qqqqqqqqqqr->where('academic_exam_type_id', $exam_type_id);
                });
            })
            ->when($written_type, function ($qqqqqqqqqqq) use ($written_type) {
                return $qqqqqqqqqqq->whereHas('siteExamQuestionInfo', function ($qqqqqqqqqqqr) use ($written_type) {
                    return $qqqqqqqqqqqr->where('written_type', $written_type);
                });
            })
            ->when($user_id, function ($qqqrr) use ($user_id) {
                return $qqqrr->whereHas('siteExamQuestionInfo', function ($qqrr) use($user_id) {
                    return $qqrr->where('created_by', $user_id);
                });
            })

            ->with(['siteExamQuestionInfo'=>function($qrr){
                $qrr->with('academicDepartment', 'academicClass', 'academicSubject', 'academicSubjectTopic', 'academicExamType','user');
            },'siteExamQuestionDetails','photo'])
            ->orderBy('id', 'desc')

            ->paginate($paginate);

        $question_data->getCollection()->transform(function ($value) {
            return [
                'id' => $value->id,
                'academic_group_id' => $value->academic_group_id,
                'created_at' => $value->created_at,
                'mark' => $value->mark,
                'photo' => $value->photo,
                'question' => $value->question,
                'question_level' => $value->question_level,
                'question_no' => $value->question_no,
                'question_status' => $value->question_status,
                'site_exam_question_details' => $value->siteExamQuestionDetails,
                'site_exam_question_info' => $value->siteExamQuestionInfo,
                'site_exam_question_info_id' => $value->site_exam_question_info_id,
                'site_id' => $value->site_id,
                'status' => $value->status,
                'translations' => $value->translations,
                'updated_at' => $value->updated_at,
                'status_change_check' => $value->question_status == 'approved' ? true : false,
//                'status_change_check' => $value->question_status == 'approved' ? true : false,

            ];
        });
//        return $question_data;

//        $question_list_final = [];
//        if(count($question_data)){
//            foreach ($question_data as $ke => $va){
//                $question_list_final[$ke]['data'] = $va;
//                $question_list_final[$ke]['check_select_checkbox'] = false;
//            }
//        }

//        $question_list = new Paginator(collect($question_list_final)->values(), $paginate);
//        $question_list = $question_list_final->paginate($paginate);;


        //==============year==========================
        $year_list = [];
        $year_ids = SiteExamQuestionInfo::where('module_key', 'exam')->pluck('academic_year_id');
        $academic_year_list = AcademicYear::whereIn('id', $year_ids)->get();

        //==============department==========================
        $department_list = [];
        $department_ids = SiteExamQuestionInfo::where('module_key', 'exam')->pluck('academic_department_id');
        $department_list = AcademicDepartment::whereIn('id', $department_ids)->get();

        //==============class==========================
        $class_list = [];
        $class_ids = SiteExamQuestionInfo::where('module_key', 'exam')->pluck('academic_class_id');
        $class_list = AcademicClass::whereIn('id', $class_ids)->get();

        //==============subject==========================
        $subject_list = [];
        $sGroupCondSettings = SubjectGroupConditionSetting::with(['academicClass', 'academicSubject'])->get();
        $subject_id_array = $sGroupCondSettings->pluck('academic_subject_id');
        $subject_list = AcademicSubject::whereIn('id', $subject_id_array)->get();

        //==============exam type==========================
        $academic_exam_type_list = [];
        $academic_exam_type_ids = SiteExamQuestionInfo::where('module_key', 'exam')->pluck('academic_exam_type_id');
        $academic_exam_type_list = AcademicExamType::whereIn('id', $academic_exam_type_ids)->get();

        //==============topic==========================
        $academic_subject_topic_list = [];
        $academic_subject_topic_ids = SiteExamQuestionInfo::where('module_key', 'exam')->pluck('academic_subject_topic_id');
        $academic_subject_topic_list = AcademicSubjectTopic::whereIn('id', $academic_subject_topic_ids)->where('module_key', 'exam')->get();

        $user_role = request()->user()->roles()->pluck('key')->first();

        return [$department_list, $class_list, $subject_list, $academic_exam_type_list, $academic_subject_topic_list, $question_data, $user_role, $academic_year_list];

    }

    public function updateQuestionStatus(Request $request)
    {
//        return $request;
        $question = SiteExamQuestion::findOrFail($request->id);
        if ($request->question_status == 'pending') {
            $question->update([
                'question_status' => 'approved'
            ]);
        } else {
            $question->update([
                'question_status' => 'pending'
            ]);
        }
        return Response::json(['message' => 'Successfully Updated!', 'mode' => 'Update'], 200);
    }

    public function updateQuestionStatusMassly(Request $request)
    {
        $request = $request->toArray();
        if(count($request)>0){
            foreach ($request as $key => $value){
                $question = SiteExamQuestion::findOrFail($value['id']);
                if ($value['status_change_check']) {
                    $question->update([
                        'question_status' => 'approved'
                    ]);
                } else {
                    $question->update([
                        'question_status' => 'pending'
                    ]);
                }
            }
            return Response::json(['message' => 'Successfully Updated!', 'mode' => 'Update'], 200);

        }else{
            return 'sorry';
        }

    }

    public function getSiteExamQuestionActiveSubjectTopicList($subject_id)
    {
        $topic_list = AcademicSubjectTopic::where('academic_subject_id', $subject_id)
            ->where('module_key','exam')
            ->get();
        return $topic_list;
    }

    public function getSiteExamTypeList()
    {
        $exam_type_ids = SiteInfoSetting::pluck('academic_exam_type_ids')->first();
        $exam_type_ids_array = explode(',', $exam_type_ids);
        $exam_type_list = AcademicExamType::whereIn('id', $exam_type_ids_array)->get();
        return $exam_type_list;
    }

    
    public function createQuestion(Request $request, SiteExamQuestionInfo $examQuestionInfo, SiteExamQuestionDetails $examQuestionDetails)
    {

        //==============validation===============
        if (!$request->exam_type || !$request->academic_version_id || !$request->academic_year_id || !$request->academic_shift_id || !$request->academic_class_id || !$request->subject_id || !$request->date) {
            throw new Error('Please, fill the required fields');
        }
//        if ($request->topic) {
//            $remove_space_txt = str_replace(' ', '', $request->topic);
//            $final_head_key = strtolower($remove_space_txt);
//            $check_data = AcademicSubjectTopic::where('head_key', $final_head_key)->first();
//            if ($check_data) {
//                $check_exist_in_question_table = SiteExamQuestionInfo::where('academic_subject_topic_id', $check_data->id)->first();
//                if($check_exist_in_question_table){
//                    throw new Error('Sorry! topic name is present! Please, write different name.');
//                }
//            }
//        }

        if (!$request->topic_id && !$request->topic) {
            throw new Error('Please,select topic or write topic name.');
        }
        //==================academic subject topic=============
        if (!$request->topic_id) {
            $remove_space_txt = str_replace(' ', '', $request->topic);
            $final_head_key = strtolower($remove_space_txt);
            $check_data = AcademicSubjectTopic::where('head_key', $final_head_key)->first();
            if (!$check_data) {
                $academic_subject_topic = new AcademicSubjectTopic();
                $academic_subject_topic->academic_subject_id = $request->subject_id;
                $academic_subject_topic->created_date = $request->date;
                $academic_subject_topic->created_by = Auth::user()->id;
                $academic_subject_topic->site_id = Session::get('SITE_ID');
                $academic_subject_topic->status = $request->status;
                $academic_subject_topic->topic_name = $request->topic;
                $academic_subject_topic->head_key = $final_head_key;
                $academic_subject_topic->save();
//                $check_data = AcademicSubjectTopic::orderBy('id', 'DESC')->first();
                $topic_id = $academic_subject_topic->id;
            }else{
                $topic_id = $check_data->id;
            }

        } else {
            $topic_id = $request->topic_id;
        }

        //=================question info========================

        if (count($examQuestionInfo->ownFields) > 0) {
            foreach ($examQuestionInfo->ownFields as $field) {
                if ($request->{$field}) {
                    $examQuestionInfo->{$field} = $request->{$field};
                }
            }
            $examQuestionInfo->academic_subject_id = $request->subject_id;
            $examQuestionInfo->academic_subject_topic_id = $topic_id;
            $examQuestionInfo->academic_exam_type_id = $request->exam_type['id'] ? $request->exam_type['id'] : 2;
            $examQuestionInfo->created_by = Auth::user()->id;
            $examQuestionInfo->created_date = $request->date;
            $examQuestionInfo->status = $request->status;
            $examQuestionInfo->save();


            //==================question===========================

            $user_role = request()->user()->roles()->pluck('key')->first();
            $site_id = (int)session()->get('SITE_ID');


            if (count($request->questionList)) {
                // $check_latest_question_info_data = SiteExamQuestionInfo::orderBy('id', 'DESC')->first();


                foreach ($request->questionList as $key => $value) {

                    $question_data = new SiteExamQuestion();
                    $question_data->site_exam_question_info_id = $examQuestionInfo->id;

                    $question_data->question = "";
                    $question_data->mark = $value['mark'] ? $value['mark'] : 0;
                    $question_data->question_level = $value['question_level'];

                    $question_data->question_status = 'pending';
//                    if($user_role == 'admin'){
//                        $question_data->question_status = 'approved';
//                    }else{
//                        $question_data->question_status = 'approved';
//                    }

                    $question_data->status = 1;
                    $check_latest_question_data = SiteExamQuestion::orderBy('id', 'DESC')->first();

                    if ($check_latest_question_data) {
                        $question_data->question_no = $check_latest_question_data->question_no + 1;
                    } else {
                        $question_data->question_no = 101;
                    }

                    $question_data->question = $value['question'];
                    $question_data->save();


                    if (count($value['options'])) {
                        foreach ($value['options'] as $k => $v) {
                            $question_details_data = new SiteExamQuestionDetails();
                            $question_details_data->site_exam_question_id = $question_data->id;
                            $question_details_data->option = $v['option'];
                            $question_details_data->answer_status = $v['answer_status'];
                            $question_details_data->mark = $v['mark'] ? $v['mark'] : 0;
//                            $question_details_data->mark = $v['mark'];
                            $question_details_data->status = 1;
                            $question_details_data->save();
                        }
                    }
                }

            }
        }

        return Response::json(['message' => 'Successfully Saved!', 'mode' => 'Save'], 200);
    }

    public function getQuestionDetailsForEdit($id)
    {
//        return $id;
        $question_list = SiteExamQuestion::with(['siteExamQuestionInfo' => function ($qrr) {
            $qrr->with('academicDepartment', 'academicClass', 'academicSubject', 'academicSubjectTopic', 'academicExamType', 'user');
        }, 'siteExamQuestionDetails'])
            ->where('id', $id)
            ->first();
        return $question_list;
    }

    public function updateQuestion(Request $request)
    {
     
        $final_head_key = "";
        //======================validation====================
        if (!$request->academic_version_id || !$request->academic_year_id || !$request->academic_shift_id || !$request->academic_class_id || !$request->subject_id || !$request->date) {
            throw new Error('Please, fill the required fields');
        }
        if ($request->topic) {
            $remove_space_txt = str_replace(' ', '', $request->topic);;
            $final_head_key = strtolower($remove_space_txt);
            $check_data = AcademicSubjectTopic::where('head_key', $final_head_key)->first();
            if ($check_data) {
                throw new Error('Sorry! topic name is present! Please, write different name.');
            }
        } else if (!$request->topic_id) {
            throw new Error('Please,select topic or write topic name.');
        }
        //==================academic subject topic=============
        if (!$request->topic_id) {
            $academic_subject_topic = new AcademicSubjectTopic();
            $academic_subject_topic->academic_subject_id = $request->subject_id;
            $academic_subject_topic->created_date = $request->date;
            $academic_subject_topic->created_by = Auth::user()->id;
            $academic_subject_topic->site_id = Session::get('SITE_ID');
            $academic_subject_topic->status = $request->status;
            $academic_subject_topic->topic_name = $request->topic;
            $academic_subject_topic->head_key = $final_head_key;
            $academic_subject_topic->save();
            $check_data = AcademicSubjectTopic::orderBy('id', 'DESC')->first();
            $topic_id = $check_data->id;

        } else {
            $topic_id = $request->topic_id;
        }

        //=================question info========================
        $question_data = SiteExamQuestion::with('photo')->where('id', $request->id)->first();

        $examQuestionInfo = SiteExamQuestionInfo::findOrFail($question_data->site_exam_question_info_id);

        if (count($examQuestionInfo->ownFields) > 0) {
            foreach ($examQuestionInfo->ownFields as $field) {
                if ($request->{$field}) {
                    $examQuestionInfo->{$field} = $request->{$field};
                }
            }
            $examQuestionInfo->academic_subject_id = $request->subject_id;
            $examQuestionInfo->academic_subject_topic_id = $topic_id;
            $examQuestionInfo->academic_exam_type_id = $request->exam_type ? $request->exam_type['id'] : "";
            $examQuestionInfo->created_date = $request->date;
            $examQuestionInfo->status = $request->status;
            $examQuestionInfo->save();

            //==================question===========================

          

            $question_details_exist_data = SiteExamQuestionDetails::where('site_exam_question_id', $request->id)->get();
            $question_details_exist_ids = $question_details_exist_data->pluck('id');

            $option_present_ids = [];
            if (count($request->questionList)) {
                foreach ($request->questionList as $key => $value) {
                    $question_data->site_exam_question_info_id = $examQuestionInfo->id;
//                    $question_data->question = $value['question'];
                    $question_data->mark = $value['mark'];
                    $question_data->question_level = $value['question_level'];
                    $question_data->status = 1;
                    $question_data->question = $value['question'];
                    $question_data->save();

                    if (count($value['options'])) {

                        foreach ($value['options'] as $kk => $vv) {
//return $vv;
                            if ($vv['id']) {
                                $check_options = $question_details_exist_data->where('id', $vv['id'])->first();

                                if ($check_options) {

                                    $option_present_ids[] = $vv['id'];

                                    $check_options->option = $vv['option'];
                                    $check_options->answer_status = $vv['answer_status'];
                                    $check_options->mark = $vv['mark'] ? $vv['mark'] : 0;
                                    $check_options->save();
                                } else {
                                    $question_details_data = new SiteExamQuestionDetails();
                                    $question_details_data->site_exam_question_id = $request->id;
                                    $question_details_data->option = $vv['option'];
                                    $question_details_data->answer_status = $vv['answer_status'];
                                    $question_details_data->mark = $vv['mark'] ? $vv['mark'] : 0;
                                    $question_details_data->status = 1;
                                    $question_details_data->save();
                                }
                            } else {
                                $question_details_data = new SiteExamQuestionDetails();
                                $question_details_data->site_exam_question_id = $request->id;
                                $question_details_data->option = $vv['option'];
                                $question_details_data->answer_status = $vv['answer_status'];
                                $question_details_data->mark = $vv['mark'] ? $vv['mark'] : 0;
                                $question_details_data->status = 1;
                                $question_details_data->save();
                            }
                        }
                    }
                }
            }


            $questionOptionAbsentCheck = array_diff($question_details_exist_ids->toArray(), $option_present_ids);

            SiteExamQuestionDetails::whereIn('id', $questionOptionAbsentCheck)->delete();


        }
        return Response::json(['message' => 'Successfully Updated!', 'mode' => 'Update'], 200);
    }

    public function deleteQuestion($id)
    {
        //        return $request;
        $question_data = SiteExamQuestion::with('photo')->where('id', $id)->first();

        $examQuestionInfo = SiteExamQuestionInfo::findOrFail($question_data->site_exam_question_info_id);

        $question_details_exist_data = SiteExamQuestionDetails::where('site_exam_question_id', $id)->get();
        if (count($question_details_exist_data)) {
            foreach ($question_details_exist_data as $k => $v) {
                $v->delete();
                $v->deleteTranslations();
            }
        }

        $checkdata = SiteExamQuestion::where('site_exam_question_info_id', $examQuestionInfo->id)->get();
        if (!count($checkdata)) {
            $examQuestionInfo->delete();
        }

        //========================delete image=============
        $sep_image_identity = explode('<p>', $question_data->question);
        if (count($sep_image_identity)) {
            $oldFileName = [];
            $sl = 0;
            foreach ($sep_image_identity as $kkk => $vvv) {
                if ($vvv) {
                    $ck_image = explode('<img', $vvv);
                    if (count($ck_image) > 1) {

                        $init_image_identity = explode('=', $ck_image[1]);

                        $img_identity = explode('">', substr($init_image_identity[1], 1));
                        $img_identity2 = explode('/', substr($img_identity[0], 1));
                        $oldFileName[$sl] = end($img_identity2);
                        $sl++;
                    }
                }
            }
        }


        if (count($oldFileName)) {
            foreach ($oldFileName as $kk => $vv) {
                $image_path = public_path('uploads/files/question/' . $vv);
                if (File::exists($image_path)) {
                    unlink($image_path);
                }
            }
        }

        $question_data->delete();
        $question_data->deleteTranslations();

        return Response::json(['message' => 'Successfully Deleted!', 'mode' => 'Delete'], 200);


    }

    public function getSiteExamQuestionSelectedQuestionPDF(Request $request)
    {
//        return $request->data;

        $view_title = 'Selected Question PDF';
        $data = $request->data;
        $report_tittle = '<b>Seleceted Question List</b><br>';
        $report_tittle2 = '';

        $pdf = PDF::loadView('default.admin.site.exam.report.question.exam-selected-question-report-pdf', compact('view_title', 'data', 'report_tittle', 'report_tittle2'));

        $path = storage_path() . '/pdf';

        $time = Auth::user()->id . '-' . Carbon::now()->unix();


        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        //  return response()->download($path.'/'.$time.'.pdf');

        $name = $time . '.pdf';

        return Response::json(['message' => $name], 200);
    }

    public function getSiteExamQuestionSelectedQuestionPDFShow($data)
    {
        try {

            $user_id = Auth::user()->id;

            $name_split = preg_split("/\-/", $data);

            if ($name_split[0] != $user_id) {
                return 'You are unauthorized!';
            }
            if (!file_exists(storage_path('pdf/' . $data))) {
                return "The file existed only for 1 day and deleted today!";
            }

            return response()->file(storage_path('pdf/' . $data));

        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
