<?php

namespace App\Http\Controllers\Site\Fee;

use App\Http\Controllers\ProjectController;
use App\Jobs\DemandSlipJob;
use App\Models\Academic\AcademicAdmissionFeeType;
use App\Models\Academic\AcademicFeeHead;
use App\Models\Academic\AcademicGeneralFeeType;
use App\Models\Academic\AcademicMonthName;
use App\Models\Examinations\Examination;
use App\Models\Site\Fee\Fine\SiteStudentFeeFine;
use App\Models\Site\Fee\GlobalSiteStudentFeeGenerate;
use App\Models\Site\Fee\SiteStudentFeeDemandSlipDetails;
use App\Models\Site\Fee\SiteStudentFeeFineAllocation;
use App\Models\Site\Fee\SiteStudentFeeGenerate;
use App\Models\Site\Fee\SiteStudentFeePaymentHistory;
use App\Models\Site\Fee\SiteStudentFeeSubHeadAllocation;
use App\Models\Site\Fee\SiteStudentFeeWaiverOfferHistory;
use App\Models\Site\GlobalSiteInfo;
use App\Models\Site\Notice\Notice;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Models\Student\StudentHistory;
use App\Models\User\User;
use App\Notifications\Site\NoticeNotification;
use App\User as MainUser;
use App\Notifications\Site\StudentPaymentNotification;
use Carbon\CarbonPeriod;
use DB;
use Exception;
use Illuminate\Http\JsonResponse;
use JsonSchema\Exception\ValidationException;
use Illuminate\Support\Facades\Notification;
use NumberFormatter;
use Carbon\Carbon;
use Auth;
use Response;
use PDF;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicFeeGroup;
use App\Models\Academic\AcademicFeeSubHead;
use App\Models\Site\Employee\Employee;
use App\Models\Site\Fee\GlobalSiteStudentFeeSubHeadAllocation;
use App\Models\Site\Fee\SiteStudentFeeGatewaySetting;
use App\Models\Site\Fee\SiteStudentHeadWiseFeePaymentHistory;
use App\Models\Site\Payment\SitePaymentGateway;
use Session;
use Error;

class SiteFeeBankTransferController extends ProjectController
{
    private $siteStudentFeeGenerate;
    private $siteStudentFeeDemandSlipDetails;
    private $siteStudentFeeWaiverOfferHistory;

    public function __construct(SiteStudentFeeGenerate $siteStudentFeeGenerate, SiteStudentFeeDemandSlipDetails $siteStudentFeeDemandSlipDetails,
                                SiteStudentFeeWaiverOfferHistory $siteStudentFeeWaiverOfferHistory)
    {
        $this->middleware('auth');
        //$this->middleware('eduworlduserchecker');
        $this->middleware('sitepagechecker');
        $this->siteStudentFeeGenerate = $siteStudentFeeGenerate;
        $this->siteStudentFeeDemandSlipDetails = $siteStudentFeeDemandSlipDetails;
        $this->siteStudentFeeWaiverOfferHistory = $siteStudentFeeWaiverOfferHistory;

    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function getSitePaymentGateway()
    {

        // payment gateway list
        $payment_gateway_list =  SitePaymentGateway::with(['academicOnlinePaymentMethod','academicOnlinePaymentMarchentType',
                    'academicFeeType'])
                    ->get();
        $payment_gateway_array=[];
        foreach($payment_gateway_list as $key=>$item){
            $payment_gateway_array[$key]['id']=$item->id;
            $payment_gateway_array[$key]['fee_type_name']=$item->academicFeeType?$item->academicFeeType->name:'';
            $payment_gateway_array[$key]['academic_payment_method_name']=$item->academicOnlinePaymentMethod?$item->academicOnlinePaymentMethod->name:'';
            $payment_gateway_array[$key]['academic_payment_type_key']=$item->academic_payment_type_key;
            $payment_gateway_array[$key]['iid']=$item->iid;
            $payment_gateway_array[$key]['user_name']=$item->user_name;
        }

        return $payment_gateway_array;

    }


    public function getHeadWiseSubheadList(Request $request){

        /////////////////

         $sitefeeHead=GlobalSiteStudentFeeSubHeadAllocation::where('site_id',Session::get('SITE_ID'))
            ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
            ->get();

        $sitefeeHeadIDs=$sitefeeHead->pluck('academic_fee_head_id')
                ->unique()
                ->values();
        
        $siteFeeHeadList=AcademicFeeHead::whereIn('id', $sitefeeHeadIDs)->get();

        $payment_gateway_list =  SitePaymentGateway::with(['academicOnlinePaymentMethod','academicOnlinePaymentMarchentType','academicFeeType'])
                ->where('academic_payment_type_key','online')
                ->where('status',true)
                ->get();

        $payment_method_keys=$payment_gateway_list->pluck('academic_payment_method_key')->unique()->values();

        $gateway_array=[];
       
        foreach($payment_method_keys as $acc_typ_key=>$item){
            $total_row_count=0;
            $gateway_account=$payment_gateway_list->where('academic_payment_method_key',$item)->values();
            $account_array=[];
          
            foreach($gateway_account as $acc_key=>$items){
                $account_array[$acc_key]['id']=$items->id;
                $account_array[$acc_key]['partner_number']=$items->partner_number;
                $account_array[$acc_key]['academic_payment_method_name']=$items->academicOnlinePaymentMethod?$items->academicOnlinePaymentMethod->name:'';
                $account_array[$acc_key]['academic_payment_type_key']=$items->academic_payment_type_key;
                $account_array[$acc_key]['iid']=$items->iid;
                $account_array[$acc_key]['user_name']=$items->user_name;

                 $check_fine_amount_push_status=SiteStudentFeeGatewaySetting::where('site_payment_gateway_id',$items->id)
                            ->where('Fee_type_key','student_fee_fine')
                            ->where('status',true)
                            ->where('fine_amount_push_status',true)
                            ->get();

              

                    if(count($check_fine_amount_push_status)){
                        $account_array[$acc_key]['fine_amount_push_status']=true;
                    }else{
                        $account_array[$acc_key]['fine_amount_push_status']=false;
                    }

                ///=== fee head list===

            $data_array=[];

            foreach($siteFeeHeadList as $keyys=>$fee_head){

                    $subHeadWiseHead=$sitefeeHead->where('academic_fee_head_id',$fee_head->id)->pluck('academic_fee_sub_head_id')->unique();
            
                    $gateway_setting_list=SiteStudentFeeGatewaySetting::where('site_payment_gateway_id',$items->id)
                            ->where('academic_fee_head_id',$fee_head->id)
                            ->where('Fee_type_key','student_fee_fine')
                            ->where('status',true)
                            ->get();

            
                    $gateway_setting_list=SiteStudentFeeGatewaySetting::where('site_payment_gateway_id',$items->id)
                            ->where('academic_fee_head_id',$fee_head->id)
                            ->where('Fee_type_key','student_fee')
                            ->where('status',true)
                            ->get();

                    if(count($gateway_setting_list)){
                        $data_array[$keyys]['select_academic_fee_head_id']=true;
                     
                    }else{
                        $data_array[$keyys]['select_academic_fee_head_id']=false;

                    }

                    $data_array[$keyys]['academic_fee_head_id']=$fee_head->id;
                    $data_array[$keyys]['academic_fee_head_name']=$fee_head->name;

                    $subHeadWiseHead=$sitefeeHead->where('academic_fee_head_id',$fee_head->id)->pluck('academic_fee_sub_head_id')->unique();
                
                    $fee_sub_head_list=AcademicFeeSubHead::whereIn('id',$subHeadWiseHead)->get();

                    $sub_head_array=[];

                    foreach($fee_sub_head_list as $keyysy=>$sub_head){
                        $gateway_setting=$gateway_setting_list->where('academic_fee_sub_head_id',$sub_head['id'])->first();
                        if($gateway_setting){
                            $sub_head_array[$keyysy]['select_sub_head']=true;
                            $sub_head_array[$keyysy]['fee_percentage']=$gateway_setting->fee_percentage;
                        }else{
                            $sub_head_array[$keyysy]['select_sub_head']=false;
                            $sub_head_array[$keyysy]['fee_percentage']='100';

                        }

                        $sub_head_array[$keyysy]['id']=$sub_head->id;
                        $sub_head_array[$keyysy]['name']=$sub_head->name;
                        $sub_head_array[$keyysy]['head_key']=$sub_head->head_key;
                        $sub_head_array[$keyysy]['head_key_base_id']=$sub_head->head_key_base_id;

                        $data_array[$keyys]['academic_fee_sub_head_list']=$sub_head_array;

                    }
                }

                $account_array[$acc_key]['fee_head_array']=$data_array;

                $total_row_count++;
            }

            $gateway_array[$acc_typ_key]['row_count']=$total_row_count;
            $gateway_array[$acc_typ_key]['academic_payment_method_key']=$item;
            $gateway_array[$acc_typ_key]['account_list']=$account_array;
           
        }

        return $gateway_array;


        //////////////
     
        // $sitefeeHead=GlobalSiteStudentFeeSubHeadAllocation::where('site_id',Session::get('SITE_ID'))
        //     ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
        //     ->get();

        // $sitefeeHeadIDs=$sitefeeHead->pluck('academic_fee_head_id')
        //         ->unique()
        //         ->values();

        // $siteFeeHeadList=AcademicFeeHead::whereIn('id', $sitefeeHeadIDs)->get();

        // $data_array=[];

        // foreach($siteFeeHeadList as $key=>$fee_head){

        //         $subHeadWiseHead=$sitefeeHead->where('academic_fee_head_id',$fee_head->id)->pluck('academic_fee_sub_head_id')->unique();
        
        //         $gateway_setting_list=SiteStudentFeeGatewaySetting::where('site_payment_gateway_id',$request->site_payment_gateway_id)
        //                 ->where('academic_fee_head_id',$fee_head->id)
        //                 ->where('Fee_type_key','student_fee')
        //                 ->where('status',true)
        //                 ->get();

        //         if(count($gateway_setting_list)){
        //             $data_array[$key]['select_academic_fee_head_id']=true;
        //         }else{
        //             $data_array[$key]['select_academic_fee_head_id']=false;
        //         }

        //         $data_array[$key]['academic_fee_head_id']=$fee_head->id;
        //         $data_array[$key]['academic_fee_head_name']=$fee_head->name;

        //         $subHeadWiseHead=$sitefeeHead->where('academic_fee_head_id',$fee_head->id)->pluck('academic_fee_sub_head_id')->unique();
            
        //         $fee_sub_head_list=AcademicFeeSubHead::whereIn('id',$subHeadWiseHead)->get();

        //         $sub_head_array=[];

        //         foreach($fee_sub_head_list as $keys=>$sub_head){
        //             $gateway_setting=$gateway_setting_list->where('academic_fee_sub_head_id',$sub_head['id'])->first();
        //             if($gateway_setting){
        //                 $sub_head_array[$keys]['select_sub_head']=true;
        //             }else{
        //                 $sub_head_array[$keys]['select_sub_head']=false;

        //             }

        //             $sub_head_array[$keys]['id']=$sub_head->id;
        //             $sub_head_array[$keys]['name']=$sub_head->name;
        //             $sub_head_array[$keys]['head_key']=$sub_head->head_key;
        //             $sub_head_array[$keys]['head_key_base_id']=$sub_head->head_key_base_id;

        //             $data_array[$key]['academic_fee_sub_head_list']=$sub_head_array;

        //         }
        //     }

        //     return $data_array;
        }


    private function returnSiteGroupFeeList($fee_head_id){
        //        return $request;
              //  $data = $request->all();
        
                $FeeGroupsGlobalID=AcademicFeeGroup::whereIn('head_key', ['global'])->pluck('id');
        
                $FeeGroupsClassIDs=AcademicFeeGroup::whereIn('head_key', ['classbase','studentbase'])->pluck('id');
        
                $siteGroupFeeList=Array();
                if($fee_head_id!=null){
        
                    $SiteGlobalFeeList_ids=SiteStudentFeeFineAllocation::with(['academicFeeHead', 'academicFeeGroup','academicFeeSubHead' ])
                        ->where('academic_fee_head_id',$fee_head_id)
                        ->where('academic_class_id',null)
                        ->where('academic_department_id',null)
                        ->where('academic_section_id',null)
                        ->where('academic_class_group_id',null)
                        ->where('academic_session_id',null)
                        ->where('status', true)
                        ->pluck('id');
        
                    $SiteOtherFeeList_ids=SiteStudentFeeFineAllocation::with(['academicFeeHead', 'academicFeeGroup','academicFeeSubHead' ])
                        ->where('academic_fee_head_id',$fee_head_id)
                        ->where('status', true)
                        ->pluck('id');
        
                    $marge_fee_list=array_merge($SiteGlobalFeeList_ids->toArray(), $SiteOtherFeeList_ids->toArray());
                    $fee_unique_ids=collect($marge_fee_list)->unique()->values();
                    $SiteFeeList=SiteStudentFeeFineAllocation::with(['academicFeeHead', 'academicFeeGroup','academicFeeSubHead' ])
                        ->whereIn('id',$fee_unique_ids)
                        ->get();
        
                    $siteGlobalFeeList=$SiteFeeList->whereIn('id', $SiteGlobalFeeList_ids);
        
                    $siteClassStudentFeeList=$SiteFeeList
                        ->whereIn('academic_fee_group_id', $FeeGroupsClassIDs);
                
                    $siteGroupFeeList=array_merge($siteGlobalFeeList->toArray(), $siteClassStudentFeeList->toArray());
                    
                }
        
                return $siteGroupFeeList;
            }


            public function siteStudentFeePaymentGatewaySettigSave(Request $request){

                //===== temporary permission =====
                $headTeacher= Employee::where('site_id',Session::get('SITE_ID'))
                    ->where('institute_head',true)
                    ->where('status',true)
                    ->where('id',Auth::user()->id)
                    ->first();

                if( !in_array(Auth::user()->username, ['rayhan','Hriday']) || $headTeacher ) {
                    return response()->json(['message' => 'You have no permission!'], 410);
                }
                ///====

                $duplicate_head_ids=[];
                $duplicate_sub_head_ids=[];
                $keyss=0;

                $duplicateMessages=[];

                foreach($request->GatewayArray as $item){

                    foreach($item['account_list'] as $account){

                        foreach($account['fee_head_array'] as $fee_head){

                                foreach($fee_head['academic_fee_sub_head_list'] as $sub_head){

                                  $checkSetting=SiteStudentFeeGatewaySetting::where('fee_type_key','student_fee')
                                        ->where('academic_payment_method_key',$item['academic_payment_method_key'])
                                        ->where('site_payment_gateway_id',$account['id'])
                                        ->where('academic_fee_head_id',$fee_head['academic_fee_head_id'])
                                        ->where('academic_fee_sub_head_id',$sub_head['id'])
                                     //   ->where('status',true)
                                        ->first();

                                     if($sub_head['select_sub_head']==false || $fee_head['select_academic_fee_head_id']==false){
                                        $checkUnselectAnother=SiteStudentFeeGatewaySetting::where('fee_type_key','student_fee')
                                            ->where('site_payment_gateway_id',$account['id'])
                                            ->where('academic_payment_method_key',$item['academic_payment_method_key'])
                                            ->where('academic_fee_head_id',$fee_head['academic_fee_head_id'])
                                            ->where('academic_fee_sub_head_id',$sub_head['id'])
                                            ->where('status',true)
                                            ->first();
                                        if($checkUnselectAnother){
                                            $checkUnselectAnother->update([
                                                'status'=>false,
                                                'updated_by'=>Auth::user()->id
                                            ]);

                                        }
                                       
                                     } 

                                    if($sub_head['select_sub_head'] && $fee_head['select_academic_fee_head_id']){
                                      

                                         $checkAnother=SiteStudentFeeGatewaySetting::where('fee_type_key','student_fee')
                                            ->where('site_payment_gateway_id','!=',$account['id'])
                                            ->where('academic_payment_method_key',$item['academic_payment_method_key'])
                                            ->where('academic_fee_head_id',$fee_head['academic_fee_head_id'])
                                            ->where('academic_fee_sub_head_id',$sub_head['id'])
                                            ->where('status',true)
                                            ->first();

                                        if($checkAnother){
                                            $head = AcademicFeeHead::where('id',$checkAnother->academic_fee_head_id)->first();
                                            $subhead = AcademicFeeSubHead::where('id',$checkAnother->academic_fee_sub_head_id)->first();
                                            $gateway = SitePaymentGateway::where('id',$checkAnother->site_payment_gateway_id)->first();
                                          

                                           // $duplicate_head_ids[$keyss][$checkAnother->academic_fee_head_id];
                                           // $duplicate_sub_head_ids[$keyss][$checkAnother->academic_fee_sub_head_id];
                                            $duplicateMessages[] = "{$head->name} into {$subhead->name} is already set in {$gateway->iid}";

                                            $keyss++;
                                            continue;

                                        //   return response()->json(['message'=>$head->name.' into '.$subhead->name.' is aleady set in '.$gateway->iid], 411);
                                        }
                                   
                                    if($checkSetting){
                                        if($checkSetting->status==false){
                                            $checkSetting->updated_by=Auth::user()->id;
                                            $checkSetting->academic_payment_method_key=$item['academic_payment_method_key'];
                                            $checkSetting->status=true;
                                            $checkSetting->save();
                                        }
                                    }else{
                                        $gateway_setting=new SiteStudentFeeGatewaySetting();
                                        $gateway_setting->site_payment_gateway_id=$account['id'];
                                        $gateway_setting->fee_type_key='student_fee';
                                        $gateway_setting->academic_payment_method_key=$item['academic_payment_method_key'];
                                        $gateway_setting->academic_fee_head_id=$fee_head['academic_fee_head_id'];
                                        $gateway_setting->academic_fee_sub_head_id=$sub_head['id'];
                                        $gateway_setting->created_by=Auth::user()->id;
                                        $gateway_setting->status=true;
                                        $gateway_setting->save();
                                    }

                                    ///

                                 
                               
                            }
                    }
                }

                
                 // if ($account['fine_amount_push_status']) {
                        $fineSetting = SiteStudentFeeGatewaySetting::firstOrCreate(
                            [
                                'fee_type_key' => 'student_fee_fine',
                                'academic_payment_method_key' => $item['academic_payment_method_key'],
                                'site_payment_gateway_id' => $account['id']
                            ],
                            [
                                'created_by' => Auth::id(),
                                'status' => true
                            ]
                        );

                        $fineSetting->update([
                            'fine_amount_push_status' => $account['fine_amount_push_status'],
                            'status' => $account['fine_amount_push_status'],
                        ]);
                  //  }

                    }
                }


            if(count($duplicateMessages)){
                return response()->json(['message'=>'Save Successfully, and '.implode(', ', $duplicateMessages)], 200);
            }

            return response()->json(['message'=>'Save Successfully'], 200);


        }

}
